(function(e, t) {
    "use strict";
    if (typeof module === "object" && typeof module.exports === "object") {
        module.exports = e.document ? t(e, true) : function(e) {
            if (!e.document) {
                throw new Error("jQuery requires a window with a document");
            }
            return t(e);
        };
    } else {
        t(e);
    }
})(typeof window !== "undefined" ? window : this, function(e, t) {
    "use strict";
    var n = [];
    var i = e.document;
    var r = Object.getPrototypeOf;
    var o = n.slice;
    var a = n.concat;
    var s = n.push;
    var l = n.indexOf;
    var f = {};
    var u = f.toString;
    var c = f.hasOwnProperty;
    var d = c.toString;
    var p = d.call(Object);
    var h = {};
    var g = function en(e) {
        return typeof e === "function" && typeof e.nodeType !== "number";
    };
    var v = function tn(e) {
        return e != null && e === e.window;
    };
    var m = {
        type: true,
        src: true,
        noModule: true
    };
    function y(e, t, n) {
        t = t || i;
        var r, o = t.createElement("script");
        o.text = e;
        if (n) {
            for (r in m) {
                if (n[r]) {
                    o[r] = n[r];
                }
            }
        }
        t.head.appendChild(o).parentNode.removeChild(o);
    }
    function b(e) {
        if (e == null) {
            return e + "";
        }
        return typeof e === "object" || typeof e === "function" ? f[u.call(e)] || "object" : typeof e;
    }
    var w = "3.3.1", x = function(e, t) {
        return new x.fn.init(e, t);
    }, C = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;
    x.fn = x.prototype = {
        jquery: w,
        constructor: x,
        length: 0,
        toArray: function() {
            return o.call(this);
        },
        get: function(e) {
            if (e == null) {
                return o.call(this);
            }
            return e < 0 ? this[e + this.length] : this[e];
        },
        pushStack: function(e) {
            var t = x.merge(this.constructor(), e);
            t.prevObject = this;
            return t;
        },
        each: function(e) {
            return x.each(this, e);
        },
        map: function(e) {
            return this.pushStack(x.map(this, function(t, n) {
                return e.call(t, n, t);
            }));
        },
        slice: function() {
            return this.pushStack(o.apply(this, arguments));
        },
        first: function() {
            return this.eq(0);
        },
        last: function() {
            return this.eq(-1);
        },
        eq: function(e) {
            var t = this.length, n = +e + (e < 0 ? t : 0);
            return this.pushStack(n >= 0 && n < t ? [ this[n] ] : []);
        },
        end: function() {
            return this.prevObject || this.constructor();
        },
        push: s,
        sort: n.sort,
        splice: n.splice
    };
    x.extend = x.fn.extend = function() {
        var e, t, n, i, r, o, a = arguments[0] || {}, s = 1, l = arguments.length, f = false;
        if (typeof a === "boolean") {
            f = a;
            a = arguments[s] || {};
            s++;
        }
        if (typeof a !== "object" && !g(a)) {
            a = {};
        }
        if (s === l) {
            a = this;
            s--;
        }
        for (;s < l; s++) {
            if ((e = arguments[s]) != null) {
                for (t in e) {
                    n = a[t];
                    i = e[t];
                    if (a === i) {
                        continue;
                    }
                    if (f && i && (x.isPlainObject(i) || (r = Array.isArray(i)))) {
                        if (r) {
                            r = false;
                            o = n && Array.isArray(n) ? n : [];
                        } else {
                            o = n && x.isPlainObject(n) ? n : {};
                        }
                        a[t] = x.extend(f, o, i);
                    } else if (i !== undefined) {
                        a[t] = i;
                    }
                }
            }
        }
        return a;
    };
    x.extend({
        expando: "jQuery" + (w + Math.random()).replace(/\D/g, ""),
        isReady: true,
        error: function(e) {
            throw new Error(e);
        },
        noop: function() {},
        isPlainObject: function(e) {
            var t, n;
            if (!e || u.call(e) !== "[object Object]") {
                return false;
            }
            t = r(e);
            if (!t) {
                return true;
            }
            n = c.call(t, "constructor") && t.constructor;
            return typeof n === "function" && d.call(n) === p;
        },
        isEmptyObject: function(e) {
            var t;
            for (t in e) {
                return false;
            }
            return true;
        },
        globalEval: function(e) {
            y(e);
        },
        each: function(e, t) {
            var n, i = 0;
            if (T(e)) {
                n = e.length;
                for (;i < n; i++) {
                    if (t.call(e[i], i, e[i]) === false) {
                        break;
                    }
                }
            } else {
                for (i in e) {
                    if (t.call(e[i], i, e[i]) === false) {
                        break;
                    }
                }
            }
            return e;
        },
        trim: function(e) {
            return e == null ? "" : (e + "").replace(C, "");
        },
        makeArray: function(e, t) {
            var n = t || [];
            if (e != null) {
                if (T(Object(e))) {
                    x.merge(n, typeof e === "string" ? [ e ] : e);
                } else {
                    s.call(n, e);
                }
            }
            return n;
        },
        inArray: function(e, t, n) {
            return t == null ? -1 : l.call(t, e, n);
        },
        merge: function(e, t) {
            var n = +t.length, i = 0, r = e.length;
            for (;i < n; i++) {
                e[r++] = t[i];
            }
            e.length = r;
            return e;
        },
        grep: function(e, t, n) {
            var i, r = [], o = 0, a = e.length, s = !n;
            for (;o < a; o++) {
                i = !t(e[o], o);
                if (i !== s) {
                    r.push(e[o]);
                }
            }
            return r;
        },
        map: function(e, t, n) {
            var i, r, o = 0, s = [];
            if (T(e)) {
                i = e.length;
                for (;o < i; o++) {
                    r = t(e[o], o, n);
                    if (r != null) {
                        s.push(r);
                    }
                }
            } else {
                for (o in e) {
                    r = t(e[o], o, n);
                    if (r != null) {
                        s.push(r);
                    }
                }
            }
            return a.apply([], s);
        },
        guid: 1,
        support: h
    });
    if (typeof Symbol === "function") {
        x.fn[Symbol.iterator] = n[Symbol.iterator];
    }
    x.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function(e, t) {
        f["[object " + t + "]"] = t.toLowerCase();
    });
    function T(e) {
        var t = !!e && "length" in e && e.length, n = b(e);
        if (g(e) || v(e)) {
            return false;
        }
        return n === "array" || t === 0 || typeof t === "number" && t > 0 && t - 1 in e;
    }
    var D = function(e) {
        var t, n, i, r, o, a, s, l, f, u, c, d, p, h, g, v, m, y, b, w = "sizzle" + 1 * new Date(), x = e.document, C = 0, T = 0, D = se(), k = se(), S = se(), E = function(e, t) {
            if (e === t) {
                c = true;
            }
            return 0;
        }, $ = {}.hasOwnProperty, A = [], N = A.pop, j = A.push, L = A.push, I = A.slice, P = function(e, t) {
            var n = 0, i = e.length;
            for (;n < i; n++) {
                if (e[n] === t) {
                    return n;
                }
            }
            return -1;
        }, O = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", H = "[\\x20\\t\\r\\n\\f]", R = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+", q = "\\[" + H + "*(" + R + ")(?:" + H + "*([*^$|!~]?=)" + H + "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + R + "))|)" + H + "*\\]", B = ":(" + R + ")(?:\\((" + "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" + "((?:\\\\.|[^\\\\()[\\]]|" + q + ")*)|" + ".*" + ")\\)|)", M = new RegExp(H + "+", "g"), _ = new RegExp("^" + H + "+|((?:^|[^\\\\])(?:\\\\.)*)" + H + "+$", "g"), F = new RegExp("^" + H + "*," + H + "*"), U = new RegExp("^" + H + "*([>+~]|" + H + ")" + H + "*"), W = new RegExp("=" + H + "*([^\\]'\"]*?)" + H + "*\\]", "g"), z = new RegExp(B), G = new RegExp("^" + R + "$"), Q = {
            ID: new RegExp("^#(" + R + ")"),
            CLASS: new RegExp("^\\.(" + R + ")"),
            TAG: new RegExp("^(" + R + "|[*])"),
            ATTR: new RegExp("^" + q),
            PSEUDO: new RegExp("^" + B),
            CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + H + "*(even|odd|(([+-]|)(\\d*)n|)" + H + "*(?:([+-]|)" + H + "*(\\d+)|))" + H + "*\\)|)", "i"),
            bool: new RegExp("^(?:" + O + ")$", "i"),
            needsContext: new RegExp("^" + H + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + H + "*((?:-\\d)?\\d*)" + H + "*\\)|)(?=[^-]|$)", "i")
        }, V = /^(?:input|select|textarea|button)$/i, X = /^h\d$/i, Y = /^[^{]+\{\s*\[native \w/, J = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, K = /[+~]/, Z = new RegExp("\\\\([\\da-f]{1,6}" + H + "?|(" + H + ")|.)", "ig"), ee = function(e, t, n) {
            var i = "0x" + t - 65536;
            return i !== i || n ? t : i < 0 ? String.fromCharCode(i + 65536) : String.fromCharCode(i >> 10 | 55296, i & 1023 | 56320);
        }, te = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g, ne = function(e, t) {
            if (t) {
                if (e === "\0") {
                    return "�";
                }
                return e.slice(0, -1) + "\\" + e.charCodeAt(e.length - 1).toString(16) + " ";
            }
            return "\\" + e;
        }, ie = function() {
            d();
        }, re = be(function(e) {
            return e.disabled === true && ("form" in e || "label" in e);
        }, {
            dir: "parentNode",
            next: "legend"
        });
        try {
            L.apply(A = I.call(x.childNodes), x.childNodes);
            A[x.childNodes.length].nodeType;
        } catch (oe) {
            L = {
                apply: A.length ? function(e, t) {
                    j.apply(e, I.call(t));
                } : function(e, t) {
                    var n = e.length, i = 0;
                    while (e[n++] = t[i++]) {}
                    e.length = n - 1;
                }
            };
        }
        function ae(e, t, i, r) {
            var o, s, f, u, c, h, m, y = t && t.ownerDocument, C = t ? t.nodeType : 9;
            i = i || [];
            if (typeof e !== "string" || !e || C !== 1 && C !== 9 && C !== 11) {
                return i;
            }
            if (!r) {
                if ((t ? t.ownerDocument || t : x) !== p) {
                    d(t);
                }
                t = t || p;
                if (g) {
                    if (C !== 11 && (c = J.exec(e))) {
                        if (o = c[1]) {
                            if (C === 9) {
                                if (f = t.getElementById(o)) {
                                    if (f.id === o) {
                                        i.push(f);
                                        return i;
                                    }
                                } else {
                                    return i;
                                }
                            } else {
                                if (y && (f = y.getElementById(o)) && b(t, f) && f.id === o) {
                                    i.push(f);
                                    return i;
                                }
                            }
                        } else if (c[2]) {
                            L.apply(i, t.getElementsByTagName(e));
                            return i;
                        } else if ((o = c[3]) && n.getElementsByClassName && t.getElementsByClassName) {
                            L.apply(i, t.getElementsByClassName(o));
                            return i;
                        }
                    }
                    if (n.qsa && !S[e + " "] && (!v || !v.test(e))) {
                        if (C !== 1) {
                            y = t;
                            m = e;
                        } else if (t.nodeName.toLowerCase() !== "object") {
                            if (u = t.getAttribute("id")) {
                                u = u.replace(te, ne);
                            } else {
                                t.setAttribute("id", u = w);
                            }
                            h = a(e);
                            s = h.length;
                            while (s--) {
                                h[s] = "#" + u + " " + ye(h[s]);
                            }
                            m = h.join(",");
                            y = K.test(e) && ve(t.parentNode) || t;
                        }
                        if (m) {
                            try {
                                L.apply(i, y.querySelectorAll(m));
                                return i;
                            } catch (T) {} finally {
                                if (u === w) {
                                    t.removeAttribute("id");
                                }
                            }
                        }
                    }
                }
            }
            return l(e.replace(_, "$1"), t, i, r);
        }
        function se() {
            var e = [];
            function t(n, r) {
                if (e.push(n + " ") > i.cacheLength) {
                    delete t[e.shift()];
                }
                return t[n + " "] = r;
            }
            return t;
        }
        function le(e) {
            e[w] = true;
            return e;
        }
        function fe(e) {
            var t = p.createElement("fieldset");
            try {
                return !!e(t);
            } catch (n) {
                return false;
            } finally {
                if (t.parentNode) {
                    t.parentNode.removeChild(t);
                }
                t = null;
            }
        }
        function ue(e, t) {
            var n = e.split("|"), r = n.length;
            while (r--) {
                i.attrHandle[n[r]] = t;
            }
        }
        function ce(e, t) {
            var n = t && e, i = n && e.nodeType === 1 && t.nodeType === 1 && e.sourceIndex - t.sourceIndex;
            if (i) {
                return i;
            }
            if (n) {
                while (n = n.nextSibling) {
                    if (n === t) {
                        return -1;
                    }
                }
            }
            return e ? 1 : -1;
        }
        function de(e) {
            return function(t) {
                var n = t.nodeName.toLowerCase();
                return n === "input" && t.type === e;
            };
        }
        function pe(e) {
            return function(t) {
                var n = t.nodeName.toLowerCase();
                return (n === "input" || n === "button") && t.type === e;
            };
        }
        function he(e) {
            return function(t) {
                if ("form" in t) {
                    if (t.parentNode && t.disabled === false) {
                        if ("label" in t) {
                            if ("label" in t.parentNode) {
                                return t.parentNode.disabled === e;
                            } else {
                                return t.disabled === e;
                            }
                        }
                        return t.isDisabled === e || t.isDisabled !== !e && re(t) === e;
                    }
                    return t.disabled === e;
                } else if ("label" in t) {
                    return t.disabled === e;
                }
                return false;
            };
        }
        function ge(e) {
            return le(function(t) {
                t = +t;
                return le(function(n, i) {
                    var r, o = e([], n.length, t), a = o.length;
                    while (a--) {
                        if (n[r = o[a]]) {
                            n[r] = !(i[r] = n[r]);
                        }
                    }
                });
            });
        }
        function ve(e) {
            return e && typeof e.getElementsByTagName !== "undefined" && e;
        }
        n = ae.support = {};
        o = ae.isXML = function(e) {
            var t = e && (e.ownerDocument || e).documentElement;
            return t ? t.nodeName !== "HTML" : false;
        };
        d = ae.setDocument = function(e) {
            var t, r, a = e ? e.ownerDocument || e : x;
            if (a === p || a.nodeType !== 9 || !a.documentElement) {
                return p;
            }
            p = a;
            h = p.documentElement;
            g = !o(p);
            if (x !== p && (r = p.defaultView) && r.top !== r) {
                if (r.addEventListener) {
                    r.addEventListener("unload", ie, false);
                } else if (r.attachEvent) {
                    r.attachEvent("onunload", ie);
                }
            }
            n.attributes = fe(function(e) {
                e.className = "i";
                return !e.getAttribute("className");
            });
            n.getElementsByTagName = fe(function(e) {
                e.appendChild(p.createComment(""));
                return !e.getElementsByTagName("*").length;
            });
            n.getElementsByClassName = Y.test(p.getElementsByClassName);
            n.getById = fe(function(e) {
                h.appendChild(e).id = w;
                return !p.getElementsByName || !p.getElementsByName(w).length;
            });
            if (n.getById) {
                i.filter["ID"] = function(e) {
                    var t = e.replace(Z, ee);
                    return function(e) {
                        return e.getAttribute("id") === t;
                    };
                };
                i.find["ID"] = function(e, t) {
                    if (typeof t.getElementById !== "undefined" && g) {
                        var n = t.getElementById(e);
                        return n ? [ n ] : [];
                    }
                };
            } else {
                i.filter["ID"] = function(e) {
                    var t = e.replace(Z, ee);
                    return function(e) {
                        var n = typeof e.getAttributeNode !== "undefined" && e.getAttributeNode("id");
                        return n && n.value === t;
                    };
                };
                i.find["ID"] = function(e, t) {
                    if (typeof t.getElementById !== "undefined" && g) {
                        var n, i, r, o = t.getElementById(e);
                        if (o) {
                            n = o.getAttributeNode("id");
                            if (n && n.value === e) {
                                return [ o ];
                            }
                            r = t.getElementsByName(e);
                            i = 0;
                            while (o = r[i++]) {
                                n = o.getAttributeNode("id");
                                if (n && n.value === e) {
                                    return [ o ];
                                }
                            }
                        }
                        return [];
                    }
                };
            }
            i.find["TAG"] = n.getElementsByTagName ? function(e, t) {
                if (typeof t.getElementsByTagName !== "undefined") {
                    return t.getElementsByTagName(e);
                } else if (n.qsa) {
                    return t.querySelectorAll(e);
                }
            } : function(e, t) {
                var n, i = [], r = 0, o = t.getElementsByTagName(e);
                if (e === "*") {
                    while (n = o[r++]) {
                        if (n.nodeType === 1) {
                            i.push(n);
                        }
                    }
                    return i;
                }
                return o;
            };
            i.find["CLASS"] = n.getElementsByClassName && function(e, t) {
                if (typeof t.getElementsByClassName !== "undefined" && g) {
                    return t.getElementsByClassName(e);
                }
            };
            m = [];
            v = [];
            if (n.qsa = Y.test(p.querySelectorAll)) {
                fe(function(e) {
                    h.appendChild(e).innerHTML = "<a id='" + w + "'></a>" + "<select id='" + w + "-\r\\' msallowcapture=''>" + "<option selected=''></option></select>";
                    if (e.querySelectorAll("[msallowcapture^='']").length) {
                        v.push("[*^$]=" + H + "*(?:''|\"\")");
                    }
                    if (!e.querySelectorAll("[selected]").length) {
                        v.push("\\[" + H + "*(?:value|" + O + ")");
                    }
                    if (!e.querySelectorAll("[id~=" + w + "-]").length) {
                        v.push("~=");
                    }
                    if (!e.querySelectorAll(":checked").length) {
                        v.push(":checked");
                    }
                    if (!e.querySelectorAll("a#" + w + "+*").length) {
                        v.push(".#.+[+~]");
                    }
                });
                fe(function(e) {
                    e.innerHTML = "<a href='' disabled='disabled'></a>" + "<select disabled='disabled'><option/></select>";
                    var t = p.createElement("input");
                    t.setAttribute("type", "hidden");
                    e.appendChild(t).setAttribute("name", "D");
                    if (e.querySelectorAll("[name=d]").length) {
                        v.push("name" + H + "*[*^$|!~]?=");
                    }
                    if (e.querySelectorAll(":enabled").length !== 2) {
                        v.push(":enabled", ":disabled");
                    }
                    h.appendChild(e).disabled = true;
                    if (e.querySelectorAll(":disabled").length !== 2) {
                        v.push(":enabled", ":disabled");
                    }
                    e.querySelectorAll("*,:x");
                    v.push(",.*:");
                });
            }
            if (n.matchesSelector = Y.test(y = h.matches || h.webkitMatchesSelector || h.mozMatchesSelector || h.oMatchesSelector || h.msMatchesSelector)) {
                fe(function(e) {
                    n.disconnectedMatch = y.call(e, "*");
                    y.call(e, "[s!='']:x");
                    m.push("!=", B);
                });
            }
            v = v.length && new RegExp(v.join("|"));
            m = m.length && new RegExp(m.join("|"));
            t = Y.test(h.compareDocumentPosition);
            b = t || Y.test(h.contains) ? function(e, t) {
                var n = e.nodeType === 9 ? e.documentElement : e, i = t && t.parentNode;
                return e === i || !!(i && i.nodeType === 1 && (n.contains ? n.contains(i) : e.compareDocumentPosition && e.compareDocumentPosition(i) & 16));
            } : function(e, t) {
                if (t) {
                    while (t = t.parentNode) {
                        if (t === e) {
                            return true;
                        }
                    }
                }
                return false;
            };
            E = t ? function(e, t) {
                if (e === t) {
                    c = true;
                    return 0;
                }
                var i = !e.compareDocumentPosition - !t.compareDocumentPosition;
                if (i) {
                    return i;
                }
                i = (e.ownerDocument || e) === (t.ownerDocument || t) ? e.compareDocumentPosition(t) : 1;
                if (i & 1 || !n.sortDetached && t.compareDocumentPosition(e) === i) {
                    if (e === p || e.ownerDocument === x && b(x, e)) {
                        return -1;
                    }
                    if (t === p || t.ownerDocument === x && b(x, t)) {
                        return 1;
                    }
                    return u ? P(u, e) - P(u, t) : 0;
                }
                return i & 4 ? -1 : 1;
            } : function(e, t) {
                if (e === t) {
                    c = true;
                    return 0;
                }
                var n, i = 0, r = e.parentNode, o = t.parentNode, a = [ e ], s = [ t ];
                if (!r || !o) {
                    return e === p ? -1 : t === p ? 1 : r ? -1 : o ? 1 : u ? P(u, e) - P(u, t) : 0;
                } else if (r === o) {
                    return ce(e, t);
                }
                n = e;
                while (n = n.parentNode) {
                    a.unshift(n);
                }
                n = t;
                while (n = n.parentNode) {
                    s.unshift(n);
                }
                while (a[i] === s[i]) {
                    i++;
                }
                return i ? ce(a[i], s[i]) : a[i] === x ? -1 : s[i] === x ? 1 : 0;
            };
            return p;
        };
        ae.matches = function(e, t) {
            return ae(e, null, null, t);
        };
        ae.matchesSelector = function(e, t) {
            if ((e.ownerDocument || e) !== p) {
                d(e);
            }
            t = t.replace(W, "='$1']");
            if (n.matchesSelector && g && !S[t + " "] && (!m || !m.test(t)) && (!v || !v.test(t))) {
                try {
                    var i = y.call(e, t);
                    if (i || n.disconnectedMatch || e.document && e.document.nodeType !== 11) {
                        return i;
                    }
                } catch (r) {}
            }
            return ae(t, p, null, [ e ]).length > 0;
        };
        ae.contains = function(e, t) {
            if ((e.ownerDocument || e) !== p) {
                d(e);
            }
            return b(e, t);
        };
        ae.attr = function(e, t) {
            if ((e.ownerDocument || e) !== p) {
                d(e);
            }
            var r = i.attrHandle[t.toLowerCase()], o = r && $.call(i.attrHandle, t.toLowerCase()) ? r(e, t, !g) : undefined;
            return o !== undefined ? o : n.attributes || !g ? e.getAttribute(t) : (o = e.getAttributeNode(t)) && o.specified ? o.value : null;
        };
        ae.escape = function(e) {
            return (e + "").replace(te, ne);
        };
        ae.error = function(e) {
            throw new Error("Syntax error, unrecognized expression: " + e);
        };
        ae.uniqueSort = function(e) {
            var t, i = [], r = 0, o = 0;
            c = !n.detectDuplicates;
            u = !n.sortStable && e.slice(0);
            e.sort(E);
            if (c) {
                while (t = e[o++]) {
                    if (t === e[o]) {
                        r = i.push(o);
                    }
                }
                while (r--) {
                    e.splice(i[r], 1);
                }
            }
            u = null;
            return e;
        };
        r = ae.getText = function(e) {
            var t, n = "", i = 0, o = e.nodeType;
            if (!o) {
                while (t = e[i++]) {
                    n += r(t);
                }
            } else if (o === 1 || o === 9 || o === 11) {
                if (typeof e.textContent === "string") {
                    return e.textContent;
                } else {
                    for (e = e.firstChild; e; e = e.nextSibling) {
                        n += r(e);
                    }
                }
            } else if (o === 3 || o === 4) {
                return e.nodeValue;
            }
            return n;
        };
        i = ae.selectors = {
            cacheLength: 50,
            createPseudo: le,
            match: Q,
            attrHandle: {},
            find: {},
            relative: {
                ">": {
                    dir: "parentNode",
                    first: true
                },
                " ": {
                    dir: "parentNode"
                },
                "+": {
                    dir: "previousSibling",
                    first: true
                },
                "~": {
                    dir: "previousSibling"
                }
            },
            preFilter: {
                ATTR: function(e) {
                    e[1] = e[1].replace(Z, ee);
                    e[3] = (e[3] || e[4] || e[5] || "").replace(Z, ee);
                    if (e[2] === "~=") {
                        e[3] = " " + e[3] + " ";
                    }
                    return e.slice(0, 4);
                },
                CHILD: function(e) {
                    e[1] = e[1].toLowerCase();
                    if (e[1].slice(0, 3) === "nth") {
                        if (!e[3]) {
                            ae.error(e[0]);
                        }
                        e[4] = +(e[4] ? e[5] + (e[6] || 1) : 2 * (e[3] === "even" || e[3] === "odd"));
                        e[5] = +(e[7] + e[8] || e[3] === "odd");
                    } else if (e[3]) {
                        ae.error(e[0]);
                    }
                    return e;
                },
                PSEUDO: function(e) {
                    var t, n = !e[6] && e[2];
                    if (Q["CHILD"].test(e[0])) {
                        return null;
                    }
                    if (e[3]) {
                        e[2] = e[4] || e[5] || "";
                    } else if (n && z.test(n) && (t = a(n, true)) && (t = n.indexOf(")", n.length - t) - n.length)) {
                        e[0] = e[0].slice(0, t);
                        e[2] = n.slice(0, t);
                    }
                    return e.slice(0, 3);
                }
            },
            filter: {
                TAG: function(e) {
                    var t = e.replace(Z, ee).toLowerCase();
                    return e === "*" ? function() {
                        return true;
                    } : function(e) {
                        return e.nodeName && e.nodeName.toLowerCase() === t;
                    };
                },
                CLASS: function(e) {
                    var t = D[e + " "];
                    return t || (t = new RegExp("(^|" + H + ")" + e + "(" + H + "|$)")) && D(e, function(e) {
                        return t.test(typeof e.className === "string" && e.className || typeof e.getAttribute !== "undefined" && e.getAttribute("class") || "");
                    });
                },
                ATTR: function(e, t, n) {
                    return function(i) {
                        var r = ae.attr(i, e);
                        if (r == null) {
                            return t === "!=";
                        }
                        if (!t) {
                            return true;
                        }
                        r += "";
                        return t === "=" ? r === n : t === "!=" ? r !== n : t === "^=" ? n && r.indexOf(n) === 0 : t === "*=" ? n && r.indexOf(n) > -1 : t === "$=" ? n && r.slice(-n.length) === n : t === "~=" ? (" " + r.replace(M, " ") + " ").indexOf(n) > -1 : t === "|=" ? r === n || r.slice(0, n.length + 1) === n + "-" : false;
                    };
                },
                CHILD: function(e, t, n, i, r) {
                    var o = e.slice(0, 3) !== "nth", a = e.slice(-4) !== "last", s = t === "of-type";
                    return i === 1 && r === 0 ? function(e) {
                        return !!e.parentNode;
                    } : function(t, n, l) {
                        var f, u, c, d, p, h, g = o !== a ? "nextSibling" : "previousSibling", v = t.parentNode, m = s && t.nodeName.toLowerCase(), y = !l && !s, b = false;
                        if (v) {
                            if (o) {
                                while (g) {
                                    d = t;
                                    while (d = d[g]) {
                                        if (s ? d.nodeName.toLowerCase() === m : d.nodeType === 1) {
                                            return false;
                                        }
                                    }
                                    h = g = e === "only" && !h && "nextSibling";
                                }
                                return true;
                            }
                            h = [ a ? v.firstChild : v.lastChild ];
                            if (a && y) {
                                d = v;
                                c = d[w] || (d[w] = {});
                                u = c[d.uniqueID] || (c[d.uniqueID] = {});
                                f = u[e] || [];
                                p = f[0] === C && f[1];
                                b = p && f[2];
                                d = p && v.childNodes[p];
                                while (d = ++p && d && d[g] || (b = p = 0) || h.pop()) {
                                    if (d.nodeType === 1 && ++b && d === t) {
                                        u[e] = [ C, p, b ];
                                        break;
                                    }
                                }
                            } else {
                                if (y) {
                                    d = t;
                                    c = d[w] || (d[w] = {});
                                    u = c[d.uniqueID] || (c[d.uniqueID] = {});
                                    f = u[e] || [];
                                    p = f[0] === C && f[1];
                                    b = p;
                                }
                                if (b === false) {
                                    while (d = ++p && d && d[g] || (b = p = 0) || h.pop()) {
                                        if ((s ? d.nodeName.toLowerCase() === m : d.nodeType === 1) && ++b) {
                                            if (y) {
                                                c = d[w] || (d[w] = {});
                                                u = c[d.uniqueID] || (c[d.uniqueID] = {});
                                                u[e] = [ C, b ];
                                            }
                                            if (d === t) {
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            b -= r;
                            return b === i || b % i === 0 && b / i >= 0;
                        }
                    };
                },
                PSEUDO: function(e, t) {
                    var n, r = i.pseudos[e] || i.setFilters[e.toLowerCase()] || ae.error("unsupported pseudo: " + e);
                    if (r[w]) {
                        return r(t);
                    }
                    if (r.length > 1) {
                        n = [ e, e, "", t ];
                        return i.setFilters.hasOwnProperty(e.toLowerCase()) ? le(function(e, n) {
                            var i, o = r(e, t), a = o.length;
                            while (a--) {
                                i = P(e, o[a]);
                                e[i] = !(n[i] = o[a]);
                            }
                        }) : function(e) {
                            return r(e, 0, n);
                        };
                    }
                    return r;
                }
            },
            pseudos: {
                not: le(function(e) {
                    var t = [], n = [], i = s(e.replace(_, "$1"));
                    return i[w] ? le(function(e, t, n, r) {
                        var o, a = i(e, null, r, []), s = e.length;
                        while (s--) {
                            if (o = a[s]) {
                                e[s] = !(t[s] = o);
                            }
                        }
                    }) : function(e, r, o) {
                        t[0] = e;
                        i(t, null, o, n);
                        t[0] = null;
                        return !n.pop();
                    };
                }),
                has: le(function(e) {
                    return function(t) {
                        return ae(e, t).length > 0;
                    };
                }),
                contains: le(function(e) {
                    e = e.replace(Z, ee);
                    return function(t) {
                        return (t.textContent || t.innerText || r(t)).indexOf(e) > -1;
                    };
                }),
                lang: le(function(e) {
                    if (!G.test(e || "")) {
                        ae.error("unsupported lang: " + e);
                    }
                    e = e.replace(Z, ee).toLowerCase();
                    return function(t) {
                        var n;
                        do {
                            if (n = g ? t.lang : t.getAttribute("xml:lang") || t.getAttribute("lang")) {
                                n = n.toLowerCase();
                                return n === e || n.indexOf(e + "-") === 0;
                            }
                        } while ((t = t.parentNode) && t.nodeType === 1);
                        return false;
                    };
                }),
                target: function(t) {
                    var n = e.location && e.location.hash;
                    return n && n.slice(1) === t.id;
                },
                root: function(e) {
                    return e === h;
                },
                focus: function(e) {
                    return e === p.activeElement && (!p.hasFocus || p.hasFocus()) && !!(e.type || e.href || ~e.tabIndex);
                },
                enabled: he(false),
                disabled: he(true),
                checked: function(e) {
                    var t = e.nodeName.toLowerCase();
                    return t === "input" && !!e.checked || t === "option" && !!e.selected;
                },
                selected: function(e) {
                    if (e.parentNode) {
                        e.parentNode.selectedIndex;
                    }
                    return e.selected === true;
                },
                empty: function(e) {
                    for (e = e.firstChild; e; e = e.nextSibling) {
                        if (e.nodeType < 6) {
                            return false;
                        }
                    }
                    return true;
                },
                parent: function(e) {
                    return !i.pseudos["empty"](e);
                },
                header: function(e) {
                    return X.test(e.nodeName);
                },
                input: function(e) {
                    return V.test(e.nodeName);
                },
                button: function(e) {
                    var t = e.nodeName.toLowerCase();
                    return t === "input" && e.type === "button" || t === "button";
                },
                text: function(e) {
                    var t;
                    return e.nodeName.toLowerCase() === "input" && e.type === "text" && ((t = e.getAttribute("type")) == null || t.toLowerCase() === "text");
                },
                first: ge(function() {
                    return [ 0 ];
                }),
                last: ge(function(e, t) {
                    return [ t - 1 ];
                }),
                eq: ge(function(e, t, n) {
                    return [ n < 0 ? n + t : n ];
                }),
                even: ge(function(e, t) {
                    var n = 0;
                    for (;n < t; n += 2) {
                        e.push(n);
                    }
                    return e;
                }),
                odd: ge(function(e, t) {
                    var n = 1;
                    for (;n < t; n += 2) {
                        e.push(n);
                    }
                    return e;
                }),
                lt: ge(function(e, t, n) {
                    var i = n < 0 ? n + t : n;
                    for (;--i >= 0; ) {
                        e.push(i);
                    }
                    return e;
                }),
                gt: ge(function(e, t, n) {
                    var i = n < 0 ? n + t : n;
                    for (;++i < t; ) {
                        e.push(i);
                    }
                    return e;
                })
            }
        };
        i.pseudos["nth"] = i.pseudos["eq"];
        for (t in {
            radio: true,
            checkbox: true,
            file: true,
            password: true,
            image: true
        }) {
            i.pseudos[t] = de(t);
        }
        for (t in {
            submit: true,
            reset: true
        }) {
            i.pseudos[t] = pe(t);
        }
        function me() {}
        me.prototype = i.filters = i.pseudos;
        i.setFilters = new me();
        a = ae.tokenize = function(e, t) {
            var n, r, o, a, s, l, f, u = k[e + " "];
            if (u) {
                return t ? 0 : u.slice(0);
            }
            s = e;
            l = [];
            f = i.preFilter;
            while (s) {
                if (!n || (r = F.exec(s))) {
                    if (r) {
                        s = s.slice(r[0].length) || s;
                    }
                    l.push(o = []);
                }
                n = false;
                if (r = U.exec(s)) {
                    n = r.shift();
                    o.push({
                        value: n,
                        type: r[0].replace(_, " ")
                    });
                    s = s.slice(n.length);
                }
                for (a in i.filter) {
                    if ((r = Q[a].exec(s)) && (!f[a] || (r = f[a](r)))) {
                        n = r.shift();
                        o.push({
                            value: n,
                            type: a,
                            matches: r
                        });
                        s = s.slice(n.length);
                    }
                }
                if (!n) {
                    break;
                }
            }
            return t ? s.length : s ? ae.error(e) : k(e, l).slice(0);
        };
        function ye(e) {
            var t = 0, n = e.length, i = "";
            for (;t < n; t++) {
                i += e[t].value;
            }
            return i;
        }
        function be(e, t, n) {
            var i = t.dir, r = t.next, o = r || i, a = n && o === "parentNode", s = T++;
            return t.first ? function(t, n, r) {
                while (t = t[i]) {
                    if (t.nodeType === 1 || a) {
                        return e(t, n, r);
                    }
                }
                return false;
            } : function(t, n, l) {
                var f, u, c, d = [ C, s ];
                if (l) {
                    while (t = t[i]) {
                        if (t.nodeType === 1 || a) {
                            if (e(t, n, l)) {
                                return true;
                            }
                        }
                    }
                } else {
                    while (t = t[i]) {
                        if (t.nodeType === 1 || a) {
                            c = t[w] || (t[w] = {});
                            u = c[t.uniqueID] || (c[t.uniqueID] = {});
                            if (r && r === t.nodeName.toLowerCase()) {
                                t = t[i] || t;
                            } else if ((f = u[o]) && f[0] === C && f[1] === s) {
                                return d[2] = f[2];
                            } else {
                                u[o] = d;
                                if (d[2] = e(t, n, l)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            };
        }
        function we(e) {
            return e.length > 1 ? function(t, n, i) {
                var r = e.length;
                while (r--) {
                    if (!e[r](t, n, i)) {
                        return false;
                    }
                }
                return true;
            } : e[0];
        }
        function xe(e, t, n) {
            var i = 0, r = t.length;
            for (;i < r; i++) {
                ae(e, t[i], n);
            }
            return n;
        }
        function Ce(e, t, n, i, r) {
            var o, a = [], s = 0, l = e.length, f = t != null;
            for (;s < l; s++) {
                if (o = e[s]) {
                    if (!n || n(o, i, r)) {
                        a.push(o);
                        if (f) {
                            t.push(s);
                        }
                    }
                }
            }
            return a;
        }
        function Te(e, t, n, i, r, o) {
            if (i && !i[w]) {
                i = Te(i);
            }
            if (r && !r[w]) {
                r = Te(r, o);
            }
            return le(function(o, a, s, l) {
                var f, u, c, d = [], p = [], h = a.length, g = o || xe(t || "*", s.nodeType ? [ s ] : s, []), v = e && (o || !t) ? Ce(g, d, e, s, l) : g, m = n ? r || (o ? e : h || i) ? [] : a : v;
                if (n) {
                    n(v, m, s, l);
                }
                if (i) {
                    f = Ce(m, p);
                    i(f, [], s, l);
                    u = f.length;
                    while (u--) {
                        if (c = f[u]) {
                            m[p[u]] = !(v[p[u]] = c);
                        }
                    }
                }
                if (o) {
                    if (r || e) {
                        if (r) {
                            f = [];
                            u = m.length;
                            while (u--) {
                                if (c = m[u]) {
                                    f.push(v[u] = c);
                                }
                            }
                            r(null, m = [], f, l);
                        }
                        u = m.length;
                        while (u--) {
                            if ((c = m[u]) && (f = r ? P(o, c) : d[u]) > -1) {
                                o[f] = !(a[f] = c);
                            }
                        }
                    }
                } else {
                    m = Ce(m === a ? m.splice(h, m.length) : m);
                    if (r) {
                        r(null, a, m, l);
                    } else {
                        L.apply(a, m);
                    }
                }
            });
        }
        function De(e) {
            var t, n, r, o = e.length, a = i.relative[e[0].type], s = a || i.relative[" "], l = a ? 1 : 0, u = be(function(e) {
                return e === t;
            }, s, true), c = be(function(e) {
                return P(t, e) > -1;
            }, s, true), d = [ function(e, n, i) {
                var r = !a && (i || n !== f) || ((t = n).nodeType ? u(e, n, i) : c(e, n, i));
                t = null;
                return r;
            } ];
            for (;l < o; l++) {
                if (n = i.relative[e[l].type]) {
                    d = [ be(we(d), n) ];
                } else {
                    n = i.filter[e[l].type].apply(null, e[l].matches);
                    if (n[w]) {
                        r = ++l;
                        for (;r < o; r++) {
                            if (i.relative[e[r].type]) {
                                break;
                            }
                        }
                        return Te(l > 1 && we(d), l > 1 && ye(e.slice(0, l - 1).concat({
                            value: e[l - 2].type === " " ? "*" : ""
                        })).replace(_, "$1"), n, l < r && De(e.slice(l, r)), r < o && De(e = e.slice(r)), r < o && ye(e));
                    }
                    d.push(n);
                }
            }
            return we(d);
        }
        function ke(e, t) {
            var n = t.length > 0, r = e.length > 0, o = function(o, a, s, l, u) {
                var c, h, v, m = 0, y = "0", b = o && [], w = [], x = f, T = o || r && i.find["TAG"]("*", u), D = C += x == null ? 1 : Math.random() || .1, k = T.length;
                if (u) {
                    f = a === p || a || u;
                }
                for (;y !== k && (c = T[y]) != null; y++) {
                    if (r && c) {
                        h = 0;
                        if (!a && c.ownerDocument !== p) {
                            d(c);
                            s = !g;
                        }
                        while (v = e[h++]) {
                            if (v(c, a || p, s)) {
                                l.push(c);
                                break;
                            }
                        }
                        if (u) {
                            C = D;
                        }
                    }
                    if (n) {
                        if (c = !v && c) {
                            m--;
                        }
                        if (o) {
                            b.push(c);
                        }
                    }
                }
                m += y;
                if (n && y !== m) {
                    h = 0;
                    while (v = t[h++]) {
                        v(b, w, a, s);
                    }
                    if (o) {
                        if (m > 0) {
                            while (y--) {
                                if (!(b[y] || w[y])) {
                                    w[y] = N.call(l);
                                }
                            }
                        }
                        w = Ce(w);
                    }
                    L.apply(l, w);
                    if (u && !o && w.length > 0 && m + t.length > 1) {
                        ae.uniqueSort(l);
                    }
                }
                if (u) {
                    C = D;
                    f = x;
                }
                return b;
            };
            return n ? le(o) : o;
        }
        s = ae.compile = function(e, t) {
            var n, i = [], r = [], o = S[e + " "];
            if (!o) {
                if (!t) {
                    t = a(e);
                }
                n = t.length;
                while (n--) {
                    o = De(t[n]);
                    if (o[w]) {
                        i.push(o);
                    } else {
                        r.push(o);
                    }
                }
                o = S(e, ke(r, i));
                o.selector = e;
            }
            return o;
        };
        l = ae.select = function(e, t, n, r) {
            var o, l, f, u, c, d = typeof e === "function" && e, p = !r && a(e = d.selector || e);
            n = n || [];
            if (p.length === 1) {
                l = p[0] = p[0].slice(0);
                if (l.length > 2 && (f = l[0]).type === "ID" && t.nodeType === 9 && g && i.relative[l[1].type]) {
                    t = (i.find["ID"](f.matches[0].replace(Z, ee), t) || [])[0];
                    if (!t) {
                        return n;
                    } else if (d) {
                        t = t.parentNode;
                    }
                    e = e.slice(l.shift().value.length);
                }
                o = Q["needsContext"].test(e) ? 0 : l.length;
                while (o--) {
                    f = l[o];
                    if (i.relative[u = f.type]) {
                        break;
                    }
                    if (c = i.find[u]) {
                        if (r = c(f.matches[0].replace(Z, ee), K.test(l[0].type) && ve(t.parentNode) || t)) {
                            l.splice(o, 1);
                            e = r.length && ye(l);
                            if (!e) {
                                L.apply(n, r);
                                return n;
                            }
                            break;
                        }
                    }
                }
            }
            (d || s(e, p))(r, t, !g, n, !t || K.test(e) && ve(t.parentNode) || t);
            return n;
        };
        n.sortStable = w.split("").sort(E).join("") === w;
        n.detectDuplicates = !!c;
        d();
        n.sortDetached = fe(function(e) {
            return e.compareDocumentPosition(p.createElement("fieldset")) & 1;
        });
        if (!fe(function(e) {
            e.innerHTML = "<a href='#'></a>";
            return e.firstChild.getAttribute("href") === "#";
        })) {
            ue("type|href|height|width", function(e, t, n) {
                if (!n) {
                    return e.getAttribute(t, t.toLowerCase() === "type" ? 1 : 2);
                }
            });
        }
        if (!n.attributes || !fe(function(e) {
            e.innerHTML = "<input/>";
            e.firstChild.setAttribute("value", "");
            return e.firstChild.getAttribute("value") === "";
        })) {
            ue("value", function(e, t, n) {
                if (!n && e.nodeName.toLowerCase() === "input") {
                    return e.defaultValue;
                }
            });
        }
        if (!fe(function(e) {
            return e.getAttribute("disabled") == null;
        })) {
            ue(O, function(e, t, n) {
                var i;
                if (!n) {
                    return e[t] === true ? t.toLowerCase() : (i = e.getAttributeNode(t)) && i.specified ? i.value : null;
                }
            });
        }
        return ae;
    }(e);
    x.find = D;
    x.expr = D.selectors;
    x.expr[":"] = x.expr.pseudos;
    x.uniqueSort = x.unique = D.uniqueSort;
    x.text = D.getText;
    x.isXMLDoc = D.isXML;
    x.contains = D.contains;
    x.escapeSelector = D.escape;
    var k = function(e, t, n) {
        var i = [], r = n !== undefined;
        while ((e = e[t]) && e.nodeType !== 9) {
            if (e.nodeType === 1) {
                if (r && x(e).is(n)) {
                    break;
                }
                i.push(e);
            }
        }
        return i;
    };
    var S = function(e, t) {
        var n = [];
        for (;e; e = e.nextSibling) {
            if (e.nodeType === 1 && e !== t) {
                n.push(e);
            }
        }
        return n;
    };
    var E = x.expr.match.needsContext;
    function $(e, t) {
        return e.nodeName && e.nodeName.toLowerCase() === t.toLowerCase();
    }
    var A = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;
    function N(e, t, n) {
        if (g(t)) {
            return x.grep(e, function(e, i) {
                return !!t.call(e, i, e) !== n;
            });
        }
        if (t.nodeType) {
            return x.grep(e, function(e) {
                return e === t !== n;
            });
        }
        if (typeof t !== "string") {
            return x.grep(e, function(e) {
                return l.call(t, e) > -1 !== n;
            });
        }
        return x.filter(t, e, n);
    }
    x.filter = function(e, t, n) {
        var i = t[0];
        if (n) {
            e = ":not(" + e + ")";
        }
        if (t.length === 1 && i.nodeType === 1) {
            return x.find.matchesSelector(i, e) ? [ i ] : [];
        }
        return x.find.matches(e, x.grep(t, function(e) {
            return e.nodeType === 1;
        }));
    };
    x.fn.extend({
        find: function(e) {
            var t, n, i = this.length, r = this;
            if (typeof e !== "string") {
                return this.pushStack(x(e).filter(function() {
                    for (t = 0; t < i; t++) {
                        if (x.contains(r[t], this)) {
                            return true;
                        }
                    }
                }));
            }
            n = this.pushStack([]);
            for (t = 0; t < i; t++) {
                x.find(e, r[t], n);
            }
            return i > 1 ? x.uniqueSort(n) : n;
        },
        filter: function(e) {
            return this.pushStack(N(this, e || [], false));
        },
        not: function(e) {
            return this.pushStack(N(this, e || [], true));
        },
        is: function(e) {
            return !!N(this, typeof e === "string" && E.test(e) ? x(e) : e || [], false).length;
        }
    });
    var j, L = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/, I = x.fn.init = function(e, t, n) {
        var r, o;
        if (!e) {
            return this;
        }
        n = n || j;
        if (typeof e === "string") {
            if (e[0] === "<" && e[e.length - 1] === ">" && e.length >= 3) {
                r = [ null, e, null ];
            } else {
                r = L.exec(e);
            }
            if (r && (r[1] || !t)) {
                if (r[1]) {
                    t = t instanceof x ? t[0] : t;
                    x.merge(this, x.parseHTML(r[1], t && t.nodeType ? t.ownerDocument || t : i, true));
                    if (A.test(r[1]) && x.isPlainObject(t)) {
                        for (r in t) {
                            if (g(this[r])) {
                                this[r](t[r]);
                            } else {
                                this.attr(r, t[r]);
                            }
                        }
                    }
                    return this;
                } else {
                    o = i.getElementById(r[2]);
                    if (o) {
                        this[0] = o;
                        this.length = 1;
                    }
                    return this;
                }
            } else if (!t || t.jquery) {
                return (t || n).find(e);
            } else {
                return this.constructor(t).find(e);
            }
        } else if (e.nodeType) {
            this[0] = e;
            this.length = 1;
            return this;
        } else if (g(e)) {
            return n.ready !== undefined ? n.ready(e) : e(x);
        }
        return x.makeArray(e, this);
    };
    I.prototype = x.fn;
    j = x(i);
    var P = /^(?:parents|prev(?:Until|All))/, O = {
        children: true,
        contents: true,
        next: true,
        prev: true
    };
    x.fn.extend({
        has: function(e) {
            var t = x(e, this), n = t.length;
            return this.filter(function() {
                var e = 0;
                for (;e < n; e++) {
                    if (x.contains(this, t[e])) {
                        return true;
                    }
                }
            });
        },
        closest: function(e, t) {
            var n, i = 0, r = this.length, o = [], a = typeof e !== "string" && x(e);
            if (!E.test(e)) {
                for (;i < r; i++) {
                    for (n = this[i]; n && n !== t; n = n.parentNode) {
                        if (n.nodeType < 11 && (a ? a.index(n) > -1 : n.nodeType === 1 && x.find.matchesSelector(n, e))) {
                            o.push(n);
                            break;
                        }
                    }
                }
            }
            return this.pushStack(o.length > 1 ? x.uniqueSort(o) : o);
        },
        index: function(e) {
            if (!e) {
                return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
            }
            if (typeof e === "string") {
                return l.call(x(e), this[0]);
            }
            return l.call(this, e.jquery ? e[0] : e);
        },
        add: function(e, t) {
            return this.pushStack(x.uniqueSort(x.merge(this.get(), x(e, t))));
        },
        addBack: function(e) {
            return this.add(e == null ? this.prevObject : this.prevObject.filter(e));
        }
    });
    function H(e, t) {
        while ((e = e[t]) && e.nodeType !== 1) {}
        return e;
    }
    x.each({
        parent: function(e) {
            var t = e.parentNode;
            return t && t.nodeType !== 11 ? t : null;
        },
        parents: function(e) {
            return k(e, "parentNode");
        },
        parentsUntil: function(e, t, n) {
            return k(e, "parentNode", n);
        },
        next: function(e) {
            return H(e, "nextSibling");
        },
        prev: function(e) {
            return H(e, "previousSibling");
        },
        nextAll: function(e) {
            return k(e, "nextSibling");
        },
        prevAll: function(e) {
            return k(e, "previousSibling");
        },
        nextUntil: function(e, t, n) {
            return k(e, "nextSibling", n);
        },
        prevUntil: function(e, t, n) {
            return k(e, "previousSibling", n);
        },
        siblings: function(e) {
            return S((e.parentNode || {}).firstChild, e);
        },
        children: function(e) {
            return S(e.firstChild);
        },
        contents: function(e) {
            if ($(e, "iframe")) {
                return e.contentDocument;
            }
            if ($(e, "template")) {
                e = e.content || e;
            }
            return x.merge([], e.childNodes);
        }
    }, function(e, t) {
        x.fn[e] = function(n, i) {
            var r = x.map(this, t, n);
            if (e.slice(-5) !== "Until") {
                i = n;
            }
            if (i && typeof i === "string") {
                r = x.filter(i, r);
            }
            if (this.length > 1) {
                if (!O[e]) {
                    x.uniqueSort(r);
                }
                if (P.test(e)) {
                    r.reverse();
                }
            }
            return this.pushStack(r);
        };
    });
    var R = /[^\x20\t\r\n\f]+/g;
    function q(e) {
        var t = {};
        x.each(e.match(R) || [], function(e, n) {
            t[n] = true;
        });
        return t;
    }
    x.Callbacks = function(e) {
        e = typeof e === "string" ? q(e) : x.extend({}, e);
        var t, n, i, r, o = [], a = [], s = -1, l = function() {
            r = r || e.once;
            i = t = true;
            for (;a.length; s = -1) {
                n = a.shift();
                while (++s < o.length) {
                    if (o[s].apply(n[0], n[1]) === false && e.stopOnFalse) {
                        s = o.length;
                        n = false;
                    }
                }
            }
            if (!e.memory) {
                n = false;
            }
            t = false;
            if (r) {
                if (n) {
                    o = [];
                } else {
                    o = "";
                }
            }
        }, f = {
            add: function() {
                if (o) {
                    if (n && !t) {
                        s = o.length - 1;
                        a.push(n);
                    }
                    (function i(t) {
                        x.each(t, function(t, n) {
                            if (g(n)) {
                                if (!e.unique || !f.has(n)) {
                                    o.push(n);
                                }
                            } else if (n && n.length && b(n) !== "string") {
                                i(n);
                            }
                        });
                    })(arguments);
                    if (n && !t) {
                        l();
                    }
                }
                return this;
            },
            remove: function() {
                x.each(arguments, function(e, t) {
                    var n;
                    while ((n = x.inArray(t, o, n)) > -1) {
                        o.splice(n, 1);
                        if (n <= s) {
                            s--;
                        }
                    }
                });
                return this;
            },
            has: function(e) {
                return e ? x.inArray(e, o) > -1 : o.length > 0;
            },
            empty: function() {
                if (o) {
                    o = [];
                }
                return this;
            },
            disable: function() {
                r = a = [];
                o = n = "";
                return this;
            },
            disabled: function() {
                return !o;
            },
            lock: function() {
                r = a = [];
                if (!n && !t) {
                    o = n = "";
                }
                return this;
            },
            locked: function() {
                return !!r;
            },
            fireWith: function(e, n) {
                if (!r) {
                    n = n || [];
                    n = [ e, n.slice ? n.slice() : n ];
                    a.push(n);
                    if (!t) {
                        l();
                    }
                }
                return this;
            },
            fire: function() {
                f.fireWith(this, arguments);
                return this;
            },
            fired: function() {
                return !!i;
            }
        };
        return f;
    };
    function B(e) {
        return e;
    }
    function M(e) {
        throw e;
    }
    function _(e, t, n, i) {
        var r;
        try {
            if (e && g(r = e.promise)) {
                r.call(e).done(t).fail(n);
            } else if (e && g(r = e.then)) {
                r.call(e, t, n);
            } else {
                t.apply(undefined, [ e ].slice(i));
            }
        } catch (e) {
            n.apply(undefined, [ e ]);
        }
    }
    x.extend({
        Deferred: function(t) {
            var n = [ [ "notify", "progress", x.Callbacks("memory"), x.Callbacks("memory"), 2 ], [ "resolve", "done", x.Callbacks("once memory"), x.Callbacks("once memory"), 0, "resolved" ], [ "reject", "fail", x.Callbacks("once memory"), x.Callbacks("once memory"), 1, "rejected" ] ], i = "pending", r = {
                state: function() {
                    return i;
                },
                always: function() {
                    o.done(arguments).fail(arguments);
                    return this;
                },
                "catch": function(e) {
                    return r.then(null, e);
                },
                pipe: function() {
                    var e = arguments;
                    return x.Deferred(function(t) {
                        x.each(n, function(n, i) {
                            var r = g(e[i[4]]) && e[i[4]];
                            o[i[1]](function() {
                                var e = r && r.apply(this, arguments);
                                if (e && g(e.promise)) {
                                    e.promise().progress(t.notify).done(t.resolve).fail(t.reject);
                                } else {
                                    t[i[0] + "With"](this, r ? [ e ] : arguments);
                                }
                            });
                        });
                        e = null;
                    }).promise();
                },
                then: function(t, i, r) {
                    var o = 0;
                    function a(t, n, i, r) {
                        return function() {
                            var s = this, l = arguments, f = function() {
                                var e, f;
                                if (t < o) {
                                    return;
                                }
                                e = i.apply(s, l);
                                if (e === n.promise()) {
                                    throw new TypeError("Thenable self-resolution");
                                }
                                f = e && (typeof e === "object" || typeof e === "function") && e.then;
                                if (g(f)) {
                                    if (r) {
                                        f.call(e, a(o, n, B, r), a(o, n, M, r));
                                    } else {
                                        o++;
                                        f.call(e, a(o, n, B, r), a(o, n, M, r), a(o, n, B, n.notifyWith));
                                    }
                                } else {
                                    if (i !== B) {
                                        s = undefined;
                                        l = [ e ];
                                    }
                                    (r || n.resolveWith)(s, l);
                                }
                            }, u = r ? f : function() {
                                try {
                                    f();
                                } catch (e) {
                                    if (x.Deferred.exceptionHook) {
                                        x.Deferred.exceptionHook(e, u.stackTrace);
                                    }
                                    if (t + 1 >= o) {
                                        if (i !== M) {
                                            s = undefined;
                                            l = [ e ];
                                        }
                                        n.rejectWith(s, l);
                                    }
                                }
                            };
                            if (t) {
                                u();
                            } else {
                                if (x.Deferred.getStackHook) {
                                    u.stackTrace = x.Deferred.getStackHook();
                                }
                                e.setTimeout(u);
                            }
                        };
                    }
                    return x.Deferred(function(e) {
                        n[0][3].add(a(0, e, g(r) ? r : B, e.notifyWith));
                        n[1][3].add(a(0, e, g(t) ? t : B));
                        n[2][3].add(a(0, e, g(i) ? i : M));
                    }).promise();
                },
                promise: function(e) {
                    return e != null ? x.extend(e, r) : r;
                }
            }, o = {};
            x.each(n, function(e, t) {
                var a = t[2], s = t[5];
                r[t[1]] = a.add;
                if (s) {
                    a.add(function() {
                        i = s;
                    }, n[3 - e][2].disable, n[3 - e][3].disable, n[0][2].lock, n[0][3].lock);
                }
                a.add(t[3].fire);
                o[t[0]] = function() {
                    o[t[0] + "With"](this === o ? undefined : this, arguments);
                    return this;
                };
                o[t[0] + "With"] = a.fireWith;
            });
            r.promise(o);
            if (t) {
                t.call(o, o);
            }
            return o;
        },
        when: function(e) {
            var t = arguments.length, n = t, i = Array(n), r = o.call(arguments), a = x.Deferred(), s = function(e) {
                return function(n) {
                    i[e] = this;
                    r[e] = arguments.length > 1 ? o.call(arguments) : n;
                    if (!--t) {
                        a.resolveWith(i, r);
                    }
                };
            };
            if (t <= 1) {
                _(e, a.done(s(n)).resolve, a.reject, !t);
                if (a.state() === "pending" || g(r[n] && r[n].then)) {
                    return a.then();
                }
            }
            while (n--) {
                _(r[n], s(n), a.reject);
            }
            return a.promise();
        }
    });
    var F = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;
    x.Deferred.exceptionHook = function(t, n) {
        if (e.console && e.console.warn && t && F.test(t.name)) {
            e.console.warn("jQuery.Deferred exception: " + t.message, t.stack, n);
        }
    };
    x.readyException = function(t) {
        e.setTimeout(function() {
            throw t;
        });
    };
    var U = x.Deferred();
    x.fn.ready = function(e) {
        U.then(e).catch(function(e) {
            x.readyException(e);
        });
        return this;
    };
    x.extend({
        isReady: false,
        readyWait: 1,
        ready: function(e) {
            if (e === true ? --x.readyWait : x.isReady) {
                return;
            }
            x.isReady = true;
            if (e !== true && --x.readyWait > 0) {
                return;
            }
            U.resolveWith(i, [ x ]);
        }
    });
    x.ready.then = U.then;
    function W() {
        i.removeEventListener("DOMContentLoaded", W);
        e.removeEventListener("load", W);
        x.ready();
    }
    if (i.readyState === "complete" || i.readyState !== "loading" && !i.documentElement.doScroll) {
        e.setTimeout(x.ready);
    } else {
        i.addEventListener("DOMContentLoaded", W);
        e.addEventListener("load", W);
    }
    var z = function(e, t, n, i, r, o, a) {
        var s = 0, l = e.length, f = n == null;
        if (b(n) === "object") {
            r = true;
            for (s in n) {
                z(e, t, s, n[s], true, o, a);
            }
        } else if (i !== undefined) {
            r = true;
            if (!g(i)) {
                a = true;
            }
            if (f) {
                if (a) {
                    t.call(e, i);
                    t = null;
                } else {
                    f = t;
                    t = function(e, t, n) {
                        return f.call(x(e), n);
                    };
                }
            }
            if (t) {
                for (;s < l; s++) {
                    t(e[s], n, a ? i : i.call(e[s], s, t(e[s], n)));
                }
            }
        }
        if (r) {
            return e;
        }
        if (f) {
            return t.call(e);
        }
        return l ? t(e[0], n) : o;
    };
    var G = /^-ms-/, Q = /-([a-z])/g;
    function V(e, t) {
        return t.toUpperCase();
    }
    function X(e) {
        return e.replace(G, "ms-").replace(Q, V);
    }
    var Y = function(e) {
        return e.nodeType === 1 || e.nodeType === 9 || !+e.nodeType;
    };
    function J() {
        this.expando = x.expando + J.uid++;
    }
    J.uid = 1;
    J.prototype = {
        cache: function(e) {
            var t = e[this.expando];
            if (!t) {
                t = {};
                if (Y(e)) {
                    if (e.nodeType) {
                        e[this.expando] = t;
                    } else {
                        Object.defineProperty(e, this.expando, {
                            value: t,
                            configurable: true
                        });
                    }
                }
            }
            return t;
        },
        set: function(e, t, n) {
            var i, r = this.cache(e);
            if (typeof t === "string") {
                r[X(t)] = n;
            } else {
                for (i in t) {
                    r[X(i)] = t[i];
                }
            }
            return r;
        },
        get: function(e, t) {
            return t === undefined ? this.cache(e) : e[this.expando] && e[this.expando][X(t)];
        },
        access: function(e, t, n) {
            if (t === undefined || t && typeof t === "string" && n === undefined) {
                return this.get(e, t);
            }
            this.set(e, t, n);
            return n !== undefined ? n : t;
        },
        remove: function(e, t) {
            var n, i = e[this.expando];
            if (i === undefined) {
                return;
            }
            if (t !== undefined) {
                if (Array.isArray(t)) {
                    t = t.map(X);
                } else {
                    t = X(t);
                    t = t in i ? [ t ] : t.match(R) || [];
                }
                n = t.length;
                while (n--) {
                    delete i[t[n]];
                }
            }
            if (t === undefined || x.isEmptyObject(i)) {
                if (e.nodeType) {
                    e[this.expando] = undefined;
                } else {
                    delete e[this.expando];
                }
            }
        },
        hasData: function(e) {
            var t = e[this.expando];
            return t !== undefined && !x.isEmptyObject(t);
        }
    };
    var K = new J();
    var Z = new J();
    var ee = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, te = /[A-Z]/g;
    function ne(e) {
        if (e === "true") {
            return true;
        }
        if (e === "false") {
            return false;
        }
        if (e === "null") {
            return null;
        }
        if (e === +e + "") {
            return +e;
        }
        if (ee.test(e)) {
            return JSON.parse(e);
        }
        return e;
    }
    function ie(e, t, n) {
        var i;
        if (n === undefined && e.nodeType === 1) {
            i = "data-" + t.replace(te, "-$&").toLowerCase();
            n = e.getAttribute(i);
            if (typeof n === "string") {
                try {
                    n = ne(n);
                } catch (r) {}
                Z.set(e, t, n);
            } else {
                n = undefined;
            }
        }
        return n;
    }
    x.extend({
        hasData: function(e) {
            return Z.hasData(e) || K.hasData(e);
        },
        data: function(e, t, n) {
            return Z.access(e, t, n);
        },
        removeData: function(e, t) {
            Z.remove(e, t);
        },
        _data: function(e, t, n) {
            return K.access(e, t, n);
        },
        _removeData: function(e, t) {
            K.remove(e, t);
        }
    });
    x.fn.extend({
        data: function(e, t) {
            var n, i, r, o = this[0], a = o && o.attributes;
            if (e === undefined) {
                if (this.length) {
                    r = Z.get(o);
                    if (o.nodeType === 1 && !K.get(o, "hasDataAttrs")) {
                        n = a.length;
                        while (n--) {
                            if (a[n]) {
                                i = a[n].name;
                                if (i.indexOf("data-") === 0) {
                                    i = X(i.slice(5));
                                    ie(o, i, r[i]);
                                }
                            }
                        }
                        K.set(o, "hasDataAttrs", true);
                    }
                }
                return r;
            }
            if (typeof e === "object") {
                return this.each(function() {
                    Z.set(this, e);
                });
            }
            return z(this, function(t) {
                var n;
                if (o && t === undefined) {
                    n = Z.get(o, e);
                    if (n !== undefined) {
                        return n;
                    }
                    n = ie(o, e);
                    if (n !== undefined) {
                        return n;
                    }
                    return;
                }
                this.each(function() {
                    Z.set(this, e, t);
                });
            }, null, t, arguments.length > 1, null, true);
        },
        removeData: function(e) {
            return this.each(function() {
                Z.remove(this, e);
            });
        }
    });
    x.extend({
        queue: function(e, t, n) {
            var i;
            if (e) {
                t = (t || "fx") + "queue";
                i = K.get(e, t);
                if (n) {
                    if (!i || Array.isArray(n)) {
                        i = K.access(e, t, x.makeArray(n));
                    } else {
                        i.push(n);
                    }
                }
                return i || [];
            }
        },
        dequeue: function(e, t) {
            t = t || "fx";
            var n = x.queue(e, t), i = n.length, r = n.shift(), o = x._queueHooks(e, t), a = function() {
                x.dequeue(e, t);
            };
            if (r === "inprogress") {
                r = n.shift();
                i--;
            }
            if (r) {
                if (t === "fx") {
                    n.unshift("inprogress");
                }
                delete o.stop;
                r.call(e, a, o);
            }
            if (!i && o) {
                o.empty.fire();
            }
        },
        _queueHooks: function(e, t) {
            var n = t + "queueHooks";
            return K.get(e, n) || K.access(e, n, {
                empty: x.Callbacks("once memory").add(function() {
                    K.remove(e, [ t + "queue", n ]);
                })
            });
        }
    });
    x.fn.extend({
        queue: function(e, t) {
            var n = 2;
            if (typeof e !== "string") {
                t = e;
                e = "fx";
                n--;
            }
            if (arguments.length < n) {
                return x.queue(this[0], e);
            }
            return t === undefined ? this : this.each(function() {
                var n = x.queue(this, e, t);
                x._queueHooks(this, e);
                if (e === "fx" && n[0] !== "inprogress") {
                    x.dequeue(this, e);
                }
            });
        },
        dequeue: function(e) {
            return this.each(function() {
                x.dequeue(this, e);
            });
        },
        clearQueue: function(e) {
            return this.queue(e || "fx", []);
        },
        promise: function(e, t) {
            var n, i = 1, r = x.Deferred(), o = this, a = this.length, s = function() {
                if (!--i) {
                    r.resolveWith(o, [ o ]);
                }
            };
            if (typeof e !== "string") {
                t = e;
                e = undefined;
            }
            e = e || "fx";
            while (a--) {
                n = K.get(o[a], e + "queueHooks");
                if (n && n.empty) {
                    i++;
                    n.empty.add(s);
                }
            }
            s();
            return r.promise(t);
        }
    });
    var re = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var oe = new RegExp("^(?:([+-])=|)(" + re + ")([a-z%]*)$", "i");
    var ae = [ "Top", "Right", "Bottom", "Left" ];
    var se = function(e, t) {
        e = t || e;
        return e.style.display === "none" || e.style.display === "" && x.contains(e.ownerDocument, e) && x.css(e, "display") === "none";
    };
    var le = function(e, t, n, i) {
        var r, o, a = {};
        for (o in t) {
            a[o] = e.style[o];
            e.style[o] = t[o];
        }
        r = n.apply(e, i || []);
        for (o in t) {
            e.style[o] = a[o];
        }
        return r;
    };
    function fe(e, t, n, i) {
        var r, o, a = 20, s = i ? function() {
            return i.cur();
        } : function() {
            return x.css(e, t, "");
        }, l = s(), f = n && n[3] || (x.cssNumber[t] ? "" : "px"), u = (x.cssNumber[t] || f !== "px" && +l) && oe.exec(x.css(e, t));
        if (u && u[3] !== f) {
            l = l / 2;
            f = f || u[3];
            u = +l || 1;
            while (a--) {
                x.style(e, t, u + f);
                if ((1 - o) * (1 - (o = s() / l || .5)) <= 0) {
                    a = 0;
                }
                u = u / o;
            }
            u = u * 2;
            x.style(e, t, u + f);
            n = n || [];
        }
        if (n) {
            u = +u || +l || 0;
            r = n[1] ? u + (n[1] + 1) * n[2] : +n[2];
            if (i) {
                i.unit = f;
                i.start = u;
                i.end = r;
            }
        }
        return r;
    }
    var ue = {};
    function ce(e) {
        var t, n = e.ownerDocument, i = e.nodeName, r = ue[i];
        if (r) {
            return r;
        }
        t = n.body.appendChild(n.createElement(i));
        r = x.css(t, "display");
        t.parentNode.removeChild(t);
        if (r === "none") {
            r = "block";
        }
        ue[i] = r;
        return r;
    }
    function de(e, t) {
        var n, i, r = [], o = 0, a = e.length;
        for (;o < a; o++) {
            i = e[o];
            if (!i.style) {
                continue;
            }
            n = i.style.display;
            if (t) {
                if (n === "none") {
                    r[o] = K.get(i, "display") || null;
                    if (!r[o]) {
                        i.style.display = "";
                    }
                }
                if (i.style.display === "" && se(i)) {
                    r[o] = ce(i);
                }
            } else {
                if (n !== "none") {
                    r[o] = "none";
                    K.set(i, "display", n);
                }
            }
        }
        for (o = 0; o < a; o++) {
            if (r[o] != null) {
                e[o].style.display = r[o];
            }
        }
        return e;
    }
    x.fn.extend({
        show: function() {
            return de(this, true);
        },
        hide: function() {
            return de(this);
        },
        toggle: function(e) {
            if (typeof e === "boolean") {
                return e ? this.show() : this.hide();
            }
            return this.each(function() {
                if (se(this)) {
                    x(this).show();
                } else {
                    x(this).hide();
                }
            });
        }
    });
    var pe = /^(?:checkbox|radio)$/i;
    var he = /<([a-z][^\/\0>\x20\t\r\n\f]+)/i;
    var ge = /^$|^module$|\/(?:java|ecma)script/i;
    var ve = {
        option: [ 1, "<select multiple='multiple'>", "</select>" ],
        thead: [ 1, "<table>", "</table>" ],
        col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        _default: [ 0, "", "" ]
    };
    ve.optgroup = ve.option;
    ve.tbody = ve.tfoot = ve.colgroup = ve.caption = ve.thead;
    ve.th = ve.td;
    function me(e, t) {
        var n;
        if (typeof e.getElementsByTagName !== "undefined") {
            n = e.getElementsByTagName(t || "*");
        } else if (typeof e.querySelectorAll !== "undefined") {
            n = e.querySelectorAll(t || "*");
        } else {
            n = [];
        }
        if (t === undefined || t && $(e, t)) {
            return x.merge([ e ], n);
        }
        return n;
    }
    function ye(e, t) {
        var n = 0, i = e.length;
        for (;n < i; n++) {
            K.set(e[n], "globalEval", !t || K.get(t[n], "globalEval"));
        }
    }
    var be = /<|&#?\w+;/;
    function we(e, t, n, i, r) {
        var o, a, s, l, f, u, c = t.createDocumentFragment(), d = [], p = 0, h = e.length;
        for (;p < h; p++) {
            o = e[p];
            if (o || o === 0) {
                if (b(o) === "object") {
                    x.merge(d, o.nodeType ? [ o ] : o);
                } else if (!be.test(o)) {
                    d.push(t.createTextNode(o));
                } else {
                    a = a || c.appendChild(t.createElement("div"));
                    s = (he.exec(o) || [ "", "" ])[1].toLowerCase();
                    l = ve[s] || ve._default;
                    a.innerHTML = l[1] + x.htmlPrefilter(o) + l[2];
                    u = l[0];
                    while (u--) {
                        a = a.lastChild;
                    }
                    x.merge(d, a.childNodes);
                    a = c.firstChild;
                    a.textContent = "";
                }
            }
        }
        c.textContent = "";
        p = 0;
        while (o = d[p++]) {
            if (i && x.inArray(o, i) > -1) {
                if (r) {
                    r.push(o);
                }
                continue;
            }
            f = x.contains(o.ownerDocument, o);
            a = me(c.appendChild(o), "script");
            if (f) {
                ye(a);
            }
            if (n) {
                u = 0;
                while (o = a[u++]) {
                    if (ge.test(o.type || "")) {
                        n.push(o);
                    }
                }
            }
        }
        return c;
    }
    (function() {
        var e = i.createDocumentFragment(), t = e.appendChild(i.createElement("div")), n = i.createElement("input");
        n.setAttribute("type", "radio");
        n.setAttribute("checked", "checked");
        n.setAttribute("name", "t");
        t.appendChild(n);
        h.checkClone = t.cloneNode(true).cloneNode(true).lastChild.checked;
        t.innerHTML = "<textarea>x</textarea>";
        h.noCloneChecked = !!t.cloneNode(true).lastChild.defaultValue;
    })();
    var xe = i.documentElement;
    var Ce = /^key/, Te = /^(?:mouse|pointer|contextmenu|drag|drop)|click/, De = /^([^.]*)(?:\.(.+)|)/;
    function ke() {
        return true;
    }
    function Se() {
        return false;
    }
    function Ee() {
        try {
            return i.activeElement;
        } catch (e) {}
    }
    function $e(e, t, n, i, r, o) {
        var a, s;
        if (typeof t === "object") {
            if (typeof n !== "string") {
                i = i || n;
                n = undefined;
            }
            for (s in t) {
                $e(e, s, n, i, t[s], o);
            }
            return e;
        }
        if (i == null && r == null) {
            r = n;
            i = n = undefined;
        } else if (r == null) {
            if (typeof n === "string") {
                r = i;
                i = undefined;
            } else {
                r = i;
                i = n;
                n = undefined;
            }
        }
        if (r === false) {
            r = Se;
        } else if (!r) {
            return e;
        }
        if (o === 1) {
            a = r;
            r = function(e) {
                x().off(e);
                return a.apply(this, arguments);
            };
            r.guid = a.guid || (a.guid = x.guid++);
        }
        return e.each(function() {
            x.event.add(this, t, r, i, n);
        });
    }
    x.event = {
        global: {},
        add: function(e, t, n, i, r) {
            var o, a, s, l, f, u, c, d, p, h, g, v = K.get(e);
            if (!v) {
                return;
            }
            if (n.handler) {
                o = n;
                n = o.handler;
                r = o.selector;
            }
            if (r) {
                x.find.matchesSelector(xe, r);
            }
            if (!n.guid) {
                n.guid = x.guid++;
            }
            if (!(l = v.events)) {
                l = v.events = {};
            }
            if (!(a = v.handle)) {
                a = v.handle = function(t) {
                    return typeof x !== "undefined" && x.event.triggered !== t.type ? x.event.dispatch.apply(e, arguments) : undefined;
                };
            }
            t = (t || "").match(R) || [ "" ];
            f = t.length;
            while (f--) {
                s = De.exec(t[f]) || [];
                p = g = s[1];
                h = (s[2] || "").split(".").sort();
                if (!p) {
                    continue;
                }
                c = x.event.special[p] || {};
                p = (r ? c.delegateType : c.bindType) || p;
                c = x.event.special[p] || {};
                u = x.extend({
                    type: p,
                    origType: g,
                    data: i,
                    handler: n,
                    guid: n.guid,
                    selector: r,
                    needsContext: r && x.expr.match.needsContext.test(r),
                    namespace: h.join(".")
                }, o);
                if (!(d = l[p])) {
                    d = l[p] = [];
                    d.delegateCount = 0;
                    if (!c.setup || c.setup.call(e, i, h, a) === false) {
                        if (e.addEventListener) {
                            e.addEventListener(p, a);
                        }
                    }
                }
                if (c.add) {
                    c.add.call(e, u);
                    if (!u.handler.guid) {
                        u.handler.guid = n.guid;
                    }
                }
                if (r) {
                    d.splice(d.delegateCount++, 0, u);
                } else {
                    d.push(u);
                }
                x.event.global[p] = true;
            }
        },
        remove: function(e, t, n, i, r) {
            var o, a, s, l, f, u, c, d, p, h, g, v = K.hasData(e) && K.get(e);
            if (!v || !(l = v.events)) {
                return;
            }
            t = (t || "").match(R) || [ "" ];
            f = t.length;
            while (f--) {
                s = De.exec(t[f]) || [];
                p = g = s[1];
                h = (s[2] || "").split(".").sort();
                if (!p) {
                    for (p in l) {
                        x.event.remove(e, p + t[f], n, i, true);
                    }
                    continue;
                }
                c = x.event.special[p] || {};
                p = (i ? c.delegateType : c.bindType) || p;
                d = l[p] || [];
                s = s[2] && new RegExp("(^|\\.)" + h.join("\\.(?:.*\\.|)") + "(\\.|$)");
                a = o = d.length;
                while (o--) {
                    u = d[o];
                    if ((r || g === u.origType) && (!n || n.guid === u.guid) && (!s || s.test(u.namespace)) && (!i || i === u.selector || i === "**" && u.selector)) {
                        d.splice(o, 1);
                        if (u.selector) {
                            d.delegateCount--;
                        }
                        if (c.remove) {
                            c.remove.call(e, u);
                        }
                    }
                }
                if (a && !d.length) {
                    if (!c.teardown || c.teardown.call(e, h, v.handle) === false) {
                        x.removeEvent(e, p, v.handle);
                    }
                    delete l[p];
                }
            }
            if (x.isEmptyObject(l)) {
                K.remove(e, "handle events");
            }
        },
        dispatch: function(e) {
            var t = x.event.fix(e);
            var n, i, r, o, a, s, l = new Array(arguments.length), f = (K.get(this, "events") || {})[t.type] || [], u = x.event.special[t.type] || {};
            l[0] = t;
            for (n = 1; n < arguments.length; n++) {
                l[n] = arguments[n];
            }
            t.delegateTarget = this;
            if (u.preDispatch && u.preDispatch.call(this, t) === false) {
                return;
            }
            s = x.event.handlers.call(this, t, f);
            n = 0;
            while ((o = s[n++]) && !t.isPropagationStopped()) {
                t.currentTarget = o.elem;
                i = 0;
                while ((a = o.handlers[i++]) && !t.isImmediatePropagationStopped()) {
                    if (!t.rnamespace || t.rnamespace.test(a.namespace)) {
                        t.handleObj = a;
                        t.data = a.data;
                        r = ((x.event.special[a.origType] || {}).handle || a.handler).apply(o.elem, l);
                        if (r !== undefined) {
                            if ((t.result = r) === false) {
                                t.preventDefault();
                                t.stopPropagation();
                            }
                        }
                    }
                }
            }
            if (u.postDispatch) {
                u.postDispatch.call(this, t);
            }
            return t.result;
        },
        handlers: function(e, t) {
            var n, i, r, o, a, s = [], l = t.delegateCount, f = e.target;
            if (l && f.nodeType && !(e.type === "click" && e.button >= 1)) {
                for (;f !== this; f = f.parentNode || this) {
                    if (f.nodeType === 1 && !(e.type === "click" && f.disabled === true)) {
                        o = [];
                        a = {};
                        for (n = 0; n < l; n++) {
                            i = t[n];
                            r = i.selector + " ";
                            if (a[r] === undefined) {
                                a[r] = i.needsContext ? x(r, this).index(f) > -1 : x.find(r, this, null, [ f ]).length;
                            }
                            if (a[r]) {
                                o.push(i);
                            }
                        }
                        if (o.length) {
                            s.push({
                                elem: f,
                                handlers: o
                            });
                        }
                    }
                }
            }
            f = this;
            if (l < t.length) {
                s.push({
                    elem: f,
                    handlers: t.slice(l)
                });
            }
            return s;
        },
        addProp: function(e, t) {
            Object.defineProperty(x.Event.prototype, e, {
                enumerable: true,
                configurable: true,
                get: g(t) ? function() {
                    if (this.originalEvent) {
                        return t(this.originalEvent);
                    }
                } : function() {
                    if (this.originalEvent) {
                        return this.originalEvent[e];
                    }
                },
                set: function(t) {
                    Object.defineProperty(this, e, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: t
                    });
                }
            });
        },
        fix: function(e) {
            return e[x.expando] ? e : new x.Event(e);
        },
        special: {
            load: {
                noBubble: true
            },
            focus: {
                trigger: function() {
                    if (this !== Ee() && this.focus) {
                        this.focus();
                        return false;
                    }
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    if (this === Ee() && this.blur) {
                        this.blur();
                        return false;
                    }
                },
                delegateType: "focusout"
            },
            click: {
                trigger: function() {
                    if (this.type === "checkbox" && this.click && $(this, "input")) {
                        this.click();
                        return false;
                    }
                },
                _default: function(e) {
                    return $(e.target, "a");
                }
            },
            beforeunload: {
                postDispatch: function(e) {
                    if (e.result !== undefined && e.originalEvent) {
                        e.originalEvent.returnValue = e.result;
                    }
                }
            }
        }
    };
    x.removeEvent = function(e, t, n) {
        if (e.removeEventListener) {
            e.removeEventListener(t, n);
        }
    };
    x.Event = function(e, t) {
        if (!(this instanceof x.Event)) {
            return new x.Event(e, t);
        }
        if (e && e.type) {
            this.originalEvent = e;
            this.type = e.type;
            this.isDefaultPrevented = e.defaultPrevented || e.defaultPrevented === undefined && e.returnValue === false ? ke : Se;
            this.target = e.target && e.target.nodeType === 3 ? e.target.parentNode : e.target;
            this.currentTarget = e.currentTarget;
            this.relatedTarget = e.relatedTarget;
        } else {
            this.type = e;
        }
        if (t) {
            x.extend(this, t);
        }
        this.timeStamp = e && e.timeStamp || Date.now();
        this[x.expando] = true;
    };
    x.Event.prototype = {
        constructor: x.Event,
        isDefaultPrevented: Se,
        isPropagationStopped: Se,
        isImmediatePropagationStopped: Se,
        isSimulated: false,
        preventDefault: function() {
            var e = this.originalEvent;
            this.isDefaultPrevented = ke;
            if (e && !this.isSimulated) {
                e.preventDefault();
            }
        },
        stopPropagation: function() {
            var e = this.originalEvent;
            this.isPropagationStopped = ke;
            if (e && !this.isSimulated) {
                e.stopPropagation();
            }
        },
        stopImmediatePropagation: function() {
            var e = this.originalEvent;
            this.isImmediatePropagationStopped = ke;
            if (e && !this.isSimulated) {
                e.stopImmediatePropagation();
            }
            this.stopPropagation();
        }
    };
    x.each({
        altKey: true,
        bubbles: true,
        cancelable: true,
        changedTouches: true,
        ctrlKey: true,
        detail: true,
        eventPhase: true,
        metaKey: true,
        pageX: true,
        pageY: true,
        shiftKey: true,
        view: true,
        "char": true,
        charCode: true,
        key: true,
        keyCode: true,
        button: true,
        buttons: true,
        clientX: true,
        clientY: true,
        offsetX: true,
        offsetY: true,
        pointerId: true,
        pointerType: true,
        screenX: true,
        screenY: true,
        targetTouches: true,
        toElement: true,
        touches: true,
        which: function(e) {
            var t = e.button;
            if (e.which == null && Ce.test(e.type)) {
                return e.charCode != null ? e.charCode : e.keyCode;
            }
            if (!e.which && t !== undefined && Te.test(e.type)) {
                if (t & 1) {
                    return 1;
                }
                if (t & 2) {
                    return 3;
                }
                if (t & 4) {
                    return 2;
                }
                return 0;
            }
            return e.which;
        }
    }, x.event.addProp);
    x.each({
        mouseenter: "mouseover",
        mouseleave: "mouseout",
        pointerenter: "pointerover",
        pointerleave: "pointerout"
    }, function(e, t) {
        x.event.special[e] = {
            delegateType: t,
            bindType: t,
            handle: function(e) {
                var n, i = this, r = e.relatedTarget, o = e.handleObj;
                if (!r || r !== i && !x.contains(i, r)) {
                    e.type = o.origType;
                    n = o.handler.apply(this, arguments);
                    e.type = t;
                }
                return n;
            }
        };
    });
    x.fn.extend({
        on: function(e, t, n, i) {
            return $e(this, e, t, n, i);
        },
        one: function(e, t, n, i) {
            return $e(this, e, t, n, i, 1);
        },
        off: function(e, t, n) {
            var i, r;
            if (e && e.preventDefault && e.handleObj) {
                i = e.handleObj;
                x(e.delegateTarget).off(i.namespace ? i.origType + "." + i.namespace : i.origType, i.selector, i.handler);
                return this;
            }
            if (typeof e === "object") {
                for (r in e) {
                    this.off(r, t, e[r]);
                }
                return this;
            }
            if (t === false || typeof t === "function") {
                n = t;
                t = undefined;
            }
            if (n === false) {
                n = Se;
            }
            return this.each(function() {
                x.event.remove(this, e, n, t);
            });
        }
    });
    var Ae = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi, Ne = /<script|<style|<link/i, je = /checked\s*(?:[^=]|=\s*.checked.)/i, Le = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;
    function Ie(e, t) {
        if ($(e, "table") && $(t.nodeType !== 11 ? t : t.firstChild, "tr")) {
            return x(e).children("tbody")[0] || e;
        }
        return e;
    }
    function Pe(e) {
        e.type = (e.getAttribute("type") !== null) + "/" + e.type;
        return e;
    }
    function Oe(e) {
        if ((e.type || "").slice(0, 5) === "true/") {
            e.type = e.type.slice(5);
        } else {
            e.removeAttribute("type");
        }
        return e;
    }
    function He(e, t) {
        var n, i, r, o, a, s, l, f;
        if (t.nodeType !== 1) {
            return;
        }
        if (K.hasData(e)) {
            o = K.access(e);
            a = K.set(t, o);
            f = o.events;
            if (f) {
                delete a.handle;
                a.events = {};
                for (r in f) {
                    for (n = 0, i = f[r].length; n < i; n++) {
                        x.event.add(t, r, f[r][n]);
                    }
                }
            }
        }
        if (Z.hasData(e)) {
            s = Z.access(e);
            l = x.extend({}, s);
            Z.set(t, l);
        }
    }
    function Re(e, t) {
        var n = t.nodeName.toLowerCase();
        if (n === "input" && pe.test(e.type)) {
            t.checked = e.checked;
        } else if (n === "input" || n === "textarea") {
            t.defaultValue = e.defaultValue;
        }
    }
    function qe(e, t, n, i) {
        t = a.apply([], t);
        var r, o, s, l, f, u, c = 0, d = e.length, p = d - 1, v = t[0], m = g(v);
        if (m || d > 1 && typeof v === "string" && !h.checkClone && je.test(v)) {
            return e.each(function(r) {
                var o = e.eq(r);
                if (m) {
                    t[0] = v.call(this, r, o.html());
                }
                qe(o, t, n, i);
            });
        }
        if (d) {
            r = we(t, e[0].ownerDocument, false, e, i);
            o = r.firstChild;
            if (r.childNodes.length === 1) {
                r = o;
            }
            if (o || i) {
                s = x.map(me(r, "script"), Pe);
                l = s.length;
                for (;c < d; c++) {
                    f = r;
                    if (c !== p) {
                        f = x.clone(f, true, true);
                        if (l) {
                            x.merge(s, me(f, "script"));
                        }
                    }
                    n.call(e[c], f, c);
                }
                if (l) {
                    u = s[s.length - 1].ownerDocument;
                    x.map(s, Oe);
                    for (c = 0; c < l; c++) {
                        f = s[c];
                        if (ge.test(f.type || "") && !K.access(f, "globalEval") && x.contains(u, f)) {
                            if (f.src && (f.type || "").toLowerCase() !== "module") {
                                if (x._evalUrl) {
                                    x._evalUrl(f.src);
                                }
                            } else {
                                y(f.textContent.replace(Le, ""), u, f);
                            }
                        }
                    }
                }
            }
        }
        return e;
    }
    function Be(e, t, n) {
        var i, r = t ? x.filter(t, e) : e, o = 0;
        for (;(i = r[o]) != null; o++) {
            if (!n && i.nodeType === 1) {
                x.cleanData(me(i));
            }
            if (i.parentNode) {
                if (n && x.contains(i.ownerDocument, i)) {
                    ye(me(i, "script"));
                }
                i.parentNode.removeChild(i);
            }
        }
        return e;
    }
    x.extend({
        htmlPrefilter: function(e) {
            return e.replace(Ae, "<$1></$2>");
        },
        clone: function(e, t, n) {
            var i, r, o, a, s = e.cloneNode(true), l = x.contains(e.ownerDocument, e);
            if (!h.noCloneChecked && (e.nodeType === 1 || e.nodeType === 11) && !x.isXMLDoc(e)) {
                a = me(s);
                o = me(e);
                for (i = 0, r = o.length; i < r; i++) {
                    Re(o[i], a[i]);
                }
            }
            if (t) {
                if (n) {
                    o = o || me(e);
                    a = a || me(s);
                    for (i = 0, r = o.length; i < r; i++) {
                        He(o[i], a[i]);
                    }
                } else {
                    He(e, s);
                }
            }
            a = me(s, "script");
            if (a.length > 0) {
                ye(a, !l && me(e, "script"));
            }
            return s;
        },
        cleanData: function(e) {
            var t, n, i, r = x.event.special, o = 0;
            for (;(n = e[o]) !== undefined; o++) {
                if (Y(n)) {
                    if (t = n[K.expando]) {
                        if (t.events) {
                            for (i in t.events) {
                                if (r[i]) {
                                    x.event.remove(n, i);
                                } else {
                                    x.removeEvent(n, i, t.handle);
                                }
                            }
                        }
                        n[K.expando] = undefined;
                    }
                    if (n[Z.expando]) {
                        n[Z.expando] = undefined;
                    }
                }
            }
        }
    });
    x.fn.extend({
        detach: function(e) {
            return Be(this, e, true);
        },
        remove: function(e) {
            return Be(this, e);
        },
        text: function(e) {
            return z(this, function(e) {
                return e === undefined ? x.text(this) : this.empty().each(function() {
                    if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                        this.textContent = e;
                    }
                });
            }, null, e, arguments.length);
        },
        append: function() {
            return qe(this, arguments, function(e) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var t = Ie(this, e);
                    t.appendChild(e);
                }
            });
        },
        prepend: function() {
            return qe(this, arguments, function(e) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var t = Ie(this, e);
                    t.insertBefore(e, t.firstChild);
                }
            });
        },
        before: function() {
            return qe(this, arguments, function(e) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(e, this);
                }
            });
        },
        after: function() {
            return qe(this, arguments, function(e) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(e, this.nextSibling);
                }
            });
        },
        empty: function() {
            var e, t = 0;
            for (;(e = this[t]) != null; t++) {
                if (e.nodeType === 1) {
                    x.cleanData(me(e, false));
                    e.textContent = "";
                }
            }
            return this;
        },
        clone: function(e, t) {
            e = e == null ? false : e;
            t = t == null ? e : t;
            return this.map(function() {
                return x.clone(this, e, t);
            });
        },
        html: function(e) {
            return z(this, function(e) {
                var t = this[0] || {}, n = 0, i = this.length;
                if (e === undefined && t.nodeType === 1) {
                    return t.innerHTML;
                }
                if (typeof e === "string" && !Ne.test(e) && !ve[(he.exec(e) || [ "", "" ])[1].toLowerCase()]) {
                    e = x.htmlPrefilter(e);
                    try {
                        for (;n < i; n++) {
                            t = this[n] || {};
                            if (t.nodeType === 1) {
                                x.cleanData(me(t, false));
                                t.innerHTML = e;
                            }
                        }
                        t = 0;
                    } catch (r) {}
                }
                if (t) {
                    this.empty().append(e);
                }
            }, null, e, arguments.length);
        },
        replaceWith: function() {
            var e = [];
            return qe(this, arguments, function(t) {
                var n = this.parentNode;
                if (x.inArray(this, e) < 0) {
                    x.cleanData(me(this));
                    if (n) {
                        n.replaceChild(t, this);
                    }
                }
            }, e);
        }
    });
    x.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function(e, t) {
        x.fn[e] = function(e) {
            var n, i = [], r = x(e), o = r.length - 1, a = 0;
            for (;a <= o; a++) {
                n = a === o ? this : this.clone(true);
                x(r[a])[t](n);
                s.apply(i, n.get());
            }
            return this.pushStack(i);
        };
    });
    var Me = new RegExp("^(" + re + ")(?!px)[a-z%]+$", "i");
    var _e = function(t) {
        var n = t.ownerDocument.defaultView;
        if (!n || !n.opener) {
            n = e;
        }
        return n.getComputedStyle(t);
    };
    var Fe = new RegExp(ae.join("|"), "i");
    (function() {
        function t() {
            if (!u) {
                return;
            }
            f.style.cssText = "position:absolute;left:-11111px;width:60px;" + "margin-top:1px;padding:0;border:0";
            u.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;" + "margin:auto;border:1px;padding:1px;" + "width:60%;top:1%";
            xe.appendChild(f).appendChild(u);
            var t = e.getComputedStyle(u);
            r = t.top !== "1%";
            l = n(t.marginLeft) === 12;
            u.style.right = "60%";
            s = n(t.right) === 36;
            o = n(t.width) === 36;
            u.style.position = "absolute";
            a = u.offsetWidth === 36 || "absolute";
            xe.removeChild(f);
            u = null;
        }
        function n(e) {
            return Math.round(parseFloat(e));
        }
        var r, o, a, s, l, f = i.createElement("div"), u = i.createElement("div");
        if (!u.style) {
            return;
        }
        u.style.backgroundClip = "content-box";
        u.cloneNode(true).style.backgroundClip = "";
        h.clearCloneStyle = u.style.backgroundClip === "content-box";
        x.extend(h, {
            boxSizingReliable: function() {
                t();
                return o;
            },
            pixelBoxStyles: function() {
                t();
                return s;
            },
            pixelPosition: function() {
                t();
                return r;
            },
            reliableMarginLeft: function() {
                t();
                return l;
            },
            scrollboxSize: function() {
                t();
                return a;
            }
        });
    })();
    function Ue(e, t, n) {
        var i, r, o, a, s = e.style;
        n = n || _e(e);
        if (n) {
            a = n.getPropertyValue(t) || n[t];
            if (a === "" && !x.contains(e.ownerDocument, e)) {
                a = x.style(e, t);
            }
            if (!h.pixelBoxStyles() && Me.test(a) && Fe.test(t)) {
                i = s.width;
                r = s.minWidth;
                o = s.maxWidth;
                s.minWidth = s.maxWidth = s.width = a;
                a = n.width;
                s.width = i;
                s.minWidth = r;
                s.maxWidth = o;
            }
        }
        return a !== undefined ? a + "" : a;
    }
    function We(e, t) {
        return {
            get: function() {
                if (e()) {
                    delete this.get;
                    return;
                }
                return (this.get = t).apply(this, arguments);
            }
        };
    }
    var ze = /^(none|table(?!-c[ea]).+)/, Ge = /^--/, Qe = {
        position: "absolute",
        visibility: "hidden",
        display: "block"
    }, Ve = {
        letterSpacing: "0",
        fontWeight: "400"
    }, Xe = [ "Webkit", "Moz", "ms" ], Ye = i.createElement("div").style;
    function Je(e) {
        if (e in Ye) {
            return e;
        }
        var t = e[0].toUpperCase() + e.slice(1), n = Xe.length;
        while (n--) {
            e = Xe[n] + t;
            if (e in Ye) {
                return e;
            }
        }
    }
    function Ke(e) {
        var t = x.cssProps[e];
        if (!t) {
            t = x.cssProps[e] = Je(e) || e;
        }
        return t;
    }
    function Ze(e, t, n) {
        var i = oe.exec(t);
        return i ? Math.max(0, i[2] - (n || 0)) + (i[3] || "px") : t;
    }
    function et(e, t, n, i, r, o) {
        var a = t === "width" ? 1 : 0, s = 0, l = 0;
        if (n === (i ? "border" : "content")) {
            return 0;
        }
        for (;a < 4; a += 2) {
            if (n === "margin") {
                l += x.css(e, n + ae[a], true, r);
            }
            if (!i) {
                l += x.css(e, "padding" + ae[a], true, r);
                if (n !== "padding") {
                    l += x.css(e, "border" + ae[a] + "Width", true, r);
                } else {
                    s += x.css(e, "border" + ae[a] + "Width", true, r);
                }
            } else {
                if (n === "content") {
                    l -= x.css(e, "padding" + ae[a], true, r);
                }
                if (n !== "margin") {
                    l -= x.css(e, "border" + ae[a] + "Width", true, r);
                }
            }
        }
        if (!i && o >= 0) {
            l += Math.max(0, Math.ceil(e["offset" + t[0].toUpperCase() + t.slice(1)] - o - l - s - .5));
        }
        return l;
    }
    function tt(e, t, n) {
        var i = _e(e), r = Ue(e, t, i), o = x.css(e, "boxSizing", false, i) === "border-box", a = o;
        if (Me.test(r)) {
            if (!n) {
                return r;
            }
            r = "auto";
        }
        a = a && (h.boxSizingReliable() || r === e.style[t]);
        if (r === "auto" || !parseFloat(r) && x.css(e, "display", false, i) === "inline") {
            r = e["offset" + t[0].toUpperCase() + t.slice(1)];
            a = true;
        }
        r = parseFloat(r) || 0;
        return r + et(e, t, n || (o ? "border" : "content"), a, i, r) + "px";
    }
    x.extend({
        cssHooks: {
            opacity: {
                get: function(e, t) {
                    if (t) {
                        var n = Ue(e, "opacity");
                        return n === "" ? "1" : n;
                    }
                }
            }
        },
        cssNumber: {
            animationIterationCount: true,
            columnCount: true,
            fillOpacity: true,
            flexGrow: true,
            flexShrink: true,
            fontWeight: true,
            lineHeight: true,
            opacity: true,
            order: true,
            orphans: true,
            widows: true,
            zIndex: true,
            zoom: true
        },
        cssProps: {},
        style: function(e, t, n, i) {
            if (!e || e.nodeType === 3 || e.nodeType === 8 || !e.style) {
                return;
            }
            var r, o, a, s = X(t), l = Ge.test(t), f = e.style;
            if (!l) {
                t = Ke(s);
            }
            a = x.cssHooks[t] || x.cssHooks[s];
            if (n !== undefined) {
                o = typeof n;
                if (o === "string" && (r = oe.exec(n)) && r[1]) {
                    n = fe(e, t, r);
                    o = "number";
                }
                if (n == null || n !== n) {
                    return;
                }
                if (o === "number") {
                    n += r && r[3] || (x.cssNumber[s] ? "" : "px");
                }
                if (!h.clearCloneStyle && n === "" && t.indexOf("background") === 0) {
                    f[t] = "inherit";
                }
                if (!a || !("set" in a) || (n = a.set(e, n, i)) !== undefined) {
                    if (l) {
                        f.setProperty(t, n);
                    } else {
                        f[t] = n;
                    }
                }
            } else {
                if (a && "get" in a && (r = a.get(e, false, i)) !== undefined) {
                    return r;
                }
                return f[t];
            }
        },
        css: function(e, t, n, i) {
            var r, o, a, s = X(t), l = Ge.test(t);
            if (!l) {
                t = Ke(s);
            }
            a = x.cssHooks[t] || x.cssHooks[s];
            if (a && "get" in a) {
                r = a.get(e, true, n);
            }
            if (r === undefined) {
                r = Ue(e, t, i);
            }
            if (r === "normal" && t in Ve) {
                r = Ve[t];
            }
            if (n === "" || n) {
                o = parseFloat(r);
                return n === true || isFinite(o) ? o || 0 : r;
            }
            return r;
        }
    });
    x.each([ "height", "width" ], function(e, t) {
        x.cssHooks[t] = {
            get: function(e, n, i) {
                if (n) {
                    return ze.test(x.css(e, "display")) && (!e.getClientRects().length || !e.getBoundingClientRect().width) ? le(e, Qe, function() {
                        return tt(e, t, i);
                    }) : tt(e, t, i);
                }
            },
            set: function(e, n, i) {
                var r, o = _e(e), a = x.css(e, "boxSizing", false, o) === "border-box", s = i && et(e, t, i, a, o);
                if (a && h.scrollboxSize() === o.position) {
                    s -= Math.ceil(e["offset" + t[0].toUpperCase() + t.slice(1)] - parseFloat(o[t]) - et(e, t, "border", false, o) - .5);
                }
                if (s && (r = oe.exec(n)) && (r[3] || "px") !== "px") {
                    e.style[t] = n;
                    n = x.css(e, t);
                }
                return Ze(e, n, s);
            }
        };
    });
    x.cssHooks.marginLeft = We(h.reliableMarginLeft, function(e, t) {
        if (t) {
            return (parseFloat(Ue(e, "marginLeft")) || e.getBoundingClientRect().left - le(e, {
                marginLeft: 0
            }, function() {
                return e.getBoundingClientRect().left;
            })) + "px";
        }
    });
    x.each({
        margin: "",
        padding: "",
        border: "Width"
    }, function(e, t) {
        x.cssHooks[e + t] = {
            expand: function(n) {
                var i = 0, r = {}, o = typeof n === "string" ? n.split(" ") : [ n ];
                for (;i < 4; i++) {
                    r[e + ae[i] + t] = o[i] || o[i - 2] || o[0];
                }
                return r;
            }
        };
        if (e !== "margin") {
            x.cssHooks[e + t].set = Ze;
        }
    });
    x.fn.extend({
        css: function(e, t) {
            return z(this, function(e, t, n) {
                var i, r, o = {}, a = 0;
                if (Array.isArray(t)) {
                    i = _e(e);
                    r = t.length;
                    for (;a < r; a++) {
                        o[t[a]] = x.css(e, t[a], false, i);
                    }
                    return o;
                }
                return n !== undefined ? x.style(e, t, n) : x.css(e, t);
            }, e, t, arguments.length > 1);
        }
    });
    function nt(e, t, n, i, r) {
        return new nt.prototype.init(e, t, n, i, r);
    }
    x.Tween = nt;
    nt.prototype = {
        constructor: nt,
        init: function(e, t, n, i, r, o) {
            this.elem = e;
            this.prop = n;
            this.easing = r || x.easing._default;
            this.options = t;
            this.start = this.now = this.cur();
            this.end = i;
            this.unit = o || (x.cssNumber[n] ? "" : "px");
        },
        cur: function() {
            var e = nt.propHooks[this.prop];
            return e && e.get ? e.get(this) : nt.propHooks._default.get(this);
        },
        run: function(e) {
            var t, n = nt.propHooks[this.prop];
            if (this.options.duration) {
                this.pos = t = x.easing[this.easing](e, this.options.duration * e, 0, 1, this.options.duration);
            } else {
                this.pos = t = e;
            }
            this.now = (this.end - this.start) * t + this.start;
            if (this.options.step) {
                this.options.step.call(this.elem, this.now, this);
            }
            if (n && n.set) {
                n.set(this);
            } else {
                nt.propHooks._default.set(this);
            }
            return this;
        }
    };
    nt.prototype.init.prototype = nt.prototype;
    nt.propHooks = {
        _default: {
            get: function(e) {
                var t;
                if (e.elem.nodeType !== 1 || e.elem[e.prop] != null && e.elem.style[e.prop] == null) {
                    return e.elem[e.prop];
                }
                t = x.css(e.elem, e.prop, "");
                return !t || t === "auto" ? 0 : t;
            },
            set: function(e) {
                if (x.fx.step[e.prop]) {
                    x.fx.step[e.prop](e);
                } else if (e.elem.nodeType === 1 && (e.elem.style[x.cssProps[e.prop]] != null || x.cssHooks[e.prop])) {
                    x.style(e.elem, e.prop, e.now + e.unit);
                } else {
                    e.elem[e.prop] = e.now;
                }
            }
        }
    };
    nt.propHooks.scrollTop = nt.propHooks.scrollLeft = {
        set: function(e) {
            if (e.elem.nodeType && e.elem.parentNode) {
                e.elem[e.prop] = e.now;
            }
        }
    };
    x.easing = {
        linear: function(e) {
            return e;
        },
        swing: function(e) {
            return .5 - Math.cos(e * Math.PI) / 2;
        },
        _default: "swing"
    };
    x.fx = nt.prototype.init;
    x.fx.step = {};
    var it, rt, ot = /^(?:toggle|show|hide)$/, at = /queueHooks$/;
    function st() {
        if (rt) {
            if (i.hidden === false && e.requestAnimationFrame) {
                e.requestAnimationFrame(st);
            } else {
                e.setTimeout(st, x.fx.interval);
            }
            x.fx.tick();
        }
    }
    function lt() {
        e.setTimeout(function() {
            it = undefined;
        });
        return it = Date.now();
    }
    function ft(e, t) {
        var n, i = 0, r = {
            height: e
        };
        t = t ? 1 : 0;
        for (;i < 4; i += 2 - t) {
            n = ae[i];
            r["margin" + n] = r["padding" + n] = e;
        }
        if (t) {
            r.opacity = r.width = e;
        }
        return r;
    }
    function ut(e, t, n) {
        var i, r = (pt.tweeners[t] || []).concat(pt.tweeners["*"]), o = 0, a = r.length;
        for (;o < a; o++) {
            if (i = r[o].call(n, t, e)) {
                return i;
            }
        }
    }
    function ct(e, t, n) {
        var i, r, o, a, s, l, f, u, c = "width" in t || "height" in t, d = this, p = {}, h = e.style, g = e.nodeType && se(e), v = K.get(e, "fxshow");
        if (!n.queue) {
            a = x._queueHooks(e, "fx");
            if (a.unqueued == null) {
                a.unqueued = 0;
                s = a.empty.fire;
                a.empty.fire = function() {
                    if (!a.unqueued) {
                        s();
                    }
                };
            }
            a.unqueued++;
            d.always(function() {
                d.always(function() {
                    a.unqueued--;
                    if (!x.queue(e, "fx").length) {
                        a.empty.fire();
                    }
                });
            });
        }
        for (i in t) {
            r = t[i];
            if (ot.test(r)) {
                delete t[i];
                o = o || r === "toggle";
                if (r === (g ? "hide" : "show")) {
                    if (r === "show" && v && v[i] !== undefined) {
                        g = true;
                    } else {
                        continue;
                    }
                }
                p[i] = v && v[i] || x.style(e, i);
            }
        }
        l = !x.isEmptyObject(t);
        if (!l && x.isEmptyObject(p)) {
            return;
        }
        if (c && e.nodeType === 1) {
            n.overflow = [ h.overflow, h.overflowX, h.overflowY ];
            f = v && v.display;
            if (f == null) {
                f = K.get(e, "display");
            }
            u = x.css(e, "display");
            if (u === "none") {
                if (f) {
                    u = f;
                } else {
                    de([ e ], true);
                    f = e.style.display || f;
                    u = x.css(e, "display");
                    de([ e ]);
                }
            }
            if (u === "inline" || u === "inline-block" && f != null) {
                if (x.css(e, "float") === "none") {
                    if (!l) {
                        d.done(function() {
                            h.display = f;
                        });
                        if (f == null) {
                            u = h.display;
                            f = u === "none" ? "" : u;
                        }
                    }
                    h.display = "inline-block";
                }
            }
        }
        if (n.overflow) {
            h.overflow = "hidden";
            d.always(function() {
                h.overflow = n.overflow[0];
                h.overflowX = n.overflow[1];
                h.overflowY = n.overflow[2];
            });
        }
        l = false;
        for (i in p) {
            if (!l) {
                if (v) {
                    if ("hidden" in v) {
                        g = v.hidden;
                    }
                } else {
                    v = K.access(e, "fxshow", {
                        display: f
                    });
                }
                if (o) {
                    v.hidden = !g;
                }
                if (g) {
                    de([ e ], true);
                }
                d.done(function() {
                    if (!g) {
                        de([ e ]);
                    }
                    K.remove(e, "fxshow");
                    for (i in p) {
                        x.style(e, i, p[i]);
                    }
                });
            }
            l = ut(g ? v[i] : 0, i, d);
            if (!(i in v)) {
                v[i] = l.start;
                if (g) {
                    l.end = l.start;
                    l.start = 0;
                }
            }
        }
    }
    function dt(e, t) {
        var n, i, r, o, a;
        for (n in e) {
            i = X(n);
            r = t[i];
            o = e[n];
            if (Array.isArray(o)) {
                r = o[1];
                o = e[n] = o[0];
            }
            if (n !== i) {
                e[i] = o;
                delete e[n];
            }
            a = x.cssHooks[i];
            if (a && "expand" in a) {
                o = a.expand(o);
                delete e[i];
                for (n in o) {
                    if (!(n in e)) {
                        e[n] = o[n];
                        t[n] = r;
                    }
                }
            } else {
                t[i] = r;
            }
        }
    }
    function pt(e, t, n) {
        var i, r, o = 0, a = pt.prefilters.length, s = x.Deferred().always(function() {
            delete l.elem;
        }), l = function() {
            if (r) {
                return false;
            }
            var t = it || lt(), n = Math.max(0, f.startTime + f.duration - t), i = n / f.duration || 0, o = 1 - i, a = 0, l = f.tweens.length;
            for (;a < l; a++) {
                f.tweens[a].run(o);
            }
            s.notifyWith(e, [ f, o, n ]);
            if (o < 1 && l) {
                return n;
            }
            if (!l) {
                s.notifyWith(e, [ f, 1, 0 ]);
            }
            s.resolveWith(e, [ f ]);
            return false;
        }, f = s.promise({
            elem: e,
            props: x.extend({}, t),
            opts: x.extend(true, {
                specialEasing: {},
                easing: x.easing._default
            }, n),
            originalProperties: t,
            originalOptions: n,
            startTime: it || lt(),
            duration: n.duration,
            tweens: [],
            createTween: function(t, n) {
                var i = x.Tween(e, f.opts, t, n, f.opts.specialEasing[t] || f.opts.easing);
                f.tweens.push(i);
                return i;
            },
            stop: function(t) {
                var n = 0, i = t ? f.tweens.length : 0;
                if (r) {
                    return this;
                }
                r = true;
                for (;n < i; n++) {
                    f.tweens[n].run(1);
                }
                if (t) {
                    s.notifyWith(e, [ f, 1, 0 ]);
                    s.resolveWith(e, [ f, t ]);
                } else {
                    s.rejectWith(e, [ f, t ]);
                }
                return this;
            }
        }), u = f.props;
        dt(u, f.opts.specialEasing);
        for (;o < a; o++) {
            i = pt.prefilters[o].call(f, e, u, f.opts);
            if (i) {
                if (g(i.stop)) {
                    x._queueHooks(f.elem, f.opts.queue).stop = i.stop.bind(i);
                }
                return i;
            }
        }
        x.map(u, ut, f);
        if (g(f.opts.start)) {
            f.opts.start.call(e, f);
        }
        f.progress(f.opts.progress).done(f.opts.done, f.opts.complete).fail(f.opts.fail).always(f.opts.always);
        x.fx.timer(x.extend(l, {
            elem: e,
            anim: f,
            queue: f.opts.queue
        }));
        return f;
    }
    x.Animation = x.extend(pt, {
        tweeners: {
            "*": [ function(e, t) {
                var n = this.createTween(e, t);
                fe(n.elem, e, oe.exec(t), n);
                return n;
            } ]
        },
        tweener: function(e, t) {
            if (g(e)) {
                t = e;
                e = [ "*" ];
            } else {
                e = e.match(R);
            }
            var n, i = 0, r = e.length;
            for (;i < r; i++) {
                n = e[i];
                pt.tweeners[n] = pt.tweeners[n] || [];
                pt.tweeners[n].unshift(t);
            }
        },
        prefilters: [ ct ],
        prefilter: function(e, t) {
            if (t) {
                pt.prefilters.unshift(e);
            } else {
                pt.prefilters.push(e);
            }
        }
    });
    x.speed = function(e, t, n) {
        var i = e && typeof e === "object" ? x.extend({}, e) : {
            complete: n || !n && t || g(e) && e,
            duration: e,
            easing: n && t || t && !g(t) && t
        };
        if (x.fx.off) {
            i.duration = 0;
        } else {
            if (typeof i.duration !== "number") {
                if (i.duration in x.fx.speeds) {
                    i.duration = x.fx.speeds[i.duration];
                } else {
                    i.duration = x.fx.speeds._default;
                }
            }
        }
        if (i.queue == null || i.queue === true) {
            i.queue = "fx";
        }
        i.old = i.complete;
        i.complete = function() {
            if (g(i.old)) {
                i.old.call(this);
            }
            if (i.queue) {
                x.dequeue(this, i.queue);
            }
        };
        return i;
    };
    x.fn.extend({
        fadeTo: function(e, t, n, i) {
            return this.filter(se).css("opacity", 0).show().end().animate({
                opacity: t
            }, e, n, i);
        },
        animate: function(e, t, n, i) {
            var r = x.isEmptyObject(e), o = x.speed(t, n, i), a = function() {
                var t = pt(this, x.extend({}, e), o);
                if (r || K.get(this, "finish")) {
                    t.stop(true);
                }
            };
            a.finish = a;
            return r || o.queue === false ? this.each(a) : this.queue(o.queue, a);
        },
        stop: function(e, t, n) {
            var i = function(e) {
                var t = e.stop;
                delete e.stop;
                t(n);
            };
            if (typeof e !== "string") {
                n = t;
                t = e;
                e = undefined;
            }
            if (t && e !== false) {
                this.queue(e || "fx", []);
            }
            return this.each(function() {
                var t = true, r = e != null && e + "queueHooks", o = x.timers, a = K.get(this);
                if (r) {
                    if (a[r] && a[r].stop) {
                        i(a[r]);
                    }
                } else {
                    for (r in a) {
                        if (a[r] && a[r].stop && at.test(r)) {
                            i(a[r]);
                        }
                    }
                }
                for (r = o.length; r--; ) {
                    if (o[r].elem === this && (e == null || o[r].queue === e)) {
                        o[r].anim.stop(n);
                        t = false;
                        o.splice(r, 1);
                    }
                }
                if (t || !n) {
                    x.dequeue(this, e);
                }
            });
        },
        finish: function(e) {
            if (e !== false) {
                e = e || "fx";
            }
            return this.each(function() {
                var t, n = K.get(this), i = n[e + "queue"], r = n[e + "queueHooks"], o = x.timers, a = i ? i.length : 0;
                n.finish = true;
                x.queue(this, e, []);
                if (r && r.stop) {
                    r.stop.call(this, true);
                }
                for (t = o.length; t--; ) {
                    if (o[t].elem === this && o[t].queue === e) {
                        o[t].anim.stop(true);
                        o.splice(t, 1);
                    }
                }
                for (t = 0; t < a; t++) {
                    if (i[t] && i[t].finish) {
                        i[t].finish.call(this);
                    }
                }
                delete n.finish;
            });
        }
    });
    x.each([ "toggle", "show", "hide" ], function(e, t) {
        var n = x.fn[t];
        x.fn[t] = function(e, i, r) {
            return e == null || typeof e === "boolean" ? n.apply(this, arguments) : this.animate(ft(t, true), e, i, r);
        };
    });
    x.each({
        slideDown: ft("show"),
        slideUp: ft("hide"),
        slideToggle: ft("toggle"),
        fadeIn: {
            opacity: "show"
        },
        fadeOut: {
            opacity: "hide"
        },
        fadeToggle: {
            opacity: "toggle"
        }
    }, function(e, t) {
        x.fn[e] = function(e, n, i) {
            return this.animate(t, e, n, i);
        };
    });
    x.timers = [];
    x.fx.tick = function() {
        var e, t = 0, n = x.timers;
        it = Date.now();
        for (;t < n.length; t++) {
            e = n[t];
            if (!e() && n[t] === e) {
                n.splice(t--, 1);
            }
        }
        if (!n.length) {
            x.fx.stop();
        }
        it = undefined;
    };
    x.fx.timer = function(e) {
        x.timers.push(e);
        x.fx.start();
    };
    x.fx.interval = 13;
    x.fx.start = function() {
        if (rt) {
            return;
        }
        rt = true;
        st();
    };
    x.fx.stop = function() {
        rt = null;
    };
    x.fx.speeds = {
        slow: 600,
        fast: 200,
        _default: 400
    };
    x.fn.delay = function(t, n) {
        t = x.fx ? x.fx.speeds[t] || t : t;
        n = n || "fx";
        return this.queue(n, function(n, i) {
            var r = e.setTimeout(n, t);
            i.stop = function() {
                e.clearTimeout(r);
            };
        });
    };
    (function() {
        var e = i.createElement("input"), t = i.createElement("select"), n = t.appendChild(i.createElement("option"));
        e.type = "checkbox";
        h.checkOn = e.value !== "";
        h.optSelected = n.selected;
        e = i.createElement("input");
        e.value = "t";
        e.type = "radio";
        h.radioValue = e.value === "t";
    })();
    var ht, gt = x.expr.attrHandle;
    x.fn.extend({
        attr: function(e, t) {
            return z(this, x.attr, e, t, arguments.length > 1);
        },
        removeAttr: function(e) {
            return this.each(function() {
                x.removeAttr(this, e);
            });
        }
    });
    x.extend({
        attr: function(e, t, n) {
            var i, r, o = e.nodeType;
            if (o === 3 || o === 8 || o === 2) {
                return;
            }
            if (typeof e.getAttribute === "undefined") {
                return x.prop(e, t, n);
            }
            if (o !== 1 || !x.isXMLDoc(e)) {
                r = x.attrHooks[t.toLowerCase()] || (x.expr.match.bool.test(t) ? ht : undefined);
            }
            if (n !== undefined) {
                if (n === null) {
                    x.removeAttr(e, t);
                    return;
                }
                if (r && "set" in r && (i = r.set(e, n, t)) !== undefined) {
                    return i;
                }
                e.setAttribute(t, n + "");
                return n;
            }
            if (r && "get" in r && (i = r.get(e, t)) !== null) {
                return i;
            }
            i = x.find.attr(e, t);
            return i == null ? undefined : i;
        },
        attrHooks: {
            type: {
                set: function(e, t) {
                    if (!h.radioValue && t === "radio" && $(e, "input")) {
                        var n = e.value;
                        e.setAttribute("type", t);
                        if (n) {
                            e.value = n;
                        }
                        return t;
                    }
                }
            }
        },
        removeAttr: function(e, t) {
            var n, i = 0, r = t && t.match(R);
            if (r && e.nodeType === 1) {
                while (n = r[i++]) {
                    e.removeAttribute(n);
                }
            }
        }
    });
    ht = {
        set: function(e, t, n) {
            if (t === false) {
                x.removeAttr(e, n);
            } else {
                e.setAttribute(n, n);
            }
            return n;
        }
    };
    x.each(x.expr.match.bool.source.match(/\w+/g), function(e, t) {
        var n = gt[t] || x.find.attr;
        gt[t] = function(e, t, i) {
            var r, o, a = t.toLowerCase();
            if (!i) {
                o = gt[a];
                gt[a] = r;
                r = n(e, t, i) != null ? a : null;
                gt[a] = o;
            }
            return r;
        };
    });
    var vt = /^(?:input|select|textarea|button)$/i, mt = /^(?:a|area)$/i;
    x.fn.extend({
        prop: function(e, t) {
            return z(this, x.prop, e, t, arguments.length > 1);
        },
        removeProp: function(e) {
            return this.each(function() {
                delete this[x.propFix[e] || e];
            });
        }
    });
    x.extend({
        prop: function(e, t, n) {
            var i, r, o = e.nodeType;
            if (o === 3 || o === 8 || o === 2) {
                return;
            }
            if (o !== 1 || !x.isXMLDoc(e)) {
                t = x.propFix[t] || t;
                r = x.propHooks[t];
            }
            if (n !== undefined) {
                if (r && "set" in r && (i = r.set(e, n, t)) !== undefined) {
                    return i;
                }
                return e[t] = n;
            }
            if (r && "get" in r && (i = r.get(e, t)) !== null) {
                return i;
            }
            return e[t];
        },
        propHooks: {
            tabIndex: {
                get: function(e) {
                    var t = x.find.attr(e, "tabindex");
                    if (t) {
                        return parseInt(t, 10);
                    }
                    if (vt.test(e.nodeName) || mt.test(e.nodeName) && e.href) {
                        return 0;
                    }
                    return -1;
                }
            }
        },
        propFix: {
            "for": "htmlFor",
            "class": "className"
        }
    });
    if (!h.optSelected) {
        x.propHooks.selected = {
            get: function(e) {
                var t = e.parentNode;
                if (t && t.parentNode) {
                    t.parentNode.selectedIndex;
                }
                return null;
            },
            set: function(e) {
                var t = e.parentNode;
                if (t) {
                    t.selectedIndex;
                    if (t.parentNode) {
                        t.parentNode.selectedIndex;
                    }
                }
            }
        };
    }
    x.each([ "tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable" ], function() {
        x.propFix[this.toLowerCase()] = this;
    });
    function yt(e) {
        var t = e.match(R) || [];
        return t.join(" ");
    }
    function bt(e) {
        return e.getAttribute && e.getAttribute("class") || "";
    }
    function wt(e) {
        if (Array.isArray(e)) {
            return e;
        }
        if (typeof e === "string") {
            return e.match(R) || [];
        }
        return [];
    }
    x.fn.extend({
        addClass: function(e) {
            var t, n, i, r, o, a, s, l = 0;
            if (g(e)) {
                return this.each(function(t) {
                    x(this).addClass(e.call(this, t, bt(this)));
                });
            }
            t = wt(e);
            if (t.length) {
                while (n = this[l++]) {
                    r = bt(n);
                    i = n.nodeType === 1 && " " + yt(r) + " ";
                    if (i) {
                        a = 0;
                        while (o = t[a++]) {
                            if (i.indexOf(" " + o + " ") < 0) {
                                i += o + " ";
                            }
                        }
                        s = yt(i);
                        if (r !== s) {
                            n.setAttribute("class", s);
                        }
                    }
                }
            }
            return this;
        },
        removeClass: function(e) {
            var t, n, i, r, o, a, s, l = 0;
            if (g(e)) {
                return this.each(function(t) {
                    x(this).removeClass(e.call(this, t, bt(this)));
                });
            }
            if (!arguments.length) {
                return this.attr("class", "");
            }
            t = wt(e);
            if (t.length) {
                while (n = this[l++]) {
                    r = bt(n);
                    i = n.nodeType === 1 && " " + yt(r) + " ";
                    if (i) {
                        a = 0;
                        while (o = t[a++]) {
                            while (i.indexOf(" " + o + " ") > -1) {
                                i = i.replace(" " + o + " ", " ");
                            }
                        }
                        s = yt(i);
                        if (r !== s) {
                            n.setAttribute("class", s);
                        }
                    }
                }
            }
            return this;
        },
        toggleClass: function(e, t) {
            var n = typeof e, i = n === "string" || Array.isArray(e);
            if (typeof t === "boolean" && i) {
                return t ? this.addClass(e) : this.removeClass(e);
            }
            if (g(e)) {
                return this.each(function(n) {
                    x(this).toggleClass(e.call(this, n, bt(this), t), t);
                });
            }
            return this.each(function() {
                var t, r, o, a;
                if (i) {
                    r = 0;
                    o = x(this);
                    a = wt(e);
                    while (t = a[r++]) {
                        if (o.hasClass(t)) {
                            o.removeClass(t);
                        } else {
                            o.addClass(t);
                        }
                    }
                } else if (e === undefined || n === "boolean") {
                    t = bt(this);
                    if (t) {
                        K.set(this, "__className__", t);
                    }
                    if (this.setAttribute) {
                        this.setAttribute("class", t || e === false ? "" : K.get(this, "__className__") || "");
                    }
                }
            });
        },
        hasClass: function(e) {
            var t, n, i = 0;
            t = " " + e + " ";
            while (n = this[i++]) {
                if (n.nodeType === 1 && (" " + yt(bt(n)) + " ").indexOf(t) > -1) {
                    return true;
                }
            }
            return false;
        }
    });
    var xt = /\r/g;
    x.fn.extend({
        val: function(e) {
            var t, n, i, r = this[0];
            if (!arguments.length) {
                if (r) {
                    t = x.valHooks[r.type] || x.valHooks[r.nodeName.toLowerCase()];
                    if (t && "get" in t && (n = t.get(r, "value")) !== undefined) {
                        return n;
                    }
                    n = r.value;
                    if (typeof n === "string") {
                        return n.replace(xt, "");
                    }
                    return n == null ? "" : n;
                }
                return;
            }
            i = g(e);
            return this.each(function(n) {
                var r;
                if (this.nodeType !== 1) {
                    return;
                }
                if (i) {
                    r = e.call(this, n, x(this).val());
                } else {
                    r = e;
                }
                if (r == null) {
                    r = "";
                } else if (typeof r === "number") {
                    r += "";
                } else if (Array.isArray(r)) {
                    r = x.map(r, function(e) {
                        return e == null ? "" : e + "";
                    });
                }
                t = x.valHooks[this.type] || x.valHooks[this.nodeName.toLowerCase()];
                if (!t || !("set" in t) || t.set(this, r, "value") === undefined) {
                    this.value = r;
                }
            });
        }
    });
    x.extend({
        valHooks: {
            option: {
                get: function(e) {
                    var t = x.find.attr(e, "value");
                    return t != null ? t : yt(x.text(e));
                }
            },
            select: {
                get: function(e) {
                    var t, n, i, r = e.options, o = e.selectedIndex, a = e.type === "select-one", s = a ? null : [], l = a ? o + 1 : r.length;
                    if (o < 0) {
                        i = l;
                    } else {
                        i = a ? o : 0;
                    }
                    for (;i < l; i++) {
                        n = r[i];
                        if ((n.selected || i === o) && !n.disabled && (!n.parentNode.disabled || !$(n.parentNode, "optgroup"))) {
                            t = x(n).val();
                            if (a) {
                                return t;
                            }
                            s.push(t);
                        }
                    }
                    return s;
                },
                set: function(e, t) {
                    var n, i, r = e.options, o = x.makeArray(t), a = r.length;
                    while (a--) {
                        i = r[a];
                        if (i.selected = x.inArray(x.valHooks.option.get(i), o) > -1) {
                            n = true;
                        }
                    }
                    if (!n) {
                        e.selectedIndex = -1;
                    }
                    return o;
                }
            }
        }
    });
    x.each([ "radio", "checkbox" ], function() {
        x.valHooks[this] = {
            set: function(e, t) {
                if (Array.isArray(t)) {
                    return e.checked = x.inArray(x(e).val(), t) > -1;
                }
            }
        };
        if (!h.checkOn) {
            x.valHooks[this].get = function(e) {
                return e.getAttribute("value") === null ? "on" : e.value;
            };
        }
    });
    h.focusin = "onfocusin" in e;
    var Ct = /^(?:focusinfocus|focusoutblur)$/, Tt = function(e) {
        e.stopPropagation();
    };
    x.extend(x.event, {
        trigger: function(t, n, r, o) {
            var a, s, l, f, u, d, p, h, m = [ r || i ], y = c.call(t, "type") ? t.type : t, b = c.call(t, "namespace") ? t.namespace.split(".") : [];
            s = h = l = r = r || i;
            if (r.nodeType === 3 || r.nodeType === 8) {
                return;
            }
            if (Ct.test(y + x.event.triggered)) {
                return;
            }
            if (y.indexOf(".") > -1) {
                b = y.split(".");
                y = b.shift();
                b.sort();
            }
            u = y.indexOf(":") < 0 && "on" + y;
            t = t[x.expando] ? t : new x.Event(y, typeof t === "object" && t);
            t.isTrigger = o ? 2 : 3;
            t.namespace = b.join(".");
            t.rnamespace = t.namespace ? new RegExp("(^|\\.)" + b.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
            t.result = undefined;
            if (!t.target) {
                t.target = r;
            }
            n = n == null ? [ t ] : x.makeArray(n, [ t ]);
            p = x.event.special[y] || {};
            if (!o && p.trigger && p.trigger.apply(r, n) === false) {
                return;
            }
            if (!o && !p.noBubble && !v(r)) {
                f = p.delegateType || y;
                if (!Ct.test(f + y)) {
                    s = s.parentNode;
                }
                for (;s; s = s.parentNode) {
                    m.push(s);
                    l = s;
                }
                if (l === (r.ownerDocument || i)) {
                    m.push(l.defaultView || l.parentWindow || e);
                }
            }
            a = 0;
            while ((s = m[a++]) && !t.isPropagationStopped()) {
                h = s;
                t.type = a > 1 ? f : p.bindType || y;
                d = (K.get(s, "events") || {})[t.type] && K.get(s, "handle");
                if (d) {
                    d.apply(s, n);
                }
                d = u && s[u];
                if (d && d.apply && Y(s)) {
                    t.result = d.apply(s, n);
                    if (t.result === false) {
                        t.preventDefault();
                    }
                }
            }
            t.type = y;
            if (!o && !t.isDefaultPrevented()) {
                if ((!p._default || p._default.apply(m.pop(), n) === false) && Y(r)) {
                    if (u && g(r[y]) && !v(r)) {
                        l = r[u];
                        if (l) {
                            r[u] = null;
                        }
                        x.event.triggered = y;
                        if (t.isPropagationStopped()) {
                            h.addEventListener(y, Tt);
                        }
                        r[y]();
                        if (t.isPropagationStopped()) {
                            h.removeEventListener(y, Tt);
                        }
                        x.event.triggered = undefined;
                        if (l) {
                            r[u] = l;
                        }
                    }
                }
            }
            return t.result;
        },
        simulate: function(e, t, n) {
            var i = x.extend(new x.Event(), n, {
                type: e,
                isSimulated: true
            });
            x.event.trigger(i, null, t);
        }
    });
    x.fn.extend({
        trigger: function(e, t) {
            return this.each(function() {
                x.event.trigger(e, t, this);
            });
        },
        triggerHandler: function(e, t) {
            var n = this[0];
            if (n) {
                return x.event.trigger(e, t, n, true);
            }
        }
    });
    if (!h.focusin) {
        x.each({
            focus: "focusin",
            blur: "focusout"
        }, function(e, t) {
            var n = function(e) {
                x.event.simulate(t, e.target, x.event.fix(e));
            };
            x.event.special[t] = {
                setup: function() {
                    var i = this.ownerDocument || this, r = K.access(i, t);
                    if (!r) {
                        i.addEventListener(e, n, true);
                    }
                    K.access(i, t, (r || 0) + 1);
                },
                teardown: function() {
                    var i = this.ownerDocument || this, r = K.access(i, t) - 1;
                    if (!r) {
                        i.removeEventListener(e, n, true);
                        K.remove(i, t);
                    } else {
                        K.access(i, t, r);
                    }
                }
            };
        });
    }
    var Dt = e.location;
    var kt = Date.now();
    var St = /\?/;
    x.parseXML = function(t) {
        var n;
        if (!t || typeof t !== "string") {
            return null;
        }
        try {
            n = new e.DOMParser().parseFromString(t, "text/xml");
        } catch (i) {
            n = undefined;
        }
        if (!n || n.getElementsByTagName("parsererror").length) {
            x.error("Invalid XML: " + t);
        }
        return n;
    };
    var Et = /\[\]$/, $t = /\r?\n/g, At = /^(?:submit|button|image|reset|file)$/i, Nt = /^(?:input|select|textarea|keygen)/i;
    function jt(e, t, n, i) {
        var r;
        if (Array.isArray(t)) {
            x.each(t, function(t, r) {
                if (n || Et.test(e)) {
                    i(e, r);
                } else {
                    jt(e + "[" + (typeof r === "object" && r != null ? t : "") + "]", r, n, i);
                }
            });
        } else if (!n && b(t) === "object") {
            for (r in t) {
                jt(e + "[" + r + "]", t[r], n, i);
            }
        } else {
            i(e, t);
        }
    }
    x.param = function(e, t) {
        var n, i = [], r = function(e, t) {
            var n = g(t) ? t() : t;
            i[i.length] = encodeURIComponent(e) + "=" + encodeURIComponent(n == null ? "" : n);
        };
        if (Array.isArray(e) || e.jquery && !x.isPlainObject(e)) {
            x.each(e, function() {
                r(this.name, this.value);
            });
        } else {
            for (n in e) {
                jt(n, e[n], t, r);
            }
        }
        return i.join("&");
    };
    x.fn.extend({
        serialize: function() {
            return x.param(this.serializeArray());
        },
        serializeArray: function() {
            return this.map(function() {
                var e = x.prop(this, "elements");
                return e ? x.makeArray(e) : this;
            }).filter(function() {
                var e = this.type;
                return this.name && !x(this).is(":disabled") && Nt.test(this.nodeName) && !At.test(e) && (this.checked || !pe.test(e));
            }).map(function(e, t) {
                var n = x(this).val();
                if (n == null) {
                    return null;
                }
                if (Array.isArray(n)) {
                    return x.map(n, function(e) {
                        return {
                            name: t.name,
                            value: e.replace($t, "\r\n")
                        };
                    });
                }
                return {
                    name: t.name,
                    value: n.replace($t, "\r\n")
                };
            }).get();
        }
    });
    var Lt = /%20/g, It = /#.*$/, Pt = /([?&])_=[^&]*/, Ot = /^(.*?):[ \t]*([^\r\n]*)$/gm, Ht = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, Rt = /^(?:GET|HEAD)$/, qt = /^\/\//, Bt = {}, Mt = {}, _t = "*/".concat("*"), Ft = i.createElement("a");
    Ft.href = Dt.href;
    function Ut(e) {
        return function(t, n) {
            if (typeof t !== "string") {
                n = t;
                t = "*";
            }
            var i, r = 0, o = t.toLowerCase().match(R) || [];
            if (g(n)) {
                while (i = o[r++]) {
                    if (i[0] === "+") {
                        i = i.slice(1) || "*";
                        (e[i] = e[i] || []).unshift(n);
                    } else {
                        (e[i] = e[i] || []).push(n);
                    }
                }
            }
        };
    }
    function Wt(e, t, n, i) {
        var r = {}, o = e === Mt;
        function a(s) {
            var l;
            r[s] = true;
            x.each(e[s] || [], function(e, s) {
                var f = s(t, n, i);
                if (typeof f === "string" && !o && !r[f]) {
                    t.dataTypes.unshift(f);
                    a(f);
                    return false;
                } else if (o) {
                    return !(l = f);
                }
            });
            return l;
        }
        return a(t.dataTypes[0]) || !r["*"] && a("*");
    }
    function zt(e, t) {
        var n, i, r = x.ajaxSettings.flatOptions || {};
        for (n in t) {
            if (t[n] !== undefined) {
                (r[n] ? e : i || (i = {}))[n] = t[n];
            }
        }
        if (i) {
            x.extend(true, e, i);
        }
        return e;
    }
    function Gt(e, t, n) {
        var i, r, o, a, s = e.contents, l = e.dataTypes;
        while (l[0] === "*") {
            l.shift();
            if (i === undefined) {
                i = e.mimeType || t.getResponseHeader("Content-Type");
            }
        }
        if (i) {
            for (r in s) {
                if (s[r] && s[r].test(i)) {
                    l.unshift(r);
                    break;
                }
            }
        }
        if (l[0] in n) {
            o = l[0];
        } else {
            for (r in n) {
                if (!l[0] || e.converters[r + " " + l[0]]) {
                    o = r;
                    break;
                }
                if (!a) {
                    a = r;
                }
            }
            o = o || a;
        }
        if (o) {
            if (o !== l[0]) {
                l.unshift(o);
            }
            return n[o];
        }
    }
    function Qt(e, t, n, i) {
        var r, o, a, s, l, f = {}, u = e.dataTypes.slice();
        if (u[1]) {
            for (a in e.converters) {
                f[a.toLowerCase()] = e.converters[a];
            }
        }
        o = u.shift();
        while (o) {
            if (e.responseFields[o]) {
                n[e.responseFields[o]] = t;
            }
            if (!l && i && e.dataFilter) {
                t = e.dataFilter(t, e.dataType);
            }
            l = o;
            o = u.shift();
            if (o) {
                if (o === "*") {
                    o = l;
                } else if (l !== "*" && l !== o) {
                    a = f[l + " " + o] || f["* " + o];
                    if (!a) {
                        for (r in f) {
                            s = r.split(" ");
                            if (s[1] === o) {
                                a = f[l + " " + s[0]] || f["* " + s[0]];
                                if (a) {
                                    if (a === true) {
                                        a = f[r];
                                    } else if (f[r] !== true) {
                                        o = s[0];
                                        u.unshift(s[1]);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    if (a !== true) {
                        if (a && e.throws) {
                            t = a(t);
                        } else {
                            try {
                                t = a(t);
                            } catch (c) {
                                return {
                                    state: "parsererror",
                                    error: a ? c : "No conversion from " + l + " to " + o
                                };
                            }
                        }
                    }
                }
            }
        }
        return {
            state: "success",
            data: t
        };
    }
    x.extend({
        active: 0,
        lastModified: {},
        etag: {},
        ajaxSettings: {
            url: Dt.href,
            type: "GET",
            isLocal: Ht.test(Dt.protocol),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            accepts: {
                "*": _t,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },
            contents: {
                xml: /\bxml\b/,
                html: /\bhtml/,
                json: /\bjson\b/
            },
            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },
            converters: {
                "* text": String,
                "text html": true,
                "text json": JSON.parse,
                "text xml": x.parseXML
            },
            flatOptions: {
                url: true,
                context: true
            }
        },
        ajaxSetup: function(e, t) {
            return t ? zt(zt(e, x.ajaxSettings), t) : zt(x.ajaxSettings, e);
        },
        ajaxPrefilter: Ut(Bt),
        ajaxTransport: Ut(Mt),
        ajax: function(t, n) {
            if (typeof t === "object") {
                n = t;
                t = undefined;
            }
            n = n || {};
            var r, o, a, s, l, f, u, c, d, p, h = x.ajaxSetup({}, n), g = h.context || h, v = h.context && (g.nodeType || g.jquery) ? x(g) : x.event, m = x.Deferred(), y = x.Callbacks("once memory"), b = h.statusCode || {}, w = {}, C = {}, T = "canceled", D = {
                readyState: 0,
                getResponseHeader: function(e) {
                    var t;
                    if (u) {
                        if (!s) {
                            s = {};
                            while (t = Ot.exec(a)) {
                                s[t[1].toLowerCase()] = t[2];
                            }
                        }
                        t = s[e.toLowerCase()];
                    }
                    return t == null ? null : t;
                },
                getAllResponseHeaders: function() {
                    return u ? a : null;
                },
                setRequestHeader: function(e, t) {
                    if (u == null) {
                        e = C[e.toLowerCase()] = C[e.toLowerCase()] || e;
                        w[e] = t;
                    }
                    return this;
                },
                overrideMimeType: function(e) {
                    if (u == null) {
                        h.mimeType = e;
                    }
                    return this;
                },
                statusCode: function(e) {
                    var t;
                    if (e) {
                        if (u) {
                            D.always(e[D.status]);
                        } else {
                            for (t in e) {
                                b[t] = [ b[t], e[t] ];
                            }
                        }
                    }
                    return this;
                },
                abort: function(e) {
                    var t = e || T;
                    if (r) {
                        r.abort(t);
                    }
                    S(0, t);
                    return this;
                }
            };
            m.promise(D);
            h.url = ((t || h.url || Dt.href) + "").replace(qt, Dt.protocol + "//");
            h.type = n.method || n.type || h.method || h.type;
            h.dataTypes = (h.dataType || "*").toLowerCase().match(R) || [ "" ];
            if (h.crossDomain == null) {
                f = i.createElement("a");
                try {
                    f.href = h.url;
                    f.href = f.href;
                    h.crossDomain = Ft.protocol + "//" + Ft.host !== f.protocol + "//" + f.host;
                } catch (k) {
                    h.crossDomain = true;
                }
            }
            if (h.data && h.processData && typeof h.data !== "string") {
                h.data = x.param(h.data, h.traditional);
            }
            Wt(Bt, h, n, D);
            if (u) {
                return D;
            }
            c = x.event && h.global;
            if (c && x.active++ === 0) {
                x.event.trigger("ajaxStart");
            }
            h.type = h.type.toUpperCase();
            h.hasContent = !Rt.test(h.type);
            o = h.url.replace(It, "");
            if (!h.hasContent) {
                p = h.url.slice(o.length);
                if (h.data && (h.processData || typeof h.data === "string")) {
                    o += (St.test(o) ? "&" : "?") + h.data;
                    delete h.data;
                }
                if (h.cache === false) {
                    o = o.replace(Pt, "$1");
                    p = (St.test(o) ? "&" : "?") + "_=" + kt++ + p;
                }
                h.url = o + p;
            } else if (h.data && h.processData && (h.contentType || "").indexOf("application/x-www-form-urlencoded") === 0) {
                h.data = h.data.replace(Lt, "+");
            }
            if (h.ifModified) {
                if (x.lastModified[o]) {
                    D.setRequestHeader("If-Modified-Since", x.lastModified[o]);
                }
                if (x.etag[o]) {
                    D.setRequestHeader("If-None-Match", x.etag[o]);
                }
            }
            if (h.data && h.hasContent && h.contentType !== false || n.contentType) {
                D.setRequestHeader("Content-Type", h.contentType);
            }
            D.setRequestHeader("Accept", h.dataTypes[0] && h.accepts[h.dataTypes[0]] ? h.accepts[h.dataTypes[0]] + (h.dataTypes[0] !== "*" ? ", " + _t + "; q=0.01" : "") : h.accepts["*"]);
            for (d in h.headers) {
                D.setRequestHeader(d, h.headers[d]);
            }
            if (h.beforeSend && (h.beforeSend.call(g, D, h) === false || u)) {
                return D.abort();
            }
            T = "abort";
            y.add(h.complete);
            D.done(h.success);
            D.fail(h.error);
            r = Wt(Mt, h, n, D);
            if (!r) {
                S(-1, "No Transport");
            } else {
                D.readyState = 1;
                if (c) {
                    v.trigger("ajaxSend", [ D, h ]);
                }
                if (u) {
                    return D;
                }
                if (h.async && h.timeout > 0) {
                    l = e.setTimeout(function() {
                        D.abort("timeout");
                    }, h.timeout);
                }
                try {
                    u = false;
                    r.send(w, S);
                } catch (k) {
                    if (u) {
                        throw k;
                    }
                    S(-1, k);
                }
            }
            function S(t, n, i, s) {
                var f, d, p, w, C, T = n;
                if (u) {
                    return;
                }
                u = true;
                if (l) {
                    e.clearTimeout(l);
                }
                r = undefined;
                a = s || "";
                D.readyState = t > 0 ? 4 : 0;
                f = t >= 200 && t < 300 || t === 304;
                if (i) {
                    w = Gt(h, D, i);
                }
                w = Qt(h, w, D, f);
                if (f) {
                    if (h.ifModified) {
                        C = D.getResponseHeader("Last-Modified");
                        if (C) {
                            x.lastModified[o] = C;
                        }
                        C = D.getResponseHeader("etag");
                        if (C) {
                            x.etag[o] = C;
                        }
                    }
                    if (t === 204 || h.type === "HEAD") {
                        T = "nocontent";
                    } else if (t === 304) {
                        T = "notmodified";
                    } else {
                        T = w.state;
                        d = w.data;
                        p = w.error;
                        f = !p;
                    }
                } else {
                    p = T;
                    if (t || !T) {
                        T = "error";
                        if (t < 0) {
                            t = 0;
                        }
                    }
                }
                D.status = t;
                D.statusText = (n || T) + "";
                if (f) {
                    m.resolveWith(g, [ d, T, D ]);
                } else {
                    m.rejectWith(g, [ D, T, p ]);
                }
                D.statusCode(b);
                b = undefined;
                if (c) {
                    v.trigger(f ? "ajaxSuccess" : "ajaxError", [ D, h, f ? d : p ]);
                }
                y.fireWith(g, [ D, T ]);
                if (c) {
                    v.trigger("ajaxComplete", [ D, h ]);
                    if (!--x.active) {
                        x.event.trigger("ajaxStop");
                    }
                }
            }
            return D;
        },
        getJSON: function(e, t, n) {
            return x.get(e, t, n, "json");
        },
        getScript: function(e, t) {
            return x.get(e, undefined, t, "script");
        }
    });
    x.each([ "get", "post" ], function(e, t) {
        x[t] = function(e, n, i, r) {
            if (g(n)) {
                r = r || i;
                i = n;
                n = undefined;
            }
            return x.ajax(x.extend({
                url: e,
                type: t,
                dataType: r,
                data: n,
                success: i
            }, x.isPlainObject(e) && e));
        };
    });
    x._evalUrl = function(e) {
        return x.ajax({
            url: e,
            type: "GET",
            dataType: "script",
            cache: true,
            async: false,
            global: false,
            "throws": true
        });
    };
    x.fn.extend({
        wrapAll: function(e) {
            var t;
            if (this[0]) {
                if (g(e)) {
                    e = e.call(this[0]);
                }
                t = x(e, this[0].ownerDocument).eq(0).clone(true);
                if (this[0].parentNode) {
                    t.insertBefore(this[0]);
                }
                t.map(function() {
                    var e = this;
                    while (e.firstElementChild) {
                        e = e.firstElementChild;
                    }
                    return e;
                }).append(this);
            }
            return this;
        },
        wrapInner: function(e) {
            if (g(e)) {
                return this.each(function(t) {
                    x(this).wrapInner(e.call(this, t));
                });
            }
            return this.each(function() {
                var t = x(this), n = t.contents();
                if (n.length) {
                    n.wrapAll(e);
                } else {
                    t.append(e);
                }
            });
        },
        wrap: function(e) {
            var t = g(e);
            return this.each(function(n) {
                x(this).wrapAll(t ? e.call(this, n) : e);
            });
        },
        unwrap: function(e) {
            this.parent(e).not("body").each(function() {
                x(this).replaceWith(this.childNodes);
            });
            return this;
        }
    });
    x.expr.pseudos.hidden = function(e) {
        return !x.expr.pseudos.visible(e);
    };
    x.expr.pseudos.visible = function(e) {
        return !!(e.offsetWidth || e.offsetHeight || e.getClientRects().length);
    };
    x.ajaxSettings.xhr = function() {
        try {
            return new e.XMLHttpRequest();
        } catch (t) {}
    };
    var Vt = {
        0: 200,
        1223: 204
    }, Xt = x.ajaxSettings.xhr();
    h.cors = !!Xt && "withCredentials" in Xt;
    h.ajax = Xt = !!Xt;
    x.ajaxTransport(function(t) {
        var n, i;
        if (h.cors || Xt && !t.crossDomain) {
            return {
                send: function(r, o) {
                    var a, s = t.xhr();
                    s.open(t.type, t.url, t.async, t.username, t.password);
                    if (t.xhrFields) {
                        for (a in t.xhrFields) {
                            s[a] = t.xhrFields[a];
                        }
                    }
                    if (t.mimeType && s.overrideMimeType) {
                        s.overrideMimeType(t.mimeType);
                    }
                    if (!t.crossDomain && !r["X-Requested-With"]) {
                        r["X-Requested-With"] = "XMLHttpRequest";
                    }
                    for (a in r) {
                        s.setRequestHeader(a, r[a]);
                    }
                    n = function(e) {
                        return function() {
                            if (n) {
                                n = i = s.onload = s.onerror = s.onabort = s.ontimeout = s.onreadystatechange = null;
                                if (e === "abort") {
                                    s.abort();
                                } else if (e === "error") {
                                    if (typeof s.status !== "number") {
                                        o(0, "error");
                                    } else {
                                        o(s.status, s.statusText);
                                    }
                                } else {
                                    o(Vt[s.status] || s.status, s.statusText, (s.responseType || "text") !== "text" || typeof s.responseText !== "string" ? {
                                        binary: s.response
                                    } : {
                                        text: s.responseText
                                    }, s.getAllResponseHeaders());
                                }
                            }
                        };
                    };
                    s.onload = n();
                    i = s.onerror = s.ontimeout = n("error");
                    if (s.onabort !== undefined) {
                        s.onabort = i;
                    } else {
                        s.onreadystatechange = function() {
                            if (s.readyState === 4) {
                                e.setTimeout(function() {
                                    if (n) {
                                        i();
                                    }
                                });
                            }
                        };
                    }
                    n = n("abort");
                    try {
                        s.send(t.hasContent && t.data || null);
                    } catch (l) {
                        if (n) {
                            throw l;
                        }
                    }
                },
                abort: function() {
                    if (n) {
                        n();
                    }
                }
            };
        }
    });
    x.ajaxPrefilter(function(e) {
        if (e.crossDomain) {
            e.contents.script = false;
        }
    });
    x.ajaxSetup({
        accepts: {
            script: "text/javascript, application/javascript, " + "application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /\b(?:java|ecma)script\b/
        },
        converters: {
            "text script": function(e) {
                x.globalEval(e);
                return e;
            }
        }
    });
    x.ajaxPrefilter("script", function(e) {
        if (e.cache === undefined) {
            e.cache = false;
        }
        if (e.crossDomain) {
            e.type = "GET";
        }
    });
    x.ajaxTransport("script", function(e) {
        if (e.crossDomain) {
            var t, n;
            return {
                send: function(r, o) {
                    t = x("<script>").prop({
                        charset: e.scriptCharset,
                        src: e.url
                    }).on("load error", n = function(e) {
                        t.remove();
                        n = null;
                        if (e) {
                            o(e.type === "error" ? 404 : 200, e.type);
                        }
                    });
                    i.head.appendChild(t[0]);
                },
                abort: function() {
                    if (n) {
                        n();
                    }
                }
            };
        }
    });
    var Yt = [], Jt = /(=)\?(?=&|$)|\?\?/;
    x.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function() {
            var e = Yt.pop() || x.expando + "_" + kt++;
            this[e] = true;
            return e;
        }
    });
    x.ajaxPrefilter("json jsonp", function(t, n, i) {
        var r, o, a, s = t.jsonp !== false && (Jt.test(t.url) ? "url" : typeof t.data === "string" && (t.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && Jt.test(t.data) && "data");
        if (s || t.dataTypes[0] === "jsonp") {
            r = t.jsonpCallback = g(t.jsonpCallback) ? t.jsonpCallback() : t.jsonpCallback;
            if (s) {
                t[s] = t[s].replace(Jt, "$1" + r);
            } else if (t.jsonp !== false) {
                t.url += (St.test(t.url) ? "&" : "?") + t.jsonp + "=" + r;
            }
            t.converters["script json"] = function() {
                if (!a) {
                    x.error(r + " was not called");
                }
                return a[0];
            };
            t.dataTypes[0] = "json";
            o = e[r];
            e[r] = function() {
                a = arguments;
            };
            i.always(function() {
                if (o === undefined) {
                    x(e).removeProp(r);
                } else {
                    e[r] = o;
                }
                if (t[r]) {
                    t.jsonpCallback = n.jsonpCallback;
                    Yt.push(r);
                }
                if (a && g(o)) {
                    o(a[0]);
                }
                a = o = undefined;
            });
            return "script";
        }
    });
    h.createHTMLDocument = function() {
        var e = i.implementation.createHTMLDocument("").body;
        e.innerHTML = "<form></form><form></form>";
        return e.childNodes.length === 2;
    }();
    x.parseHTML = function(e, t, n) {
        if (typeof e !== "string") {
            return [];
        }
        if (typeof t === "boolean") {
            n = t;
            t = false;
        }
        var r, o, a;
        if (!t) {
            if (h.createHTMLDocument) {
                t = i.implementation.createHTMLDocument("");
                r = t.createElement("base");
                r.href = i.location.href;
                t.head.appendChild(r);
            } else {
                t = i;
            }
        }
        o = A.exec(e);
        a = !n && [];
        if (o) {
            return [ t.createElement(o[1]) ];
        }
        o = we([ e ], t, a);
        if (a && a.length) {
            x(a).remove();
        }
        return x.merge([], o.childNodes);
    };
    x.fn.load = function(e, t, n) {
        var i, r, o, a = this, s = e.indexOf(" ");
        if (s > -1) {
            i = yt(e.slice(s));
            e = e.slice(0, s);
        }
        if (g(t)) {
            n = t;
            t = undefined;
        } else if (t && typeof t === "object") {
            r = "POST";
        }
        if (a.length > 0) {
            x.ajax({
                url: e,
                type: r || "GET",
                dataType: "html",
                data: t
            }).done(function(e) {
                o = arguments;
                a.html(i ? x("<div>").append(x.parseHTML(e)).find(i) : e);
            }).always(n && function(e, t) {
                a.each(function() {
                    n.apply(this, o || [ e.responseText, t, e ]);
                });
            });
        }
        return this;
    };
    x.each([ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function(e, t) {
        x.fn[t] = function(e) {
            return this.on(t, e);
        };
    });
    x.expr.pseudos.animated = function(e) {
        return x.grep(x.timers, function(t) {
            return e === t.elem;
        }).length;
    };
    x.offset = {
        setOffset: function(e, t, n) {
            var i, r, o, a, s, l, f, u = x.css(e, "position"), c = x(e), d = {};
            if (u === "static") {
                e.style.position = "relative";
            }
            s = c.offset();
            o = x.css(e, "top");
            l = x.css(e, "left");
            f = (u === "absolute" || u === "fixed") && (o + l).indexOf("auto") > -1;
            if (f) {
                i = c.position();
                a = i.top;
                r = i.left;
            } else {
                a = parseFloat(o) || 0;
                r = parseFloat(l) || 0;
            }
            if (g(t)) {
                t = t.call(e, n, x.extend({}, s));
            }
            if (t.top != null) {
                d.top = t.top - s.top + a;
            }
            if (t.left != null) {
                d.left = t.left - s.left + r;
            }
            if ("using" in t) {
                t.using.call(e, d);
            } else {
                c.css(d);
            }
        }
    };
    x.fn.extend({
        offset: function(e) {
            if (arguments.length) {
                return e === undefined ? this : this.each(function(t) {
                    x.offset.setOffset(this, e, t);
                });
            }
            var t, n, i = this[0];
            if (!i) {
                return;
            }
            if (!i.getClientRects().length) {
                return {
                    top: 0,
                    left: 0
                };
            }
            t = i.getBoundingClientRect();
            n = i.ownerDocument.defaultView;
            return {
                top: t.top + n.pageYOffset,
                left: t.left + n.pageXOffset
            };
        },
        position: function() {
            if (!this[0]) {
                return;
            }
            var e, t, n, i = this[0], r = {
                top: 0,
                left: 0
            };
            if (x.css(i, "position") === "fixed") {
                t = i.getBoundingClientRect();
            } else {
                t = this.offset();
                n = i.ownerDocument;
                e = i.offsetParent || n.documentElement;
                while (e && (e === n.body || e === n.documentElement) && x.css(e, "position") === "static") {
                    e = e.parentNode;
                }
                if (e && e !== i && e.nodeType === 1) {
                    r = x(e).offset();
                    r.top += x.css(e, "borderTopWidth", true);
                    r.left += x.css(e, "borderLeftWidth", true);
                }
            }
            return {
                top: t.top - r.top - x.css(i, "marginTop", true),
                left: t.left - r.left - x.css(i, "marginLeft", true)
            };
        },
        offsetParent: function() {
            return this.map(function() {
                var e = this.offsetParent;
                while (e && x.css(e, "position") === "static") {
                    e = e.offsetParent;
                }
                return e || xe;
            });
        }
    });
    x.each({
        scrollLeft: "pageXOffset",
        scrollTop: "pageYOffset"
    }, function(e, t) {
        var n = "pageYOffset" === t;
        x.fn[e] = function(i) {
            return z(this, function(e, i, r) {
                var o;
                if (v(e)) {
                    o = e;
                } else if (e.nodeType === 9) {
                    o = e.defaultView;
                }
                if (r === undefined) {
                    return o ? o[t] : e[i];
                }
                if (o) {
                    o.scrollTo(!n ? r : o.pageXOffset, n ? r : o.pageYOffset);
                } else {
                    e[i] = r;
                }
            }, e, i, arguments.length);
        };
    });
    x.each([ "top", "left" ], function(e, t) {
        x.cssHooks[t] = We(h.pixelPosition, function(e, n) {
            if (n) {
                n = Ue(e, t);
                return Me.test(n) ? x(e).position()[t] + "px" : n;
            }
        });
    });
    x.each({
        Height: "height",
        Width: "width"
    }, function(e, t) {
        x.each({
            padding: "inner" + e,
            content: t,
            "": "outer" + e
        }, function(n, i) {
            x.fn[i] = function(r, o) {
                var a = arguments.length && (n || typeof r !== "boolean"), s = n || (r === true || o === true ? "margin" : "border");
                return z(this, function(t, n, r) {
                    var o;
                    if (v(t)) {
                        return i.indexOf("outer") === 0 ? t["inner" + e] : t.document.documentElement["client" + e];
                    }
                    if (t.nodeType === 9) {
                        o = t.documentElement;
                        return Math.max(t.body["scroll" + e], o["scroll" + e], t.body["offset" + e], o["offset" + e], o["client" + e]);
                    }
                    return r === undefined ? x.css(t, n, s) : x.style(t, n, r, s);
                }, t, a ? r : undefined, a);
            };
        });
    });
    x.each(("blur focus focusin focusout resize scroll click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup contextmenu").split(" "), function(e, t) {
        x.fn[t] = function(e, n) {
            return arguments.length > 0 ? this.on(t, null, e, n) : this.trigger(t);
        };
    });
    x.fn.extend({
        hover: function(e, t) {
            return this.mouseenter(e).mouseleave(t || e);
        }
    });
    x.fn.extend({
        bind: function(e, t, n) {
            return this.on(e, null, t, n);
        },
        unbind: function(e, t) {
            return this.off(e, null, t);
        },
        delegate: function(e, t, n, i) {
            return this.on(t, e, n, i);
        },
        undelegate: function(e, t, n) {
            return arguments.length === 1 ? this.off(e, "**") : this.off(t, e || "**", n);
        }
    });
    x.proxy = function(e, t) {
        var n, i, r;
        if (typeof t === "string") {
            n = e[t];
            t = e;
            e = n;
        }
        if (!g(e)) {
            return undefined;
        }
        i = o.call(arguments, 2);
        r = function() {
            return e.apply(t || this, i.concat(o.call(arguments)));
        };
        r.guid = e.guid = e.guid || x.guid++;
        return r;
    };
    x.holdReady = function(e) {
        if (e) {
            x.readyWait++;
        } else {
            x.ready(true);
        }
    };
    x.isArray = Array.isArray;
    x.parseJSON = JSON.parse;
    x.nodeName = $;
    x.isFunction = g;
    x.isWindow = v;
    x.camelCase = X;
    x.type = b;
    x.now = Date.now;
    x.isNumeric = function(e) {
        var t = x.type(e);
        return (t === "number" || t === "string") && !isNaN(e - parseFloat(e));
    };
    if (typeof define === "function" && define.amd) {
        define("jquery", [], function() {
            return x;
        });
    }
    var Kt = e.jQuery, Zt = e.$;
    x.noConflict = function(t) {
        if (e.$ === x) {
            e.$ = Zt;
        }
        if (t && e.jQuery === x) {
            e.jQuery = Kt;
        }
        return x;
    };
    if (!t) {
        e.jQuery = e.$ = x;
    }
    return x;
});

if (typeof jQuery === "undefined") {
    throw new Error("Bootstrap's JavaScript requires jQuery");
}

+function(e) {
    "use strict";
    var t = e.fn.jquery.split(" ")[0].split(".");
    if (t[0] < 2 && t[1] < 9 || t[0] == 1 && t[1] == 9 && t[2] < 1 || t[0] > 3) {
        throw new Error("Bootstrap's JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4");
    }
}(jQuery);

+function(e) {
    "use strict";
    function t() {
        var e = document.createElement("bootstrap");
        var t = {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd otransitionend",
            transition: "transitionend"
        };
        for (var n in t) {
            if (e.style[n] !== undefined) {
                return {
                    end: t[n]
                };
            }
        }
        return false;
    }
    e.fn.emulateTransitionEnd = function(t) {
        var n = false;
        var i = this;
        e(this).one("bsTransitionEnd", function() {
            n = true;
        });
        var r = function() {
            if (!n) e(i).trigger(e.support.transition.end);
        };
        setTimeout(r, t);
        return this;
    };
    e(function() {
        e.support.transition = t();
        if (!e.support.transition) return;
        e.event.special.bsTransitionEnd = {
            bindType: e.support.transition.end,
            delegateType: e.support.transition.end,
            handle: function(t) {
                if (e(t.target).is(this)) return t.handleObj.handler.apply(this, arguments);
            }
        };
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = '[data-dismiss="alert"]';
    var n = function(n) {
        e(n).on("click", t, this.close);
    };
    n.VERSION = "3.3.7";
    n.TRANSITION_DURATION = 150;
    n.prototype.close = function(t) {
        var i = e(this);
        var r = i.attr("data-target");
        if (!r) {
            r = i.attr("href");
            r = r && r.replace(/.*(?=#[^\s]*$)/, "");
        }
        var o = e(r === "#" ? [] : r);
        if (t) t.preventDefault();
        if (!o.length) {
            o = i.closest(".alert");
        }
        o.trigger(t = e.Event("close.bs.alert"));
        if (t.isDefaultPrevented()) return;
        o.removeClass("in");
        function a() {
            o.detach().trigger("closed.bs.alert").remove();
        }
        e.support.transition && o.hasClass("fade") ? o.one("bsTransitionEnd", a).emulateTransitionEnd(n.TRANSITION_DURATION) : a();
    };
    function i(t) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.alert");
            if (!r) i.data("bs.alert", r = new n(this));
            if (typeof t == "string") r[t].call(i);
        });
    }
    var r = e.fn.alert;
    e.fn.alert = i;
    e.fn.alert.Constructor = n;
    e.fn.alert.noConflict = function() {
        e.fn.alert = r;
        return this;
    };
    e(document).on("click.bs.alert.data-api", t, n.prototype.close);
}(jQuery);

+function(e) {
    "use strict";
    var t = function(n, i) {
        this.$element = e(n);
        this.options = e.extend({}, t.DEFAULTS, i);
        this.isLoading = false;
    };
    t.VERSION = "3.3.7";
    t.DEFAULTS = {
        loadingText: "loading..."
    };
    t.prototype.setState = function(t) {
        var n = "disabled";
        var i = this.$element;
        var r = i.is("input") ? "val" : "html";
        var o = i.data();
        t += "Text";
        if (o.resetText == null) i.data("resetText", i[r]());
        setTimeout(e.proxy(function() {
            i[r](o[t] == null ? this.options[t] : o[t]);
            if (t == "loadingText") {
                this.isLoading = true;
                i.addClass(n).attr(n, n).prop(n, true);
            } else if (this.isLoading) {
                this.isLoading = false;
                i.removeClass(n).removeAttr(n).prop(n, false);
            }
        }, this), 0);
    };
    t.prototype.toggle = function() {
        var e = true;
        var t = this.$element.closest('[data-toggle="buttons"]');
        if (t.length) {
            var n = this.$element.find("input");
            if (n.prop("type") == "radio") {
                if (n.prop("checked")) e = false;
                t.find(".active").removeClass("active");
                this.$element.addClass("active");
            } else if (n.prop("type") == "checkbox") {
                if (n.prop("checked") !== this.$element.hasClass("active")) e = false;
                this.$element.toggleClass("active");
            }
            n.prop("checked", this.$element.hasClass("active"));
            if (e) n.trigger("change");
        } else {
            this.$element.attr("aria-pressed", !this.$element.hasClass("active"));
            this.$element.toggleClass("active");
        }
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.button");
            var o = typeof n == "object" && n;
            if (!r) i.data("bs.button", r = new t(this, o));
            if (n == "toggle") r.toggle(); else if (n) r.setState(n);
        });
    }
    var i = e.fn.button;
    e.fn.button = n;
    e.fn.button.Constructor = t;
    e.fn.button.noConflict = function() {
        e.fn.button = i;
        return this;
    };
    e(document).on("click.bs.button.data-api", '[data-toggle^="button"]', function(t) {
        var i = e(t.target).closest(".btn");
        n.call(i, "toggle");
        if (!e(t.target).is('input[type="radio"], input[type="checkbox"]')) {
            t.preventDefault();
            if (i.is("input,button")) i.trigger("focus"); else i.find("input:visible,button:visible").first().trigger("focus");
        }
    }).on("focus.bs.button.data-api blur.bs.button.data-api", '[data-toggle^="button"]', function(t) {
        e(t.target).closest(".btn").toggleClass("focus", /^focus(in)?$/.test(t.type));
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = function(t, n) {
        this.$element = e(t);
        this.$indicators = this.$element.find(".carousel-indicators");
        this.options = n;
        this.paused = null;
        this.sliding = null;
        this.interval = null;
        this.$active = null;
        this.$items = null;
        this.options.keyboard && this.$element.on("keydown.bs.carousel", e.proxy(this.keydown, this));
        this.options.pause == "hover" && !("ontouchstart" in document.documentElement) && this.$element.on("mouseenter.bs.carousel", e.proxy(this.pause, this)).on("mouseleave.bs.carousel", e.proxy(this.cycle, this));
    };
    t.VERSION = "3.3.7";
    t.TRANSITION_DURATION = 600;
    t.DEFAULTS = {
        interval: 5e3,
        pause: "hover",
        wrap: true,
        keyboard: true
    };
    t.prototype.keydown = function(e) {
        if (/input|textarea/i.test(e.target.tagName)) return;
        switch (e.which) {
          case 37:
            this.prev();
            break;

          case 39:
            this.next();
            break;

          default:
            return;
        }
        e.preventDefault();
    };
    t.prototype.cycle = function(t) {
        t || (this.paused = false);
        this.interval && clearInterval(this.interval);
        this.options.interval && !this.paused && (this.interval = setInterval(e.proxy(this.next, this), this.options.interval));
        return this;
    };
    t.prototype.getItemIndex = function(e) {
        this.$items = e.parent().children(".item");
        return this.$items.index(e || this.$active);
    };
    t.prototype.getItemForDirection = function(e, t) {
        var n = this.getItemIndex(t);
        var i = e == "prev" && n === 0 || e == "next" && n == this.$items.length - 1;
        if (i && !this.options.wrap) return t;
        var r = e == "prev" ? -1 : 1;
        var o = (n + r) % this.$items.length;
        return this.$items.eq(o);
    };
    t.prototype.to = function(e) {
        var t = this;
        var n = this.getItemIndex(this.$active = this.$element.find(".item.active"));
        if (e > this.$items.length - 1 || e < 0) return;
        if (this.sliding) return this.$element.one("slid.bs.carousel", function() {
            t.to(e);
        });
        if (n == e) return this.pause().cycle();
        return this.slide(e > n ? "next" : "prev", this.$items.eq(e));
    };
    t.prototype.pause = function(t) {
        t || (this.paused = true);
        if (this.$element.find(".next, .prev").length && e.support.transition) {
            this.$element.trigger(e.support.transition.end);
            this.cycle(true);
        }
        this.interval = clearInterval(this.interval);
        return this;
    };
    t.prototype.next = function() {
        if (this.sliding) return;
        return this.slide("next");
    };
    t.prototype.prev = function() {
        if (this.sliding) return;
        return this.slide("prev");
    };
    t.prototype.slide = function(n, i) {
        var r = this.$element.find(".item.active");
        var o = i || this.getItemForDirection(n, r);
        var a = this.interval;
        var s = n == "next" ? "left" : "right";
        var l = this;
        if (o.hasClass("active")) return this.sliding = false;
        var f = o[0];
        var u = e.Event("slide.bs.carousel", {
            relatedTarget: f,
            direction: s
        });
        this.$element.trigger(u);
        if (u.isDefaultPrevented()) return;
        this.sliding = true;
        a && this.pause();
        if (this.$indicators.length) {
            this.$indicators.find(".active").removeClass("active");
            var c = e(this.$indicators.children()[this.getItemIndex(o)]);
            c && c.addClass("active");
        }
        var d = e.Event("slid.bs.carousel", {
            relatedTarget: f,
            direction: s
        });
        if (e.support.transition && this.$element.hasClass("slide")) {
            o.addClass(n);
            o[0].offsetWidth;
            r.addClass(s);
            o.addClass(s);
            r.one("bsTransitionEnd", function() {
                o.removeClass([ n, s ].join(" ")).addClass("active");
                r.removeClass([ "active", s ].join(" "));
                l.sliding = false;
                setTimeout(function() {
                    l.$element.trigger(d);
                }, 0);
            }).emulateTransitionEnd(t.TRANSITION_DURATION);
        } else {
            r.removeClass("active");
            o.addClass("active");
            this.sliding = false;
            this.$element.trigger(d);
        }
        a && this.cycle();
        return this;
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.carousel");
            var o = e.extend({}, t.DEFAULTS, i.data(), typeof n == "object" && n);
            var a = typeof n == "string" ? n : o.slide;
            if (!r) i.data("bs.carousel", r = new t(this, o));
            if (typeof n == "number") r.to(n); else if (a) r[a](); else if (o.interval) r.pause().cycle();
        });
    }
    var i = e.fn.carousel;
    e.fn.carousel = n;
    e.fn.carousel.Constructor = t;
    e.fn.carousel.noConflict = function() {
        e.fn.carousel = i;
        return this;
    };
    var r = function(t) {
        var i;
        var r = e(this);
        var o = e(r.attr("data-target") || (i = r.attr("href")) && i.replace(/.*(?=#[^\s]+$)/, ""));
        if (!o.hasClass("carousel")) return;
        var a = e.extend({}, o.data(), r.data());
        var s = r.attr("data-slide-to");
        if (s) a.interval = false;
        n.call(o, a);
        if (s) {
            o.data("bs.carousel").to(s);
        }
        t.preventDefault();
    };
    e(document).on("click.bs.carousel.data-api", "[data-slide]", r).on("click.bs.carousel.data-api", "[data-slide-to]", r);
    e(window).on("load", function() {
        e('[data-ride="carousel"]').each(function() {
            var t = e(this);
            n.call(t, t.data());
        });
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = function(n, i) {
        this.$element = e(n);
        this.options = e.extend({}, t.DEFAULTS, i);
        this.$trigger = e('[data-toggle="collapse"][href="#' + n.id + '"],' + '[data-toggle="collapse"][data-target="#' + n.id + '"]');
        this.transitioning = null;
        if (this.options.parent) {
            this.$parent = this.getParent();
        } else {
            this.addAriaAndCollapsedClass(this.$element, this.$trigger);
        }
        if (this.options.toggle) this.toggle();
    };
    t.VERSION = "3.3.7";
    t.TRANSITION_DURATION = 350;
    t.DEFAULTS = {
        toggle: true
    };
    t.prototype.dimension = function() {
        var e = this.$element.hasClass("width");
        return e ? "width" : "height";
    };
    t.prototype.show = function() {
        if (this.transitioning || this.$element.hasClass("in")) return;
        var n;
        var r = this.$parent && this.$parent.children(".panel").children(".in, .collapsing");
        if (r && r.length) {
            n = r.data("bs.collapse");
            if (n && n.transitioning) return;
        }
        var o = e.Event("show.bs.collapse");
        this.$element.trigger(o);
        if (o.isDefaultPrevented()) return;
        if (r && r.length) {
            i.call(r, "hide");
            n || r.data("bs.collapse", null);
        }
        var a = this.dimension();
        this.$element.removeClass("collapse").addClass("collapsing")[a](0).attr("aria-expanded", true);
        this.$trigger.removeClass("collapsed").attr("aria-expanded", true);
        this.transitioning = 1;
        var s = function() {
            this.$element.removeClass("collapsing").addClass("collapse in")[a]("");
            this.transitioning = 0;
            this.$element.trigger("shown.bs.collapse");
        };
        if (!e.support.transition) return s.call(this);
        var l = e.camelCase([ "scroll", a ].join("-"));
        this.$element.one("bsTransitionEnd", e.proxy(s, this)).emulateTransitionEnd(t.TRANSITION_DURATION)[a](this.$element[0][l]);
    };
    t.prototype.hide = function() {
        if (this.transitioning || !this.$element.hasClass("in")) return;
        var n = e.Event("hide.bs.collapse");
        this.$element.trigger(n);
        if (n.isDefaultPrevented()) return;
        var i = this.dimension();
        this.$element[i](this.$element[i]())[0].offsetHeight;
        this.$element.addClass("collapsing").removeClass("collapse in").attr("aria-expanded", false);
        this.$trigger.addClass("collapsed").attr("aria-expanded", false);
        this.transitioning = 1;
        var r = function() {
            this.transitioning = 0;
            this.$element.removeClass("collapsing").addClass("collapse").trigger("hidden.bs.collapse");
        };
        if (!e.support.transition) return r.call(this);
        this.$element[i](0).one("bsTransitionEnd", e.proxy(r, this)).emulateTransitionEnd(t.TRANSITION_DURATION);
    };
    t.prototype.toggle = function() {
        this[this.$element.hasClass("in") ? "hide" : "show"]();
    };
    t.prototype.getParent = function() {
        return e(this.options.parent).find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]').each(e.proxy(function(t, i) {
            var r = e(i);
            this.addAriaAndCollapsedClass(n(r), r);
        }, this)).end();
    };
    t.prototype.addAriaAndCollapsedClass = function(e, t) {
        var n = e.hasClass("in");
        e.attr("aria-expanded", n);
        t.toggleClass("collapsed", !n).attr("aria-expanded", n);
    };
    function n(t) {
        var n;
        var i = t.attr("data-target") || (n = t.attr("href")) && n.replace(/.*(?=#[^\s]+$)/, "");
        return e(i);
    }
    function i(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.collapse");
            var o = e.extend({}, t.DEFAULTS, i.data(), typeof n == "object" && n);
            if (!r && o.toggle && /show|hide/.test(n)) o.toggle = false;
            if (!r) i.data("bs.collapse", r = new t(this, o));
            if (typeof n == "string") r[n]();
        });
    }
    var r = e.fn.collapse;
    e.fn.collapse = i;
    e.fn.collapse.Constructor = t;
    e.fn.collapse.noConflict = function() {
        e.fn.collapse = r;
        return this;
    };
    e(document).on("click.bs.collapse.data-api", '[data-toggle="collapse"]', function(t) {
        var r = e(this);
        if (!r.attr("data-target")) t.preventDefault();
        var o = n(r);
        var a = o.data("bs.collapse");
        var s = a ? "toggle" : r.data();
        i.call(o, s);
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = ".dropdown-backdrop";
    var n = '[data-toggle="dropdown"]';
    var i = function(t) {
        e(t).on("click.bs.dropdown", this.toggle);
    };
    i.VERSION = "3.3.7";
    function r(t) {
        var n = t.attr("data-target");
        if (!n) {
            n = t.attr("href");
            n = n && /#[A-Za-z]/.test(n) && n.replace(/.*(?=#[^\s]*$)/, "");
        }
        var i = n && e(n);
        return i && i.length ? i : t.parent();
    }
    function o(i) {
        if (i && i.which === 3) return;
        e(t).remove();
        e(n).each(function() {
            var t = e(this);
            var n = r(t);
            var o = {
                relatedTarget: this
            };
            if (!n.hasClass("open")) return;
            if (i && i.type == "click" && /input|textarea/i.test(i.target.tagName) && e.contains(n[0], i.target)) return;
            n.trigger(i = e.Event("hide.bs.dropdown", o));
            if (i.isDefaultPrevented()) return;
            t.attr("aria-expanded", "false");
            n.removeClass("open").trigger(e.Event("hidden.bs.dropdown", o));
        });
    }
    i.prototype.toggle = function(t) {
        var n = e(this);
        if (n.is(".disabled, :disabled")) return;
        var i = r(n);
        var a = i.hasClass("open");
        o();
        if (!a) {
            if ("ontouchstart" in document.documentElement && !i.closest(".navbar-nav").length) {
                e(document.createElement("div")).addClass("dropdown-backdrop").insertAfter(e(this)).on("click", o);
            }
            var s = {
                relatedTarget: this
            };
            i.trigger(t = e.Event("show.bs.dropdown", s));
            if (t.isDefaultPrevented()) return;
            n.trigger("focus").attr("aria-expanded", "true");
            i.toggleClass("open").trigger(e.Event("shown.bs.dropdown", s));
        }
        return false;
    };
    i.prototype.keydown = function(t) {
        if (!/(38|40|27|32)/.test(t.which) || /input|textarea/i.test(t.target.tagName)) return;
        var i = e(this);
        t.preventDefault();
        t.stopPropagation();
        if (i.is(".disabled, :disabled")) return;
        var o = r(i);
        var a = o.hasClass("open");
        if (!a && t.which != 27 || a && t.which == 27) {
            if (t.which == 27) o.find(n).trigger("focus");
            return i.trigger("click");
        }
        var s = " li:not(.disabled):visible a";
        var l = o.find(".dropdown-menu" + s);
        if (!l.length) return;
        var f = l.index(t.target);
        if (t.which == 38 && f > 0) f--;
        if (t.which == 40 && f < l.length - 1) f++;
        if (!~f) f = 0;
        l.eq(f).trigger("focus");
    };
    function a(t) {
        return this.each(function() {
            var n = e(this);
            var r = n.data("bs.dropdown");
            if (!r) n.data("bs.dropdown", r = new i(this));
            if (typeof t == "string") r[t].call(n);
        });
    }
    var s = e.fn.dropdown;
    e.fn.dropdown = a;
    e.fn.dropdown.Constructor = i;
    e.fn.dropdown.noConflict = function() {
        e.fn.dropdown = s;
        return this;
    };
    e(document).on("click.bs.dropdown.data-api", o).on("click.bs.dropdown.data-api", ".dropdown form", function(e) {
        e.stopPropagation();
    }).on("click.bs.dropdown.data-api", n, i.prototype.toggle).on("keydown.bs.dropdown.data-api", n, i.prototype.keydown).on("keydown.bs.dropdown.data-api", ".dropdown-menu", i.prototype.keydown);
}(jQuery);

+function(e) {
    "use strict";
    var t = function(t, n) {
        this.options = n;
        this.$body = e(document.body);
        this.$element = e(t);
        this.$dialog = this.$element.find(".modal-dialog");
        this.$backdrop = null;
        this.isShown = null;
        this.originalBodyPad = null;
        this.scrollbarWidth = 0;
        this.ignoreBackdropClick = false;
        if (this.options.remote) {
            this.$element.find(".modal-content").load(this.options.remote, e.proxy(function() {
                this.$element.trigger("loaded.bs.modal");
            }, this));
        }
    };
    t.VERSION = "3.3.7";
    t.TRANSITION_DURATION = 300;
    t.BACKDROP_TRANSITION_DURATION = 150;
    t.DEFAULTS = {
        backdrop: true,
        keyboard: true,
        show: true
    };
    t.prototype.toggle = function(e) {
        return this.isShown ? this.hide() : this.show(e);
    };
    t.prototype.show = function(n) {
        var i = this;
        var r = e.Event("show.bs.modal", {
            relatedTarget: n
        });
        this.$element.trigger(r);
        if (this.isShown || r.isDefaultPrevented()) return;
        this.isShown = true;
        this.checkScrollbar();
        this.setScrollbar();
        this.$body.addClass("modal-open");
        this.escape();
        this.resize();
        this.$element.on("click.dismiss.bs.modal", '[data-dismiss="modal"]', e.proxy(this.hide, this));
        this.$dialog.on("mousedown.dismiss.bs.modal", function() {
            i.$element.one("mouseup.dismiss.bs.modal", function(t) {
                if (e(t.target).is(i.$element)) i.ignoreBackdropClick = true;
            });
        });
        this.backdrop(function() {
            var r = e.support.transition && i.$element.hasClass("fade");
            if (!i.$element.parent().length) {
                i.$element.appendTo(i.$body);
            }
            i.$element.show().scrollTop(0);
            i.adjustDialog();
            if (r) {
                i.$element[0].offsetWidth;
            }
            i.$element.addClass("in");
            i.enforceFocus();
            var o = e.Event("shown.bs.modal", {
                relatedTarget: n
            });
            r ? i.$dialog.one("bsTransitionEnd", function() {
                i.$element.trigger("focus").trigger(o);
            }).emulateTransitionEnd(t.TRANSITION_DURATION) : i.$element.trigger("focus").trigger(o);
        });
    };
    t.prototype.hide = function(n) {
        if (n) n.preventDefault();
        n = e.Event("hide.bs.modal");
        this.$element.trigger(n);
        if (!this.isShown || n.isDefaultPrevented()) return;
        this.isShown = false;
        this.escape();
        this.resize();
        e(document).off("focusin.bs.modal");
        this.$element.removeClass("in").off("click.dismiss.bs.modal").off("mouseup.dismiss.bs.modal");
        this.$dialog.off("mousedown.dismiss.bs.modal");
        e.support.transition && this.$element.hasClass("fade") ? this.$element.one("bsTransitionEnd", e.proxy(this.hideModal, this)).emulateTransitionEnd(t.TRANSITION_DURATION) : this.hideModal();
    };
    t.prototype.enforceFocus = function() {
        e(document).off("focusin.bs.modal").on("focusin.bs.modal", e.proxy(function(e) {
            if (document !== e.target && this.$element[0] !== e.target && !this.$element.has(e.target).length) {
                this.$element.trigger("focus");
            }
        }, this));
    };
    t.prototype.escape = function() {
        if (this.isShown && this.options.keyboard) {
            this.$element.on("keydown.dismiss.bs.modal", e.proxy(function(e) {
                e.which == 27 && this.hide();
            }, this));
        } else if (!this.isShown) {
            this.$element.off("keydown.dismiss.bs.modal");
        }
    };
    t.prototype.resize = function() {
        if (this.isShown) {
            e(window).on("resize.bs.modal", e.proxy(this.handleUpdate, this));
        } else {
            e(window).off("resize.bs.modal");
        }
    };
    t.prototype.hideModal = function() {
        var e = this;
        this.$element.hide();
        this.backdrop(function() {
            e.$body.removeClass("modal-open");
            e.resetAdjustments();
            e.resetScrollbar();
            e.$element.trigger("hidden.bs.modal");
        });
    };
    t.prototype.removeBackdrop = function() {
        this.$backdrop && this.$backdrop.remove();
        this.$backdrop = null;
    };
    t.prototype.backdrop = function(n) {
        var i = this;
        var r = this.$element.hasClass("fade") ? "fade" : "";
        if (this.isShown && this.options.backdrop) {
            var o = e.support.transition && r;
            this.$backdrop = e(document.createElement("div")).addClass("modal-backdrop " + r).appendTo(this.$body);
            this.$element.on("click.dismiss.bs.modal", e.proxy(function(e) {
                if (this.ignoreBackdropClick) {
                    this.ignoreBackdropClick = false;
                    return;
                }
                if (e.target !== e.currentTarget) return;
                this.options.backdrop == "static" ? this.$element[0].focus() : this.hide();
            }, this));
            if (o) this.$backdrop[0].offsetWidth;
            this.$backdrop.addClass("in");
            if (!n) return;
            o ? this.$backdrop.one("bsTransitionEnd", n).emulateTransitionEnd(t.BACKDROP_TRANSITION_DURATION) : n();
        } else if (!this.isShown && this.$backdrop) {
            this.$backdrop.removeClass("in");
            var a = function() {
                i.removeBackdrop();
                n && n();
            };
            e.support.transition && this.$element.hasClass("fade") ? this.$backdrop.one("bsTransitionEnd", a).emulateTransitionEnd(t.BACKDROP_TRANSITION_DURATION) : a();
        } else if (n) {
            n();
        }
    };
    t.prototype.handleUpdate = function() {
        this.adjustDialog();
    };
    t.prototype.adjustDialog = function() {
        var e = this.$element[0].scrollHeight > document.documentElement.clientHeight;
        this.$element.css({
            paddingLeft: !this.bodyIsOverflowing && e ? this.scrollbarWidth : "",
            paddingRight: this.bodyIsOverflowing && !e ? this.scrollbarWidth : ""
        });
    };
    t.prototype.resetAdjustments = function() {
        this.$element.css({
            paddingLeft: "",
            paddingRight: ""
        });
    };
    t.prototype.checkScrollbar = function() {
        var e = window.innerWidth;
        if (!e) {
            var t = document.documentElement.getBoundingClientRect();
            e = t.right - Math.abs(t.left);
        }
        this.bodyIsOverflowing = document.body.clientWidth < e;
        this.scrollbarWidth = this.measureScrollbar();
    };
    t.prototype.setScrollbar = function() {
        var e = parseInt(this.$body.css("padding-right") || 0, 10);
        this.originalBodyPad = document.body.style.paddingRight || "";
        if (this.bodyIsOverflowing) this.$body.css("padding-right", e + this.scrollbarWidth);
    };
    t.prototype.resetScrollbar = function() {
        this.$body.css("padding-right", this.originalBodyPad);
    };
    t.prototype.measureScrollbar = function() {
        var e = document.createElement("div");
        e.className = "modal-scrollbar-measure";
        this.$body.append(e);
        var t = e.offsetWidth - e.clientWidth;
        this.$body[0].removeChild(e);
        return t;
    };
    function n(n, i) {
        return this.each(function() {
            var r = e(this);
            var o = r.data("bs.modal");
            var a = e.extend({}, t.DEFAULTS, r.data(), typeof n == "object" && n);
            if (!o) r.data("bs.modal", o = new t(this, a));
            if (typeof n == "string") o[n](i); else if (a.show) o.show(i);
        });
    }
    var i = e.fn.modal;
    e.fn.modal = n;
    e.fn.modal.Constructor = t;
    e.fn.modal.noConflict = function() {
        e.fn.modal = i;
        return this;
    };
    e(document).on("click.bs.modal.data-api", '[data-toggle="modal"]', function(t) {
        var i = e(this);
        var r = i.attr("href");
        var o = e(i.attr("data-target") || r && r.replace(/.*(?=#[^\s]+$)/, ""));
        var a = o.data("bs.modal") ? "toggle" : e.extend({
            remote: !/#/.test(r) && r
        }, o.data(), i.data());
        if (i.is("a")) t.preventDefault();
        o.one("show.bs.modal", function(e) {
            if (e.isDefaultPrevented()) return;
            o.one("hidden.bs.modal", function() {
                i.is(":visible") && i.trigger("focus");
            });
        });
        n.call(o, a, this);
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = function(e, t) {
        this.type = null;
        this.options = null;
        this.enabled = null;
        this.timeout = null;
        this.hoverState = null;
        this.$element = null;
        this.inState = null;
        this.init("tooltip", e, t);
    };
    t.VERSION = "3.3.7";
    t.TRANSITION_DURATION = 150;
    t.DEFAULTS = {
        animation: true,
        placement: "top",
        selector: false,
        template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
        trigger: "hover focus",
        title: "",
        delay: 0,
        html: false,
        container: false,
        viewport: {
            selector: "body",
            padding: 0
        }
    };
    t.prototype.init = function(t, n, i) {
        this.enabled = true;
        this.type = t;
        this.$element = e(n);
        this.options = this.getOptions(i);
        this.$viewport = this.options.viewport && e(e.isFunction(this.options.viewport) ? this.options.viewport.call(this, this.$element) : this.options.viewport.selector || this.options.viewport);
        this.inState = {
            click: false,
            hover: false,
            focus: false
        };
        if (this.$element[0] instanceof document.constructor && !this.options.selector) {
            throw new Error("`selector` option must be specified when initializing " + this.type + " on the window.document object!");
        }
        var r = this.options.trigger.split(" ");
        for (var o = r.length; o--; ) {
            var a = r[o];
            if (a == "click") {
                this.$element.on("click." + this.type, this.options.selector, e.proxy(this.toggle, this));
            } else if (a != "manual") {
                var s = a == "hover" ? "mouseenter" : "focusin";
                var l = a == "hover" ? "mouseleave" : "focusout";
                this.$element.on(s + "." + this.type, this.options.selector, e.proxy(this.enter, this));
                this.$element.on(l + "." + this.type, this.options.selector, e.proxy(this.leave, this));
            }
        }
        this.options.selector ? this._options = e.extend({}, this.options, {
            trigger: "manual",
            selector: ""
        }) : this.fixTitle();
    };
    t.prototype.getDefaults = function() {
        return t.DEFAULTS;
    };
    t.prototype.getOptions = function(t) {
        t = e.extend({}, this.getDefaults(), this.$element.data(), t);
        if (t.delay && typeof t.delay == "number") {
            t.delay = {
                show: t.delay,
                hide: t.delay
            };
        }
        return t;
    };
    t.prototype.getDelegateOptions = function() {
        var t = {};
        var n = this.getDefaults();
        this._options && e.each(this._options, function(e, i) {
            if (n[e] != i) t[e] = i;
        });
        return t;
    };
    t.prototype.enter = function(t) {
        var n = t instanceof this.constructor ? t : e(t.currentTarget).data("bs." + this.type);
        if (!n) {
            n = new this.constructor(t.currentTarget, this.getDelegateOptions());
            e(t.currentTarget).data("bs." + this.type, n);
        }
        if (t instanceof e.Event) {
            n.inState[t.type == "focusin" ? "focus" : "hover"] = true;
        }
        if (n.tip().hasClass("in") || n.hoverState == "in") {
            n.hoverState = "in";
            return;
        }
        clearTimeout(n.timeout);
        n.hoverState = "in";
        if (!n.options.delay || !n.options.delay.show) return n.show();
        n.timeout = setTimeout(function() {
            if (n.hoverState == "in") n.show();
        }, n.options.delay.show);
    };
    t.prototype.isInStateTrue = function() {
        for (var e in this.inState) {
            if (this.inState[e]) return true;
        }
        return false;
    };
    t.prototype.leave = function(t) {
        var n = t instanceof this.constructor ? t : e(t.currentTarget).data("bs." + this.type);
        if (!n) {
            n = new this.constructor(t.currentTarget, this.getDelegateOptions());
            e(t.currentTarget).data("bs." + this.type, n);
        }
        if (t instanceof e.Event) {
            n.inState[t.type == "focusout" ? "focus" : "hover"] = false;
        }
        if (n.isInStateTrue()) return;
        clearTimeout(n.timeout);
        n.hoverState = "out";
        if (!n.options.delay || !n.options.delay.hide) return n.hide();
        n.timeout = setTimeout(function() {
            if (n.hoverState == "out") n.hide();
        }, n.options.delay.hide);
    };
    t.prototype.show = function() {
        var n = e.Event("show.bs." + this.type);
        if (this.hasContent() && this.enabled) {
            this.$element.trigger(n);
            var i = e.contains(this.$element[0].ownerDocument.documentElement, this.$element[0]);
            if (n.isDefaultPrevented() || !i) return;
            var r = this;
            var o = this.tip();
            var a = this.getUID(this.type);
            this.setContent();
            o.attr("id", a);
            this.$element.attr("aria-describedby", a);
            if (this.options.animation) o.addClass("fade");
            var s = typeof this.options.placement == "function" ? this.options.placement.call(this, o[0], this.$element[0]) : this.options.placement;
            var l = /\s?auto?\s?/i;
            var f = l.test(s);
            if (f) s = s.replace(l, "") || "top";
            o.detach().css({
                top: 0,
                left: 0,
                display: "block"
            }).addClass(s).data("bs." + this.type, this);
            this.options.container ? o.appendTo(this.options.container) : o.insertAfter(this.$element);
            this.$element.trigger("inserted.bs." + this.type);
            var u = this.getPosition();
            var c = o[0].offsetWidth;
            var d = o[0].offsetHeight;
            if (f) {
                var p = s;
                var h = this.getPosition(this.$viewport);
                s = s == "bottom" && u.bottom + d > h.bottom ? "top" : s == "top" && u.top - d < h.top ? "bottom" : s == "right" && u.right + c > h.width ? "left" : s == "left" && u.left - c < h.left ? "right" : s;
                o.removeClass(p).addClass(s);
            }
            var g = this.getCalculatedOffset(s, u, c, d);
            this.applyPlacement(g, s);
            var v = function() {
                var e = r.hoverState;
                r.$element.trigger("shown.bs." + r.type);
                r.hoverState = null;
                if (e == "out") r.leave(r);
            };
            e.support.transition && this.$tip.hasClass("fade") ? o.one("bsTransitionEnd", v).emulateTransitionEnd(t.TRANSITION_DURATION) : v();
        }
    };
    t.prototype.applyPlacement = function(t, n) {
        var i = this.tip();
        var r = i[0].offsetWidth;
        var o = i[0].offsetHeight;
        var a = parseInt(i.css("margin-top"), 10);
        var s = parseInt(i.css("margin-left"), 10);
        if (isNaN(a)) a = 0;
        if (isNaN(s)) s = 0;
        t.top += a;
        t.left += s;
        e.offset.setOffset(i[0], e.extend({
            using: function(e) {
                i.css({
                    top: Math.round(e.top),
                    left: Math.round(e.left)
                });
            }
        }, t), 0);
        i.addClass("in");
        var l = i[0].offsetWidth;
        var f = i[0].offsetHeight;
        if (n == "top" && f != o) {
            t.top = t.top + o - f;
        }
        var u = this.getViewportAdjustedDelta(n, t, l, f);
        if (u.left) t.left += u.left; else t.top += u.top;
        var c = /top|bottom/.test(n);
        var d = c ? u.left * 2 - r + l : u.top * 2 - o + f;
        var p = c ? "offsetWidth" : "offsetHeight";
        i.offset(t);
        this.replaceArrow(d, i[0][p], c);
    };
    t.prototype.replaceArrow = function(e, t, n) {
        this.arrow().css(n ? "left" : "top", 50 * (1 - e / t) + "%").css(n ? "top" : "left", "");
    };
    t.prototype.setContent = function() {
        var e = this.tip();
        var t = this.getTitle();
        e.find(".tooltip-inner")[this.options.html ? "html" : "text"](t);
        e.removeClass("fade in top bottom left right");
    };
    t.prototype.hide = function(n) {
        var i = this;
        var r = e(this.$tip);
        var o = e.Event("hide.bs." + this.type);
        function a() {
            if (i.hoverState != "in") r.detach();
            if (i.$element) {
                i.$element.removeAttr("aria-describedby").trigger("hidden.bs." + i.type);
            }
            n && n();
        }
        this.$element.trigger(o);
        if (o.isDefaultPrevented()) return;
        r.removeClass("in");
        e.support.transition && r.hasClass("fade") ? r.one("bsTransitionEnd", a).emulateTransitionEnd(t.TRANSITION_DURATION) : a();
        this.hoverState = null;
        return this;
    };
    t.prototype.fixTitle = function() {
        var e = this.$element;
        if (e.attr("title") || typeof e.attr("data-original-title") != "string") {
            e.attr("data-original-title", e.attr("title") || "").attr("title", "");
        }
    };
    t.prototype.hasContent = function() {
        return this.getTitle();
    };
    t.prototype.getPosition = function(t) {
        t = t || this.$element;
        var n = t[0];
        var i = n.tagName == "BODY";
        var r = n.getBoundingClientRect();
        if (r.width == null) {
            r = e.extend({}, r, {
                width: r.right - r.left,
                height: r.bottom - r.top
            });
        }
        var o = window.SVGElement && n instanceof window.SVGElement;
        var a = i ? {
            top: 0,
            left: 0
        } : o ? null : t.offset();
        var s = {
            scroll: i ? document.documentElement.scrollTop || document.body.scrollTop : t.scrollTop()
        };
        var l = i ? {
            width: e(window).width(),
            height: e(window).height()
        } : null;
        return e.extend({}, r, s, l, a);
    };
    t.prototype.getCalculatedOffset = function(e, t, n, i) {
        return e == "bottom" ? {
            top: t.top + t.height,
            left: t.left + t.width / 2 - n / 2
        } : e == "top" ? {
            top: t.top - i,
            left: t.left + t.width / 2 - n / 2
        } : e == "left" ? {
            top: t.top + t.height / 2 - i / 2,
            left: t.left - n
        } : {
            top: t.top + t.height / 2 - i / 2,
            left: t.left + t.width
        };
    };
    t.prototype.getViewportAdjustedDelta = function(e, t, n, i) {
        var r = {
            top: 0,
            left: 0
        };
        if (!this.$viewport) return r;
        var o = this.options.viewport && this.options.viewport.padding || 0;
        var a = this.getPosition(this.$viewport);
        if (/right|left/.test(e)) {
            var s = t.top - o - a.scroll;
            var l = t.top + o - a.scroll + i;
            if (s < a.top) {
                r.top = a.top - s;
            } else if (l > a.top + a.height) {
                r.top = a.top + a.height - l;
            }
        } else {
            var f = t.left - o;
            var u = t.left + o + n;
            if (f < a.left) {
                r.left = a.left - f;
            } else if (u > a.right) {
                r.left = a.left + a.width - u;
            }
        }
        return r;
    };
    t.prototype.getTitle = function() {
        var e;
        var t = this.$element;
        var n = this.options;
        e = t.attr("data-original-title") || (typeof n.title == "function" ? n.title.call(t[0]) : n.title);
        return e;
    };
    t.prototype.getUID = function(e) {
        do e += ~~(Math.random() * 1e6); while (document.getElementById(e));
        return e;
    };
    t.prototype.tip = function() {
        if (!this.$tip) {
            this.$tip = e(this.options.template);
            if (this.$tip.length != 1) {
                throw new Error(this.type + " `template` option must consist of exactly 1 top-level element!");
            }
        }
        return this.$tip;
    };
    t.prototype.arrow = function() {
        return this.$arrow = this.$arrow || this.tip().find(".tooltip-arrow");
    };
    t.prototype.enable = function() {
        this.enabled = true;
    };
    t.prototype.disable = function() {
        this.enabled = false;
    };
    t.prototype.toggleEnabled = function() {
        this.enabled = !this.enabled;
    };
    t.prototype.toggle = function(t) {
        var n = this;
        if (t) {
            n = e(t.currentTarget).data("bs." + this.type);
            if (!n) {
                n = new this.constructor(t.currentTarget, this.getDelegateOptions());
                e(t.currentTarget).data("bs." + this.type, n);
            }
        }
        if (t) {
            n.inState.click = !n.inState.click;
            if (n.isInStateTrue()) n.enter(n); else n.leave(n);
        } else {
            n.tip().hasClass("in") ? n.leave(n) : n.enter(n);
        }
    };
    t.prototype.destroy = function() {
        var e = this;
        clearTimeout(this.timeout);
        this.hide(function() {
            e.$element.off("." + e.type).removeData("bs." + e.type);
            if (e.$tip) {
                e.$tip.detach();
            }
            e.$tip = null;
            e.$arrow = null;
            e.$viewport = null;
            e.$element = null;
        });
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.tooltip");
            var o = typeof n == "object" && n;
            if (!r && /destroy|hide/.test(n)) return;
            if (!r) i.data("bs.tooltip", r = new t(this, o));
            if (typeof n == "string") r[n]();
        });
    }
    var i = e.fn.tooltip;
    e.fn.tooltip = n;
    e.fn.tooltip.Constructor = t;
    e.fn.tooltip.noConflict = function() {
        e.fn.tooltip = i;
        return this;
    };
}(jQuery);

+function(e) {
    "use strict";
    var t = function(e, t) {
        this.init("popover", e, t);
    };
    if (!e.fn.tooltip) throw new Error("Popover requires tooltip.js");
    t.VERSION = "3.3.7";
    t.DEFAULTS = e.extend({}, e.fn.tooltip.Constructor.DEFAULTS, {
        placement: "right",
        trigger: "click",
        content: "",
        template: '<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'
    });
    t.prototype = e.extend({}, e.fn.tooltip.Constructor.prototype);
    t.prototype.constructor = t;
    t.prototype.getDefaults = function() {
        return t.DEFAULTS;
    };
    t.prototype.setContent = function() {
        var e = this.tip();
        var t = this.getTitle();
        var n = this.getContent();
        e.find(".popover-title")[this.options.html ? "html" : "text"](t);
        e.find(".popover-content").children().detach().end()[this.options.html ? typeof n == "string" ? "html" : "append" : "text"](n);
        e.removeClass("fade top bottom left right in");
        if (!e.find(".popover-title").html()) e.find(".popover-title").hide();
    };
    t.prototype.hasContent = function() {
        return this.getTitle() || this.getContent();
    };
    t.prototype.getContent = function() {
        var e = this.$element;
        var t = this.options;
        return e.attr("data-content") || (typeof t.content == "function" ? t.content.call(e[0]) : t.content);
    };
    t.prototype.arrow = function() {
        return this.$arrow = this.$arrow || this.tip().find(".arrow");
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.popover");
            var o = typeof n == "object" && n;
            if (!r && /destroy|hide/.test(n)) return;
            if (!r) i.data("bs.popover", r = new t(this, o));
            if (typeof n == "string") r[n]();
        });
    }
    var i = e.fn.popover;
    e.fn.popover = n;
    e.fn.popover.Constructor = t;
    e.fn.popover.noConflict = function() {
        e.fn.popover = i;
        return this;
    };
}(jQuery);

+function(e) {
    "use strict";
    function t(n, i) {
        this.$body = e(document.body);
        this.$scrollElement = e(n).is(document.body) ? e(window) : e(n);
        this.options = e.extend({}, t.DEFAULTS, i);
        this.selector = (this.options.target || "") + " .nav li > a";
        this.offsets = [];
        this.targets = [];
        this.activeTarget = null;
        this.scrollHeight = 0;
        this.$scrollElement.on("scroll.bs.scrollspy", e.proxy(this.process, this));
        this.refresh();
        this.process();
    }
    t.VERSION = "3.3.7";
    t.DEFAULTS = {
        offset: 10
    };
    t.prototype.getScrollHeight = function() {
        return this.$scrollElement[0].scrollHeight || Math.max(this.$body[0].scrollHeight, document.documentElement.scrollHeight);
    };
    t.prototype.refresh = function() {
        var t = this;
        var n = "offset";
        var i = 0;
        this.offsets = [];
        this.targets = [];
        this.scrollHeight = this.getScrollHeight();
        if (!e.isWindow(this.$scrollElement[0])) {
            n = "position";
            i = this.$scrollElement.scrollTop();
        }
        this.$body.find(this.selector).map(function() {
            var t = e(this);
            var r = t.data("target") || t.attr("href");
            var o = /^#./.test(r) && e(r);
            return o && o.length && o.is(":visible") && [ [ o[n]().top + i, r ] ] || null;
        }).sort(function(e, t) {
            return e[0] - t[0];
        }).each(function() {
            t.offsets.push(this[0]);
            t.targets.push(this[1]);
        });
    };
    t.prototype.process = function() {
        var e = this.$scrollElement.scrollTop() + this.options.offset;
        var t = this.getScrollHeight();
        var n = this.options.offset + t - this.$scrollElement.height();
        var i = this.offsets;
        var r = this.targets;
        var o = this.activeTarget;
        var a;
        if (this.scrollHeight != t) {
            this.refresh();
        }
        if (e >= n) {
            return o != (a = r[r.length - 1]) && this.activate(a);
        }
        if (o && e < i[0]) {
            this.activeTarget = null;
            return this.clear();
        }
        for (a = i.length; a--; ) {
            o != r[a] && e >= i[a] && (i[a + 1] === undefined || e < i[a + 1]) && this.activate(r[a]);
        }
    };
    t.prototype.activate = function(t) {
        this.activeTarget = t;
        this.clear();
        var n = this.selector + '[data-target="' + t + '"],' + this.selector + '[href="' + t + '"]';
        var i = e(n).parents("li").addClass("active");
        if (i.parent(".dropdown-menu").length) {
            i = i.closest("li.dropdown").addClass("active");
        }
        i.trigger("activate.bs.scrollspy");
    };
    t.prototype.clear = function() {
        e(this.selector).parentsUntil(this.options.target, ".active").removeClass("active");
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.scrollspy");
            var o = typeof n == "object" && n;
            if (!r) i.data("bs.scrollspy", r = new t(this, o));
            if (typeof n == "string") r[n]();
        });
    }
    var i = e.fn.scrollspy;
    e.fn.scrollspy = n;
    e.fn.scrollspy.Constructor = t;
    e.fn.scrollspy.noConflict = function() {
        e.fn.scrollspy = i;
        return this;
    };
    e(window).on("load.bs.scrollspy.data-api", function() {
        e('[data-spy="scroll"]').each(function() {
            var t = e(this);
            n.call(t, t.data());
        });
    });
}(jQuery);

+function(e) {
    "use strict";
    var t = function(t) {
        this.element = e(t);
    };
    t.VERSION = "3.3.7";
    t.TRANSITION_DURATION = 150;
    t.prototype.show = function() {
        var t = this.element;
        var n = t.closest("ul:not(.dropdown-menu)");
        var i = t.data("target");
        if (!i) {
            i = t.attr("href");
            i = i && i.replace(/.*(?=#[^\s]*$)/, "");
        }
        if (t.parent("li").hasClass("active")) return;
        var r = n.find(".active:last a");
        var o = e.Event("hide.bs.tab", {
            relatedTarget: t[0]
        });
        var a = e.Event("show.bs.tab", {
            relatedTarget: r[0]
        });
        r.trigger(o);
        t.trigger(a);
        if (a.isDefaultPrevented() || o.isDefaultPrevented()) return;
        var s = e(i);
        this.activate(t.closest("li"), n);
        this.activate(s, s.parent(), function() {
            r.trigger({
                type: "hidden.bs.tab",
                relatedTarget: t[0]
            });
            t.trigger({
                type: "shown.bs.tab",
                relatedTarget: r[0]
            });
        });
    };
    t.prototype.activate = function(n, i, r) {
        var o = i.find("> .active");
        var a = r && e.support.transition && (o.length && o.hasClass("fade") || !!i.find("> .fade").length);
        function s() {
            o.removeClass("active").find("> .dropdown-menu > .active").removeClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded", false);
            n.addClass("active").find('[data-toggle="tab"]').attr("aria-expanded", true);
            if (a) {
                n[0].offsetWidth;
                n.addClass("in");
            } else {
                n.removeClass("fade");
            }
            if (n.parent(".dropdown-menu").length) {
                n.closest("li.dropdown").addClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded", true);
            }
            r && r();
        }
        o.length && a ? o.one("bsTransitionEnd", s).emulateTransitionEnd(t.TRANSITION_DURATION) : s();
        o.removeClass("in");
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.tab");
            if (!r) i.data("bs.tab", r = new t(this));
            if (typeof n == "string") r[n]();
        });
    }
    var i = e.fn.tab;
    e.fn.tab = n;
    e.fn.tab.Constructor = t;
    e.fn.tab.noConflict = function() {
        e.fn.tab = i;
        return this;
    };
    var r = function(t) {
        t.preventDefault();
        n.call(e(this), "show");
    };
    e(document).on("click.bs.tab.data-api", '[data-toggle="tab"]', r).on("click.bs.tab.data-api", '[data-toggle="pill"]', r);
}(jQuery);

+function(e) {
    "use strict";
    var t = function(n, i) {
        this.options = e.extend({}, t.DEFAULTS, i);
        this.$target = e(this.options.target).on("scroll.bs.affix.data-api", e.proxy(this.checkPosition, this)).on("click.bs.affix.data-api", e.proxy(this.checkPositionWithEventLoop, this));
        this.$element = e(n);
        this.affixed = null;
        this.unpin = null;
        this.pinnedOffset = null;
        this.checkPosition();
    };
    t.VERSION = "3.3.7";
    t.RESET = "affix affix-top affix-bottom";
    t.DEFAULTS = {
        offset: 0,
        target: window
    };
    t.prototype.getState = function(e, t, n, i) {
        var r = this.$target.scrollTop();
        var o = this.$element.offset();
        var a = this.$target.height();
        if (n != null && this.affixed == "top") return r < n ? "top" : false;
        if (this.affixed == "bottom") {
            if (n != null) return r + this.unpin <= o.top ? false : "bottom";
            return r + a <= e - i ? false : "bottom";
        }
        var s = this.affixed == null;
        var l = s ? r : o.top;
        var f = s ? a : t;
        if (n != null && r <= n) return "top";
        if (i != null && l + f >= e - i) return "bottom";
        return false;
    };
    t.prototype.getPinnedOffset = function() {
        if (this.pinnedOffset) return this.pinnedOffset;
        this.$element.removeClass(t.RESET).addClass("affix");
        var e = this.$target.scrollTop();
        var n = this.$element.offset();
        return this.pinnedOffset = n.top - e;
    };
    t.prototype.checkPositionWithEventLoop = function() {
        setTimeout(e.proxy(this.checkPosition, this), 1);
    };
    t.prototype.checkPosition = function() {
        if (!this.$element.is(":visible")) return;
        var n = this.$element.height();
        var i = this.options.offset;
        var r = i.top;
        var o = i.bottom;
        var a = Math.max(e(document).height(), e(document.body).height());
        if (typeof i != "object") o = r = i;
        if (typeof r == "function") r = i.top(this.$element);
        if (typeof o == "function") o = i.bottom(this.$element);
        var s = this.getState(a, n, r, o);
        if (this.affixed != s) {
            if (this.unpin != null) this.$element.css("top", "");
            var l = "affix" + (s ? "-" + s : "");
            var f = e.Event(l + ".bs.affix");
            this.$element.trigger(f);
            if (f.isDefaultPrevented()) return;
            this.affixed = s;
            this.unpin = s == "bottom" ? this.getPinnedOffset() : null;
            this.$element.removeClass(t.RESET).addClass(l).trigger(l.replace("affix", "affixed") + ".bs.affix");
        }
        if (s == "bottom") {
            this.$element.offset({
                top: a - n - o
            });
        }
    };
    function n(n) {
        return this.each(function() {
            var i = e(this);
            var r = i.data("bs.affix");
            var o = typeof n == "object" && n;
            if (!r) i.data("bs.affix", r = new t(this, o));
            if (typeof n == "string") r[n]();
        });
    }
    var i = e.fn.affix;
    e.fn.affix = n;
    e.fn.affix.Constructor = t;
    e.fn.affix.noConflict = function() {
        e.fn.affix = i;
        return this;
    };
    e(window).on("load", function() {
        e('[data-spy="affix"]').each(function() {
            var t = e(this);
            var i = t.data();
            i.offset = i.offset || {};
            if (i.offsetBottom != null) i.offset.bottom = i.offsetBottom;
            if (i.offsetTop != null) i.offset.top = i.offsetTop;
            n.call(t, i);
        });
    });
}(jQuery);

(function(e) {
    "use strict";
    var t = {
        version: "3.35.1"
    };
    t.pfBreakpoints = {
        tablet: 768,
        desktop: 1200
    };
    e.patternfly = t;
})(window);

(function(e) {
    "use strict";
    patternfly.pfPaletteColors = {
        black: "#030303",
        black100: "#fafafa",
        black200: "#ededed",
        black300: "#d1d1d1",
        black400: "#bbbbbb",
        black500: "#8b8d8f",
        black600: "#72767b",
        black700: "#4d5258",
        black800: "#393f44",
        black900: "#292e34",
        blue: "#0088ce",
        blue100: "#bee1f4",
        blue200: "#7dc3e8",
        blue300: "#39a5dc",
        blue400: "#0088ce",
        blue500: "#00659c",
        blue600: "#004368",
        blue700: "#002235",
        gold: "#f0ab00",
        gold100: "#fbeabc",
        gold200: "#f9d67a",
        gold300: "#f5c12e",
        gold400: "#f0ab00",
        gold500: "#b58100",
        gold600: "#795600",
        gold700: "#3d2c00",
        orange: "#ec7a08",
        orange100: "#fbdebf",
        orange200: "#f7bd7f",
        orange300: "#f39d3c",
        orange400: "#ec7a08",
        orange500: "#b35c00",
        orange600: "#773d00",
        orange700: "#3b1f00",
        lightBlue: "#00b9e4",
        lightBlue100: "#beedf9",
        lightBlue200: "#7cdbf3",
        lightBlue300: "#35caed",
        lightBlue400: "#00b9e4",
        lightBlue500: "#008bad",
        lightBlue600: "#005c73",
        lightBlue700: "#002d39",
        green: "#3f9c35",
        green100: "#cfe7cd",
        green200: "#9ecf99",
        green300: "#6ec664",
        green400: "#3f9c35",
        green500: "#2d7623",
        green600: "#1e4f18",
        green700: "#0f280d",
        lightGreen: "#92d400",
        lightGreen100: "#e4f5bc",
        lightGreen200: "#c8eb79",
        lightGreen300: "#ace12e",
        lightGreen400: "#92d400",
        lightGreen500: "#6ca100",
        lightGreen600: "#486b00",
        lightGreen700: "#253600",
        cyan: "#007a87",
        cyan100: "#bedee1",
        cyan200: "#7dbdc3",
        cyan300: "#3a9ca6",
        cyan400: "#007a87",
        cyan500: "#005c66",
        cyan600: "#003d44",
        cyan700: "#001f22",
        purple: "#703fec",
        purple100: "#c7bfff",
        purple200: "#a18fff",
        purple300: "#8461f7",
        purple400: "#703fec",
        purple500: "#582fc0",
        purple600: "#40199a",
        purple700: "#1f0066",
        red: "#cc0000",
        red100: "#cc0000",
        red200: "#a30000",
        red300: "#8b0000",
        red400: "#470000",
        red500: "#2c0000"
    };
})(window);

(function(e) {
    "use strict";
    patternfly.pfSetDonutChartTitle = function(t, n, i) {
        var r = e.d3.select(t).select("text.c3-chart-arcs-title");
        r.text("");
        r.insert("tspan").text(n).classed("donut-title-big-pf", true).attr("dy", 0).attr("x", 0);
        r.insert("tspan").text(i).classed("donut-title-small-pf", true).attr("dy", 20).attr("x", 0);
    };
    patternfly.pfDonutTooltipContents = function(e, t, n, i) {
        return '<table class="c3-tooltip">' + "  <tr>" + '    <td><span style="background-color:' + i(e[0].id) + '"></span>' + "<strong>" + e[0].value + "</strong> " + e[0].name + "</td>" + "    <td>" + Math.round(e[0].ratio * 1e3) / 10 + "%</td>" + "  </tr>" + "</table>";
    };
    patternfly.pfGetUtilizationDonutTooltipContentsFn = function(e) {
        return function(t) {
            return '<span class="donut-tooltip-pf" style="white-space: nowrap;">' + Math.round(t[0].ratio * 1e3) / 10 + "%" + " " + e + " " + t[0].name + "</span>";
        };
    };
    patternfly.pfGetBarChartTooltipContentsFn = function(e) {
        return function(t) {
            var n = e ? e[t[0].index] : t[0].index;
            return '<table class="c3-tooltip">' + "  <tr>" + "    <td><strong>" + n + ":</td>" + "    <td>" + t[0].value + "</td>" + "  </tr>" + "</table>";
        };
    };
    patternfly.pfSingleLineChartTooltipContentsFn = function(e) {
        return function(t) {
            var n = e ? e[t[0].index] : t[0].index;
            return '<table class="c3-tooltip">' + "  <tr>" + "    <td><strong>" + n + ":</td>" + "    <td>" + t[0].value + "</td>" + "  </tr>" + "</table>";
        };
    };
    patternfly.pfPieTooltipContents = function(e, t, n, i) {
        return patternfly.pfDonutTooltipContents(e, t, n, i);
    };
    patternfly.c3ChartDefaults = function() {
        var e = function() {
            return {
                pattern: [ patternfly.pfPaletteColors.blue, patternfly.pfPaletteColors.blue300, patternfly.pfPaletteColors.green, patternfly.pfPaletteColors.orange, patternfly.pfPaletteColors.red ]
            };
        }, t = function() {
            return {
                y: {
                    show: true
                }
            };
        }, n = function(e) {
            return {
                contents: patternfly.pfGetBarChartTooltipContentsFn(e)
            };
        }, i = function() {
            return {
                show: false
            };
        }, r = function(e) {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultBarGrid(),
                tooltip: this.getDefaultBarTooltip(e),
                legend: this.getDefaultBarLegend()
            };
        }, o = function() {
            return {
                y: {
                    show: true
                }
            };
        }, a = function() {
            return {
                show: true,
                position: "bottom"
            };
        }, s = function() {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultGroupedBarGrid(),
                legend: this.getDefaultGroupedBarLegend()
            };
        }, l = function() {
            return {
                y: {
                    show: true
                }
            };
        }, f = function() {
            return {
                show: true,
                position: "bottom"
            };
        }, u = function() {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultStackedBarGrid(),
                legend: this.getDefaultStackedBarLegend()
            };
        }, c = function(e) {
            return {
                title: e,
                label: {
                    show: false
                },
                width: 11
            };
        }, d = function() {
            return {
                height: 171
            };
        }, p = function() {
            return {
                pattern: [ patternfly.pfPaletteColors.blue, patternfly.pfPaletteColors.black300 ]
            };
        }, h = function() {
            return {
                show: false
            };
        }, g = function() {
            return {
                show: false
            };
        }, v = function(e) {
            return {
                donut: this.getDefaultDonut(e),
                size: this.getDefaultDonutSize(),
                legend: this.getDefaultDonutLegend(),
                color: this.getDefaultDonutColors(),
                tooltip: this.getDefaultDonutTooltip()
            };
        }, m = function() {
            return {
                expand: true,
                label: {
                    show: false
                }
            };
        }, y = function() {
            return {
                height: 171
            };
        }, b = function() {
            return {
                pattern: [ patternfly.pfPaletteColors.blue, patternfly.pfPaletteColors.black300 ]
            };
        }, w = function() {
            return {
                contents: patternfly.pfPieTooltipContents
            };
        }, x = function() {
            return {
                show: false
            };
        }, C = function() {
            return {
                pie: this.getDefaultPie(),
                size: this.getDefaultPieSize(),
                legend: this.getDefaultPieLegend(),
                color: this.getDefaultPieColors(),
                tooltip: this.getDefaultPieTooltip()
            };
        }, T = function() {
            return {
                zerobased: true
            };
        }, D = function() {
            return {
                height: 60
            };
        }, k = function() {
            return {
                x: {
                    show: false
                },
                y: {
                    show: false
                }
            };
        }, S = function() {
            return {
                show: false
            };
        }, E = function() {
            return {
                r: 1,
                focus: {
                    expand: {
                        r: 4
                    }
                }
            };
        }, $ = function() {
            return {
                contents: function(e) {
                    return '<span class="c3-tooltip-sparkline">' + e[0].value + " " + e[0].name + "</span>";
                }
            };
        }, A = function() {
            return {
                area: T(),
                size: D(),
                axis: k(),
                color: e(),
                legend: S(),
                point: E(),
                tooltip: $()
            };
        }, N = function() {
            return {
                x: {
                    show: true
                },
                y: {
                    show: true
                }
            };
        }, j = function() {
            return {
                x: {
                    show: false
                },
                y: {
                    show: true
                }
            };
        }, L = function() {
            return {
                show: true
            };
        }, I = function() {
            return {
                r: 3,
                focus: {
                    expand: {
                        r: 5
                    }
                }
            };
        }, P = function() {
            return {
                axis: N(),
                grid: j(),
                color: e(),
                legend: L(),
                point: I()
            };
        }, O = function() {
            return {
                contents: patternfly.pfGetBarChartTooltipContentsFn()
            };
        }, H = function() {
            return {
                show: false
            };
        }, R = function() {
            return {
                axis: N(),
                grid: j(),
                color: e(),
                legend: H(),
                point: I(),
                tooltip: O()
            };
        }, q = function() {
            return N();
        }, B = function() {
            return j();
        }, M = function() {
            return L();
        }, _ = function() {
            return I();
        }, F = function() {
            return {
                axis: q(),
                grid: B(),
                color: e(),
                legend: M(),
                point: _()
            };
        }, U = function() {
            return {
                contents: patternfly.pfGetBarChartTooltipContentsFn()
            };
        }, W = function() {
            return H();
        }, z = function() {
            return {
                axis: q(),
                grid: B(),
                color: e(),
                legend: W(),
                point: _(),
                tooltip: U()
            };
        };
        return {
            getDefaultColors: e,
            getDefaultBarGrid: t,
            getDefaultBarTooltip: n,
            getDefaultBarLegend: i,
            getDefaultBarConfig: r,
            getDefaultGroupedBarGrid: o,
            getDefaultGroupedBarLegend: a,
            getDefaultGroupedBarConfig: s,
            getDefaultStackedBarGrid: l,
            getDefaultStackedBarLegend: f,
            getDefaultStackedBarConfig: u,
            getDefaultDonut: c,
            getDefaultDonutSize: d,
            getDefaultDonutColors: p,
            getDefaultDonutTooltip: h,
            getDefaultDonutLegend: g,
            getDefaultDonutConfig: v,
            getDefaultPie: m,
            getDefaultPieSize: y,
            getDefaultPieColors: b,
            getDefaultPieTooltip: w,
            getDefaultPieLegend: x,
            getDefaultPieConfig: C,
            getDefaultSparklineArea: T,
            getDefaultSparklineSize: D,
            getDefaultSparklineAxis: k,
            getDefaultSparklineLegend: S,
            getDefaultSparklinePoint: E,
            getDefaultSparklineTooltip: $,
            getDefaultSparklineConfig: A,
            getDefaultLineAxis: N,
            getDefaultLineGrid: j,
            getDefaultLineLegend: L,
            getDefaultLinePoint: I,
            getDefaultLineConfig: P,
            getDefaultSingleLineTooltip: O,
            getDefaultSingleLineConfig: R,
            getDefaultAreaAxis: q,
            getDefaultAreaGrid: B,
            getDefaultAreaLegend: M,
            getDefaultAreaPoint: _,
            getDefaultAreaConfig: F,
            getDefaultSingleAreaTooltip: U,
            getDefaultSingleAreaConfig: z
        };
    };
})(window);

(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.pfBreakpoints = patternfly.pfBreakpoints;
    }
})(jQuery);

(function(e) {
    "use strict";
    e.fn.pfList = function() {
        function t(t) {
            t.find("[data-list=expansion], .list-pf-item, .list-pf-expansion").each(function(t, n) {
                var o = e(n), a = o.find(".collapse").first(), s = a.hasClass("in");
                r(o, s);
                if (o.hasClass("list-pf-item")) {
                    i(o, s);
                }
            });
            t.find(".list-pf-container").each(function(t, i) {
                var r = e(i);
                var o = r.find("[data-list=toggle]");
                o.length || (o = r);
                o.on("keydown", function(e) {
                    if (e.keyCode === 13 || e.keyCode === 32) {
                        n(this);
                        e.stopPropagation();
                        e.preventDefault();
                    }
                });
                o.on("click", function(e) {
                    n(this);
                    e.stopPropagation();
                    e.preventDefault();
                });
            });
        }
        function n(t) {
            var n, o, a, s, l;
            n = e(t);
            o = n.parentsUntil(".list-pf", "[data-list=expansion]").first();
            o.length || (o = n.closest(".list-pf-item, .list-pf-expansion"));
            a = o.find(".collapse").first();
            a.toggleClass("in");
            r(o, a.hasClass("in"));
            l = o.closest(".list-pf-item");
            i(l, l.find(".collapse").first().hasClass("in"));
        }
        function i(e, t) {
            if (t) {
                e.addClass("active");
            } else {
                e.removeClass("active");
            }
        }
        function r(e, t) {
            var n = e.find(".list-pf-chevron .fa").first();
            if (t) {
                n.removeClass("fa-angle-right");
                n.addClass("fa-angle-down");
            } else {
                n.addClass("fa-angle-right");
                n.removeClass("fa-angle-down");
            }
        }
        t(this);
        return this;
    };
})(jQuery);

(function(e) {
    "use strict";
    e.fn.sidebar = function() {
        var t = 0, n = 0, i = 0;
        if (e(".navbar-pf .navbar-toggle").is(":hidden")) {
            t = e(document).height();
            n = e(".navbar-pf").outerHeight();
            i = t - n;
        }
        e(".sidebar-pf").parent(".row").children('[class*="col-"]').css({
            "min-height": i
        });
    };
    e(document).ready(function() {
        if (e(".sidebar-pf").length > 0 && e(".datatable").length === 0) {
            e.fn.sidebar();
        }
    });
    e(window).resize(function() {
        if (e(".sidebar-pf").length > 0) {
            e.fn.sidebar();
        }
    });
})(jQuery);

(function(e) {
    "use strict";
    e.fn.popovers = function() {
        this.popover();
        this.filter("[data-close=true]").each(function(t, n) {
            var i = e(n), r = i.attr("data-original-title") + '<button type="button" class="close" aria-hidden="true"><span class="pficon pficon-close"></span></button>';
            i.attr("data-original-title", r);
        });
        this.on("click", function(t) {
            var n = e(this), i = n.next(".popover").find(".popover-title");
            i.find(".close").parent(".popover-title").addClass("closable");
            i.find(".close").on("click", function() {
                n.popover("hide");
            });
            t.preventDefault();
        });
        return this;
    };
})(jQuery);

(function(e) {
    "use strict";
    if (e.fn.dataTableExt) {
        e.extend(true, e.fn.dataTable.defaults, {
            bDestroy: true,
            bAutoWidth: false,
            iDisplayLength: 20,
            sDom: "<'dataTables_header' f i r >" + "<'table-responsive'  t >" + "<'dataTables_footer' p >",
            oLanguage: {
                sInfo: "Showing <b>_START_</b> to <b>_END_</b> of <b>_TOTAL_</b> Items",
                sInfoFiltered: "(of <b>_MAX_</b>)",
                sInfoEmpty: "Showing <b>0</b> Results",
                sZeroRecords: "<p>Suggestions</p>" + "<ul>" + "<li>Check the javascript regular expression syntax of the search term.</li>" + "<li>Check that the correct menu option is chosen (token ID vs. user ID).</li>" + "<li>Use wildcards (* to match 0 or more characters, + to match 1 or more characters, ? to match 0 or 1 character).</li>" + "<li>Clear the search field, then click Search to return to the 20 most recent records.</li>" + "</ul>",
                sSearch: ""
            },
            sPaginationType: "bootstrap_input",
            oSearch: {
                sSearch: "",
                bRegex: true,
                bSmart: false
            }
        });
        e.extend(e.fn.dataTableExt.oStdClasses, {
            sWrapper: "dataTables_wrapper"
        });
        e.fn.dataTableExt.oApi.fnPagingInfo = function(e) {
            return {
                iStart: e._iDisplayStart,
                iEnd: e.fnDisplayEnd(),
                iLength: e._iDisplayLength,
                iTotal: e.fnRecordsTotal(),
                iFilteredTotal: e.fnRecordsDisplay(),
                iPage: e._iDisplayLength === -1 ? 0 : Math.ceil(e._iDisplayStart / e._iDisplayLength),
                iTotalPages: e._iDisplayLength === -1 ? 0 : Math.ceil(e.fnRecordsDisplay() / e._iDisplayLength)
            };
        };
        e.extend(e.fn.dataTableExt.oPagination, {
            bootstrap_input: {
                fnInit: function(t, n, i) {
                    var r = function(e) {
                        e.preventDefault();
                        if (t.oApi._fnPageChange(t, e.data.action)) {
                            i(t);
                        }
                    }, o, a;
                    e(n).append('<ul class="pagination">' + '  <li class="first disabled"><span class="i fa fa-angle-double-left"></span></li>' + '  <li class="prev disabled"><span class="i fa fa-angle-left"></span></li>' + "</ul>" + '<div class="pagination-input">' + '  <input type="text" class="paginate_input">' + '  <span class="paginate_of">of <b>3</b></span>' + "</div>" + '<ul class="pagination">' + '  <li class="next disabled"><span class="i fa fa-angle-right"></span></li>' + '  <li class="last disabled"><span class="i fa fa-angle-double-right"></span></li>' + "</ul>");
                    o = e("li", n);
                    e(o[0]).bind("click.DT", {
                        action: "first"
                    }, r);
                    e(o[1]).bind("click.DT", {
                        action: "previous"
                    }, r);
                    e(o[2]).bind("click.DT", {
                        action: "next"
                    }, r);
                    e(o[3]).bind("click.DT", {
                        action: "last"
                    }, r);
                    a = e("input", n);
                    e(a).keyup(function(e) {
                        var n;
                        if (e.which === 38 || e.which === 39) {
                            this.value += 1;
                        } else if ((e.which === 37 || e.which === 40) && this.value > 1) {
                            this.value -= 1;
                        }
                        if (this.value === "" || !this.value.match(/[0-9]/)) {
                            return;
                        }
                        n = t._iDisplayLength * (this.value - 1);
                        if (n >= t.fnRecordsDisplay()) {
                            t._iDisplayStart = (Math.ceil((t.fnRecordsDisplay() - 1) / t._iDisplayLength) - 1) * t._iDisplayLength;
                            i(t);
                            return;
                        }
                        t._iDisplayStart = n;
                        i(t);
                    });
                },
                fnUpdate: function(t, n) {
                    var i = t.oInstance.fnPagingInfo(), r = t.aanFeatures.p, o = r.length, a = Math.ceil(t.fnRecordsDisplay() / t._iDisplayLength), s = Math.ceil(t._iDisplayStart / t._iDisplayLength) + 1, l;
                    for (l = 0; l < o; l += 1) {
                        e(".paginate_input", r[l]).val(s).siblings(".paginate_of").find("b").html(a);
                        if (i.iPage === 0) {
                            e("li.first", r[l]).addClass("disabled");
                            e("li.prev", r[l]).addClass("disabled");
                        } else {
                            e("li.first", r[l]).removeClass("disabled");
                            e("li.prev", r[l]).removeClass("disabled");
                        }
                        if (i.iPage === i.iTotalPages - 1 || i.iTotalPages === 0) {
                            e("li.next", r[l]).addClass("disabled");
                            e("li.last", r[l]).addClass("disabled");
                        } else {
                            e("li.next", r[l]).removeClass("disabled");
                            e("li.last", r[l]).removeClass("disabled");
                        }
                    }
                }
            }
        });
    }
})(jQuery);

(function(e) {
    "use strict";
    e.fn.navigation = function() {
        var t = e(".layout-pf-alt-fixed .nav-pf-vertical-alt"), n = e(".container-pf-alt-nav-pf-vertical-alt"), i = e(".navbar-toggle"), r = false, o = function() {
            var i = e(window).width();
            t.removeClass("hidden show-mobile-nav collapsed");
            n.removeClass("collapsed-nav hidden-nav");
            if (i < e.pfBreakpoints.desktop || r) {
                t.addClass("collapsed");
                n.addClass("collapsed-nav");
            }
            if (i < e.pfBreakpoints.tablet) {
                t.addClass("hidden");
                t.removeClass("collapsed");
                n.removeClass("collapsed-nav");
                n.addClass("hidden-nav");
            }
        }, a = function() {
            t.addClass("collapsed");
            n.addClass("collapsed-nav");
            r = true;
        }, s = function() {
            e("html").addClass("transitions");
        }, l = function() {
            t.removeClass("collapsed");
            n.removeClass("collapsed-nav");
            r = false;
        }, f = function() {
            i.on("click", function(e) {
                var i = n.hasClass("hidden-nav");
                s();
                if (i && t.hasClass("show-mobile-nav")) {
                    t.removeClass("show-mobile-nav");
                } else if (i) {
                    t.addClass("show-mobile-nav");
                } else if (t.hasClass("collapsed")) {
                    l();
                } else {
                    a();
                }
            });
        }, u = function() {
            e('.nav-pf-vertical-alt [data-toggle="tooltip"]').tooltip({
                container: "body",
                delay: {
                    show: "500",
                    hide: "200"
                }
            });
            e(".nav-pf-vertical-alt").on("show.bs.tooltip", function(t) {
                return e(this).hasClass("collapsed");
            });
        }, c = function() {
            o();
            f();
            u();
        };
        e(window).on("resize", function() {
            o();
            s();
        });
        c();
    };
    e(document).ready(function() {
        if (e(".nav-pf-vertical-alt").length > 0) {
            e.fn.navigation();
        }
    });
})(jQuery);

(function(e) {
    "use strict";
    e.fn.countRemainingChars = function(t) {
        var n = e.extend({
            charsMaxLimit: 100,
            charsWarnRemaining: 5,
            blockInputAtMaxLimit: false
        }, t), i = this, r = e("#" + n.countFld).text(n.charsMaxLimit), o = function(e) {
            var t = n.charsMaxLimit - e;
            r.text(t);
            r.toggleClass("chars-warn-remaining-pf", t <= n.charsWarnRemaining);
            if (t < 0) {
                i.trigger("overCharsMaxLimitEvent", i.attr("id"));
            } else {
                i.trigger("underCharsMaxLimitEvent", i.attr("id"));
            }
        };
        this.on("paste", function(e) {
            setTimeout(function() {
                var e = i.val().length, t;
                if (n.blockInputAtMaxLimit && e > n.charsMaxLimit) {
                    t = i.val();
                    t = t.substring(0, n.charsMaxLimit);
                    i.val(t);
                    e = i.val().length;
                }
                o(e);
            }, 100);
        });
        this.keyup(function(e) {
            o(i.val().length);
        });
        this.keydown(function(e) {
            var t = i.val().length;
            if (n.blockInputAtMaxLimit && t >= n.charsMaxLimit) {
                if (e.keyCode !== 8) {
                    e.preventDefault();
                }
            }
        });
        return this;
    };
})(jQuery);

(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.pfPaletteColors = patternfly.pfPaletteColors;
    }
})(jQuery);

(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.fn.pfSetDonutChartTitle = patternfly.pfSetDonutChartTitle;
        e.fn.pfDonutTooltipContents = patternfly.pfDonutTooltipContents;
        e.fn.pfGetUtilizationDonutTooltipContentsFn = patternfly.pfGetUtilizationDonutTooltipContentsFn;
        e.fn.pfGetBarChartTooltipContentsFn = patternfly.pfGetBarChartTooltipContentsFn;
        e.fn.pfSingleLineChartTooltipContentsFn = patternfly.pfSingleLineChartTooltipContentsFn;
        e.fn.pfPieTooltipContents = patternfly.pfPieTooltipContents;
        e.fn.c3ChartDefaults = patternfly.c3ChartDefaults;
    }
})(jQuery);

(function(e) {
    "use strict";
    e.fn.initCollapseHeights = function(t) {
        var n = this, i, r = t;
        i = function() {
            var t, i, o, a, s = "hidden";
            t = n.height();
            i = n.find(".collapse.in");
            if (i && i.length > 0) {
                i.removeClass("in");
            }
            o = 0;
            n.children().each(e.proxy(function(t, n) {
                var i = e(n);
                o += i.outerHeight(true);
            }, n)).end();
            a = t - o;
            if (a < 25) {
                a = 25;
                s = "auto";
            }
            if (i && i.length > 0) {
                i.addClass("in");
            }
            setTimeout(function() {
                n.find('[data-toggle="collapse"]').each(e.proxy(function(t, n) {
                    var i, o, s, l, f = 0;
                    i = e(n);
                    o = i.attr("data-target");
                    if (!o) {
                        o = i.attr("href");
                    }
                    s = e(o);
                    l = s;
                    if (r) {
                        l = s.find(r);
                        if (l.length === 1) {
                            f = 0;
                            s.children().each(e.proxy(function(t, n) {
                                var i = e(n);
                                if (n !== l[0]) {
                                    f += i.outerHeight(true);
                                }
                            }, s)).end();
                            a -= f;
                        } else {
                            l = s;
                        }
                    }
                    l.css({
                        "max-height": a - f + "px",
                        "overflow-y": "auto"
                    });
                }, n)).end();
                n.css({
                    "overflow-y": s
                });
            }, 100);
        };
        i();
        e(window).resize(i);
    };
})(jQuery);

(function(e) {
    "use strict";
    function t(t, n) {
        var i = n.attr("data-parent");
        if (typeof i === "string") {
            if (isNaN(i)) {
                i = t.closest(i);
            } else {
                i = e(t[parseInt(i, 10)]);
            }
            return i;
        }
        return undefined;
    }
    function n(e, t) {
        if (t) {
            t.find(".treegrid-node > span.expand-icon").toggleClass("fa-angle-right", t.hasClass("collapsed")).toggleClass("fa-angle-down", !t.hasClass("collapsed"));
            e.toggleClass("hidden", t.hasClass("collapsed"));
            if (t.hasClass("collapsed")) {
                e.addClass("collapsed");
            }
        }
    }
    function i(e) {
        e.find("tbody > tr").removeClass("odd");
        e.find("tbody > tr:not(.hidden):odd").addClass("odd");
    }
    e.fn.treegrid = function(r) {
        var o, a, s;
        a = this.find("tbody > tr");
        s = this;
        e.each(a, function() {
            var l, f;
            l = e(this);
            f = t(a, l);
            l.children(".treegrid-node").prepend('<span class="icon expand-icon fa"/>');
            l.children(".treegrid-node").on("click", function(o) {
                var f = l.find("span.expand-icon");
                if (r && typeof r.callback === "function") {
                    r.callback(o);
                }
                if (f.hasClass("fa-angle-right")) {
                    l.removeClass("collapsed");
                }
                if (f.hasClass("fa-angle-down")) {
                    l.addClass("collapsed");
                }
                e.each(a.slice(a.index(l) + 1), function() {
                    n(e(this), t(a, e(this)));
                });
                i(s);
            });
            if (f) {
                o = f.find(".treegrid-node > span.indent").length + 1;
                for (;o > 0; o -= 1) {
                    l.children(".treegrid-node").prepend('<span class="indent"/>');
                }
                n(l, f);
            }
        });
        i(s);
    };
})(jQuery);

(function(e) {
    "use strict";
    e.fn.setupVerticalNavigation = function(t, n) {
        var i = e(".nav-pf-vertical"), r = e(".container-pf-nav-pf-vertical"), o = e(".navbar-toggle"), a = true, s = false, l = false, f = 500, u = f + 200, c = function() {
            return r.hasClass("hidden-nav");
        }, d = function(t) {
            setTimeout(function() {
                e(window).trigger("resize");
            }, t);
        }, p = function() {
            if (c() || !l) {
                i.addClass("secondary-visible-pf");
                r.addClass("secondary-visible-pf");
            }
            if (!l) {
                d(100);
            }
        }, h = function() {
            i.removeClass("secondary-visible-pf");
            r.removeClass("secondary-visible-pf");
            if (i.find(".secondary-nav-item-pf.is-hover").length <= 1) {
                i.removeClass("hover-secondary-nav-pf");
            }
            i.find(".mobile-nav-item-pf").each(function(t, n) {
                e(n).removeClass("mobile-nav-item-pf");
            });
            i.find(".is-hover").each(function(t, n) {
                e(n).removeClass("is-hover");
            });
        }, g = function() {
            i.removeClass("tertiary-visible-pf");
            r.removeClass("tertiary-visible-pf");
            if (i.find(".tertiary-nav-item-pf.is-hover").length <= 1) {
                i.removeClass("hover-tertiary-nav-pf");
            }
            i.find(".mobile-nav-item-pf").each(function(t, n) {
                e(n).removeClass("mobile-nav-item-pf");
            });
            i.find(".is-hover").each(function(t, n) {
                e(n).removeClass("is-hover");
            });
        }, v = function(t) {
            e(".nav-pf-vertical .list-group-item.active").removeClass("active");
            t.addClass("active").parents(".list-group-item").addClass("active");
        }, m = function() {
            if (c()) {
                i.removeClass("show-mobile-nav");
                h();
                i.find(".mobile-nav-item-pf").each(function(t, n) {
                    e(n).removeClass("mobile-nav-item-pf");
                });
            } else {
                p();
            }
        }, y = function(t, n) {
            if (t) {
                n.addClass("collapsed");
                i.addClass("collapsed-secondary-nav-pf");
                r.addClass("collapsed-secondary-nav-pf");
            } else {
                if (n) {
                    n.removeClass("collapsed");
                } else {
                    i.find('[data-toggle="collapse-secondary-nav"]').each(function(t, n) {
                        var i = e(n);
                        i.removeClass("collapsed");
                    });
                }
                i.removeClass("collapsed-secondary-nav-pf");
                r.removeClass("collapsed-secondary-nav-pf");
            }
        }, b = function(t, n) {
            if (t) {
                n.addClass("collapsed");
                i.addClass("collapsed-tertiary-nav-pf");
                r.addClass("collapsed-tertiary-nav-pf");
                y(false);
            } else {
                if (n) {
                    n.removeClass("collapsed");
                } else {
                    i.find('[data-toggle="collapse-tertiary-nav"]').each(function(t, n) {
                        var i = e(n);
                        i.removeClass("collapsed");
                    });
                }
                i.removeClass("collapsed-tertiary-nav-pf");
                r.removeClass("collapsed-tertiary-nav-pf");
            }
        }, w = function(t, n) {
            e(document).find(".list-group-item.mobile-nav-item-pf").each(function(t, n) {
                e(n).removeClass("mobile-nav-item-pf");
            });
            e(document).find(".list-group-item.mobile-secondary-item-pf").each(function(t, n) {
                e(n).removeClass("mobile-secondary-item-pf");
            });
            if (t) {
                t.addClass("mobile-nav-item-pf");
                if (n) {
                    n.addClass("mobile-secondary-item-pf");
                    i.removeClass("show-mobile-secondary");
                    i.addClass("show-mobile-tertiary");
                } else {
                    i.addClass("show-mobile-secondary");
                    i.removeClass("show-mobile-tertiary");
                }
            } else {
                i.removeClass("show-mobile-secondary");
                i.removeClass("show-mobile-tertiary");
            }
        }, x = function() {
            if (!i.hasClass("hidden")) {
                i.addClass("hidden");
                i.removeClass("collapsed");
                r.removeClass("collapsed-nav");
                r.addClass("hidden-nav");
                y(false);
                b(false);
                s = false;
            }
        }, C = function() {
            i.removeClass("hidden show-mobile-nav");
            r.removeClass("hidden-nav");
        }, T = function() {
            var t = e(window).width(), n;
            if (!a) {
                return;
            }
            if (t < e.pfBreakpoints.tablet && !s) {
                x();
            } else if (i.hasClass("hidden")) {
                C();
            }
            if (t < e.pfBreakpoints.desktop) {
                if (!l) {
                    i.addClass("collapsed");
                    r.addClass("collapsed-nav");
                }
                if (t >= e.pfBreakpoints.tablet) {
                    h();
                }
                l = true;
            } else {
                n = l && i.find(".secondary-nav-item-pf.active").length > 0;
                l = false;
                if (n) {
                    p();
                }
            }
            if (s) {
                i.addClass("collapsed");
                r.addClass("collapsed-nav");
            } else {
                i.removeClass("collapsed");
                r.removeClass("collapsed-nav");
            }
        }, D = function() {
            i.addClass("collapsed");
            r.addClass("collapsed-nav");
            if (l) {
                h();
            }
            s = true;
        }, k = function() {
            e("html").addClass("transitions");
        }, S = function() {
            i.removeClass("collapsed");
            r.removeClass("collapsed-nav");
            s = false;
            if (!l) {
                d(100);
            }
        }, E = function() {
            o.on("click", function(t) {
                var r;
                k();
                if (c()) {
                    if (i.hasClass("show-mobile-nav")) {
                        i.removeClass("show-mobile-nav");
                    } else {
                        w();
                        i.addClass("show-mobile-nav");
                        if (!n) {
                            r = e(".drawer-pf");
                            if (r.length) {
                                e(".drawer-pf-trigger").removeClass("open");
                                r.addClass("hide");
                            }
                        }
                    }
                } else if (i.hasClass("collapsed")) {
                    window.localStorage.setItem("patternfly-navigation-primary", "expanded");
                    S();
                } else {
                    window.localStorage.setItem("patternfly-navigation-primary", "collapsed");
                    D();
                }
            });
        }, $ = function() {
            i.addClass("force-hide-secondary-nav-pf");
            setTimeout(function() {
                i.removeClass("force-hide-secondary-nav-pf");
            }, 500);
        }, A = function(t) {
            e(document).find(".nav-pf-vertical .list-group-item").each(function(n, r) {
                var o, a = e(r), s = a.closest('[class*="nav-pf-"]');
                if (s.hasClass("nav-pf-vertical")) {
                    o = function(n) {
                        var r = e(this), o, s, l;
                        if (!r.hasClass("secondary-nav-item-pf")) {
                            h();
                            if (c()) {
                                w();
                                i.removeClass("show-mobile-nav");
                            }
                            if (t) {
                                v(r);
                                n.stopImmediatePropagation();
                            }
                        } else if (c()) {
                            w(r);
                        } else if (t) {
                            l = o = a.find(".nav-pf-secondary-nav > .list-group > .list-group-item").eq(0);
                            if (o.hasClass("tertiary-nav-item-pf")) {
                                l = o.find(".nav-pf-tertiary-nav > .list-group > .list-group-item").eq(0);
                            }
                            v(l);
                            n.stopImmediatePropagation();
                        }
                    };
                } else if (s.hasClass("nav-pf-secondary-nav")) {
                    o = function(n) {
                        var r = e(this), o, s;
                        if (!r.hasClass("tertiary-nav-item-pf")) {
                            if (c()) {
                                w();
                                i.removeClass("show-mobile-nav");
                            }
                            m();
                            if (t) {
                                v(a);
                                h();
                                n.stopImmediatePropagation();
                            }
                        } else if (c()) {
                            s = a.parents(".list-group-item");
                            w(r, s);
                            n.stopImmediatePropagation();
                        } else if (t) {
                            o = a.find(".nav-pf-tertiary-nav > .list-group > .list-group-item").eq(0);
                            v(o);
                            n.stopImmediatePropagation();
                        }
                    };
                } else if (s.hasClass("nav-pf-tertiary-nav")) {
                    o = function(e) {
                        if (c()) {
                            w();
                            i.removeClass("show-mobile-nav");
                        }
                        m();
                        if (t) {
                            v(a);
                            g();
                            h();
                            e.stopImmediatePropagation();
                        }
                    };
                }
                a.on("click.pf.secondarynav.data-api", o);
            });
            e(document).find(".secondary-nav-item-pf").each(function(n, r) {
                var o = e(r);
                o.on("click.pf.secondarynav.data-api", '[data-toggle="collapse-secondary-nav"]', function(n) {
                    var r = e(this);
                    if (c()) {
                        w();
                        n.stopImmediatePropagation();
                    } else {
                        if (r.hasClass("collapsed")) {
                            window.localStorage.setItem("patternfly-navigation-secondary", "expanded");
                            window.localStorage.setItem("patternfly-navigation-tertiary", "expanded");
                            y(false, r);
                            $();
                        } else {
                            window.localStorage.setItem("patternfly-navigation-secondary", "collapsed");
                            y(true, r);
                        }
                    }
                    i.removeClass("hover-secondary-nav-pf");
                    if (t) {
                        n.stopImmediatePropagation();
                    }
                });
                o.find(".tertiary-nav-item-pf").each(function(n, r) {
                    var a = e(r);
                    a.on("click.pf.tertiarynav.data-api", '[data-toggle="collapse-tertiary-nav"]', function(n) {
                        var r = e(this);
                        if (c()) {
                            w(o);
                            n.stopImmediatePropagation();
                        } else {
                            if (r.hasClass("collapsed")) {
                                window.localStorage.setItem("patternfly-navigation-secondary", "expanded");
                                window.localStorage.setItem("patternfly-navigation-tertiary", "expanded");
                                b(false, r);
                                $();
                            } else {
                                window.localStorage.setItem("patternfly-navigation-tertiary", "collapsed");
                                b(true, r);
                            }
                        }
                        i.removeClass("hover-secondary-nav-pf");
                        i.removeClass("hover-tertiary-nav-pf");
                        if (t) {
                            n.stopImmediatePropagation();
                        }
                    });
                });
            });
            e(document).on("mouseenter.pf.tertiarynav.data-api", ".secondary-nav-item-pf", function(t) {
                var n = e(this);
                if (!c()) {
                    if (n[0].navUnHoverTimeout !== undefined) {
                        clearTimeout(n[0].navUnHoverTimeout);
                        n[0].navUnHoverTimeout = undefined;
                    } else if (n[0].navHoverTimeout === undefined) {
                        n[0].navHoverTimeout = setTimeout(function() {
                            i.addClass("hover-secondary-nav-pf");
                            n.addClass("is-hover");
                            n[0].navHoverTimeout = undefined;
                        }, f);
                    }
                }
            });
            e(document).on("mouseleave.pf.tertiarynav.data-api", ".secondary-nav-item-pf", function(t) {
                var n = e(this);
                if (n[0].navHoverTimeout !== undefined) {
                    clearTimeout(n[0].navHoverTimeout);
                    n[0].navHoverTimeout = undefined;
                } else if (n[0].navUnHoverTimeout === undefined && i.find(".secondary-nav-item-pf.is-hover").length > 0) {
                    n[0].navUnHoverTimeout = setTimeout(function() {
                        if (i.find(".secondary-nav-item-pf.is-hover").length <= 1) {
                            i.removeClass("hover-secondary-nav-pf");
                        }
                        n.removeClass("is-hover");
                        n[0].navUnHoverTimeout = undefined;
                    }, u);
                }
            });
            e(document).on("mouseover.pf.tertiarynav.data-api", ".tertiary-nav-item-pf", function(t) {
                var n = e(this);
                if (!c()) {
                    if (n[0].navUnHoverTimeout !== undefined) {
                        clearTimeout(n[0].navUnHoverTimeout);
                        n[0].navUnHoverTimeout = undefined;
                    } else if (n[0].navHoverTimeout === undefined) {
                        n[0].navHoverTimeout = setTimeout(function() {
                            i.addClass("hover-tertiary-nav-pf");
                            n.addClass("is-hover");
                            n[0].navHoverTimeout = undefined;
                        }, f);
                    }
                }
            });
            e(document).on("mouseout.pf.tertiarynav.data-api", ".tertiary-nav-item-pf", function(t) {
                var n = e(this);
                if (n[0].navHoverTimeout !== undefined) {
                    clearTimeout(n[0].navHoverTimeout);
                    n[0].navHoverTimeout = undefined;
                } else if (n[0].navUnHoverTimeout === undefined) {
                    n[0].navUnHoverTimeout = setTimeout(function() {
                        if (i.find(".tertiary-nav-item-pf.is-hover").length <= 1) {
                            i.removeClass("hover-tertiary-nav-pf");
                        }
                        n.removeClass("is-hover");
                        n[0].navUnHoverTimeout = undefined;
                    }, u);
                }
            });
        }, N = function() {
            if (c()) {
                return;
            }
            if (window.localStorage.getItem("patternfly-navigation-primary") === "collapsed") {
                D();
            }
            if (e(".nav-pf-vertical.nav-pf-vertical-collapsible-menus").length > 0) {
                if (window.localStorage.getItem("patternfly-navigation-secondary") === "collapsed") {
                    y(true, e(".secondary-nav-item-pf.active [data-toggle=collapse-secondary-nav]"));
                }
                if (window.localStorage.getItem("patternfly-navigation-tertiary") === "collapsed") {
                    b(true, e(".tertiary-nav-item-pf.active [data-toggle=collapse-tertiary-nav]"));
                }
            }
        }, j = function() {
            var t = {
                container: "body",
                placement: "bottom",
                delay: {
                    show: "500",
                    hide: "200"
                },
                template: '<div class="nav-pf-vertical-tooltip tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
            };
            e('.nav-pf-vertical [data-toggle="tooltip"]').tooltip(t);
            e(".nav-pf-vertical").on("show.bs.tooltip", function(t) {
                return e(this).hasClass("collapsed");
            });
        }, L = function(e) {
            i.addClass("hide-nav-pf");
            r.addClass("hide-nav-pf");
            T();
            E();
            A(e);
            j();
            N();
            i.removeClass("hide-nav-pf");
            r.removeClass("hide-nav-pf");
            d(250);
        }, I = {
            hideMenu: function() {
                a = false;
                x();
            },
            showMenu: function() {
                a = true;
                C();
            },
            isVisible: function() {
                return a;
            }
        };
        if (!e.fn.setupVerticalNavigation.self) {
            e.fn.setupVerticalNavigation.self = I;
            e(window).on("resize", function() {
                T();
                k();
            });
            L(t);
        }
        return e.fn.setupVerticalNavigation.self;
    };
})(jQuery);
//# sourceMappingURL=jquery.min.js.map