COLLATINUS 12
=============

L'interface utilisateur de la version 12 de Collatinus est 
la même que celle de Collatinus 11. Quelques options de 
menu ont été ajoutées, afin de pouvoir adapter le lemmatiseur
aux difféntes évolutions qu'a connues la latinité.

À mesure que l'Empire s'étendait en Europe, en Asie et en Afrique,
à mesure que le temps passait, le lexique s'est enrichi, et les mots
ont changé de sens. La phonétique se transformant, la notation écrite
a fini par se conformer à ces transformations. parmi les modifications
évidentes, on peut citer la diphtongue _ae_, qui est devenue _e_ ; un _p_
épenthétique s'est glissé entre _m_ et _n_ ; _mihi_ est souvent devenu
_michi_. Conscients de ces glissements, les auteurs et les copistes ont
quelquefois tenté de revenir à une graphie classique, pas toujours avec
bonheur.

Comme nous voulions que Collatinus puisse s'occuper de l'immense corpus
médiéval, et pour s'adapter à la diversité de ce corpus, il a fallu
rendre modulaires les données de Collatinus. Le programme est donc
installé avec ses données classiques, mais on peut télécharger des
modules, les installer, et décider quel module on veut utiliser pour
travailler. La génération des modules lexicaux n'est pas une tâche
très facile. À cette seule fin, J'ai écrit ECCE (Ecce Collatinistarum
Communitatis Editor), mais son usage nécessite de bien se documenter
auparavant. 

L'interface de Collatinus est intuitive, mais il est
conseillé de commencer par le [chapitre suivant](anatomie.html),
qui la présente avec des images annotées.

1. **[Fenêtre, éditeurs et boutons](anatomie.html)**
    Une présentation de ce qu'on voit lorsqu'on a lancé
    Collatinus.
1. **[Pour débuter](debuter.html)** Un guide pas à pas
   pour les premières utilisations.
1. **[Lemmatiser et analyser](lemmatiser.html)**
   Lemmatiser un texte latin, c'est à dire établir le
   lexique de tous les mots latins utilisés par le
   texte. On peut aussi obtenir l'*analyse
   morphologique* des formes, c'est à dire leurs cas,
   genre, nombre, degré, personne, etc.
1. **[Modules](modules.html)** On peut augmenter et modifier
	lexique, flexions, graphies et irréguliers à l'aide
	d'un des modules proposés en téléchargement.
1. **[Dictionnaires](dictionnaires.html)** On peut
    ouvrir jusqu'à deux dictionnaires, consultables
    en cliquant sur un mot du texte, ou en saisissant
    un ou plusieurs mots.
1. **[Scander](scander.html)** Afficher le mot/texte muni
   de toutes ses quantités. Toutes les solutions
   possibles sont données. On peut aussi accentuer
   les mots et/ou marquer la césure entre les syllabes.
1. **[Fléchir](flechir.html)** Afficher la déclinaison
   d'un mot, la conjugaison d'un verbe.
1. **[Tagger](tagger.html)** Utiliser un tagueur
   probabiliste pour obtenir la *meilleure* analyse
   de la phrase ou du texte.
1. **[Serveur](server.html)** Interroger Collatinus depuis 
   une autre application.
1. **[Utilisation avancée](avancee.html)** Si on a 
    pris le soin de faire des sauvegardes, on peut
    essayer de modifier les lexiques, ajouter des mots,
    modifier des traductions ou des modèles.
1. **[Pour les programmeurs](programmeurs.html)** Le code
    source de l'application est disponible, et peut
    être adapté pour analyser une autre langue flexionnelle.
1. **[Remerciements, licence](licence.html)**.

Conformément à la licence de Collatinus, ses
développeurs mettent régulièrement à jour son code
source, présent sur ce [dépôt Github](https://github.com/biblissima/collatinus)

