/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <device/pci_ops.h>
#include <southbridge/intel/lynxpoint/hsio/hsio.h>
#include <southbridge/intel/lynxpoint/pch.h>
#include <types.h>

const struct hsio_table_row hsio_sata_shared_lpt_h_cx[] = {
	{ 0xea002008, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002208, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002038, ~0x3f00000f, 0x0700000d },
	{ 0xea002238, ~0x3f00000f, 0x0700000d },
	{ 0xea00202c, ~0x00020f00, 0x00020100 },
	{ 0xea00222c, ~0x00020f00, 0x00020100 },
	{ 0xea002040, ~0x1f000000, 0x01000000 },
	{ 0xea002240, ~0x1f000000, 0x01000000 },
	{ 0xea002010, ~0xffff0000, 0x0d510000 },
	{ 0xea002210, ~0xffff0000, 0x0d510000 },
	{ 0xea002018, ~0xffff0300, 0x38250100 },
	{ 0xea002218, ~0xffff0300, 0x38250100 },
	{ 0xea002000, ~0xcf030000, 0xcf030000 },
	{ 0xea002200, ~0xcf030000, 0xcf030000 },
	{ 0xea002028, ~0xff1f0000, 0x580e0000 },
	{ 0xea002228, ~0xff1f0000, 0x580e0000 },
	{ 0xea00201c, ~0x00007c00, 0x00002400 },
	{ 0xea00221c, ~0x00007c00, 0x00002400 },
	{ 0xea00208c, ~0x00ff0000, 0x00800000 },
	{ 0xea00228c, ~0x00ff0000, 0x00800000 },
	{ 0xea0020a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0022a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0020ac, ~0x00000030, 0x00000020 },
	{ 0xea0022ac, ~0x00000030, 0x00000020 },
	{ 0xea002140, ~0x00ffffff, 0x00140718 },
	{ 0xea002340, ~0x00ffffff, 0x00140718 },
	{ 0xea002144, ~0x00ffffff, 0x00140998 },
	{ 0xea002344, ~0x00ffffff, 0x00140998 },
	{ 0xea002148, ~0x00ffffff, 0x00140998 },
	{ 0xea002348, ~0x00ffffff, 0x00140998 },
	{ 0xea00217c, ~0x03000000, 0x03000000 },
	{ 0xea00237c, ~0x03000000, 0x03000000 },
	{ 0xea002178, ~0x00001f00, 0x00001800 },
	{ 0xea002378, ~0x00001f00, 0x00001800 },
	{ 0xea00210c, ~0x0038000f, 0x00000005 },
	{ 0xea00230c, ~0x0038000f, 0x00000005 },
};

const struct hsio_table_row hsio_sata_lpt_h_cx[] = {
	{ 0xea008008, ~0xff000000, 0x1c000000 },
	{ 0xea002408, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002608, ~0xfffc6108, 0xea6c6108 },
	{ 0xea000808, ~0xfffc6108, 0xea6c6108 },
	{ 0xea000a08, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002438, ~0x3f00000f, 0x0700000d },
	{ 0xea002638, ~0x3f00000f, 0x0700000d },
	{ 0xea000838, ~0x3f00000f, 0x0700000d },
	{ 0xea000a38, ~0x3f00000f, 0x0700000d },
	{ 0xea002440, ~0x1f000000, 0x01000000 },
	{ 0xea002640, ~0x1f000000, 0x01000000 },
	{ 0xea000840, ~0x1f000000, 0x01000000 },
	{ 0xea000a40, ~0x1f000000, 0x01000000 },
	{ 0xea002410, ~0xffff0000, 0x0d510000 },
	{ 0xea002610, ~0xffff0000, 0x0d510000 },
	{ 0xea000810, ~0xffff0000, 0x0d510000 },
	{ 0xea000a10, ~0xffff0000, 0x0d510000 },
	{ 0xea00242c, ~0x00020800, 0x00020000 },
	{ 0xea00262c, ~0x00020800, 0x00020000 },
	{ 0xea00082c, ~0x00020800, 0x00020000 },
	{ 0xea000a2c, ~0x00020800, 0x00020000 },
	{ 0xea002418, ~0xffff0300, 0x38250100 },
	{ 0xea002618, ~0xffff0300, 0x38250100 },
	{ 0xea000818, ~0xffff0300, 0x38250100 },
	{ 0xea000a18, ~0xffff0300, 0x38250100 },
	{ 0xea002400, ~0xcf030000, 0xcf030000 },
	{ 0xea002600, ~0xcf030000, 0xcf030000 },
	{ 0xea000800, ~0xcf030000, 0xcf030000 },
	{ 0xea000a00, ~0xcf030000, 0xcf030000 },
	{ 0xea002428, ~0xff1f0000, 0x580e0000 },
	{ 0xea002628, ~0xff1f0000, 0x580e0000 },
	{ 0xea000828, ~0xff1f0000, 0x580e0000 },
	{ 0xea000a28, ~0xff1f0000, 0x580e0000 },
	{ 0xea00241c, ~0x00007c00, 0x00002400 },
	{ 0xea00261c, ~0x00007c00, 0x00002400 },
	{ 0xea00081c, ~0x00007c00, 0x00002400 },
	{ 0xea000a1c, ~0x00007c00, 0x00002400 },
	{ 0xea00248c, ~0x00ff0000, 0x00800000 },
	{ 0xea00268c, ~0x00ff0000, 0x00800000 },
	{ 0xea00088c, ~0x00ff0000, 0x00800000 },
	{ 0xea000a8c, ~0x00ff0000, 0x00800000 },
	{ 0xea0024a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0026a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0008a4, ~0x0030ff00, 0x00308300 },
	{ 0xea000aa4, ~0x0030ff00, 0x00308300 },
	{ 0xea0024ac, ~0x00000030, 0x00000020 },
	{ 0xea0026ac, ~0x00000030, 0x00000020 },
	{ 0xea0008ac, ~0x00000030, 0x00000020 },
	{ 0xea000aac, ~0x00000030, 0x00000020 },
	{ 0xea002540, ~0x00ffffff, 0x00140718 },
	{ 0xea002740, ~0x00ffffff, 0x00140718 },
	{ 0xea000940, ~0x00ffffff, 0x00140718 },
	{ 0xea000b40, ~0x00ffffff, 0x00140718 },
	{ 0xea002544, ~0x00ffffff, 0x00140998 },
	{ 0xea002744, ~0x00ffffff, 0x00140998 },
	{ 0xea000944, ~0x00ffffff, 0x00140998 },
	{ 0xea000b44, ~0x00ffffff, 0x00140998 },
	{ 0xea002548, ~0x00ffffff, 0x00140998 },
	{ 0xea002748, ~0x00ffffff, 0x00140998 },
	{ 0xea000948, ~0x00ffffff, 0x00140998 },
	{ 0xea000b48, ~0x00ffffff, 0x00140998 },
	{ 0xea00257c, ~0x03000000, 0x03000000 },
	{ 0xea00277c, ~0x03000000, 0x03000000 },
	{ 0xea00097c, ~0x03000000, 0x03000000 },
	{ 0xea000b7c, ~0x03000000, 0x03000000 },
	{ 0xea002578, ~0x00001f00, 0x00001800 },
	{ 0xea002778, ~0x00001f00, 0x00001800 },
	{ 0xea000978, ~0x00001f00, 0x00001800 },
	{ 0xea000b78, ~0x00001f00, 0x00001800 },
	{ 0xea00250c, ~0x0038000f, 0x00000005 },
	{ 0xea00270c, ~0x0038000f, 0x00000005 },
	{ 0xea00090c, ~0x0038000f, 0x00000005 },
	{ 0xea000b0c, ~0x0038000f, 0x00000005 },
};

const struct hsio_table_row hsio_xhci_shared_lpt_h_cx[] = {
	{ 0xe9002c2c, ~0x00000700, 0x00000100 },
	{ 0xe9002e2c, ~0x00000700, 0x00000100 },
	{ 0xe9002dcc, ~0x00001407, 0x00001407 },
	{ 0xe9002fcc, ~0x00001407, 0x00001407 },
	{ 0xe9002d68, ~0x01000f3c, 0x00000a28 },
	{ 0xe9002f68, ~0x01000f3c, 0x00000a28 },
	{ 0xe9002d6c, ~0x000000ff, 0x0000003f },
	{ 0xe9002f6c, ~0x000000ff, 0x0000003f },
	{ 0xe9002d4c, ~0x00ffff00, 0x00120500 },
	{ 0xe9002f4c, ~0x00ffff00, 0x00120500 },
	{ 0xe9002d14, ~0x38000700, 0x00000100 },
	{ 0xe9002f14, ~0x38000700, 0x00000100 },
	{ 0xe9002d64, ~0x0000f000, 0x00005000 },
	{ 0xe9002f64, ~0x0000f000, 0x00005000 },
	{ 0xe9002d70, ~0x00000018, 0x00000000 },
	{ 0xe9002f70, ~0x00000018, 0x00000000 },
	{ 0xe9002c38, ~0x3f00000f, 0x0700000b },
	{ 0xe9002e38, ~0x3f00000f, 0x0700000b },
	{ 0xe9002d40, ~0x00800000, 0x00000000 },
	{ 0xe9002f40, ~0x00800000, 0x00000000 },
};

const struct hsio_table_row hsio_xhci_lpt_h_cx[] = {
	{ 0xe90031cc, ~0x00001407, 0x00001407 },
	{ 0xe90033cc, ~0x00001407, 0x00001407 },
	{ 0xe90015cc, ~0x00001407, 0x00001407 },
	{ 0xe90017cc, ~0x00001407, 0x00001407 },
	{ 0xe9003168, ~0x01000f3c, 0x00000a28 },
	{ 0xe9003368, ~0x01000f3c, 0x00000a28 },
	{ 0xe9001568, ~0x01000f3c, 0x00000a28 },
	{ 0xe9001768, ~0x01000f3c, 0x00000a28 },
	{ 0xe900316c, ~0x000000ff, 0x0000003f },
	{ 0xe900336c, ~0x000000ff, 0x0000003f },
	{ 0xe900156c, ~0x000000ff, 0x0000003f },
	{ 0xe900176c, ~0x000000ff, 0x0000003f },
	{ 0xe900314c, ~0x00ffff00, 0x00120500 },
	{ 0xe900334c, ~0x00ffff00, 0x00120500 },
	{ 0xe900154c, ~0x00ffff00, 0x00120500 },
	{ 0xe900174c, ~0x00ffff00, 0x00120500 },
	{ 0xe9003114, ~0x38000700, 0x00000100 },
	{ 0xe9003314, ~0x38000700, 0x00000100 },
	{ 0xe9001514, ~0x38000700, 0x00000100 },
	{ 0xe9001714, ~0x38000700, 0x00000100 },
	{ 0xe9003164, ~0x0000f000, 0x00005000 },
	{ 0xe9003364, ~0x0000f000, 0x00005000 },
	{ 0xe9001564, ~0x0000f000, 0x00005000 },
	{ 0xe9001764, ~0x0000f000, 0x00005000 },
	{ 0xe9003170, ~0x00000018, 0x00000000 },
	{ 0xe9003370, ~0x00000018, 0x00000000 },
	{ 0xe9001570, ~0x00000018, 0x00000000 },
	{ 0xe9001770, ~0x00000018, 0x00000000 },
	{ 0xe9003038, ~0x3f00000f, 0x0700000b },
	{ 0xe9003238, ~0x3f00000f, 0x0700000b },
	{ 0xe9001438, ~0x3f00000f, 0x0700000b },
	{ 0xe9001638, ~0x3f00000f, 0x0700000b },
	{ 0xe9003140, ~0x00800000, 0x00000000 },
	{ 0xe9003340, ~0x00800000, 0x00000000 },
	{ 0xe9001540, ~0x00800000, 0x00000000 },
	{ 0xe9001740, ~0x00800000, 0x00000000 },
};

void program_hsio_sata_lpt_h_cx(const bool is_mobile)
{
	const struct hsio_table_row *pch_hsio_table;
	size_t len;

	pch_hsio_table = hsio_sata_lpt_h_cx;
	len = ARRAY_SIZE(hsio_sata_lpt_h_cx);
	for (size_t i = 0; i < len; i++)
		hsio_update_row(pch_hsio_table[i]);

	pch_hsio_table = hsio_sata_shared_lpt_h_cx;
	len = ARRAY_SIZE(hsio_sata_shared_lpt_h_cx);
	for (size_t i = 0; i < len; i++)
		hsio_sata_shared_update_row(pch_hsio_table[i]);

	const uint32_t hsio_sata_value = is_mobile ? 0x00004c5a : 0x00003e67;

	hsio_update(0xea002490, ~0x0000ffff, hsio_sata_value);
	hsio_update(0xea002690, ~0x0000ffff, hsio_sata_value);
	hsio_update(0xea000890, ~0x0000ffff, hsio_sata_value);
	hsio_update(0xea000a90, ~0x0000ffff, hsio_sata_value);

	hsio_sata_shared_update(0xea002090, ~0x0000ffff, hsio_sata_value);
	hsio_sata_shared_update(0xea002290, ~0x0000ffff, hsio_sata_value);
}

void program_hsio_xhci_lpt_h_cx(void)
{
	const struct hsio_table_row *pch_hsio_table;
	size_t len;

	pch_hsio_table = hsio_xhci_lpt_h_cx;
	len = ARRAY_SIZE(hsio_xhci_lpt_h_cx);

	for (size_t i = 0; i < len; i++)
		hsio_update_row(pch_hsio_table[i]);

	pch_hsio_table = hsio_xhci_shared_lpt_h_cx;
	len = ARRAY_SIZE(hsio_xhci_shared_lpt_h_cx);

	for (size_t i = 0; i < len; i++)
		hsio_xhci_shared_update_row(pch_hsio_table[i]);
}

void program_hsio_igbe_lpt_h_cx(void)
{
	const uint32_t strpfusecfg1 = pci_read_config32(PCH_PCIE_DEV(0), 0xfc);
	if (!(strpfusecfg1 & (1 << 19)))
		return;

	const uint8_t gbe_port = (strpfusecfg1 >> 16) & 0x7;
	const uint8_t lane_owner = pci_read_config8(PCH_PCIE_DEV(0), 0x410);
	if (gbe_port == 0 && ((lane_owner >> 0) & 3) != 1)
		return;

	if (gbe_port == 1 && ((lane_owner >> 2) & 3) != 1)
		return;

	const uint32_t gbe_hsio_base = 0xe900 << 16 | (0x2e - 2 * gbe_port) << 8;
	hsio_update(gbe_hsio_base + 0x08, ~0xf0000100, 0xe0000100);
}
