/* $Id: irplib_strehl.h,v 1.12 2009/06/29 14:32:53 kmirny Exp $
 *
 * This file is part of the irplib package
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: kmirny $
 * $Date: 2009/06/29 14:32:53 $
 * $Revision: 1.12 $
 * $Name: sinfo-2_4_0 $
 */

#ifndef IRPLIB_STREHL_H
#define IRPLIB_STREHL_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

#ifndef IRPLIB_STREHL_BORDER
#define IRPLIB_STREHL_BORDER        5
#endif

typedef enum {
    IRPLIB_BG_METHOD_AVER_REJ,
    IRPLIB_BG_METHOD_MEDIAN
} irplib_strehl_bg_method;

/*-----------------------------------------------------------------------------
                               Functions prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code irplib_strehl_compute(const cpl_image *, double, double, double,
                                     double, double, int, double, double,
                                     double, double, double, int, int,
                                     double *, double *, double *, double *,
                                     double *, double *, double *, double *);
cpl_error_code irplib_strehl_mark_bad_and_compute(
					cpl_image *, double, double, double,
					double, double, int, double, double,
					double, double, double, int, int,
					double *, double *, double *, double *,
					double *, double *, double *, double *);
double irplib_strehl_disk_flux(const cpl_image *, double, double, double,
                               double);

double irplib_strehl_ring_background(const cpl_image *, double, double, double,
                                     double, irplib_strehl_bg_method);

cpl_image * irplib_strehl_generate_psf(double, double, double, double, double,
                                       int);
cpl_error_code irplib_strehl_disk_max(const cpl_image *, double, double,
                                             double, double *);
#endif
