struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 400,
		.content = "Processor\t: ARMv7 Processor rev 1 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 3577.00\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 3577.00\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 3577.00\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 3577.00\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp thumbee neon vfpv3 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x4\n"
			   "CPU part\t: 0xc09\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "Hardware\t: hi6620oem\n"
			   "Revision\t: 0000\n"
			   "Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 6983,
		.content =
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.version.sdk=19\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.release=4.4.2\n"
			"ro.build.date=Sat Sep 12 09:52:31 CST 2015\n"
			"ro.build.date.utc=1442022751\n"
			"ro.build.type=user\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=hi6620oem\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=hi6620oem\n"
			"# Do not try to parse ro.build.description or .fingerprint\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"#\n"
			"# from device/hisi/hi6620oem/system.prop\n"
			"#\n"
			"rild.libpath=/system/lib/libbalong-ril.so\n"
			"rild.libargs=-m modem0\n"
			"rild.libpath1=/system/lib/libbalong-ril.so\n"
			"rild.libargs1=-m modem1\n"
			"ro.config.hisi_soc_type=true\n"
			"ro.config.hisi_rpt_mode=0\n"
			"balong.debug.on=true\n"
			"ro.config.fm_type=libbcmfm_if\n"
			"ro.bt.bdaddr_path=/data/misc/bluedroid/macbt\n"
			"ro.config.KeyPassToUser=true\n"
			"persist.sys.strictmode.visual=false\n"
			"ro.config.notification_sound=Glory.ogg\n"
			"ro.config.alarm_alert=Pmukkale.ogg\n"
			"ro.config.ringtone=Huawei_Tune.ogg\n"
			"install.frobidden=false\n"
			"ro.camera.sound.forced=1\n"
			"keyguard.no_require_sim=true\n"
			"ro.config.hw_dolby=false\n"
			"ro.config.hw_voicerecord=false\n"
			"ro.config.widevine_level3=true\n"
			"ro.product.manufacturer=HUAWEI\n"
			"drm.service.enabled=true\n"
			"ro.config.hw_multiscreen=true\n"
			"ro.ril.ecclist=112,911,#911,*911\n"
			"af.resampler.quality=3\n"
			"af.resampler.quality=4\n"
			"persist.demo.hdmirotation=portrait\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.atrace.tags.enableflags=0\n"
			"ro.config.hw_dts=true\n"
			"ro.config.hw_music_lp=true\n"
			"ro.config.balong_test=false\n"
			"debug.hwui.render_dirty_regions=false\n"
			"ro.config.hw_fastcoldboot=true\n"
			"persist.sys.hdcp_checking=never\n"
			"ro.config.hw_subtitle_support=true\n"
			"ro.hw_se13list_version=20130826\n"
			"ro.config.hw_disable_cops=true\n"
			"ro.product.platform.pseudonym=1ARB9CV\n"
			"ro.config.hw_music_lp=true\n"
			"persist.sys.thermalm=default\n"
			"ro.config.hw_navigationbar=true\n"
			"ro.config.hw_sglte.mcc=460\n"
			"ro.config.hw_sglte_simblist=46001\n"
			"ro.config.hw_testingsettings=true\n"
			"dalvik.vm.checkjni=false\n"
			"ro.config.hw_emerg=on\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.carrier=unknown\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=4.4_r6\n"
			"drm.service.enabled=true\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=192m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"service.inputaccel.config=2,5,0,0,4,160\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"persist.sys.dalvik.vm.lib=libdvm.so\n"
			"dalvik.vm.dexopt-flags=m=y\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"\n"
			"audioril.lib=libhuawei-audio-ril.so\n"
			"ro.config.keypasstouser=true\n"
			"ro.com.google.clientidbase=android-huawei\n"
			"ro.com.google.clientidbase.am=android-huawei\n"
			"ro.com.google.clientidbase.ms=android-huawei\n"
			"ro.com.google.clientidbase.yt=android-huawei\n"
			"ro.com.google.clientidbase.gmm=android-huawei\n"
			"ro.cellbroadcast.emergencyids=0-65534\n"
			"ro.config.hw_flashless=true\n"
			"ro.config.modem_hsic=true\n"
			"ro.config.hw_addsettingsdbex=1\n"
			"ro.opengles.version=131072\n"
			"ro.config.hw_toolbox = true\n"
			"ro.config.fast_dormancy=false\n"
			"ro.config.hwtheme=2\n"
			"ro.config.hw_gcf=false\n"
			"ro.config.hw_allowformat=true\n"
			"ro.config.hw_proximity=true\n"
			"ro.config.hw_lockscreen=true\n"
			"ro.config.hw_menu_unlockscreen=false\n"
			"ro.config.helix_enable=true\n"
			"ro.config.hwft_PinPukUnlockscr=true\n"
			"ro.config.hw_use_browser_ua=http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L12_UAProfile.xml\n"
			"ro.config.hw_always_allow_mms=false\n"
			"ro.config.hw_vcardBase64=true\n"
			"ro.config.hw_ecclist_withcard=1+110,6+119,8+118\n"
			"ro.config.hw_ecclist_nocard=1+110,6+119,8+118\n"
			"ro.config.hw_globalEcc = true\n"
			"ro.config.hw_allow_ums_and_mtp=true\n"
			"ro.config.incall_notify_mms=true\n"
			"ro.config.hw_useCtrlSocket=true\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"ro.config.AM_PM_STYLE=1\n"
			"persist.sys.powerup_reason=\n"
			"ro.poweroff_alarm=true\n"
			"persist.sys.actualpoweron=true\n"
			"ro.config.hw_show_number=false\n"
			"ro.config.bg_call_twinking=true\n"
			"ro.config.hw_power_saving=true\n"
			"ro.config.hwft_emerCallDefNum=\"\"\n"
			"ro.config.hw_proximitySensor=true\n"
			"ro.config.always_animation=true\n"
			"ro.config.hw_RemindWifiToPdp=false\n"
			"ro.config.app_big_icon_size=168\n"
			"ro.config.do_sdcard_upgrade=true\n"
			"ro.config.hw_eapsim=false\n"
			"ro.config.disablesmbacklinght=true\n"
			"persist.alarm.enable.uhb=0\n"
			"ro.config.hw_rightsmgr=1\n"
			"persist.sys.phb.enable=1\n"
			"persist.sys.phb.debug.enable=1\n"
			"ro.ads.bootanim=true\n"
			"ro.config.hw_acceleratord_onoff=1\n"
			"ro.config.hw.logsystem.send=0\n"
			"ro.config.hw_enable_merge=true\n"
			"ro.config.themecolor=true\n"
			"modify_ram_show=true\n"
			"ro.config.hw_hightLight=true\n"
			"ro.config.hw_hightLightValue=200\n"
			"persist.sys.alarm.enable.uhb=1\n"
			"ro.config.hw.security_volume=0\n"
			"ro.config.hw_GSensorOptimize=true\n"
			"ro.config.hw_omacp=1\n"
			"ro.config.hwscope=true\n"
			"ro.thmodem.type=sprd\n"
			"ro.config.hw_accesscontrol=true\n"
			"ro.config.hw_singlehand=0\n"
			"ro.config.hw_singlehand_smart=false\n"
			"ro.config.hw_acceleratord_onoff=0\n"
			"ril.gsm.deviceid=-1\n"
			"ril.cdma.deviceid=-1\n"
			"ril.gsm.rssi=-1\n"
			"ril.cdma.rssi=-1\n"
			"persist.sys.logsystem.neversend=0\n"
			"ro.config.hw_shownavisettings=true\n"
			"ro.config.dlvs=true\n"
			"ro.config.carkitmodenotif=true\n"
			"ro.config.hwscope=true\n"
			"ro.config.hwscope=true\n"
			"ro.config.lockscreen_lensflare=true\n"
			"ro.config.hw.powerlogserve.send=1\n"
			"persist.service.tm2.tofile=true\n"
			"ro.config.hw.VIS=true\n"
			"ro.config.hw_activity_state=true\n"
			"ril.hw_modem0.rssi=-1\n"
			"ril.hw_modem1.rssi=-1\n"
			"ro.config.hw_simpleui_enable=1\n"
			"ro.pwrtmg.aegis.state=20\n"
			"ro.config.hw_showTestInfo=true\n"
			"ro.cust.cdrom= /cust/preinstalled/public/cdrom/autorun.iso\n"
			"ro.config.switchPrimaryVolume=true\n"
			"ro.config.hw_navi_launcher=false\n"
			"ro.build.version.emui=EmotionUI_2.3\n"
			"ro.config.conn_diagnose=true\n"
			"ro.config.hw_gallery_video_edit=true\n"
			"ro.config.huawei_smallwindow=591,292,1060,1332\n"
			"ro.hwcamera.networklocation=true\n"
			"ro.config.hw_photoshare=false\n"
			"ro.config.browser_hw_nav_switch=false\n"
			"ro.config.browser_def_hw_nav=false\n"
			"ro.config.antivirus=false\n"
			"ro.config.addetect=false\n"
			"ro.config.spamwordsupdate=false\n"
			"ro.config.hw_custverdisplay=true\n"
			"ro.config.huawei_lowwindow=394,194,706,888\n"
			"ro.config.protocol_errors=false\n"
			"ro.cofig.onlinemusic.enabled=false\n"
			"ro.config.hw_ReduceSAR=true\n"
			"persist.hw.power.shutdown=1\n"
			"ro.config.hw_ChipPlatform=V9R1_Platform\r\n"
			"ro.config.hw_nfc_on=true\n"
			"ro.config.ShowNavigationBar=true\n"
			"ro.config.hw_blacklist=true\n"
			"ro.networkstatus.delaytimer=6\n"
			"ro.config.spare_ntp_server=pool.ntp.org\n"
			"\n"
			"ro.product.board=P7-L12\n"
			"\n"
			"ro.product.name=P7-L12\n"
			"\n"
			"ro.product.device=hwp7\n"
			"\n"
			"ro.confg.hw_systemversion=P7-L12V100R001C00B119_SYSTEM\n"
			"\n"
			"ro.build.display.id=P7-L12V100R001C00B119\n"
			"\n"
			"ro.build.id=HuaweiP7-L12\n"
			"\n"
			"ro.build.version.incremental=C00B119\n"
			"\n"
			"ro.build.description=P7-L12-user 4.4.2 HuaweiP7-L12 C00B119 ota-rel-keys,release-keys\n"
			"\n"
			"ro.build.fingerprint=Huawei/P7-L12/hwp7:4.4.2/HuaweiP7-L12/C00B119:user/ota-rel-keys,release-keys\n"
			"\n"
			"ro.product.model=HUAWEI P7-L12\n"
			"\n"
			"ro.product.brand=Huawei\n"
			"\n"
			"ro.build.tags=ota-rel-keys,release-keys\n"
			"\n"
			"ro.build.user=android\n"
			"\n"
			"ro.build.host=localhost#1\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-2\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 8,
		.content = "cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1795000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 53,
		.content = "208000 416000 624000 798000 1196000 1596000 1795000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 16,
		.content = "pwrctrl_hotplug\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 12,
		.content = "k3v2cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 15,
		.content = "pwrctrl_hotplug",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 81,
		.content = "208000 2430\n"
			   "416000 211\n"
			   "624000 432\n"
			   "798000 195\n"
			   "1196000 156\n"
			   "1596000 55\n"
			   "1795000 6002\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "211\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1795000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 53,
		.content = "208000 416000 624000 798000 1196000 1596000 1795000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 16,
		.content = "pwrctrl_hotplug\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 12,
		.content = "k3v2cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 15,
		.content = "pwrctrl_hotplug",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1795000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 66,
		.content = "208000 0\n"
			   "416000 0\n"
			   "624000 0\n"
			   "798000 0\n"
			   "1196000 0\n"
			   "1596000 0\n"
			   "1795000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1795000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 53,
		.content = "208000 416000 624000 798000 1196000 1596000 1795000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 16,
		.content = "pwrctrl_hotplug\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 12,
		.content = "k3v2cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 15,
		.content = "pwrctrl_hotplug",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1795000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 66,
		.content = "208000 0\n"
			   "416000 0\n"
			   "624000 0\n"
			   "798000 0\n"
			   "1196000 0\n"
			   "1596000 0\n"
			   "1795000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.resampler.quality",
		.value = "4",
	},
	{
		.key = "audioril.lib",
		.value = "libhuawei-audio-ril.so",
	},
	{
		.key = "balong.debug.on",
		.value = "true",
	},
	{
		.key = "dalvik.vm.checkjni",
		.value = "false",
	},
	{
		.key = "dalvik.vm.dexopt-flags",
		.value = "m=y",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dhcp.wlan0.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "dhcp.wlan0.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "dhcp.wlan0.dns3",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns4",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.domain",
		.value = "tfbnw.net",
	},
	{
		.key = "dhcp.wlan0.gateway",
		.value = "172.22.192.1",
	},
	{
		.key = "dhcp.wlan0.ipaddress",
		.value = "172.22.221.37",
	},
	{
		.key = "dhcp.wlan0.leasetime",
		.value = "1800",
	},
	{
		.key = "dhcp.wlan0.mask",
		.value = "255.255.224.0",
	},
	{
		.key = "dhcp.wlan0.mtu",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.pid",
		.value = "1263",
	},
	{
		.key = "dhcp.wlan0.reason",
		.value = "ROUTERADVERT",
	},
	{
		.key = "dhcp.wlan0.result",
		.value = "ok",
	},
	{
		.key = "dhcp.wlan0.server",
		.value = "192.168.47.185",
	},
	{
		.key = "dhcp.wlan0.vendorInfo",
		.value = "",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.fastdormancy.mode",
		.value = "3",
	},
	{
		.key = "gsm.network.type",
		.value = "HSPA",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.hw_atr",
		.value = "null",
	},
	{
		.key = "gsm.sim.num.simlock",
		.value = "-1,-1,-1",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.temp.defapn.state",
		.value = "false",
	},
	{
		.key = "gsm.version.baseband",
		.value = "23.195.00.00.000",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android infineon balong-ril 1.0",
	},
	{
		.key = "huawei.check_root.hotapermit",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.mount",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.oldstate",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.prop",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.su",
		.value = "safe",
	},
	{
		.key = "hw.hdmiON",
		.value = "0",
	},
	{
		.key = "hw.lcd.density",
		.value = "480",
	},
	{
		.key = "init.svc.acceleratord",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09911",
		.value = "running",
	},
	{
		.key = "init.svc.akmd8963",
		.value = "stopped",
	},
	{
		.key = "init.svc.applogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.chargelogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.check_root",
		.value = "stopped",
	},
	{
		.key = "init.svc.create_swapfile",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.device-monitor",
		.value = "running",
	},
	{
		.key = "init.svc.dhcpcd_wlan0",
		.value = "running",
	},
	{
		.key = "init.svc.diagserver",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.exch",
		.value = "stopped",
	},
	{
		.key = "init.svc.filebackup",
		.value = "running",
	},
	{
		.key = "init.svc.gpsd",
		.value = "running",
	},
	{
		.key = "init.svc.hdmi-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hw_modem_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hw_pcui_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hwnffserver",
		.value = "running",
	},
	{
		.key = "init.svc.hwpged",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.kmsglogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.macaddr",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.nvm-server",
		.value = "running",
	},
	{
		.key = "init.svc.oeminfo_nvm",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rillogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.sleeplogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tcp_mw3",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermalm",
		.value = "running",
	},
	{
		.key = "init.svc.thermalmemo",
		.value = "stopped",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.user_coredump",
		.value = "stopped",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "install.frobidden",
		.value = "false",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "modify_ram_show",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.hostname",
		.value = "android-3ff6c812345d6d0e",
	},
	{
		.key = "net.ntp.time",
		.value = "1508436317964",
	},
	{
		.key = "net.ntp.timereference",
		.value = "24734",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "persist.alarm.enable.uhb",
		.value = "0",
	},
	{
		.key = "persist.demo.hdmirotation",
		.value = "portrait",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.dsds.enabled",
		.value = "false",
	},
	{
		.key = "persist.hw.power.shutdown",
		.value = "0",
	},
	{
		.key = "persist.radio.1sthwlauncher",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.supp.notification",
		.value = "false",
	},
	{
		.key = "persist.service.tm2.tofile",
		.value = "true",
	},
	{
		.key = "persist.sys.actualpoweron",
		.value = "true",
	},
	{
		.key = "persist.sys.alarm.enable.uhb",
		.value = "1",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.datacrash",
		.value = "0",
	},
	{
		.key = "persist.sys.hdcp_checking",
		.value = "never",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.logsystem.neversend",
		.value = "0",
	},
	{
		.key = "persist.sys.phb.debug.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.phb.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.powersystem.enable",
		.value = "0",
	},
	{
		.key = "persist.sys.powerup_reason",
		.value = "NORMAL",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.smart_power",
		.value = "2",
	},
	{
		.key = "persist.sys.strictmode.visual",
		.value = "false",
	},
	{
		.key = "persist.sys.thermalm",
		.value = "default",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mass_storage,adb",
	},
	{
		.key = "persist.telephony.mpdn",
		.value = "false",
	},
	{
		.key = "ril.balong_cid",
		.value = "0",
	},
	{
		.key = "ril.cdma.deviceid",
		.value = "-1",
	},
	{
		.key = "ril.cdma.rssi",
		.value = "-1",
	},
	{
		.key = "ril.ecclist",
		.value = "112,911,000,08,110,118,119,999,911,*911,#911",
	},
	{
		.key = "ril.force_to_set_ecc",
		.value = "invalid",
	},
	{
		.key = "ril.gsm.deviceid",
		.value = "-1",
	},
	{
		.key = "ril.gsm.rssi",
		.value = "-1",
	},
	{
		.key = "ril.hw_modem0.rssi",
		.value = "-92",
	},
	{
		.key = "ril.hw_modem1.rssi",
		.value = "-1",
	},
	{
		.key = "ril.modem.balong_nvm_server",
		.value = "true",
	},
	{
		.key = "ril.operator.numeric",
		.value = "310260",
	},
	{
		.key = "rild.libargs1",
		.value = "-m modem1",
	},
	{
		.key = "rild.libargs",
		.value = "-m modem0",
	},
	{
		.key = "rild.libpath1",
		.value = "/system/lib/libbalong-ril.so",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libbalong-ril.so",
	},
	{
		.key = "rild.rild1_ready_to_start",
		.value = "false",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.ads.bootanim",
		.value = "true",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.analogMIC",
		.value = "1",
	},
	{
		.key = "ro.audio.dobuleMIC",
		.value = "1",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "hi6620oem",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/data/misc/bluedroid/macbt",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.cust.id",
		.value = "P7-L12V100R001C00B119SP03",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1442022751",
	},
	{
		.key = "ro.build.date",
		.value = "Sat Sep 12 09:52:31 CST 2015",
	},
	{
		.key = "ro.build.description",
		.value = "P7-L12-user 4.4.2 HuaweiP7-L12 C00B119 ota-rel-keys,release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "P7-L12V100R001C00B119",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Huawei/P7-L12/hwp7:4.4.2/HuaweiP7-L12/C00B119:user/ota-rel-keys,release-keys",
	},
	{
		.key = "ro.build.host",
		.value = "localhost#1",
	},
	{
		.key = "ro.build.id",
		.value = "HuaweiP7-L12",
	},
	{
		.key = "ro.build.product",
		.value = "hi6620oem",
	},
	{
		.key = "ro.build.tags",
		.value = "ota-rel-keys,release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "android",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.emui",
		.value = "EmotionUI_2.3",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "C00B119",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "1",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.cellbroadcast.emergencyids",
		.value = "0-65535",
	},
	{
		.key = "ro.cofig.onlinemusic.enabled",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "4.4_r6",
	},
	{
		.key = "ro.confg.hw_bootversion",
		.value = "P7-L12V100R001C00B119_BOOT",
	},
	{
		.key = "ro.confg.hw_fastbootversion",
		.value = "P7-L12V100R001C00B119_FASTBOOT",
	},
	{
		.key = "ro.confg.hw_systemversion",
		.value = "P7-L12V100R001C00B119_SYSTEM",
	},
	{
		.key = "ro.config.AM_PM_STYLE",
		.value = "1",
	},
	{
		.key = "ro.config.KeyPassToUser",
		.value = "true",
	},
	{
		.key = "ro.config.ShowNavigationBar",
		.value = "true",
	},
	{
		.key = "ro.config.addetect",
		.value = "false",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Huawei_Alarm.ogg",
	},
	{
		.key = "ro.config.always_animation",
		.value = "true",
	},
	{
		.key = "ro.config.antivirus",
		.value = "false",
	},
	{
		.key = "ro.config.app_big_icon_size",
		.value = "168",
	},
	{
		.key = "ro.config.balong_test",
		.value = "false",
	},
	{
		.key = "ro.config.bg_call_twinking",
		.value = "true",
	},
	{
		.key = "ro.config.browser_def_hw_nav",
		.value = "false",
	},
	{
		.key = "ro.config.browser_hw_nav_switch",
		.value = "false",
	},
	{
		.key = "ro.config.calendarsound",
		.value = "Step.ogg",
	},
	{
		.key = "ro.config.carkitmodenotif",
		.value = "true",
	},
	{
		.key = "ro.config.compatibility_enable",
		.value = "1",
	},
	{
		.key = "ro.config.conn_diagnose",
		.value = "true",
	},
	{
		.key = "ro.config.dateformat",
		.value = "dd-MM-yyyy",
	},
	{
		.key = "ro.config.disablesmbacklinght",
		.value = "true",
	},
	{
		.key = "ro.config.dlvs",
		.value = "true",
	},
	{
		.key = "ro.config.do_sdcard_upgrade",
		.value = "true",
	},
	{
		.key = "ro.config.dsds_mode",
		.value = "umts",
	},
	{
		.key = "ro.config.emailsound",
		.value = "Letter.ogg",
	},
	{
		.key = "ro.config.fast_dormancy",
		.value = "false",
	},
	{
		.key = "ro.config.fm_type",
		.value = "libbcmfm_if",
	},
	{
		.key = "ro.config.forbid_internal_call",
		.value = "true",
	},
	{
		.key = "ro.config.helix_enable",
		.value = "true",
	},
	{
		.key = "ro.config.hisi_rpt_mode",
		.value = "0",
	},
	{
		.key = "ro.config.hisi_soc_type",
		.value = "true",
	},
	{
		.key = "ro.config.huawei_lowwindow",
		.value = "394,194,706,888",
	},
	{
		.key = "ro.config.huawei_smallwindow",
		.value = "591,292,1060,1332",
	},
	{
		.key = "ro.config.hw.VIS",
		.value = "true",
	},
	{
		.key = "ro.config.hw.logsystem.send",
		.value = "0",
	},
	{
		.key = "ro.config.hw.powerlogserve.send",
		.value = "1",
	},
	{
		.key = "ro.config.hw.security_volume",
		.value = "10",
	},
	{
		.key = "ro.config.hw_ChipPlatform",
		.value = "V9R1_Platform",
	},
	{
		.key = "ro.config.hw_GSensorOptimize",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ReduceSAR",
		.value = "true",
	},
	{
		.key = "ro.config.hw_RemindWifiToPdp",
		.value = "false",
	},
	{
		.key = "ro.config.hw_acceleratord_onoff",
		.value = "1",
	},
	{
		.key = "ro.config.hw_accesscontrol",
		.value = "true",
	},
	{
		.key = "ro.config.hw_activity_state",
		.value = "true",
	},
	{
		.key = "ro.config.hw_addsettingsdbex",
		.value = "1",
	},
	{
		.key = "ro.config.hw_allow_rs_mms",
		.value = "true",
	},
	{
		.key = "ro.config.hw_allow_ums_and_mtp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_allowformat",
		.value = "true",
	},
	{
		.key = "ro.config.hw_always_allow_mms",
		.value = "false",
	},
	{
		.key = "ro.config.hw_blacklist",
		.value = "true",
	},
	{
		.key = "ro.config.hw_browser_flag_nii",
		.value = "true",
	},
	{
		.key = "ro.config.hw_cp_showagree",
		.value = "false",
	},
	{
		.key = "ro.config.hw_custverdisplay",
		.value = "true",
	},
	{
		.key = "ro.config.hw_dateformat",
		.value = "true",
	},
	{
		.key = "ro.config.hw_disable_cops",
		.value = "true",
	},
	{
		.key = "ro.config.hw_dolby",
		.value = "false",
	},
	{
		.key = "ro.config.hw_dsda",
		.value = "false",
	},
	{
		.key = "ro.config.hw_dts",
		.value = "true",
	},
	{
		.key = "ro.config.hw_eapsim",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ecclist_nocard",
		.value = "1+110,6+119,8+118",
	},
	{
		.key = "ro.config.hw_ecclist_withcard",
		.value = "1+110,6+119,8+118",
	},
	{
		.key = "ro.config.hw_emerg",
		.value = "on",
	},
	{
		.key = "ro.config.hw_enable_merge",
		.value = "true",
	},
	{
		.key = "ro.config.hw_fastcoldboot",
		.value = "true",
	},
	{
		.key = "ro.config.hw_flashless",
		.value = "true",
	},
	{
		.key = "ro.config.hw_gallery_video_edit",
		.value = "true",
	},
	{
		.key = "ro.config.hw_gcf",
		.value = "false",
	},
	{
		.key = "ro.config.hw_globalEcc",
		.value = "true",
	},
	{
		.key = "ro.config.hw_glovemode_enabled",
		.value = "1",
	},
	{
		.key = "ro.config.hw_hightLightValue",
		.value = "200",
	},
	{
		.key = "ro.config.hw_hightLight",
		.value = "true",
	},
	{
		.key = "ro.config.hw_lockscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_menu_unlockscreen",
		.value = "false",
	},
	{
		.key = "ro.config.hw_multiscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_music_lp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_navi_launcher",
		.value = "false",
	},
	{
		.key = "ro.config.hw_navigationbar",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nfc_on",
		.value = "true",
	},
	{
		.key = "ro.config.hw_omacp",
		.value = "1",
	},
	{
		.key = "ro.config.hw_photoshare",
		.value = "false",
	},
	{
		.key = "ro.config.hw_power_saving",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximitySensor",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximity",
		.value = "true",
	},
	{
		.key = "ro.config.hw_rightsmgr",
		.value = "1",
	},
	{
		.key = "ro.config.hw_sglte.mcc",
		.value = "460",
	},
	{
		.key = "ro.config.hw_sglte_simblist",
		.value = "46001",
	},
	{
		.key = "ro.config.hw_showSimName",
		.value = "true",
	},
	{
		.key = "ro.config.hw_showTestInfo",
		.value = "false",
	},
	{
		.key = "ro.config.hw_show_number",
		.value = "false",
	},
	{
		.key = "ro.config.hw_shownavisettings",
		.value = "true",
	},
	{
		.key = "ro.config.hw_simpleui_enable",
		.value = "1",
	},
	{
		.key = "ro.config.hw_singlehand",
		.value = "0",
	},
	{
		.key = "ro.config.hw_singlehand_smart",
		.value = "false",
	},
	{
		.key = "ro.config.hw_subtitle_support",
		.value = "true",
	},
	{
		.key = "ro.config.hw_support_ipcall",
		.value = "false",
	},
	{
		.key = "ro.config.hw_testingsettings",
		.value = "true",
	},
	{
		.key = "ro.config.hw_timeformat",
		.value = "true",
	},
	{
		.key = "ro.config.hw_toolbox",
		.value = "true",
	},
	{
		.key = "ro.config.hw_useCtrlSocket",
		.value = "true",
	},
	{
		.key = "ro.config.hw_use_browser_ua",
		.value = "http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L12_UAProfile.xml",
	},
	{
		.key = "ro.config.hw_vcardBase64",
		.value = "true",
	},
	{
		.key = "ro.config.hw_voicemail_sim",
		.value = "true",
	},
	{
		.key = "ro.config.hw_voicerecord",
		.value = "false",
	},
	{
		.key = "ro.config.hw_wifipopup_off",
		.value = "true",
	},
	{
		.key = "ro.config.hwft_PinPukUnlockscr",
		.value = "true",
	},
	{
		.key = "ro.config.hwft_emerCallDefNum",
		.value = "\"\"",
	},
	{
		.key = "ro.config.hwscope",
		.value = "true",
	},
	{
		.key = "ro.config.hwtheme",
		.value = "2",
	},
	{
		.key = "ro.config.incall_notify_mms",
		.value = "true",
	},
	{
		.key = "ro.config.keypasstouser",
		.value = "true",
	},
	{
		.key = "ro.config.launcher_matchcard",
		.value = "0",
	},
	{
		.key = "ro.config.lockscreen_lensflare",
		.value = "true",
	},
	{
		.key = "ro.config.messagesound",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.mnc_having_2digits",
		.value = "71401",
	},
	{
		.key = "ro.config.modem_hsic",
		.value = "true",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Bongo.ogg",
	},
	{
		.key = "ro.config.protocol_errors",
		.value = "false",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Huawei_Tune.ogg",
	},
	{
		.key = "ro.config.setupcall_from_ap",
		.value = "true",
	},
	{
		.key = "ro.config.spamwordsupdate",
		.value = "false",
	},
	{
		.key = "ro.config.spare_ntp_server",
		.value = "pool.ntp.org",
	},
	{
		.key = "ro.config.switchPrimaryVolume",
		.value = "true",
	},
	{
		.key = "ro.config.themecolor",
		.value = "true",
	},
	{
		.key = "ro.config.timeformat",
		.value = "12",
	},
	{
		.key = "ro.config.vm_prioritymode",
		.value = "2",
	},
	{
		.key = "ro.config.widevine_level3",
		.value = "true",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unsupported",
	},
	{
		.key = "ro.cust.cdrom",
		.value = "/cust/preinstalled/public/cdrom/autorun.iso",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.hardware",
		.value = "hi6620oem",
	},
	{
		.key = "ro.huawei.flag.oma_reboot",
		.value = "true",
	},
	{
		.key = "ro.hw_se13list_version",
		.value = "20130826",
	},
	{
		.key = "ro.hwcamera.networklocation",
		.value = "true",
	},
	{
		.key = "ro.hwcamera.sound.muteable",
		.value = "true",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.isfullhd",
		.value = "1",
	},
	{
		.key = "ro.multi.rild",
		.value = "false",
	},
	{
		.key = "ro.networkstatus.delaytimer",
		.value = "6",
	},
	{
		.key = "ro.opengles.version",
		.value = "131072",
	},
	{
		.key = "ro.poweroff_alarm",
		.value = "true",
	},
	{
		.key = "ro.product.CustCVersion",
		.value = "C00",
	},
	{
		.key = "ro.product.CustDVersion",
		.value = "D119",
	},
	{
		.key = "ro.product.board",
		.value = "P7-L12",
	},
	{
		.key = "ro.product.brand",
		.value = "Huawei",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.device",
		.value = "hwp7",
	},
	{
		.key = "ro.product.fackKernelVersion1",
		.value = "3.0.8-00348-gc2acf5d",
	},
	{
		.key = "ro.product.fackKernelVersion2",
		.value = "android@localhost#1%sFri Jun 6 20:05:50 CTS 2014",
	},
	{
		.key = "ro.product.locale.language",
		.value = "es",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "HUAWEI",
	},
	{
		.key = "ro.product.model",
		.value = "HUAWEI P7-L12",
	},
	{
		.key = "ro.product.name",
		.value = "P7-L12",
	},
	{
		.key = "ro.product.platform.pseudonym",
		.value = "1ARB9CV",
	},
	{
		.key = "ro.product.sutelversion",
		.value = "Sutel:00046-2014",
	},
	{
		.key = "ro.pwrtmg.aegis.state",
		.value = "20",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.ecclist",
		.value = "112,911,#911,*911",
	},
	{
		.key = "ro.runmode",
		.value = "normal",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1508436336632",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "7N2UNB159P003774",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "0",
	},
	{
		.key = "ro.thmodem.type",
		.value = "sprd",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.hdmi-daemon.exit",
		.value = "0",
	},
	{
		.key = "service.inputaccel.config",
		.value = "2,5,0,0,4,160",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.emergency.mountdata",
		.value = "0",
	},
	{
		.key = "sys.hwsholder.count",
		.value = "0",
	},
	{
		.key = "sys.iswifihotspoton",
		.value = "false",
	},
	{
		.key = "sys.nsd.support",
		.value = "2",
	},
	{
		.key = "sys.settings_global_version",
		.value = "5",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "2",
	},
	{
		.key = "sys.settings_systemex_version",
		.value = "4",
	},
	{
		.key = "sys.show_google_nlp",
		.value = "true",
	},
	{
		.key = "sys.super_power_save",
		.value = "false",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "mass_storage,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mass_storage,adb",
	},
	{
		.key = "viatel.device.asci",
		.value = "uart.0.ttyAMA",
	},
	{
		.key = "viatel.device.at",
		.value = "sdio.10.ttySDIO",
	},
	{
		.key = "viatel.device.data",
		.value = "sdio.0.ttySDIO",
	},
	{
		.key = "viatel.device.fls",
		.value = "sdio.2.ttySDIO",
	},
	{
		.key = "viatel.device.gps",
		.value = "sdio.5.ttySDIO",
	},
	{
		.key = "viatel.device.pcv",
		.value = "sdio.4.ttySDIO",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
