/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 */

#include "config.h"

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "crypto_aux.h"
#include "libdsm_common.h"
#include "ntlm_hmac_md5.h"

#ifndef lint
static MAYBE_UNUSED const char copyright[] =
"Copyright (c) 2003-2017\n\
Distributed Systems Software.  All rights reserved.";
static MAYBE_UNUSED const char revid[] =
  "$Id: ntlm_hmac_md5.c 2958 2017-05-18 18:56:19Z brachman $";
#endif

/*
 * This is the NTLMv2 authentication version of HMAC/MD5, which is not the
 * standard algorithm.
 * Returns the result in HMAC, if it is non-NULL, otherwise in a static buffer
 * (so beware successive calls are done correctly); return NULL if an error
 * occurs.
 *
 * This is a sub-optimal implementation.
 */
unsigned char *
ntlm_hmac_md5(const void *key, size_t key_len, const void *msg, size_t msg_len,
			  void *hmac)
{
  unsigned int i;
  uint8_t key_pad[64], o_key_pad[64], i_key_pad[64], kcat[80];
  uint8_t *cat, *out;
  MD5_ctx ctx;
  static uint8_t hmac_static[16];

  assert(key != NULL && msg != NULL);

  /*
   * This is Microsoft's variation of HMAC_MD5 for NTLMv2.
   * They truncate over-sized keys instead of rehashing.
   */
  if (key_len > 64)
	key_len = 64;

  memcpy(key_pad, key, key_len);
  if (key_len < 64)
	memset(key_pad + key_len, 0, 64 - key_len);

  /*
   * Compute the o/i XORed padded keys.
   */
  for (i = 0; i < 64; i++) {
	o_key_pad[i] = 0x5c ^ key_pad[i];
	i_key_pad[i] = 0x36 ^ key_pad[i];
  }

  /*
   * Concatenate inner padded key with message.
   */
  cat = malloc(msg_len + 64);
  if (!cat)
	return(NULL);
  memcpy(cat, i_key_pad, 64);
  memcpy(cat + 64, msg, msg_len);

  /*
   * MD5 of the result.
   */
  MD5_init(&ctx);
  MD5_update(&ctx, cat, msg_len + 64);
  MD5_final(&ctx, key_pad);
  free(cat);

  memcpy(kcat, o_key_pad, 64);
  memcpy(kcat + 64, key_pad, 16);

  if (hmac != NULL)
	out = hmac;
  else
	out = hmac_static;

  MD5_init(&ctx);
  MD5_update(&ctx, kcat, 80);
  MD5_final(&ctx, out);

  return(out);
}
