/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Sylver Bruneau <sylver.bruneau@gmail.com>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 */

#include "config.h"

#include <assert.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <netinet/in.h>

#include "smb_session_msg.h"
#include "smb_fd.h"
#include "smb_utils.h"
#include "smb_dir.h"

#ifndef lint
static MAYBE_UNUSED const char copyright[] =
"Copyright (c) 2003-2017\n\
Distributed Systems Software.  All rights reserved.";
static MAYBE_UNUSED const char revid[] =
  "$Id: smb_dir.c 2958 2017-05-18 18:56:19Z brachman $";
#endif

int
smb_directory_rm(smb_session *s, smb_tid tid, const char *path)
{
  smb_message *req_msg, resp_msg;
  smb_directory_rm_req  req;
  smb_directory_rm_resp *resp;
  size_t utf_pattern_len;
  char *utf_pattern;

  assert(s != NULL && path != NULL);

  utf_pattern_len = smb_to_utf16(path, strlen(path) + 1, &utf_pattern);
  if (utf_pattern_len == 0)
	return(DSM_ERROR_CHARSET);

  req_msg = smb_message_new(SMB_CMD_RMDIR);
  if (!req_msg) {
	free(utf_pattern);
	return(DSM_ERROR_GENERIC);
  }

  req_msg->packet->header.tid = (uint16_t) tid;

  SMB_MSG_INIT_PKT(req);
  req.wct = 0x00; // Must be 0
  req.bct = (uint16_t) (utf_pattern_len + 1);
  req.buffer_format = 0x04; // Must be 4
  SMB_MSG_PUT_PKT(req_msg, req);
  smb_message_append(req_msg, utf_pattern, utf_pattern_len);

  smb_session_send_msg(s, req_msg);
  smb_message_destroy(req_msg);

  free(utf_pattern);

  if (!smb_session_recv_msg(s, &resp_msg))
	return(DSM_ERROR_NETWORK);

  if (!smb_session_check_nt_status(s, &resp_msg))
	return(DSM_ERROR_NT);

  resp = (smb_directory_rm_resp *) resp_msg.packet->payload;
  if ((resp->wct != 0) || (resp->bct != 0))
	return(DSM_ERROR_NETWORK);

  return(0);
}

int
smb_directory_create(smb_session *s, smb_tid tid, const char *path)
{
  smb_message *req_msg, resp_msg;
  smb_directory_mk_req req;
  smb_directory_mk_resp *resp;
  size_t utf_pattern_len;
  char *utf_pattern;

  assert(s != NULL && path != NULL);

  utf_pattern_len = smb_to_utf16(path, strlen(path) + 1, &utf_pattern);
  if (utf_pattern_len == 0)
	return(DSM_ERROR_CHARSET);

  req_msg = smb_message_new(SMB_CMD_MKDIR);
  if (!req_msg) {
	free(utf_pattern);
	return(DSM_ERROR_GENERIC);
  }

  req_msg->packet->header.tid = (uint16_t) tid;

  SMB_MSG_INIT_PKT(req);
  req.wct = 0x00; // Must be 0
  req.bct = (uint16_t) (utf_pattern_len + 1);
  req.buffer_format = 0x04; // Must be 4
  SMB_MSG_PUT_PKT(req_msg, req);
  smb_message_append(req_msg, utf_pattern, utf_pattern_len);

  smb_session_send_msg(s, req_msg);
  smb_message_destroy(req_msg);

  free(utf_pattern);

  if (!smb_session_recv_msg(s, &resp_msg))
	return(DSM_ERROR_NETWORK);

  if (!smb_session_check_nt_status(s, &resp_msg))
	return(DSM_ERROR_NT);

  resp = (smb_directory_mk_resp *) resp_msg.packet->payload;
  if ((resp->wct != 0) || (resp->bct != 0))
	return(DSM_ERROR_NETWORK);

  return(0);
}
