# Generated by Django 3.2.12 on 2023-05-18 08:57

import django.contrib.auth.models
import django.contrib.auth.validators
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'password',
                    models.CharField(max_length=128, verbose_name='password'),
                ),
                (
                    'last_login',
                    models.DateTimeField(
                        blank=True, null=True, verbose_name='last login'
                    ),
                ),
                (
                    'is_superuser',
                    models.BooleanField(
                        default=False,
                        help_text='Designates that this user has all permissions without explicitly assigning them.',
                        verbose_name='superuser status',
                    ),
                ),
                (
                    'username',
                    models.CharField(
                        error_messages={
                            'unique': 'A user with that username already exists.'
                        },
                        help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name='username',
                    ),
                ),
                (
                    'first_name',
                    models.CharField(
                        blank=True, max_length=150, verbose_name='first name'
                    ),
                ),
                (
                    'last_name',
                    models.CharField(
                        blank=True, max_length=150, verbose_name='last name'
                    ),
                ),
                (
                    'is_staff',
                    models.BooleanField(
                        default=False,
                        help_text='Designates whether the user can log into this admin site.',
                        verbose_name='staff status',
                    ),
                ),
                (
                    'is_active',
                    models.BooleanField(
                        default=True,
                        help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.',
                        verbose_name='active',
                    ),
                ),
                (
                    'date_joined',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name='date joined',
                    ),
                ),
                ('email', models.EmailField(max_length=254, unique=True)),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Artifact',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('category', models.CharField(max_length=255)),
                ('data', models.JSONField(blank=True, default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('expire_at', models.DateTimeField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ArtifactRelation',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'type',
                    models.CharField(
                        choices=[
                            ('extends', 'Extends'),
                            ('relates-to', 'Relates to'),
                            ('built-using', 'Built using'),
                        ],
                        max_length=11,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'sha256',
                    models.BinaryField(
                        help_text='sha256 of the file', max_length=4
                    ),
                ),
                (
                    'size',
                    models.PositiveBigIntegerField(
                        help_text='Size in bytes of the file'
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='FileInArtifact',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('path', models.CharField(max_length=500)),
                (
                    'artifact',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.artifact',
                    ),
                ),
                (
                    'file',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.file',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='FileInStore',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('data', models.JSONField(blank=True, default=dict)),
                (
                    'file',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.file',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='FileStore',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('name', models.CharField(max_length=255, unique=True)),
                (
                    'backend',
                    models.CharField(
                        choices=[('Local', 'Local')], max_length=5
                    ),
                ),
                ('configuration', models.JSONField(blank=True, default=dict)),
                (
                    'files',
                    models.ManyToManyField(
                        through='db.FileInStore', to='db.File'
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Token',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=64,
                        unique=True,
                        validators=[
                            django.core.validators.MaxLengthValidator(64),
                            django.core.validators.MinLengthValidator(64),
                        ],
                        verbose_name='Hexadecimal key, length is 64 chars',
                    ),
                ),
                (
                    'owner',
                    models.CharField(
                        max_length=150, verbose_name='Owner, for traceability'
                    ),
                ),
                (
                    'comment',
                    models.CharField(
                        default='',
                        max_length=100,
                        verbose_name='Reason that this token was created',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('enabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Worker',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'name',
                    models.SlugField(
                        help_text='Human readable name of the worker based on the FQDN',
                        unique=True,
                    ),
                ),
                ('registered_at', models.DateTimeField()),
                ('connected_at', models.DateTimeField(blank=True, null=True)),
                ('static_metadata', models.JSONField(blank=True, default=dict)),
                (
                    'dynamic_metadata',
                    models.JSONField(blank=True, default=dict),
                ),
                (
                    'dynamic_metadata_updated_at',
                    models.DateTimeField(blank=True, null=True),
                ),
                (
                    'token',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='worker',
                        to='db.token',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Workspace',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('name', models.CharField(max_length=255, unique=True)),
                ('public', models.BooleanField(default=False)),
                (
                    'default_file_store',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='default_workspaces',
                        to='db.filestore',
                    ),
                ),
                (
                    'other_file_stores',
                    models.ManyToManyField(
                        related_name='other_workspaces', to='db.FileStore'
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='WorkRequest',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('pending', 'Pending'),
                            ('running', 'Running'),
                            ('completed', 'Completed'),
                            ('aborted', 'Aborted'),
                        ],
                        default='pending',
                        editable=False,
                        max_length=9,
                    ),
                ),
                (
                    'result',
                    models.CharField(
                        choices=[
                            ('', ''),
                            ('success', 'Success'),
                            ('failure', 'Failure'),
                            ('error', 'Error'),
                        ],
                        default='',
                        editable=False,
                        max_length=7,
                    ),
                ),
                (
                    'task_name',
                    models.CharField(
                        max_length=100,
                        verbose_name='Name of the task to execute',
                    ),
                ),
                ('task_data', models.JSONField(blank=True, default=dict)),
                (
                    'worker',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='assigned_work_requests',
                        to='db.worker',
                    ),
                ),
                (
                    'workspace',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.workspace',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='FileUpload',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'path',
                    models.CharField(
                        help_text='Path in the uploads directory',
                        max_length=500,
                        unique=True,
                    ),
                ),
                ('last_activity_at', models.DateTimeField(auto_now_add=True)),
                (
                    'file_in_artifact',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.fileinartifact',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='fileinstore',
            name='store',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to='db.filestore'
            ),
        ),
        migrations.AddConstraint(
            model_name='file',
            constraint=models.UniqueConstraint(
                fields=('sha256', 'size'), name='Hash-size must be unique'
            ),
        ),
        migrations.AddConstraint(
            model_name='file',
            constraint=models.CheckConstraint(
                check=models.Q(('sha256', b''), _negated=True),
                name='sha256 cannot be empty',
            ),
        ),
        migrations.AddField(
            model_name='artifactrelation',
            name='artifact',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name='relations',
                to='db.artifact',
            ),
        ),
        migrations.AddField(
            model_name='artifactrelation',
            name='target',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name='targeted_by',
                to='db.artifact',
            ),
        ),
        migrations.AddField(
            model_name='artifact',
            name='created_by_work_request',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to='db.workrequest',
            ),
        ),
        migrations.AddField(
            model_name='artifact',
            name='files',
            field=models.ManyToManyField(
                through='db.FileInArtifact', to='db.File'
            ),
        ),
        migrations.AddField(
            model_name='artifact',
            name='workspace',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to='db.workspace'
            ),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(
                blank=True,
                help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.',
                related_name='user_set',
                related_query_name='user',
                to='auth.Group',
                verbose_name='groups',
            ),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(
                blank=True,
                help_text='Specific permissions for this user.',
                related_name='user_set',
                related_query_name='user',
                to='auth.Permission',
                verbose_name='user permissions',
            ),
        ),
        migrations.AddConstraint(
            model_name='fileinstore',
            constraint=models.UniqueConstraint(
                fields=('store', 'file'), name='Unique_StoreFile'
            ),
        ),
        migrations.AddConstraint(
            model_name='fileinartifact',
            constraint=models.UniqueConstraint(
                fields=('artifact', 'path'), name='artifact_path_unique'
            ),
        ),
        migrations.AddConstraint(
            model_name='artifactrelation',
            constraint=models.UniqueConstraint(
                fields=('artifact', 'target', 'type'),
                name='ArtifactRelations_must_be_unique',
            ),
        ),
    ]
