# Generated by Django 3.2.19 on 2024-02-27 15:33

from django.db import migrations, models
import django.db.models.expressions


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0020_alter_filestore_backend'),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name='artifactrelation',
            name='ArtifactRelations_must_be_unique',
        ),
        migrations.RemoveConstraint(
            model_name='collection',
            name='unique_name_category',
        ),
        migrations.RemoveConstraint(
            model_name='collection',
            name='collection_name_not_empty',
        ),
        migrations.RemoveConstraint(
            model_name='collection',
            name='collection_category_not_empty',
        ),
        migrations.RemoveConstraint(
            model_name='collectionitem',
            name='unique_active_name_within_collectionitem',
        ),
        migrations.RemoveConstraint(
            model_name='collectionitem',
            name='collectionitem_parent_collection_cannot_be_same_as_collection',
        ),
        migrations.RemoveConstraint(
            model_name='collectionitem',
            name='collectionitem_type_removed_at_consistent',
        ),
        migrations.RemoveConstraint(
            model_name='file',
            name='Hash-size must be unique',
        ),
        migrations.RemoveConstraint(
            model_name='file',
            name='sha256 cannot be empty',
        ),
        migrations.RemoveConstraint(
            model_name='fileinartifact',
            name='artifact_path_unique',
        ),
        migrations.RemoveConstraint(
            model_name='fileinstore',
            name='Unique_StoreFile',
        ),
        migrations.RemoveConstraint(
            model_name='identity',
            name='Each issuer must have unique subjects',
        ),
        migrations.AddConstraint(
            model_name='artifactrelation',
            constraint=models.UniqueConstraint(
                fields=('artifact', 'target', 'type'),
                name='db_artifactrelation_unique_artifact_target_type',
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.UniqueConstraint(
                fields=('name', 'category'),
                name='db_collection_unique_name_category',
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.CheckConstraint(
                check=models.Q(('name', ''), _negated=True),
                name='db_collection_name_not_empty',
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.CheckConstraint(
                check=models.Q(('category', ''), _negated=True),
                name='db_collection_category_not_empty',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.UniqueConstraint(
                condition=models.Q(('removed_at__isnull', True)),
                fields=('name', 'child_type', 'parent_collection'),
                name='db_collectionitem_unique_active_name',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.CheckConstraint(
                check=models.Q(
                    (
                        'collection',
                        django.db.models.expressions.F('parent_collection'),
                    ),
                    _negated=True,
                ),
                name='db_collectionitem_distinct_parent_collection',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ('artifact__isnull', True),
                        ('child_type', 'b'),
                        ('collection__isnull', True),
                    ),
                    models.Q(
                        ('child_type', 'a'),
                        ('collection__isnull', True),
                        models.Q(
                            ('artifact__isnull', False),
                            ('removed_at__isnull', False),
                            _connector='OR',
                        ),
                    ),
                    models.Q(
                        ('artifact__isnull', True),
                        ('child_type', 'c'),
                        models.Q(
                            ('collection__isnull', False),
                            ('removed_at__isnull', False),
                            _connector='OR',
                        ),
                    ),
                    _connector='OR',
                ),
                name='db_collectionitem_childtype_removedat_consistent',
            ),
        ),
        migrations.AddConstraint(
            model_name='file',
            constraint=models.UniqueConstraint(
                fields=('sha256', 'size'), name='db_file_unique_sha256_size'
            ),
        ),
        migrations.AddConstraint(
            model_name='file',
            constraint=models.CheckConstraint(
                check=models.Q(('sha256', b''), _negated=True),
                name='db_file_sha256_not_empty',
            ),
        ),
        migrations.AddConstraint(
            model_name='fileinartifact',
            constraint=models.UniqueConstraint(
                fields=('artifact', 'path'),
                name='db_fileinartifact_unique_artifact_path',
            ),
        ),
        migrations.AddConstraint(
            model_name='fileinstore',
            constraint=models.UniqueConstraint(
                fields=('store', 'file'),
                name='db_fileinstore_unique_store_file',
            ),
        ),
        migrations.AddConstraint(
            model_name='identity',
            constraint=models.UniqueConstraint(
                fields=('issuer', 'subject'),
                name='db_identity_unique_issuer_subject',
            ),
        ),
    ]
