// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Data.Common;
using System.Diagnostics.CodeAnalysis;

namespace System.Data.OleDb
{
    [RequiresDynamicCode(OleDbConnection.TrimWarning)]
    public sealed class OleDbFactory : DbProviderFactory
    {
        public static readonly OleDbFactory Instance = new OleDbFactory();

        private OleDbFactory()
        {
        }

        public override DbCommand CreateCommand()
        {
            return new OleDbCommand();
        }

        public override DbCommandBuilder CreateCommandBuilder()
        {
            return new OleDbCommandBuilder();
        }

        public override DbConnection CreateConnection()
        {
            return new OleDbConnection();
        }

        public override DbConnectionStringBuilder CreateConnectionStringBuilder()
        {
            return new OleDbConnectionStringBuilder();
        }

        public override DbDataAdapter CreateDataAdapter()
        {
            return new OleDbDataAdapter();
        }

        public override DbParameter CreateParameter()
        {
            return new OleDbParameter();
        }

    }
}
