/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.parser;

import javax.swing.JCheckBox;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;
import org.emboss.jemboss.gui.form.TextFieldSink;
import org.emboss.jemboss.parser.ParseAcd;

public class AcdVarResolve {
    private String exp;

    public AcdVarResolve(String exp, String val, String varName, ParseAcd parseAcd, int nof, TextFieldSink[] textf, TextFieldInt[] textInt, TextFieldFloat[] textFloat, JembossComboPopup[] fieldOption, JCheckBox[] checkBox) {
        RECompiler rec = new RECompiler();
        try {
            exp = exp.replace('\n', ' ');
            REProgram varexp = rec.compile("^(.*)\\$\\(([a-zA-Z0-9_.]+)\\)");
            RE regvarexp = new RE(varexp);
            while (regvarexp.match(exp)) {
                String var = regvarexp.getParen(2);
                String res = "";
                if (var.endsWith("acdprotein")) {
                    res = new Boolean(SectionPanel.ajaxProtein).toString();
                } else if (var.endsWith(".length") || var.endsWith(".end")) {
                    res = new Integer(SectionPanel.ajaxLength).toString();
                } else if (var.endsWith(".begin")) {
                    res = "0";
                } else if (var.endsWith(".totweight")) {
                    res = new Float(SectionPanel.ajaxWeight).toString();
                } else if (var.equals(varName)) {
                    res = val;
                } else {
                    res = new String("UnresolvedToken" + var);
                    for (int i = 0; i < nof; ++i) {
                        if (!parseAcd.getParamValueStr(i, 0).equals(var)) continue;
                        String att = parseAcd.getParameterAttribute(i, 0).toLowerCase();
                        int h = parseAcd.getGuiHandleNumber(i);
                        if (att.startsWith("datafile") || att.startsWith("featout") || att.startsWith("string") || att.startsWith("seqout") || att.startsWith("outfile") || att.startsWith("matrix") || att.startsWith("infile") || att.startsWith("regexp") || att.startsWith("codon") || att.startsWith("features")) {
                            if (textf[h].getText().equals("")) break;
                            res = textf[h].getText();
                            break;
                        }
                        if (att.startsWith("int")) {
                            if (textInt[h].getText() == null) break;
                            res = Integer.toString(textInt[h].getValue());
                            break;
                        }
                        if (att.startsWith("float")) {
                            if (textFloat[h].getText() == null) break;
                            res = Double.toString(textFloat[h].getValue());
                            break;
                        }
                        if (att.startsWith("select")) {
                            res = new Integer(fieldOption[h].getSelectedIndex() + 1).toString();
                            break;
                        }
                        if (att.startsWith("list")) {
                            int index = fieldOption[h].getSelectedIndex();
                            res = parseAcd.getListLabel(i, index);
                            break;
                        }
                        if (!att.startsWith("bool")) break;
                        if (checkBox[h].isSelected()) {
                            res = new String("true");
                            break;
                        }
                        res = new String("false");
                        break;
                    }
                }
                int iend = regvarexp.getParenEnd(1);
                String newvar = exp.substring(0, iend);
                iend = regvarexp.getParenEnd(2);
                newvar = newvar.concat(res);
                newvar = newvar.concat(exp.substring(iend + 1));
                exp = new String(newvar);
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        this.exp = exp;
    }

    public String getResult() {
        return this.exp;
    }
}

