/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Sequence;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreMatrix;

public class BinarySequence
extends Sequence {
    int[] binary;
    double[] dbinary;

    public BinarySequence(String s) {
        super("", s, 0, s.length());
    }

    public void encode() {
        int i;
        this.dbinary = new double[this.getSequence().length * 21];
        int nores = 21;
        for (i = 0; i < this.dbinary.length; ++i) {
            this.dbinary[i] = 0.0;
        }
        for (i = 0; i < this.getSequence().length; ++i) {
            int aanum = 20;
            try {
                aanum = ResidueProperties.aaIndex[this.getCharAt(i)];
            }
            catch (NullPointerException e) {
                aanum = 20;
            }
            if (aanum > 20) {
                aanum = 20;
            }
            this.dbinary[i * nores + aanum] = 1.0;
        }
    }

    public void matrixEncode(ScoreMatrix matrix) {
        this.matrixEncode(matrix.isDNA() ? ResidueProperties.nucleotideIndex : ResidueProperties.aaIndex, matrix.getMatrix());
    }

    public void blosumEncode() {
        this.matrixEncode(ResidueProperties.aaIndex, ResidueProperties.getBLOSUM62());
    }

    private void matrixEncode(int[] aaIndex, int[][] matrix) {
        this.dbinary = new double[this.getSequence().length * 21];
        int nores = 21;
        for (int i = 0; i < this.getSequence().length; ++i) {
            int aanum = 20;
            try {
                aanum = aaIndex[this.getCharAt(i)];
            }
            catch (NullPointerException e) {
                aanum = 20;
            }
            if (aanum > 20) {
                aanum = 20;
            }
            for (int j = 0; j < 20; ++j) {
                this.dbinary[i * nores + j] = matrix[aanum][j];
            }
        }
    }

    public String toBinaryString() {
        String out = "";
        for (int i = 0; i < this.binary.length; ++i) {
            out = out + new Integer(this.binary[i]).toString();
            if (i >= this.binary.length - 1) continue;
            out = out + " ";
        }
        return out;
    }

    public double[] getDBinary() {
        return this.dbinary;
    }
}

