// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitsetsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "bitsetsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "bitsets.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

void register_InnerTypedBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_InnerTypedBitsetHelper)
{
    ReturnCode_t return_code_InnerTypedBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerTypedBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerTypedBitsetHelper", type_ids_InnerTypedBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerTypedBitsetHelper)
    {
        BitsetTypeFlag bitset_flags_InnerTypedBitsetHelper = 0;
        QualifiedTypeName type_name_InnerTypedBitsetHelper = "InnerTypedBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerTypedBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerTypedBitsetHelper;
        CompleteTypeDetail detail_InnerTypedBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerTypedBitsetHelper, ann_custom_InnerTypedBitsetHelper, type_name_InnerTypedBitsetHelper.to_string());
        CompleteBitsetHeader header_InnerTypedBitsetHelper = TypeObjectUtils::build_complete_bitset_header(detail_InnerTypedBitsetHelper);
        CompleteBitfieldSeq field_seq_InnerTypedBitsetHelper;
        {
            uint16_t position_boolean_bitfield = 0;
            BitsetMemberFlag flags_boolean_bitfield = 0;
            uint8_t bitcount_boolean_bitfield = 1;
            TypeKind holder_type_boolean_bitfield = TK_BOOLEAN;
            CommonBitfield common_boolean_bitfield = TypeObjectUtils::build_common_bitfield(position_boolean_bitfield, flags_boolean_bitfield, bitcount_boolean_bitfield, holder_type_boolean_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_boolean_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_boolean_bitfield = "boolean_bitfield";
            CompleteMemberDetail detail_boolean_bitfield = TypeObjectUtils::build_complete_member_detail(name_boolean_bitfield, member_ann_builtin_boolean_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_boolean_bitfield = TypeObjectUtils::build_complete_bitfield(common_boolean_bitfield, detail_boolean_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_boolean_bitfield);
        }
        {
            uint16_t position_byte_bitfield = 1;
            BitsetMemberFlag flags_byte_bitfield = 0;
            uint8_t bitcount_byte_bitfield = 8;
            TypeKind holder_type_byte_bitfield = TK_BYTE;
            CommonBitfield common_byte_bitfield = TypeObjectUtils::build_common_bitfield(position_byte_bitfield, flags_byte_bitfield, bitcount_byte_bitfield, holder_type_byte_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_byte_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_byte_bitfield = "byte_bitfield";
            CompleteMemberDetail detail_byte_bitfield = TypeObjectUtils::build_complete_member_detail(name_byte_bitfield, member_ann_builtin_byte_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_byte_bitfield = TypeObjectUtils::build_complete_bitfield(common_byte_bitfield, detail_byte_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_byte_bitfield);
        }
        {
            uint16_t position_int8_bitfield = 9;
            BitsetMemberFlag flags_int8_bitfield = 0;
            uint8_t bitcount_int8_bitfield = 8;
            TypeKind holder_type_int8_bitfield = TK_INT8;
            CommonBitfield common_int8_bitfield = TypeObjectUtils::build_common_bitfield(position_int8_bitfield, flags_int8_bitfield, bitcount_int8_bitfield, holder_type_int8_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int8_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_int8_bitfield = "int8_bitfield";
            CompleteMemberDetail detail_int8_bitfield = TypeObjectUtils::build_complete_member_detail(name_int8_bitfield, member_ann_builtin_int8_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_int8_bitfield = TypeObjectUtils::build_complete_bitfield(common_int8_bitfield, detail_int8_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_int8_bitfield);
        }
        {
            uint16_t position_uint8_bitfield = 17;
            BitsetMemberFlag flags_uint8_bitfield = 0;
            uint8_t bitcount_uint8_bitfield = 8;
            TypeKind holder_type_uint8_bitfield = TK_UINT8;
            CommonBitfield common_uint8_bitfield = TypeObjectUtils::build_common_bitfield(position_uint8_bitfield, flags_uint8_bitfield, bitcount_uint8_bitfield, holder_type_uint8_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint8_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_uint8_bitfield = "uint8_bitfield";
            CompleteMemberDetail detail_uint8_bitfield = TypeObjectUtils::build_complete_member_detail(name_uint8_bitfield, member_ann_builtin_uint8_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_uint8_bitfield = TypeObjectUtils::build_complete_bitfield(common_uint8_bitfield, detail_uint8_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_uint8_bitfield);
        }
        {
            uint16_t position_short_bitfield = 25;
            BitsetMemberFlag flags_short_bitfield = 0;
            uint8_t bitcount_short_bitfield = 16;
            TypeKind holder_type_short_bitfield = TK_INT16;
            CommonBitfield common_short_bitfield = TypeObjectUtils::build_common_bitfield(position_short_bitfield, flags_short_bitfield, bitcount_short_bitfield, holder_type_short_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_short_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_short_bitfield = "short_bitfield";
            CompleteMemberDetail detail_short_bitfield = TypeObjectUtils::build_complete_member_detail(name_short_bitfield, member_ann_builtin_short_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_short_bitfield = TypeObjectUtils::build_complete_bitfield(common_short_bitfield, detail_short_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_short_bitfield);
        }
        {
            uint16_t position_ushort_bitfield = 41;
            BitsetMemberFlag flags_ushort_bitfield = 0;
            uint8_t bitcount_ushort_bitfield = 16;
            TypeKind holder_type_ushort_bitfield = TK_UINT16;
            CommonBitfield common_ushort_bitfield = TypeObjectUtils::build_common_bitfield(position_ushort_bitfield, flags_ushort_bitfield, bitcount_ushort_bitfield, holder_type_ushort_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ushort_bitfield;
            ann_custom_InnerTypedBitsetHelper.reset();
            MemberName name_ushort_bitfield = "ushort_bitfield";
            CompleteMemberDetail detail_ushort_bitfield = TypeObjectUtils::build_complete_member_detail(name_ushort_bitfield, member_ann_builtin_ushort_bitfield, ann_custom_InnerTypedBitsetHelper);
            CompleteBitfield bitfield_ushort_bitfield = TypeObjectUtils::build_complete_bitfield(common_ushort_bitfield, detail_ushort_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper, bitfield_ushort_bitfield);
        }
        CompleteBitsetType bitset_type_InnerTypedBitsetHelper = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerTypedBitsetHelper, header_InnerTypedBitsetHelper, field_seq_InnerTypedBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerTypedBitsetHelper,
                    type_name_InnerTypedBitsetHelper.to_string(), type_ids_InnerTypedBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerTypedBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_InnerTypedBitsetHelper2_type_identifier(
        TypeIdentifierPair& type_ids_InnerTypedBitsetHelper2)
{
    ReturnCode_t return_code_InnerTypedBitsetHelper2 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerTypedBitsetHelper2 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerTypedBitsetHelper2", type_ids_InnerTypedBitsetHelper2);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerTypedBitsetHelper2)
    {
        BitsetTypeFlag bitset_flags_InnerTypedBitsetHelper2 = 0;
        QualifiedTypeName type_name_InnerTypedBitsetHelper2 = "InnerTypedBitsetHelper2";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerTypedBitsetHelper2;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerTypedBitsetHelper2;
        CompleteTypeDetail detail_InnerTypedBitsetHelper2 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerTypedBitsetHelper2, ann_custom_InnerTypedBitsetHelper2, type_name_InnerTypedBitsetHelper2.to_string());
        CompleteBitsetHeader header_InnerTypedBitsetHelper2 = TypeObjectUtils::build_complete_bitset_header(detail_InnerTypedBitsetHelper2);
        CompleteBitfieldSeq field_seq_InnerTypedBitsetHelper2;
        {
            uint16_t position_long_bitfield = 0;
            BitsetMemberFlag flags_long_bitfield = 0;
            uint8_t bitcount_long_bitfield = 32;
            TypeKind holder_type_long_bitfield = TK_INT32;
            CommonBitfield common_long_bitfield = TypeObjectUtils::build_common_bitfield(position_long_bitfield, flags_long_bitfield, bitcount_long_bitfield, holder_type_long_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_long_bitfield;
            ann_custom_InnerTypedBitsetHelper2.reset();
            MemberName name_long_bitfield = "long_bitfield";
            CompleteMemberDetail detail_long_bitfield = TypeObjectUtils::build_complete_member_detail(name_long_bitfield, member_ann_builtin_long_bitfield, ann_custom_InnerTypedBitsetHelper2);
            CompleteBitfield bitfield_long_bitfield = TypeObjectUtils::build_complete_bitfield(common_long_bitfield, detail_long_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper2, bitfield_long_bitfield);
        }
        {
            uint16_t position_ulong_bitfield = 32;
            BitsetMemberFlag flags_ulong_bitfield = 0;
            uint8_t bitcount_ulong_bitfield = 32;
            TypeKind holder_type_ulong_bitfield = TK_UINT32;
            CommonBitfield common_ulong_bitfield = TypeObjectUtils::build_common_bitfield(position_ulong_bitfield, flags_ulong_bitfield, bitcount_ulong_bitfield, holder_type_ulong_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ulong_bitfield;
            ann_custom_InnerTypedBitsetHelper2.reset();
            MemberName name_ulong_bitfield = "ulong_bitfield";
            CompleteMemberDetail detail_ulong_bitfield = TypeObjectUtils::build_complete_member_detail(name_ulong_bitfield, member_ann_builtin_ulong_bitfield, ann_custom_InnerTypedBitsetHelper2);
            CompleteBitfield bitfield_ulong_bitfield = TypeObjectUtils::build_complete_bitfield(common_ulong_bitfield, detail_ulong_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper2, bitfield_ulong_bitfield);
        }
        CompleteBitsetType bitset_type_InnerTypedBitsetHelper2 = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerTypedBitsetHelper2, header_InnerTypedBitsetHelper2, field_seq_InnerTypedBitsetHelper2);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerTypedBitsetHelper2,
                    type_name_InnerTypedBitsetHelper2.to_string(), type_ids_InnerTypedBitsetHelper2))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerTypedBitsetHelper2 already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_InnerTypedBitsetHelper3_type_identifier(
        TypeIdentifierPair& type_ids_InnerTypedBitsetHelper3)
{
    ReturnCode_t return_code_InnerTypedBitsetHelper3 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerTypedBitsetHelper3 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerTypedBitsetHelper3", type_ids_InnerTypedBitsetHelper3);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerTypedBitsetHelper3)
    {
        BitsetTypeFlag bitset_flags_InnerTypedBitsetHelper3 = 0;
        QualifiedTypeName type_name_InnerTypedBitsetHelper3 = "InnerTypedBitsetHelper3";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerTypedBitsetHelper3;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerTypedBitsetHelper3;
        CompleteTypeDetail detail_InnerTypedBitsetHelper3 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerTypedBitsetHelper3, ann_custom_InnerTypedBitsetHelper3, type_name_InnerTypedBitsetHelper3.to_string());
        CompleteBitsetHeader header_InnerTypedBitsetHelper3 = TypeObjectUtils::build_complete_bitset_header(detail_InnerTypedBitsetHelper3);
        CompleteBitfieldSeq field_seq_InnerTypedBitsetHelper3;
        {
            uint16_t position_long_long_bitfield = 0;
            BitsetMemberFlag flags_long_long_bitfield = 0;
            uint8_t bitcount_long_long_bitfield = 64;
            TypeKind holder_type_long_long_bitfield = TK_INT64;
            CommonBitfield common_long_long_bitfield = TypeObjectUtils::build_common_bitfield(position_long_long_bitfield, flags_long_long_bitfield, bitcount_long_long_bitfield, holder_type_long_long_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_long_long_bitfield;
            ann_custom_InnerTypedBitsetHelper3.reset();
            MemberName name_long_long_bitfield = "long_long_bitfield";
            CompleteMemberDetail detail_long_long_bitfield = TypeObjectUtils::build_complete_member_detail(name_long_long_bitfield, member_ann_builtin_long_long_bitfield, ann_custom_InnerTypedBitsetHelper3);
            CompleteBitfield bitfield_long_long_bitfield = TypeObjectUtils::build_complete_bitfield(common_long_long_bitfield, detail_long_long_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper3, bitfield_long_long_bitfield);
        }
        CompleteBitsetType bitset_type_InnerTypedBitsetHelper3 = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerTypedBitsetHelper3, header_InnerTypedBitsetHelper3, field_seq_InnerTypedBitsetHelper3);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerTypedBitsetHelper3,
                    type_name_InnerTypedBitsetHelper3.to_string(), type_ids_InnerTypedBitsetHelper3))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerTypedBitsetHelper3 already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_InnerTypedBitsetHelper4_type_identifier(
        TypeIdentifierPair& type_ids_InnerTypedBitsetHelper4)
{
    ReturnCode_t return_code_InnerTypedBitsetHelper4 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerTypedBitsetHelper4 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerTypedBitsetHelper4", type_ids_InnerTypedBitsetHelper4);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerTypedBitsetHelper4)
    {
        BitsetTypeFlag bitset_flags_InnerTypedBitsetHelper4 = 0;
        QualifiedTypeName type_name_InnerTypedBitsetHelper4 = "InnerTypedBitsetHelper4";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerTypedBitsetHelper4;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerTypedBitsetHelper4;
        CompleteTypeDetail detail_InnerTypedBitsetHelper4 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerTypedBitsetHelper4, ann_custom_InnerTypedBitsetHelper4, type_name_InnerTypedBitsetHelper4.to_string());
        CompleteBitsetHeader header_InnerTypedBitsetHelper4 = TypeObjectUtils::build_complete_bitset_header(detail_InnerTypedBitsetHelper4);
        CompleteBitfieldSeq field_seq_InnerTypedBitsetHelper4;
        {
            uint16_t position_ulong_long_bitfield = 0;
            BitsetMemberFlag flags_ulong_long_bitfield = 0;
            uint8_t bitcount_ulong_long_bitfield = 64;
            TypeKind holder_type_ulong_long_bitfield = TK_UINT64;
            CommonBitfield common_ulong_long_bitfield = TypeObjectUtils::build_common_bitfield(position_ulong_long_bitfield, flags_ulong_long_bitfield, bitcount_ulong_long_bitfield, holder_type_ulong_long_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ulong_long_bitfield;
            ann_custom_InnerTypedBitsetHelper4.reset();
            MemberName name_ulong_long_bitfield = "ulong_long_bitfield";
            CompleteMemberDetail detail_ulong_long_bitfield = TypeObjectUtils::build_complete_member_detail(name_ulong_long_bitfield, member_ann_builtin_ulong_long_bitfield, ann_custom_InnerTypedBitsetHelper4);
            CompleteBitfield bitfield_ulong_long_bitfield = TypeObjectUtils::build_complete_bitfield(common_ulong_long_bitfield, detail_ulong_long_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerTypedBitsetHelper4, bitfield_ulong_long_bitfield);
        }
        CompleteBitsetType bitset_type_InnerTypedBitsetHelper4 = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerTypedBitsetHelper4, header_InnerTypedBitsetHelper4, field_seq_InnerTypedBitsetHelper4);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerTypedBitsetHelper4,
                    type_name_InnerTypedBitsetHelper4.to_string(), type_ids_InnerTypedBitsetHelper4))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerTypedBitsetHelper4 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BitsetStruct_type_identifier(
        TypeIdentifierPair& type_ids_BitsetStruct)
{

    ReturnCode_t return_code_BitsetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitsetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BitsetStruct", type_ids_BitsetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitsetStruct)
    {
        StructTypeFlag struct_flags_BitsetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BitsetStruct = "BitsetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitsetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitsetStruct;
        CompleteTypeDetail detail_BitsetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitsetStruct, ann_custom_BitsetStruct, type_name_BitsetStruct.to_string());
        CompleteStructHeader header_BitsetStruct;
        header_BitsetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BitsetStruct);
        CompleteStructMemberSeq member_seq_BitsetStruct;
        {
            TypeIdentifierPair type_ids_var_InnerBitsetHelper;
            ReturnCode_t return_code_var_InnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerBitsetHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitsetHelper", type_ids_var_InnerBitsetHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerBitsetHelper)
            {
            ::register_InnerBitsetHelper_type_identifier(type_ids_var_InnerBitsetHelper);
            }
            StructMemberFlag member_flags_var_InnerBitsetHelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerBitsetHelper = 0x00000000;
            bool common_var_InnerBitsetHelper_ec {false};
            CommonStructMember common_var_InnerBitsetHelper {TypeObjectUtils::build_common_struct_member(member_id_var_InnerBitsetHelper, member_flags_var_InnerBitsetHelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerBitsetHelper, common_var_InnerBitsetHelper_ec))};
            if (!common_var_InnerBitsetHelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerBitsetHelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerBitsetHelper = "var_InnerBitsetHelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerBitsetHelper;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_var_InnerBitsetHelper = TypeObjectUtils::build_complete_member_detail(name_var_InnerBitsetHelper, member_ann_builtin_var_InnerBitsetHelper, ann_custom_BitsetStruct);
            CompleteStructMember member_var_InnerBitsetHelper = TypeObjectUtils::build_complete_struct_member(common_var_InnerBitsetHelper, detail_var_InnerBitsetHelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_var_InnerBitsetHelper);
        }
        {
            TypeIdentifierPair type_ids_var_InnerTypedBitsetHelper;
            ReturnCode_t return_code_var_InnerTypedBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerTypedBitsetHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerTypedBitsetHelper", type_ids_var_InnerTypedBitsetHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerTypedBitsetHelper)
            {
            ::register_InnerTypedBitsetHelper_type_identifier(type_ids_var_InnerTypedBitsetHelper);
            }
            StructMemberFlag member_flags_var_InnerTypedBitsetHelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerTypedBitsetHelper = 0x00000001;
            bool common_var_InnerTypedBitsetHelper_ec {false};
            CommonStructMember common_var_InnerTypedBitsetHelper {TypeObjectUtils::build_common_struct_member(member_id_var_InnerTypedBitsetHelper, member_flags_var_InnerTypedBitsetHelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerTypedBitsetHelper, common_var_InnerTypedBitsetHelper_ec))};
            if (!common_var_InnerTypedBitsetHelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerTypedBitsetHelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerTypedBitsetHelper = "var_InnerTypedBitsetHelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerTypedBitsetHelper;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_var_InnerTypedBitsetHelper = TypeObjectUtils::build_complete_member_detail(name_var_InnerTypedBitsetHelper, member_ann_builtin_var_InnerTypedBitsetHelper, ann_custom_BitsetStruct);
            CompleteStructMember member_var_InnerTypedBitsetHelper = TypeObjectUtils::build_complete_struct_member(common_var_InnerTypedBitsetHelper, detail_var_InnerTypedBitsetHelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_var_InnerTypedBitsetHelper);
        }
        {
            TypeIdentifierPair type_ids_var_InnerTypedBitsetHelper2;
            ReturnCode_t return_code_var_InnerTypedBitsetHelper2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerTypedBitsetHelper2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerTypedBitsetHelper2", type_ids_var_InnerTypedBitsetHelper2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerTypedBitsetHelper2)
            {
            ::register_InnerTypedBitsetHelper2_type_identifier(type_ids_var_InnerTypedBitsetHelper2);
            }
            StructMemberFlag member_flags_var_InnerTypedBitsetHelper2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerTypedBitsetHelper2 = 0x00000002;
            bool common_var_InnerTypedBitsetHelper2_ec {false};
            CommonStructMember common_var_InnerTypedBitsetHelper2 {TypeObjectUtils::build_common_struct_member(member_id_var_InnerTypedBitsetHelper2, member_flags_var_InnerTypedBitsetHelper2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerTypedBitsetHelper2, common_var_InnerTypedBitsetHelper2_ec))};
            if (!common_var_InnerTypedBitsetHelper2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerTypedBitsetHelper2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerTypedBitsetHelper2 = "var_InnerTypedBitsetHelper2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerTypedBitsetHelper2;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_var_InnerTypedBitsetHelper2 = TypeObjectUtils::build_complete_member_detail(name_var_InnerTypedBitsetHelper2, member_ann_builtin_var_InnerTypedBitsetHelper2, ann_custom_BitsetStruct);
            CompleteStructMember member_var_InnerTypedBitsetHelper2 = TypeObjectUtils::build_complete_struct_member(common_var_InnerTypedBitsetHelper2, detail_var_InnerTypedBitsetHelper2);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_var_InnerTypedBitsetHelper2);
        }
        {
            TypeIdentifierPair type_ids_var_InnerTypedBitsetHelper3;
            ReturnCode_t return_code_var_InnerTypedBitsetHelper3 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerTypedBitsetHelper3 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerTypedBitsetHelper3", type_ids_var_InnerTypedBitsetHelper3);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerTypedBitsetHelper3)
            {
            ::register_InnerTypedBitsetHelper3_type_identifier(type_ids_var_InnerTypedBitsetHelper3);
            }
            StructMemberFlag member_flags_var_InnerTypedBitsetHelper3 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerTypedBitsetHelper3 = 0x00000003;
            bool common_var_InnerTypedBitsetHelper3_ec {false};
            CommonStructMember common_var_InnerTypedBitsetHelper3 {TypeObjectUtils::build_common_struct_member(member_id_var_InnerTypedBitsetHelper3, member_flags_var_InnerTypedBitsetHelper3, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerTypedBitsetHelper3, common_var_InnerTypedBitsetHelper3_ec))};
            if (!common_var_InnerTypedBitsetHelper3_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerTypedBitsetHelper3 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerTypedBitsetHelper3 = "var_InnerTypedBitsetHelper3";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerTypedBitsetHelper3;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_var_InnerTypedBitsetHelper3 = TypeObjectUtils::build_complete_member_detail(name_var_InnerTypedBitsetHelper3, member_ann_builtin_var_InnerTypedBitsetHelper3, ann_custom_BitsetStruct);
            CompleteStructMember member_var_InnerTypedBitsetHelper3 = TypeObjectUtils::build_complete_struct_member(common_var_InnerTypedBitsetHelper3, detail_var_InnerTypedBitsetHelper3);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_var_InnerTypedBitsetHelper3);
        }
        {
            TypeIdentifierPair type_ids_var_InnerTypedBitsetHelper4;
            ReturnCode_t return_code_var_InnerTypedBitsetHelper4 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerTypedBitsetHelper4 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerTypedBitsetHelper4", type_ids_var_InnerTypedBitsetHelper4);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerTypedBitsetHelper4)
            {
            ::register_InnerTypedBitsetHelper4_type_identifier(type_ids_var_InnerTypedBitsetHelper4);
            }
            StructMemberFlag member_flags_var_InnerTypedBitsetHelper4 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerTypedBitsetHelper4 = 0x00000004;
            bool common_var_InnerTypedBitsetHelper4_ec {false};
            CommonStructMember common_var_InnerTypedBitsetHelper4 {TypeObjectUtils::build_common_struct_member(member_id_var_InnerTypedBitsetHelper4, member_flags_var_InnerTypedBitsetHelper4, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerTypedBitsetHelper4, common_var_InnerTypedBitsetHelper4_ec))};
            if (!common_var_InnerTypedBitsetHelper4_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerTypedBitsetHelper4 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerTypedBitsetHelper4 = "var_InnerTypedBitsetHelper4";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerTypedBitsetHelper4;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_var_InnerTypedBitsetHelper4 = TypeObjectUtils::build_complete_member_detail(name_var_InnerTypedBitsetHelper4, member_ann_builtin_var_InnerTypedBitsetHelper4, ann_custom_BitsetStruct);
            CompleteStructMember member_var_InnerTypedBitsetHelper4 = TypeObjectUtils::build_complete_struct_member(common_var_InnerTypedBitsetHelper4, detail_var_InnerTypedBitsetHelper4);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_var_InnerTypedBitsetHelper4);
        }
        CompleteStructType struct_type_BitsetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BitsetStruct, header_BitsetStruct, member_seq_BitsetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BitsetStruct, type_name_BitsetStruct.to_string(), type_ids_BitsetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BitsetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

