/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_DATA_IMPORT_
#define _H_DATA_IMPORT_

/* Common area */

#include <config.h>


/* Global Functions */

/**
 * Init data importer. It will launch a thread that import data from mplayer.
 *
 * @return 0 on success, -1 otherwise
 */
int data_import_init();

/**
 * Stop the data importer thread and clean up things.
 */
void data_import_quit();


#ifndef _C_DATA_IMPORT_

extern int16_t    sound_data[ 2048 ];     /**< imported data from mplayer (2ch, 512samples, 16bits)*/
extern SDL_mutex  *data_mutex;            /**< data mutex */
extern unsigned long long  data_counter;  /**< data counter */

#else // _C_DATA_IMPORT_

/*
 * Local Area: use only in data_import.c 
 */

#include <SDL.h>
#include <SDL/SDL_thread.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <fastmemcpy.h>
#include <errno.h>
#include <mpav.h>

typedef struct 
{
  int nch;
  int bs;
  unsigned long long count;
} data_t;

int fd = 0;
data_t *mmap_area = NULL;
int16_t sound_data[ 2 ][ 512 ];     /**< imported data from mplayer */
unsigned long long  data_counter=0; /**< data counter */
SDL_mutex *data_mutex = NULL;       /**< data mutex */

/* Local Vars */
static SDL_Thread *data_import_thread = NULL; /**< data_import thread pointer */

/* Local functions */

/**
 * Function to be launched as thread. Handle SDL data_imports
 */
void __data_import_thread_func();

#endif // _C_DATA_IMPORT_

#endif // _H_DATA_IMPORT_
