// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/controltower/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An operation performed by the control.
type ControlOperation struct {

	// The time that the operation finished.
	EndTime *time.Time

	// One of ENABLE_CONTROL or DISABLE_CONTROL .
	OperationType ControlOperationType

	// The time that the operation began.
	StartTime *time.Time

	// One of IN_PROGRESS , SUCEEDED , or FAILED .
	Status ControlOperationStatus

	// If the operation result is FAILED , this string contains a message explaining
	// why the operation failed.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The drift summary of the enabled control. Amazon Web Services Control Tower
// expects the enabled control configuration to include all supported and governed
// Regions. If the enabled control differs from the expected configuration, it is
// defined to be in a state of drift. You can repair this drift by resetting the
// enabled control.
type DriftStatusSummary struct {

	// The drift status of the enabled control. Valid values:
	//   - DRIFTED : The enabledControl deployed in this configuration doesn’t match
	//   the configuration that Amazon Web Services Control Tower expected.
	//   - IN_SYNC : The enabledControl deployed in this configuration matches the
	//   configuration that Amazon Web Services Control Tower expected.
	//   - NOT_CHECKING : Amazon Web Services Control Tower does not check drift for
	//   this enabled control. Drift is not supported for the control type.
	//   - UNKNOWN : Amazon Web Services Control Tower is not able to check the drift
	//   status for the enabled control.
	DriftStatus DriftStatus

	noSmithyDocumentSerde
}

// Information about the enabled control.
type EnabledControlDetails struct {

	// The ARN of the enabled control.
	Arn *string

	// The control identifier of the enabled control. For information on how to find
	// the controlIdentifier , see the overview page (https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html)
	// .
	ControlIdentifier *string

	// The drift status of the enabled control.
	DriftStatusSummary *DriftStatusSummary

	// Array of EnabledControlParameter objects.
	Parameters []EnabledControlParameterSummary

	// The deployment summary of the enabled control.
	StatusSummary *EnablementStatusSummary

	// The ARN of the organizational unit. For information on how to find the
	// targetIdentifier , see the overview page (https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html)
	// .
	TargetIdentifier *string

	// Target Amazon Web Services Regions for the enabled control.
	TargetRegions []Region

	noSmithyDocumentSerde
}

// A set of parameters that configure the behavior of the enabled control. A
// key/value pair, where Key is of type String and Value is of type Document .
type EnabledControlParameter struct {

	// The key of a key/value pair. It is of type string .
	//
	// This member is required.
	Key *string

	// The value of a key/value pair. It can be of type array string , number , object
	// , or boolean .
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Returns a summary of information about the parameters of an enabled control.
type EnabledControlParameterSummary struct {

	// The key of a key/value pair.
	//
	// This member is required.
	Key *string

	// The value of a key/value pair.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Returns a summary of information about an enabled control.
type EnabledControlSummary struct {

	// The ARN of the enabled control.
	Arn *string

	// The controlIdentifier of the enabled control.
	ControlIdentifier *string

	// The drift status of the enabled control.
	DriftStatusSummary *DriftStatusSummary

	// A short description of the status of the enabled control.
	StatusSummary *EnablementStatusSummary

	// The ARN of the organizational unit.
	TargetIdentifier *string

	noSmithyDocumentSerde
}

// The deployment summary of the enabled control.
type EnablementStatusSummary struct {

	// The last operation identifier for the enabled control.
	LastOperationIdentifier *string

	// The deployment status of the enabled control. Valid values:
	//   - SUCCEEDED : The enabledControl configuration was deployed successfully.
	//   - UNDER_CHANGE : The enabledControl configuration is changing.
	//   - FAILED : The enabledControl configuration failed to deploy.
	Status EnablementStatus

	noSmithyDocumentSerde
}

// Information about the landing zone.
type LandingZoneDetail struct {

	// The landing zone manifest JSON text file that specifies the landing zone
	// configurations.
	//
	// This member is required.
	Manifest document.Interface

	// The landing zone's current deployed version.
	//
	// This member is required.
	Version *string

	// The ARN of the landing zone.
	Arn *string

	// The drift status of the landing zone.
	DriftStatus *LandingZoneDriftStatusSummary

	// The latest available version of the landing zone.
	LatestAvailableVersion *string

	// The landing zone deployment status.
	Status LandingZoneStatus

	noSmithyDocumentSerde
}

// The drift status summary of the landing zone. If the landing zone differs from
// the expected configuration, it is defined to be in a state of drift. You can
// repair this drift by resetting the landing zone.
type LandingZoneDriftStatusSummary struct {

	// The drift status of the landing zone. Valid values:
	//   - DRIFTED : The landing zone deployed in this configuration does not match the
	//   configuration that Amazon Web Services Control Tower expected.
	//   - IN_SYNC : The landing zone deployed in this configuration matches the
	//   configuration that Amazon Web Services Control Tower expected.
	Status LandingZoneDriftStatus

	noSmithyDocumentSerde
}

// Information about a landing zone operation.
type LandingZoneOperationDetail struct {

	// The landing zone operation end time.
	EndTime *time.Time

	// The landing zone operation type. Valid values:
	//   - DELETE : The DeleteLandingZone operation.
	//   - CREATE : The CreateLandingZone operation.
	//   - UPDATE : The UpdateLandingZone operation.
	//   - RESET : The ResetLandingZone operation.
	OperationType LandingZoneOperationType

	// The landing zone operation start time.
	StartTime *time.Time

	// Valid values:
	//   - SUCCEEDED : The landing zone operation succeeded.
	//   - IN_PROGRESS : The landing zone operation is in progress.
	//   - FAILED : The landing zone operation failed.
	Status LandingZoneOperationStatus

	// If the operation result is FAILED, this string contains a message explaining
	// why the operation failed.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Returns a summary of information about a landing zone.
type LandingZoneSummary struct {

	// The ARN of the landing zone.
	Arn *string

	noSmithyDocumentSerde
}

// An Amazon Web Services Region in which Amazon Web Services Control Tower
// expects to find the control deployed. The expected Regions are based on the
// Regions that are governed by the landing zone. In certain cases, a control is
// not actually enabled in the Region as expected, such as during drift, or mixed
// governance (https://docs.aws.amazon.com/controltower/latest/userguide/region-how.html#mixed-governance)
// .
type Region struct {

	// The Amazon Web Services Region name.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
