// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteTerminology = "DeleteTerminology"

// DeleteTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTerminology for more information on using the DeleteTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTerminologyRequest method.
//    req, resp := client.DeleteTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminologyRequest(input *DeleteTerminologyInput) (req *request.Request, output *DeleteTerminologyOutput) {
	op := &request.Operation{
		Name:       opDeleteTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTerminologyInput{}
	}

	output = &DeleteTerminologyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTerminology API operation for Amazon Translate.
//
// A synchronous action that deletes a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DeleteTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminology(input *DeleteTerminologyInput) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	return out, req.Send()
}

// DeleteTerminologyWithContext is the same as DeleteTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DeleteTerminologyWithContext(ctx aws.Context, input *DeleteTerminologyInput, opts ...request.Option) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTextTranslationJob = "DescribeTextTranslationJob"

// DescribeTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTextTranslationJob for more information on using the DescribeTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTextTranslationJobRequest method.
//    req, resp := client.DescribeTextTranslationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob
func (c *Translate) DescribeTextTranslationJobRequest(input *DescribeTextTranslationJobInput) (req *request.Request, output *DescribeTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTextTranslationJobInput{}
	}

	output = &DescribeTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTextTranslationJob API operation for Amazon Translate.
//
// Gets the properties associated with an asycnhronous batch translation job
// including name, ID, status, source and target languages, input/output S3
// buckets, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DescribeTextTranslationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob
func (c *Translate) DescribeTextTranslationJob(input *DescribeTextTranslationJobInput) (*DescribeTextTranslationJobOutput, error) {
	req, out := c.DescribeTextTranslationJobRequest(input)
	return out, req.Send()
}

// DescribeTextTranslationJobWithContext is the same as DescribeTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DescribeTextTranslationJobWithContext(ctx aws.Context, input *DescribeTextTranslationJobInput, opts ...request.Option) (*DescribeTextTranslationJobOutput, error) {
	req, out := c.DescribeTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTerminology = "GetTerminology"

// GetTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the GetTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTerminology for more information on using the GetTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTerminologyRequest method.
//    req, resp := client.GetTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminologyRequest(input *GetTerminologyInput) (req *request.Request, output *GetTerminologyOutput) {
	op := &request.Operation{
		Name:       opGetTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTerminologyInput{}
	}

	output = &GetTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTerminology API operation for Amazon Translate.
//
// Retrieves a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation GetTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminology(input *GetTerminologyInput) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	return out, req.Send()
}

// GetTerminologyWithContext is the same as GetTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See GetTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) GetTerminologyWithContext(ctx aws.Context, input *GetTerminologyInput, opts ...request.Option) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportTerminology = "ImportTerminology"

// ImportTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the ImportTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportTerminology for more information on using the ImportTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportTerminologyRequest method.
//    req, resp := client.ImportTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminologyRequest(input *ImportTerminologyInput) (req *request.Request, output *ImportTerminologyOutput) {
	op := &request.Operation{
		Name:       opImportTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportTerminologyInput{}
	}

	output = &ImportTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportTerminology API operation for Amazon Translate.
//
// Creates or updates a custom terminology, depending on whether or not one
// already exists for the given terminology name. Importing a terminology with
// the same name as an existing one will merge the terminologies based on the
// chosen merge strategy. Currently, the only supported merge strategy is OVERWRITE,
// and so the imported terminology will overwrite an existing terminology of
// the same name.
//
// If you import a terminology that overwrites an existing one, the new terminology
// take up to 10 minutes to fully propagate and be available for use in a translation
// due to cache policies with the DataPlane service that performs the translations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ImportTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The specified limit has been exceeded. Review your request and retry it with
//   a quantity below the stated limit.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminology(input *ImportTerminologyInput) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	return out, req.Send()
}

// ImportTerminologyWithContext is the same as ImportTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See ImportTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ImportTerminologyWithContext(ctx aws.Context, input *ImportTerminologyInput, opts ...request.Option) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTerminologies = "ListTerminologies"

// ListTerminologiesRequest generates a "aws/request.Request" representing the
// client's request for the ListTerminologies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTerminologies for more information on using the ListTerminologies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTerminologiesRequest method.
//    req, resp := client.ListTerminologiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologiesRequest(input *ListTerminologiesInput) (req *request.Request, output *ListTerminologiesOutput) {
	op := &request.Operation{
		Name:       opListTerminologies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTerminologiesInput{}
	}

	output = &ListTerminologiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTerminologies API operation for Amazon Translate.
//
// Provides a list of custom terminologies associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListTerminologies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologies(input *ListTerminologiesInput) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	return out, req.Send()
}

// ListTerminologiesWithContext is the same as ListTerminologies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTerminologies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTerminologiesWithContext(ctx aws.Context, input *ListTerminologiesInput, opts ...request.Option) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTerminologiesPages iterates over the pages of a ListTerminologies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTerminologies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTerminologies operation.
//    pageNum := 0
//    err := client.ListTerminologiesPages(params,
//        func(page *translate.ListTerminologiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Translate) ListTerminologiesPages(input *ListTerminologiesInput, fn func(*ListTerminologiesOutput, bool) bool) error {
	return c.ListTerminologiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTerminologiesPagesWithContext same as ListTerminologiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTerminologiesPagesWithContext(ctx aws.Context, input *ListTerminologiesInput, fn func(*ListTerminologiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTerminologiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTerminologiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTerminologiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTextTranslationJobs = "ListTextTranslationJobs"

// ListTextTranslationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTextTranslationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTextTranslationJobs for more information on using the ListTextTranslationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTextTranslationJobsRequest method.
//    req, resp := client.ListTextTranslationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs
func (c *Translate) ListTextTranslationJobsRequest(input *ListTextTranslationJobsInput) (req *request.Request, output *ListTextTranslationJobsOutput) {
	op := &request.Operation{
		Name:       opListTextTranslationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTextTranslationJobsInput{}
	}

	output = &ListTextTranslationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTextTranslationJobs API operation for Amazon Translate.
//
// Gets a list of the batch translation jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListTextTranslationJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs
func (c *Translate) ListTextTranslationJobs(input *ListTextTranslationJobsInput) (*ListTextTranslationJobsOutput, error) {
	req, out := c.ListTextTranslationJobsRequest(input)
	return out, req.Send()
}

// ListTextTranslationJobsWithContext is the same as ListTextTranslationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTextTranslationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTextTranslationJobsWithContext(ctx aws.Context, input *ListTextTranslationJobsInput, opts ...request.Option) (*ListTextTranslationJobsOutput, error) {
	req, out := c.ListTextTranslationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTextTranslationJobsPages iterates over the pages of a ListTextTranslationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTextTranslationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTextTranslationJobs operation.
//    pageNum := 0
//    err := client.ListTextTranslationJobsPages(params,
//        func(page *translate.ListTextTranslationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Translate) ListTextTranslationJobsPages(input *ListTextTranslationJobsInput, fn func(*ListTextTranslationJobsOutput, bool) bool) error {
	return c.ListTextTranslationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTextTranslationJobsPagesWithContext same as ListTextTranslationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTextTranslationJobsPagesWithContext(ctx aws.Context, input *ListTextTranslationJobsInput, fn func(*ListTextTranslationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTextTranslationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTextTranslationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTextTranslationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTextTranslationJob = "StartTextTranslationJob"

// StartTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTextTranslationJob for more information on using the StartTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTextTranslationJobRequest method.
//    req, resp := client.StartTextTranslationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob
func (c *Translate) StartTextTranslationJobRequest(input *StartTextTranslationJobInput) (req *request.Request, output *StartTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opStartTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTextTranslationJobInput{}
	}

	output = &StartTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTextTranslationJob API operation for Amazon Translate.
//
// Starts an asynchronous batch translation job. Batch translation jobs can
// be used to translate large volumes of text across multiple documents at once.
// For more information, see async.
//
// Batch translation jobs can be described with the DescribeTextTranslationJob
// operation, listed with the ListTextTranslationJobs operation, and stopped
// with the StopTextTranslationJob operation.
//
// Amazon Translate does not support batch translation of multiple source languages
// at once.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation StartTextTranslationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeUnsupportedLanguagePairException "UnsupportedLanguagePairException"
//   Amazon Translate does not support translation from the language of the source
//   text into the requested target language. For more information, see how-to-error-msg.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob
func (c *Translate) StartTextTranslationJob(input *StartTextTranslationJobInput) (*StartTextTranslationJobOutput, error) {
	req, out := c.StartTextTranslationJobRequest(input)
	return out, req.Send()
}

// StartTextTranslationJobWithContext is the same as StartTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) StartTextTranslationJobWithContext(ctx aws.Context, input *StartTextTranslationJobInput, opts ...request.Option) (*StartTextTranslationJobOutput, error) {
	req, out := c.StartTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTextTranslationJob = "StopTextTranslationJob"

// StopTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTextTranslationJob for more information on using the StopTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTextTranslationJobRequest method.
//    req, resp := client.StopTextTranslationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob
func (c *Translate) StopTextTranslationJobRequest(input *StopTextTranslationJobInput) (req *request.Request, output *StopTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opStopTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTextTranslationJobInput{}
	}

	output = &StopTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTextTranslationJob API operation for Amazon Translate.
//
// Stops an asynchronous batch translation job that is in progress.
//
// If the job's state is IN_PROGRESS, the job will be marked for termination
// and put into the STOP_REQUESTED state. If the job completes before it can
// be stopped, it is put into the COMPLETED state. Otherwise, the job is put
// into the STOPPED state.
//
// Asynchronous batch translation jobs are started with the StartTextTranslationJob
// operation. You can use the DescribeTextTranslationJob or ListTextTranslationJobs
// operations to get a batch translation job's JobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation StopTextTranslationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob
func (c *Translate) StopTextTranslationJob(input *StopTextTranslationJobInput) (*StopTextTranslationJobOutput, error) {
	req, out := c.StopTextTranslationJobRequest(input)
	return out, req.Send()
}

// StopTextTranslationJobWithContext is the same as StopTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) StopTextTranslationJobWithContext(ctx aws.Context, input *StopTextTranslationJobInput, opts ...request.Option) (*StopTextTranslationJobOutput, error) {
	req, out := c.StopTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opText = "TranslateText"

// TextRequest generates a "aws/request.Request" representing the
// client's request for the Text operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Text for more information on using the Text
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TextRequest method.
//    req, resp := client.TextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) TextRequest(input *TextInput) (req *request.Request, output *TextOutput) {
	op := &request.Operation{
		Name:       opText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TextInput{}
	}

	output = &TextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Text API operation for Amazon Translate.
//
// Translates input text from the source language to the target language. For
// a list of available languages and language codes, see what-is-languages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation Text for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the text you submitted exceeds the size limit. Reduce the size
//   of the text or use a smaller document and then retry your request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeUnsupportedLanguagePairException "UnsupportedLanguagePairException"
//   Amazon Translate does not support translation from the language of the source
//   text into the requested target language. For more information, see how-to-error-msg.
//
//   * ErrCodeDetectedLanguageLowConfidenceException "DetectedLanguageLowConfidenceException"
//   The confidence that Amazon Comprehend accurately detected the source language
//   is low. If a low confidence level is acceptable for your application, you
//   can use the language in the exception to call Amazon Translate again. For
//   more information, see the DetectDominantLanguage (https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html)
//   operation in the Amazon Comprehend Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The Amazon Translate service is temporarily unavailable. Please wait a bit
//   and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) Text(input *TextInput) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	return out, req.Send()
}

// TextWithContext is the same as Text with the addition of
// the ability to pass a context and additional request options.
//
// See Text for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) TextWithContext(ctx aws.Context, input *TextInput, opts ...request.Option) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The custom terminology applied to the input text by Amazon Translate for
// the translated text response. This is optional in the response and will only
// be present if you specified terminology input in the request. Currently,
// only one terminology can be applied per TranslateText request.
type AppliedTerminology struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology applied to the input text by Amazon Translate
	// for the translated text response.
	Name *string `min:"1" type:"string"`

	// The specific terms of the custom terminology applied to the input text by
	// Amazon Translate for the translated text response. A maximum of 250 terms
	// will be returned, and the specific terms applied will be the first 250 terms
	// in the source text.
	Terms []*Term `type:"list"`
}

// String returns the string representation
func (s AppliedTerminology) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppliedTerminology) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AppliedTerminology) SetName(v string) *AppliedTerminology {
	s.Name = &v
	return s
}

// SetTerms sets the Terms field's value.
func (s *AppliedTerminology) SetTerms(v []*Term) *AppliedTerminology {
	s.Terms = v
	return s
}

type DeleteTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTerminologyInput) SetName(v string) *DeleteTerminologyInput {
	s.Name = &v
	return s
}

type DeleteTerminologyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTerminologyOutput) GoString() string {
	return s.String()
}

type DescribeTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Translate generated for the job. The StartTextTranslationJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTextTranslationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTextTranslationJobInput) SetJobId(v string) *DescribeTextTranslationJobInput {
	s.JobId = &v
	return s
}

type DescribeTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an asynchronous batch
	// translation job.
	TextTranslationJobProperties *TextTranslationJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetTextTranslationJobProperties sets the TextTranslationJobProperties field's value.
func (s *DescribeTextTranslationJobOutput) SetTextTranslationJobProperties(v *TextTranslationJobProperties) *DescribeTextTranslationJobOutput {
	s.TextTranslationJobProperties = v
	return s
}

// The encryption key used to encrypt the custom terminologies used by Amazon
// Translate.
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the encryption key being used to encrypt
	// the custom terminology.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The type of encryption key used by Amazon Translate to encrypt custom terminologies.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EncryptionKeyType"`
}

// String returns the string representation
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionKey"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *EncryptionKey) SetId(v string) *EncryptionKey {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionKey) SetType(v string) *EncryptionKey {
	s.Type = &v
	return s
}

type GetTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data format of the custom terminology being retrieved, either CSV or
	// TMX.
	//
	// TerminologyDataFormat is a required field
	TerminologyDataFormat *string `type:"string" required:"true" enum:"TerminologyDataFormat"`
}

// String returns the string representation
func (s GetTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TerminologyDataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminologyDataFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTerminologyInput) SetName(v string) *GetTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyDataFormat sets the TerminologyDataFormat field's value.
func (s *GetTerminologyInput) SetTerminologyDataFormat(v string) *GetTerminologyInput {
	s.TerminologyDataFormat = &v
	return s
}

type GetTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The data location of the custom terminology being retrieved. The custom terminology
	// file is returned in a presigned url that has a 30 minute expiration.
	TerminologyDataLocation *TerminologyDataLocation `type:"structure"`

	// The properties of the custom terminology being retrieved.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation
func (s GetTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTerminologyOutput) GoString() string {
	return s.String()
}

// SetTerminologyDataLocation sets the TerminologyDataLocation field's value.
func (s *GetTerminologyOutput) SetTerminologyDataLocation(v *TerminologyDataLocation) *GetTerminologyOutput {
	s.TerminologyDataLocation = v
	return s
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *GetTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *GetTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

type ImportTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The description of the custom terminology being imported.
	Description *string `type:"string"`

	// The encryption key for the custom terminology being imported.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The merge strategy of the custom terminology being imported. Currently, only
	// the OVERWRITE merge strategy is supported. In this case, the imported terminology
	// will overwrite an existing terminology of the same name.
	//
	// MergeStrategy is a required field
	MergeStrategy *string `type:"string" required:"true" enum:"MergeStrategy"`

	// The name of the custom terminology being imported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The terminology data for the custom terminology being imported.
	//
	// TerminologyData is a required field
	TerminologyData *TerminologyData `type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTerminologyInput"}
	if s.MergeStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("MergeStrategy"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TerminologyData == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminologyData"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}
	if s.TerminologyData != nil {
		if err := s.TerminologyData.Validate(); err != nil {
			invalidParams.AddNested("TerminologyData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ImportTerminologyInput) SetDescription(v string) *ImportTerminologyInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ImportTerminologyInput) SetEncryptionKey(v *EncryptionKey) *ImportTerminologyInput {
	s.EncryptionKey = v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *ImportTerminologyInput) SetMergeStrategy(v string) *ImportTerminologyInput {
	s.MergeStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportTerminologyInput) SetName(v string) *ImportTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyData sets the TerminologyData field's value.
func (s *ImportTerminologyInput) SetTerminologyData(v *TerminologyData) *ImportTerminologyInput {
	s.TerminologyData = v
	return s
}

type ImportTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the custom terminology being imported.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation
func (s ImportTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTerminologyOutput) GoString() string {
	return s.String()
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *ImportTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *ImportTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

// The input configuration properties for requesting a batch translation job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The multipurpose internet mail extension (MIME) type of the input files.
	// Valid values are text/plain for plaintext files and text/html for HTML files.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true"`

	// The URI of the AWS S3 folder that contains the input file. The folder must
	// be in the same Region as the API endpoint you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *InputDataConfig) SetContentType(v string) *InputDataConfig {
	s.ContentType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// The number of documents successfully and unsuccessfully processed during
// a translation job.
type JobDetails struct {
	_ struct{} `type:"structure"`

	// The number of documents that could not be processed during a translation
	// job.
	DocumentsWithErrorsCount *int64 `type:"integer"`

	// The number of documents used as input in a translation job.
	InputDocumentsCount *int64 `type:"integer"`

	// The number of documents successfully processed during a translation job.
	TranslatedDocumentsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDetails) GoString() string {
	return s.String()
}

// SetDocumentsWithErrorsCount sets the DocumentsWithErrorsCount field's value.
func (s *JobDetails) SetDocumentsWithErrorsCount(v int64) *JobDetails {
	s.DocumentsWithErrorsCount = &v
	return s
}

// SetInputDocumentsCount sets the InputDocumentsCount field's value.
func (s *JobDetails) SetInputDocumentsCount(v int64) *JobDetails {
	s.InputDocumentsCount = &v
	return s
}

// SetTranslatedDocumentsCount sets the TranslatedDocumentsCount field's value.
func (s *JobDetails) SetTranslatedDocumentsCount(v int64) *JobDetails {
	s.TranslatedDocumentsCount = &v
	return s
}

type ListTerminologiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom terminologies returned per list request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the request to ListTerminologies was truncated, include
	// the NextToken to fetch the next group of custom terminologies.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTerminologiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTerminologiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTerminologiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTerminologiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTerminologiesInput) SetMaxResults(v int64) *ListTerminologiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesInput) SetNextToken(v string) *ListTerminologiesInput {
	s.NextToken = &v
	return s
}

type ListTerminologiesOutput struct {
	_ struct{} `type:"structure"`

	// If the response to the ListTerminologies was truncated, the NextToken fetches
	// the next group of custom terminologies.
	NextToken *string `type:"string"`

	// The properties list of the custom terminologies returned on the list request.
	TerminologyPropertiesList []*TerminologyProperties `type:"list"`
}

// String returns the string representation
func (s ListTerminologiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTerminologiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesOutput) SetNextToken(v string) *ListTerminologiesOutput {
	s.NextToken = &v
	return s
}

// SetTerminologyPropertiesList sets the TerminologyPropertiesList field's value.
func (s *ListTerminologiesOutput) SetTerminologyPropertiesList(v []*TerminologyProperties) *ListTerminologiesOutput {
	s.TerminologyPropertiesList = v
	return s
}

type ListTextTranslationJobsInput struct {
	_ struct{} `type:"structure"`

	// The parameters that specify which batch translation jobs to retrieve. Filters
	// include job name, job status, and submission time. You can only set one filter
	// at a time.
	Filter *TextTranslationJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default value is
	// 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTextTranslationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTextTranslationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTextTranslationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTextTranslationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTextTranslationJobsInput) SetFilter(v *TextTranslationJobFilter) *ListTextTranslationJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTextTranslationJobsInput) SetMaxResults(v int64) *ListTextTranslationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTextTranslationJobsInput) SetNextToken(v string) *ListTextTranslationJobsInput {
	s.NextToken = &v
	return s
}

type ListTextTranslationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retreive the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// A list containing the properties of each job that is returned.
	TextTranslationJobPropertiesList []*TextTranslationJobProperties `type:"list"`
}

// String returns the string representation
func (s ListTextTranslationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTextTranslationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTextTranslationJobsOutput) SetNextToken(v string) *ListTextTranslationJobsOutput {
	s.NextToken = &v
	return s
}

// SetTextTranslationJobPropertiesList sets the TextTranslationJobPropertiesList field's value.
func (s *ListTextTranslationJobsOutput) SetTextTranslationJobPropertiesList(v []*TextTranslationJobProperties) *ListTextTranslationJobsOutput {
	s.TextTranslationJobPropertiesList = v
	return s
}

// The output configuration properties for a batch translation job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The URI of the S3 folder that contains a translation job's output file. The
	// folder must be in the same Region as the API endpoint that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

type StartTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The client token of the EC2 instance calling the request. This token is auto-generated
	// when using the Amazon Translate SDK. Otherwise, use the DescribeInstances
	// (docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html)
	// EC2 operation to retreive an instance's client token. For more information,
	// see Client Tokens (docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html#client-tokens)
	// in the EC2 User Guide.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM)
	// role that grants Amazon Translate read access to your input data. For more
	// nformation, see identity-and-access-management.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and S3 location of the input documents for the translation
	// job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The name of the batch translation job to be performed.
	JobName *string `min:"1" type:"string"`

	// Specifies the S3 folder to which your job output will be saved.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The language code of the input language. For a list of language codes, see
	// what-is-languages.
	//
	// Amazon Translate does not automatically detect a source language during batch
	// translation jobs.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code of the output language.
	//
	// TargetLanguageCodes is a required field
	TargetLanguageCodes []*string `min:"1" type:"list" required:"true"`

	// The name of the terminology to use in the batch translation job. For a list
	// of available terminologies, use the ListTerminologies operation.
	TerminologyNames []*string `type:"list"`
}

// String returns the string representation
func (s StartTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTextTranslationJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCodes"))
	}
	if s.TargetLanguageCodes != nil && len(s.TargetLanguageCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCodes", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartTextTranslationJobInput) SetClientToken(v string) *StartTextTranslationJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTextTranslationJobInput) SetDataAccessRoleArn(v string) *StartTextTranslationJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTextTranslationJobInput) SetInputDataConfig(v *InputDataConfig) *StartTextTranslationJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTextTranslationJobInput) SetJobName(v string) *StartTextTranslationJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTextTranslationJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTextTranslationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *StartTextTranslationJobInput) SetSourceLanguageCode(v string) *StartTextTranslationJobInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *StartTextTranslationJobInput) SetTargetLanguageCodes(v []*string) *StartTextTranslationJobInput {
	s.TargetLanguageCodes = v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *StartTextTranslationJobInput) SetTerminologyNames(v []*string) *StartTextTranslationJobInput {
	s.TerminologyNames = v
	return s
}

type StartTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// ID with the DescribeTextTranslationJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job. Possible values include:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Translate is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * COMPLETED_WITH_ERRORS - The job was completed with errors. The errors
	//    can be analyzed in the job's output.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTextTranslationJob
	//    operation.
	//
	//    * STOP_REQUESTED - The user who started the job has requested that it
	//    be stopped.
	//
	//    * STOPPED - The job has been stopped.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTextTranslationJobOutput) SetJobId(v string) *StartTextTranslationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTextTranslationJobOutput) SetJobStatus(v string) *StartTextTranslationJobOutput {
	s.JobStatus = &v
	return s
}

type StopTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID of the job to be stopped.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTextTranslationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopTextTranslationJobInput) SetJobId(v string) *StopTextTranslationJobInput {
	s.JobId = &v
	return s
}

type StopTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// The job ID of the stopped batch translation job.
	JobId *string `min:"1" type:"string"`

	// The status of the designated job. Upon successful completion, the job's status
	// will be STOPPED.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopTextTranslationJobOutput) SetJobId(v string) *StopTextTranslationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopTextTranslationJobOutput) SetJobStatus(v string) *StopTextTranslationJobOutput {
	s.JobStatus = &v
	return s
}

// The term being translated by the custom terminology.
type Term struct {
	_ struct{} `type:"structure"`

	// The source text of the term being translated by the custom terminology.
	SourceText *string `type:"string"`

	// The target text of the term being translated by the custom terminology.
	TargetText *string `type:"string"`
}

// String returns the string representation
func (s Term) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Term) GoString() string {
	return s.String()
}

// SetSourceText sets the SourceText field's value.
func (s *Term) SetSourceText(v string) *Term {
	s.SourceText = &v
	return s
}

// SetTargetText sets the TargetText field's value.
func (s *Term) SetTargetText(v string) *Term {
	s.TargetText = &v
	return s
}

// The data associated with the custom terminology.
type TerminologyData struct {
	_ struct{} `type:"structure"`

	// The file containing the custom terminology data. Your version of the AWS
	// SDK performs a Base64-encoding on this field before sending a request to
	// the AWS service. Users of the SDK should not perform Base64-encoding themselves.
	//
	// File is automatically base64 encoded/decoded by the SDK.
	//
	// File is a required field
	File []byte `type:"blob" required:"true" sensitive:"true"`

	// The data format of the custom terminology. Either CSV or TMX.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"TerminologyDataFormat"`
}

// String returns the string representation
func (s TerminologyData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminologyData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminologyData"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *TerminologyData) SetFile(v []byte) *TerminologyData {
	s.File = v
	return s
}

// SetFormat sets the Format field's value.
func (s *TerminologyData) SetFormat(v string) *TerminologyData {
	s.Format = &v
	return s
}

// The location of the custom terminology data.
type TerminologyDataLocation struct {
	_ struct{} `type:"structure"`

	// The location of the custom terminology data.
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`

	// The repository type for the custom terminology data.
	//
	// RepositoryType is a required field
	RepositoryType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminologyDataLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyDataLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *TerminologyDataLocation) SetLocation(v string) *TerminologyDataLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *TerminologyDataLocation) SetRepositoryType(v string) *TerminologyDataLocation {
	s.RepositoryType = &v
	return s
}

// The properties of the custom terminology.
type TerminologyProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom terminology.
	Arn *string `type:"string"`

	// The time at which the custom terminology was created, based on the timestamp.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the custom terminology properties.
	Description *string `type:"string"`

	// The encryption key for the custom terminology.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The time at which the custom terminology was last update, based on the timestamp.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the custom terminology.
	Name *string `min:"1" type:"string"`

	// The size of the file used when importing a custom terminology.
	SizeBytes *int64 `type:"integer"`

	// The language code for the source text of the translation request for which
	// the custom terminology is being used.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The language codes for the target languages available with the custom terminology
	// file. All possible target languages are returned in array.
	TargetLanguageCodes []*string `type:"list"`

	// The number of terms included in the custom terminology.
	TermCount *int64 `type:"integer"`
}

// String returns the string representation
func (s TerminologyProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyProperties) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TerminologyProperties) SetArn(v string) *TerminologyProperties {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TerminologyProperties) SetCreatedAt(v time.Time) *TerminologyProperties {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TerminologyProperties) SetDescription(v string) *TerminologyProperties {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *TerminologyProperties) SetEncryptionKey(v *EncryptionKey) *TerminologyProperties {
	s.EncryptionKey = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TerminologyProperties) SetLastUpdatedAt(v time.Time) *TerminologyProperties {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *TerminologyProperties) SetName(v string) *TerminologyProperties {
	s.Name = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *TerminologyProperties) SetSizeBytes(v int64) *TerminologyProperties {
	s.SizeBytes = &v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TerminologyProperties) SetSourceLanguageCode(v string) *TerminologyProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *TerminologyProperties) SetTargetLanguageCodes(v []*string) *TerminologyProperties {
	s.TargetLanguageCodes = v
	return s
}

// SetTermCount sets the TermCount field's value.
func (s *TerminologyProperties) SetTermCount(v int64) *TerminologyProperties {
	s.TermCount = &v
	return s
}

type TextInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the source text. The language must
	// be a language supported by Amazon Translate. For a list of language codes,
	// see what-is-languages.
	//
	// To have Amazon Translate determine the source language of your text, you
	// can specify auto in the SourceLanguageCode field. If you specify auto, Amazon
	// Translate will call Amazon Comprehend (https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html)
	// to determine the source language.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code requested for the language of the target text. The language
	// must be a language supported by Amazon Translate.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The name of the terminology list file to be used in the TranslateText request.
	// You can use 1 terminology list at most in a TranslateText request. Terminology
	// lists can contain a maximum of 256 terms.
	TerminologyNames []*string `type:"list"`

	// The text to translate. The text string can be a maximum of 5,000 bytes long.
	// Depending on your character set, this may be fewer than 5,000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextInput"}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCode"))
	}
	if s.TargetLanguageCode != nil && len(*s.TargetLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCode", 2))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextInput) SetSourceLanguageCode(v string) *TextInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextInput) SetTargetLanguageCode(v string) *TextInput {
	s.TargetLanguageCode = &v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *TextInput) SetTerminologyNames(v []*string) *TextInput {
	s.TerminologyNames = v
	return s
}

// SetText sets the Text field's value.
func (s *TextInput) SetText(v string) *TextInput {
	s.Text = &v
	return s
}

type TextOutput struct {
	_ struct{} `type:"structure"`

	// The names of the custom terminologies applied to the input text by Amazon
	// Translate for the translated text response.
	AppliedTerminologies []*AppliedTerminology `type:"list"`

	// The language code for the language of the source text.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code for the language of the target text.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The translated text.
	//
	// TranslatedText is a required field
	TranslatedText *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextOutput) GoString() string {
	return s.String()
}

// SetAppliedTerminologies sets the AppliedTerminologies field's value.
func (s *TextOutput) SetAppliedTerminologies(v []*AppliedTerminology) *TextOutput {
	s.AppliedTerminologies = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextOutput) SetSourceLanguageCode(v string) *TextOutput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextOutput) SetTargetLanguageCode(v string) *TextOutput {
	s.TargetLanguageCode = &v
	return s
}

// SetTranslatedText sets the TranslatedText field's value.
func (s *TextOutput) SetTranslatedText(v string) *TextOutput {
	s.TranslatedText = &v
	return s
}

// Provides information for filtering a list of translation jobs. For more information,
// see ListTextTranslationJobs.
type TextTranslationJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list of jobs by name.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based by job status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing and returns only the jobs submitted after the specified time.
	// Jobs are returned in descending order, newest to oldest.
	SubmittedAfterTime *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing and returns only the jobs submitted before the specified time.
	// Jobs are returned in ascending order, oldest to newest.
	SubmittedBeforeTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TextTranslationJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextTranslationJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextTranslationJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextTranslationJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *TextTranslationJobFilter) SetJobName(v string) *TextTranslationJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TextTranslationJobFilter) SetJobStatus(v string) *TextTranslationJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmittedAfterTime sets the SubmittedAfterTime field's value.
func (s *TextTranslationJobFilter) SetSubmittedAfterTime(v time.Time) *TextTranslationJobFilter {
	s.SubmittedAfterTime = &v
	return s
}

// SetSubmittedBeforeTime sets the SubmittedBeforeTime field's value.
func (s *TextTranslationJobFilter) SetSubmittedBeforeTime(v time.Time) *TextTranslationJobFilter {
	s.SubmittedBeforeTime = &v
	return s
}

// Provides information about a translation job.
type TextTranslationJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM)
	// role that granted Amazon Translate read access to the job's input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time at which the translation job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input configuration properties that were specified when the job was requested.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The number of documents successfully and unsuccessfully processed during
	// the translation job.
	JobDetails *JobDetails `type:"structure"`

	// The ID of the translation job.
	JobId *string `min:"1" type:"string"`

	// The user-defined name of the translation job.
	JobName *string `min:"1" type:"string"`

	// The status of the translation job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// An explanation of any errors that may have occured during the translation
	// job.
	Message *string `type:"string"`

	// The output configuration properties that were specified when the job was
	// requested.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The language code of the language of the source text. The language must be
	// a language supported by Amazon Translate.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The time at which the translation job was submitted.
	SubmittedTime *time.Time `type:"timestamp"`

	// The language code of the language of the target text. The language must be
	// a language supported by Amazon Translate.
	TargetLanguageCodes []*string `min:"1" type:"list"`

	// A list containing the names of the terminologies applied to a translation
	// job. Only one terminology can be applied per StartTextTranslationJob request
	// at this time.
	TerminologyNames []*string `type:"list"`
}

// String returns the string representation
func (s TextTranslationJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextTranslationJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *TextTranslationJobProperties) SetDataAccessRoleArn(v string) *TextTranslationJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *TextTranslationJobProperties) SetEndTime(v time.Time) *TextTranslationJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *TextTranslationJobProperties) SetInputDataConfig(v *InputDataConfig) *TextTranslationJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *TextTranslationJobProperties) SetJobDetails(v *JobDetails) *TextTranslationJobProperties {
	s.JobDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *TextTranslationJobProperties) SetJobId(v string) *TextTranslationJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *TextTranslationJobProperties) SetJobName(v string) *TextTranslationJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TextTranslationJobProperties) SetJobStatus(v string) *TextTranslationJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TextTranslationJobProperties) SetMessage(v string) *TextTranslationJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *TextTranslationJobProperties) SetOutputDataConfig(v *OutputDataConfig) *TextTranslationJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextTranslationJobProperties) SetSourceLanguageCode(v string) *TextTranslationJobProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetSubmittedTime sets the SubmittedTime field's value.
func (s *TextTranslationJobProperties) SetSubmittedTime(v time.Time) *TextTranslationJobProperties {
	s.SubmittedTime = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *TextTranslationJobProperties) SetTargetLanguageCodes(v []*string) *TextTranslationJobProperties {
	s.TargetLanguageCodes = v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *TextTranslationJobProperties) SetTerminologyNames(v []*string) *TextTranslationJobProperties {
	s.TerminologyNames = v
	return s
}

const (
	// EncryptionKeyTypeKms is a EncryptionKeyType enum value
	EncryptionKeyTypeKms = "KMS"
)

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusCompletedWithError is a JobStatus enum value
	JobStatusCompletedWithError = "COMPLETED_WITH_ERROR"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

const (
	// MergeStrategyOverwrite is a MergeStrategy enum value
	MergeStrategyOverwrite = "OVERWRITE"
)

const (
	// TerminologyDataFormatCsv is a TerminologyDataFormat enum value
	TerminologyDataFormatCsv = "CSV"

	// TerminologyDataFormatTmx is a TerminologyDataFormat enum value
	TerminologyDataFormatTmx = "TMX"
)
