/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.JarUtil;
import jarinstaller.gui.DebugInfo;
import jarinstaller.gui.IReport;
import jarinstaller.gui.MainFrame;
import jarinstaller.oshandler.IOsHandler;
import jarinstaller.oshandler.OsFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class FileUtil
implements Runnable {
    public static final char SEPARATOR_START = '{';
    public static final char SEPARATOR_END = '}';
    public static final String SEPARATOR_VARIABLE = "$";
    public static final String FILE_TYPE_TXT = "txt";
    public static final String FILE_TYPE_LOG = "log";
    public static final String FILE_TYPE_SCRIPT = "script";
    public static final String SYSTYPE_ALL_PREFIX = "all";
    public static final String SYSTYPE_WINDOWS_PREFIX = "WIN";
    public static final int BUFFER_SIZE = 4096;
    String destdir;
    Vector files;
    Vector dirs;
    IReport report;
    Vector resultfiles = null;
    Vector resultdirs = null;
    Hashtable params;
    boolean insresult = false;
    boolean stop = false;
    boolean stopped = false;
    IOsHandler osHandler = OsFactory.getOsHandler();
    private boolean usertodo = false;

    public void setUsertodo(boolean usertodo) {
        this.usertodo = usertodo;
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }

    public void setFiles(Vector files) {
        this.files = files;
    }

    public void setDirs(Vector dirs) {
        this.dirs = dirs;
    }

    public void setReport(IReport report) {
        this.report = report;
    }

    public void setResultfiles(Vector resultfiles) {
        this.resultfiles = resultfiles;
    }

    public void setResultdirs(Vector resultdirs) {
        this.resultdirs = resultdirs;
    }

    public void setParams(Hashtable params) {
        this.params = params;
    }

    public void remove(Vector files, Vector dirs) {
        File file;
        int i;
        if (files != null) {
            for (i = 0; i < files.size(); ++i) {
                file = (File)files.elementAt(i);
                this.removeFile(file);
            }
        }
        if (dirs != null) {
            for (i = dirs.size() - 1; i > -1; --i) {
                file = (File)dirs.elementAt(i);
                this.removeFile(file);
            }
        }
    }

    public boolean removeFile(File file) {
        try {
            if (file.isDirectory() && file.listFiles().length > 0) {
                return false;
            }
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean removeRDirs(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files.length == 0) {
            file.delete();
        } else {
            for (int i = 0; i < files.length; ++i) {
                File chf = files[i];
                if (!chf.isDirectory()) continue;
                this.removeRDirs(chf);
            }
            files = file.listFiles();
            if (files.length == 0) {
                file.delete();
            }
        }
        return true;
    }

    public boolean isExist(String path, String fname) {
        try {
            File file = new File(path + File.separator + fname);
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean createDirs(Vector dirs, Vector resultvect, IReport report) throws Exception {
        if (dirs == null) {
            return true;
        }
        report.inFormStart((String)this.params.get("todopanel.dircreate"), "", 0L);
        for (int i = 0; i < dirs.size(); ++i) {
            String fpar = (String)dirs.elementAt(i);
            if (this.createDir(fpar, resultvect, report)) continue;
            return false;
        }
        return true;
    }

    public boolean createDir(String dir, Vector resultvect, IReport report) throws Exception {
        File destdir = new File(this.replaceTokens(dir, this.params));
        report.inFormStart(destdir.getPath(), "", 0L);
        if (destdir.isDirectory()) {
            return true;
        }
        if (destdir.mkdirs()) {
            resultvect.add(destdir);
            return true;
        }
        return false;
    }

    public boolean createFiles(Vector files, Vector resultvect, IReport report) throws Exception {
        if (files == null) {
            return true;
        }
        report.inFormStart((String)this.params.get("todopanel.filecreate"), "", 0L);
        for (int i = 0; i < files.size(); ++i) {
            Hashtable fpar = (Hashtable)files.elementAt(i);
            this.createFile(fpar, resultvect, report);
        }
        return true;
    }

    public void createFile(Hashtable ht, Vector resultvect, IReport report) throws Exception {
        block16: {
            String destfile = "";
            String keynorewrite = "";
            String norewrite = "";
            String needErrorHandler = "";
            File file = null;
            if (ht == null) {
                return;
            }
            try {
                boolean txt;
                destfile = this.replaceTokens((String)ht.get("filename"), this.params);
                String os = ((String)ht.get("os")).toLowerCase();
                String filetype = (String)ht.get("filetype");
                String notuninstall = (String)ht.get("notuninstall");
                if (notuninstall == null) {
                    notuninstall = "";
                }
                Vector lines = (Vector)ht.get("lines");
                String charsetname = (String)ht.get("charset");
                keynorewrite = (String)ht.get("norewrite");
                if (keynorewrite != null && (norewrite = (String)this.params.get(keynorewrite)) != null) {
                    return;
                }
                needErrorHandler = (String)ht.get("error");
                if (needErrorHandler == null) {
                    needErrorHandler = "";
                }
                if (filetype.compareTo(FILE_TYPE_SCRIPT) == 0) {
                    destfile = destfile + this.osHandler.getScriptPostfix();
                }
                boolean log = filetype.compareTo(FILE_TYPE_LOG) == 0;
                boolean bl = txt = filetype.compareTo(FILE_TYPE_TXT) == 0;
                if (os.compareTo(SYSTYPE_ALL_PREFIX) != 0) {
                    if (IOsHandler.OS_NAME.indexOf(os) == -1) break block16;
                }
                file = new File(destfile);
                report.inFormStart(file.getPath(), "", 0L);
                if (!log) {
                    this.removeFile(file);
                }
                if (txt || log) {
                    this.writeFile(file, lines, this.params, charsetname, log);
                } else if (filetype.compareTo(FILE_TYPE_SCRIPT) == 0) {
                    this.writeFile(file, lines, this.params, charsetname, false);
                    this.setExecuteFlag(file.getPath());
                }
                if (notuninstall.length() == 0) {
                    resultvect.add(file);
                }
            }
            catch (Exception e) {
                if (file != null) {
                    this.removeFile(file);
                }
                if (needErrorHandler.equalsIgnoreCase("dontsend")) {
                    return;
                }
                throw e;
            }
        }
    }

    public void writeFile(File destfile, Vector lines, Hashtable params, String char_set_name, boolean append) throws Exception {
        System.out.println("write file destfile = " + destfile.getAbsolutePath());
        try {
            System.out.println("write file destfile = " + destfile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destfile, append), char_set_name)));
            for (int i = 0; i < lines.size(); ++i) {
                String str = (String)lines.elementAt(i);
                if (str.startsWith(SEPARATOR_VARIABLE)) {
                    this.writeStructure(str, params, pw);
                    continue;
                }
                pw.println(this.replaceTokens(str, params));
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    private void writeStructure(String str, Hashtable ht, PrintWriter pw) throws Exception {
        Vector tv = this.getTokens(str, '{', '}');
        for (int i = 0; i < tv.size(); ++i) {
            String token = (String)tv.elementAt(i);
            if (!ht.containsKey(token)) continue;
            if (ht.get(token) instanceof Vector) {
                this.write((Vector)ht.get(token), pw);
            }
            if (!(ht.get(token) instanceof Hashtable)) continue;
            this.write((Hashtable)ht.get(token), pw);
        }
    }

    private void write(Vector v, PrintWriter pw) {
        for (int i = 0; i < v.size(); ++i) {
            Object s = v.elementAt(i);
            pw.println(s.toString());
        }
    }

    private void write(Hashtable h, PrintWriter pw) {
        Enumeration en = h.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            pw.println(key.toString() + "=" + h.get(key).toString());
        }
    }

    public String replaceTokens(String str, Hashtable ht) throws Exception {
        Vector tv = this.getTokens(str, '{', '}');
        for (int i = 0; i < tv.size(); ++i) {
            String token = (String)tv.elementAt(i);
            String ftoken = "\\{" + token + "\\" + '}';
            if (!ht.containsKey(token)) {
                DebugInfo.showMessage("Hi\u00e1nyz\u00f3 param\u00e9ter: " + token);
                continue;
            }
            String repl = ((String)ht.get(token)).trim();
            str = str.replaceAll(ftoken.trim(), this.convert(repl).trim());
        }
        return str;
    }

    public String convert(String str) {
        String cstr = "";
        cstr = str.replaceAll("\\\\", "/");
        return cstr;
    }

    public Vector getTokens(String str, char token_s, char token_e) {
        StringBuffer sb = new StringBuffer(str);
        Vector<String> results = new Vector<String>();
        int s = 0;
        int e = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != token_s && sb.charAt(i) != token_e) continue;
            if (i == 0) {
                e = -1;
                continue;
            }
            if (s > e) {
                e = i;
                results.add(sb.substring(s + 1, e));
                s = i;
                continue;
            }
            s = i;
        }
        return results;
    }

    public void setExecuteFlag(String filename) throws Exception {
        this.osHandler.setExecuteFlag(filename);
    }

    private void createIcon() throws Exception {
        String tmpdir = (String)this.params.get("DESTINATIONDATADIR");
        Hashtable desktop = (Hashtable)this.params.get("desktop");
        String name = this.replaceTokens((String)desktop.get("name"), this.params);
        String description = this.replaceTokens((String)desktop.get("description"), this.params);
        String target = this.replaceTokens((String)desktop.get("target"), this.params);
        String arguments = this.replaceTokens((String)desktop.get("arguments"), this.params);
        String workingDirectory = this.replaceTokens((String)desktop.get("workingDirectory"), this.params);
        String icon = this.replaceTokens((String)desktop.get("icon"), this.params);
        DebugInfo.showMessage("((Boolean) params.get(\"ISCREATEDESKTOPSHORTCUT\")).booleanValue()) = " + (Boolean)this.params.get("ISCREATEDESKTOPSHORTCUT"));
        if (this.params.containsKey("ISCREATEDESKTOPSHORTCUT") && ((Boolean)this.params.get("ISCREATEDESKTOPSHORTCUT")).booleanValue()) {
            this.osHandler.createDesktopIcon(tmpdir, name, description, target, arguments, workingDirectory, icon);
        }
        Hashtable menu = (Hashtable)this.params.get("menu");
        name = this.replaceTokens((String)menu.get("name"), this.params);
        description = this.replaceTokens((String)menu.get("description"), this.params);
        target = this.replaceTokens((String)menu.get("target"), this.params);
        arguments = this.replaceTokens((String)menu.get("arguments"), this.params);
        workingDirectory = this.replaceTokens((String)menu.get("workingDirectory"), this.params);
        icon = this.replaceTokens((String)menu.get("icon"), this.params);
        if (this.params.containsKey("ISCREATEMENUSHORTCUT") && ((Boolean)this.params.get("ISCREATEMENUSHORTCUT")).booleanValue()) {
            this.osHandler.createMenuItem(tmpdir, name, description, target, arguments, workingDirectory, icon);
        }
    }

    public String getProperty(String installPath, String filename, String key) {
        String value = "";
        BufferedReader br = null;
        try {
            String line;
            File file = new File(installPath + File.separator + filename);
            if (!file.exists()) {
                return "";
            }
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(key)) continue;
                value = line.substring(line.indexOf("=") + 1, line.length());
                return value.trim();
            }
            br.close();
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return value;
        }
        return value;
    }

    private boolean addEnvironmentVariable() throws Exception {
        String tmpdir = (String)this.params.get("DESTINATIONDATADIR");
        Vector env = (Vector)this.params.get("userenvvariables");
        for (int i = 0; i < env.size(); ++i) {
            Hashtable title = (Hashtable)env.elementAt(i);
            String file = (String)title.get("file");
            String key = (String)title.get("key");
            String var = (String)title.get("var");
            if (this.existEnvironmentVariable(tmpdir, this.replaceTokens(file, this.params), key, this.replaceTokens(var, this.params))) continue;
            this.osHandler.createEnvironmentVariable(tmpdir, this.replaceTokens(file, this.params), key, this.replaceTokens(var, this.params));
        }
        return true;
    }

    public boolean existEnvironmentVariable(String tmpdir, String inuserfile, String key, String value) {
        String inVar = value.replace('/', '\\');
        String previous = this.osHandler.getEnvironmentVariable(key);
        return previous != null && previous.length() > 0 && previous.replace('/', '\\').equalsIgnoreCase(inVar);
    }

    private boolean copyUserFiles() throws Exception {
        URI sourcefile = (URI)this.params.get("parameter.option.sourcefile");
        JarUtil jf = new JarUtil(sourcefile);
        jf.setParams(this.params);
        jf.setReport(this.report);
        if (!jf.readDestinations("usercopies")) {
            return true;
        }
        jf.initDataStore();
        jf.extract();
        return true;
    }

    public void run() {
        try {
            System.gc();
            this.insresult = this.createDirs(this.dirs, this.resultdirs, this.report);
            if (this.insresult) {
                this.insresult = this.createFiles(this.files, this.resultfiles, this.report);
            }
            if (this.usertodo && this.insresult) {
                this.createIcon();
                this.addEnvironmentVariable();
                this.copyUserFiles();
            }
            if (!this.insresult || this.stop) {
                this.remove(this.resultfiles, this.resultdirs);
            }
            this.report.setResult(this.insresult, "", null);
        }
        catch (Exception e) {
            this.remove(this.resultfiles, this.resultdirs);
            e.printStackTrace();
            this.report.setResult(false, "Hiba a param\u00e9ter \u00e1llom\u00e1nyok be\u00e1ll\u00edt\u00e1s\u00e1n\u00e1l(" + e.toString() + ")", null);
        }
        this.stopped = true;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Vector readFile(String file) throws Exception {
        BufferedReader br = null;
        try {
            String line;
            Vector<String> out = new Vector<String>();
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                out.add(line);
            }
            br.close();
            return out;
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public boolean copyFile(File sourceFile, File destFile) {
        FilterOutputStream ofi = null;
        BufferedInputStream ifi = null;
        try {
            int lrb;
            ifi = new BufferedInputStream(new FileInputStream(sourceFile));
            ofi = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] b = new byte[4096];
            while ((lrb = ifi.read(b, 0, 4096)) != -1) {
                ((BufferedOutputStream)ofi).write(b, 0, lrb);
            }
            ((BufferedOutputStream)ofi).flush();
            ofi.close();
            ifi.close();
            return true;
        }
        catch (Exception e) {
            try {
                if (ifi != null) {
                    ifi.close();
                }
            }
            catch (Exception d) {
                // empty catch block
            }
            try {
                if (ofi != null) {
                    ofi.close();
                }
            }
            catch (Exception d) {
                // empty catch block
            }
            this.removeFile(destFile);
            return false;
        }
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(MainFrame.getRPane(), message);
    }
}

