/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    boolean mslogon = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    AuthPanel authenticator;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    FTPFrame ftp;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String host;
    int port;
    String passwordParam;
    String encPasswordParam;
    boolean showControls;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    String usernameParam;
    String encUsernameParam;
    String dm;
    byte[] domain = new byte[256];
    byte[] user = new byte[256];
    byte[] passwd = new byte[32];
    int i;
    boolean disconnectRequested = false;

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    public void init() {
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("Ultr@VNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.ftp = new FTPFrame(this);
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(this.vc);
            this.desktopScrollPane = new ScrollPane(0);
            gridBagConstraints.fill = 1;
            this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
            this.desktopScrollPane.add(panel);
            if (this.inSeparateFrame) {
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.add(this.desktopScrollPane);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.vc.processNormalProtocol();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            noRouteToHostException.printStackTrace();
            this.fatalError("Network error: no route to server: " + this.host);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            this.fatalError("Network error: server name unknown: " + this.host);
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port);
        }
        catch (EOFException eOFException) {
            eOFException.printStackTrace();
            if (this.showOfflineDesktop) {
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                }
                if (this.rfb != null) {
                    this.rfb.close();
                    this.rfb = null;
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection");
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            iOException.printStackTrace();
            if (string != null && string.length() != 0) {
                this.fatalError("Network Error: " + string);
            } else {
                this.fatalError(iOException.toString());
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            exception.printStackTrace();
            if (string != null && string.length() != 0) {
                this.fatalError("Error: " + string);
            }
            this.fatalError(exception.toString());
        }
    }

    void connectAndAuthenticate() throws Exception {
        Object object;
        if (this.encPasswordParam != null) {
            Object object2;
            Object object3;
            object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int n = this.encPasswordParam.length() / 2;
            if (n > 8) {
                n = 8;
            }
            int n2 = 0;
            while (n2 < n) {
                object3 = this.encPasswordParam.substring(n2 * 2, n2 * 2 + 2);
                object2 = new Integer(Integer.parseInt((String)object3, 16));
                object[n2] = ((Integer)object2).byteValue();
                ++n2;
            }
            object3 = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object2 = new DesCipher((byte[])object3);
            ((DesCipher)object2).decrypt((byte[])object, 0, (byte[])object, 0);
            this.passwordParam = new String((byte[])object);
        }
        if (this.passwordParam != null) {
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
                this.vncFrame.show();
            } else {
                this.validate();
            }
            if (!this.tryAuthenticate(this.usernameParam, this.passwordParam)) {
                throw new Exception("VNC authentication failed");
            }
            return;
        }
        this.prologueDetectAuthProtocol();
        this.authenticator = new AuthPanel(this.mslogon);
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).ipadx = 100;
        ((GridBagConstraints)object).ipady = 50;
        this.gridbag.setConstraints(this.authenticator, (GridBagConstraints)object);
        this.vncContainer.add(this.authenticator);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
            this.authenticator.moveFocusToUsernameField();
        }
        while (true) {
            AuthPanel authPanel = this.authenticator;
            synchronized (authPanel) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String string = this.mslogon ? this.authenticator.username.getText() : "";
            if (this.tryAuthenticate(string, this.authenticator.password.getText())) break;
            this.authenticator.retry();
        }
        this.vncContainer.remove(this.authenticator);
    }

    void prologueDetectAuthProtocol() throws Exception {
        this.rfb = new RfbProto(this.host, this.port, this, null, 0);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        if (this.rfb.serverMinor == 4) {
            this.mslogon = true;
            System.out.println("Ultr@VNC mslogon detected");
        }
        this.rfb.writeVersionMsg();
    }

    boolean tryAuthenticate(String string, String string2) throws Exception {
        this.rfb = new RfbProto(this.host, this.port, this, null, 0);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int n = this.rfb.readAuthScheme();
        block0 : switch (n) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                int n2;
                byte[] byArray;
                if (this.mslogon) {
                    System.out.println("showing JOptionPane warning.");
                    int n3 = JOptionPane.showConfirmDialog(this.vncFrame, "The current authentication method does not transfer your password securely.Do you want to continue?", "Warning", 0);
                    if (n3 != 0) {
                        throw new Exception("User cancelled insecure MS-Logon");
                    }
                }
                byte[] byArray2 = new byte[64];
                if (this.mslogon) {
                    System.arraycopy(string.getBytes(), 0, this.user, 0, string.length());
                    if (string.length() < 256) {
                        this.i = string.length();
                        while (this.i < 256) {
                            this.user[this.i] = 0;
                            ++this.i;
                        }
                    }
                    this.dm = ".";
                    System.arraycopy(this.dm.getBytes(), 0, this.domain, 0, this.dm.length());
                    if (this.dm.length() < 256) {
                        this.i = this.dm.length();
                        while (this.i < 256) {
                            this.domain[this.i] = 0;
                            ++this.i;
                        }
                    }
                    System.arraycopy(string2.getBytes(), 0, this.passwd, 0, string2.length());
                    if (string2.length() < 32) {
                        this.i = string2.length();
                        while (this.i < 32) {
                            this.passwd[this.i] = 0;
                            ++this.i;
                        }
                    }
                    byArray = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
                    DesCipher desCipher = new DesCipher(byArray);
                    desCipher.encrypt(this.passwd, 0, this.passwd, 0);
                    this.rfb.is.readFully(byArray2);
                }
                byArray = new byte[16];
                this.rfb.is.readFully(byArray);
                if (string2.length() > 8) {
                    string2 = string2.substring(0, 8);
                }
                if ((n2 = string2.indexOf(0)) != -1) {
                    string2 = string2.substring(0, n2);
                }
                if (this.mslogon) {
                    this.i = 0;
                    while (this.i < 32) {
                        byArray2[this.i] = (byte)(this.passwd[this.i] ^ byArray2[this.i]);
                        ++this.i;
                    }
                    this.rfb.os.write(this.user);
                    this.rfb.os.write(this.domain);
                    this.rfb.os.write(byArray2);
                }
                byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                System.arraycopy(string2.getBytes(), 0, byArray3, 0, string2.length());
                DesCipher desCipher = new DesCipher(byArray3);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.rfb.os.write(byArray);
                int n4 = this.rfb.is.readInt();
                switch (n4) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new Exception("VNC authentication failed - too many tries");
                    }
                }
                throw new Exception("Unknown VNC authentication result " + n4);
            }
            case -6: {
                System.out.println("MS-Logon (DH) detected");
                if (!this.AuthMsLogon(string, string2)) break;
                return true;
            }
            default: {
                throw new Exception("Unknown VNC authentication scheme " + n);
            }
        }
        return false;
    }

    boolean AuthMsLogon(String string, String string2) throws Exception {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[64];
        long l = this.rfb.is.readLong();
        long l2 = this.rfb.is.readLong();
        long l3 = this.rfb.is.readLong();
        DH dH = new DH(l, l2);
        long l4 = dH.createInterKey();
        this.rfb.os.write(DH.longToBytes(l4));
        long l5 = dH.createEncryptionKey(l3);
        System.out.println("gen=" + l + ", mod=" + l2 + ", pub=" + l4 + ", key=" + l5);
        DesCipher desCipher = new DesCipher(DH.longToBytes(l5));
        System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
        if (string.length() < 256) {
            this.i = string.length();
            while (this.i < 256) {
                byArray[this.i] = 0;
                ++this.i;
            }
        }
        System.arraycopy(string2.getBytes(), 0, byArray2, 0, string2.length());
        if (string2.length() < 32) {
            this.i = string2.length();
            while (this.i < 32) {
                byArray2[this.i] = 0;
                ++this.i;
            }
        }
        desCipher.encryptText(byArray, byArray, DH.longToBytes(l5));
        desCipher.encryptText(byArray2, byArray2, DH.longToBytes(l5));
        this.rfb.os.write(byArray);
        this.rfb.os.write(byArray2);
        int n = this.rfb.is.readInt();
        switch (n) {
            case 0: {
                System.out.println("MS-Logon (DH) authentication succeeded");
                return true;
            }
            case 1: {
                System.out.println("MS-Logon (DH) authentication failed");
                break;
            }
            case 2: {
                throw new Exception("MS-Logon (DH) authentication failed - too many tries");
            }
            default: {
                throw new Exception("Unknown MS-Logon (DH) authentication result " + n);
            }
        }
        return false;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    boolean bl = true;
                    return bl;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[3].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[5].getSelectedItem();
                this.options.choices[3].select("Disable");
                this.options.choices[3].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[5].select("Full");
                this.options.choices[5].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[3].select(this.cursorUpdatesDef);
                this.options.choices[3].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[5].select(this.eightBitColorsDef);
                this.options.choices[5].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.encPasswordParam = this.readParameter("ENCPASSWORD", false);
        if (this.encPasswordParam == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(string + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String string, int n) {
        String string2 = this.readParameter(string, false);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToPasswordField();
            }
        }
    }

    public synchronized void disconnect() {
        this.disconnectRequested = true;
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println("Disconnect");
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label label = new Label("Disconnected");
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            this.rfbThread.stop();
        } else {
            System.exit(0);
        }
    }

    public synchronized void fatalError(String string) {
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println(string);
        if (this.disconnectRequested) {
            this.disconnectRequested = false;
            return;
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label label = new Label(string);
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public void destroy() {
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.ftp != null) {
            this.ftp.dispose();
        }
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToPasswordField();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

