#!/bin/sh
#
# lsh-utils	Start/stop secure shell server.
#		Written by Timshel Knoll <timshel@debian.org>
#		Updated by Stefan Pfetzing <dreamind@dreamind.de>
#               Updated by Magnus Holmgren <magnus@debian.org>

### BEGIN INIT INFO
# Provides:          lsh-server
# Required-Start:    $local_fs $remote_fs $syslog $named $network
# Required-Stop:     $local_fs $remote_fs $syslog $named $network
# X-Start-Before:    cman drbd smokeping vz
# X-Stop-After:      cman drbd smokeping vz
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: lsh secure shell server
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/lshd
NAME=lshd
DESC="secure shell v2 server"
CONFIG=/etc/default/lsh-server
PIDFILE=/var/run/$NAME.pid

RANDOM_SEED="/var/spool/lsh/yarrow-seed-file"
HOST_KEY="/etc/lsh_host_key"

test -f $DAEMON || exit 0

. /lib/lsb/init-functions

set +e

if [ -r "$CONFIG" ]; then
   . "$CONFIG"
fi

if [ x"$LSHD_PORT" = x ]; then
   LSHD_PORT="22"
fi

case "$ENABLE_SFTP" in
  true|y*|Y*)
    SFTP_FLAG="--subsystems sftp=/usr/lib/lsh-server/sftp-server"
    ;;
  *)
    SFTP_FLAG=""
    ;;
esac

case "$1" in
  start)
	log_daemon_msg "Starting $DESC" "$NAME"
	start-stop-daemon --start --quiet --oknodo --pidfile $PIDFILE --exec $DAEMON \
                          -- --daemonic --port "$LSHD_PORT" $SFTP_FLAG $EXTRA_ARGS
	log_end_msg $?
	;;
  stop|graceful-stop)
	log_daemon_msg "Gracefully stopping $DESC" "$NAME"
	# Signal 1 causes the "old" lsh to close up shop on its port, but
	# keeps running until all active connections have been closed
	start-stop-daemon --stop --retry HUP/1 --quiet --pidfile $PIDFILE \
	    --oknodo --exec $DAEMON
	log_end_msg $?
	;;
  restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	start-stop-daemon --stop --retry HUP/1 --quiet --pidfile $PIDFILE \
	    --oknodo --exec $DAEMON &&
	start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $DAEMON \
                       -- --daemonic --port "$LSHD_PORT" $SFTP_FLAG $EXTRA_ARGS
	log_end_msg $?
	;;
  status)
	status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
	;;
  *)
	echo "Usage: /etc/init.d/lsh-utils {start|stop|restart|force-reload}" >&2
	exit 3
	;;
esac
