/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserMDIFrame;
import org.gjt.jclasslib.browser.config.classpath.ClassTreeNode;
import org.gjt.jclasslib.browser.config.classpath.ClasspathChangeEvent;
import org.gjt.jclasslib.browser.config.classpath.ClasspathChangeListener;
import org.gjt.jclasslib.browser.config.classpath.ClasspathComponent;
import org.gjt.jclasslib.util.GUIHelper;
import org.gjt.jclasslib.util.ProgressDialog;

public class ClasspathBrowser
extends JDialog
implements ActionListener,
ClasspathChangeListener {
    private static final int DIALOG_WIDTH = 450;
    private static final int DIALOG_HEIGHT = 450;
    private BrowserMDIFrame frame;
    private ClasspathComponent classpathComponent;
    private JLabel lblTitle;
    private JTree tree;
    private JScrollPane scpTree;
    private JButton btnSetup;
    private JButton btnSync;
    private JButton btnOk;
    private JButton btnCancel;
    private ProgressDialog progressDialog;
    private boolean resetOnNextMerge;
    private boolean needsMerge;
    private String selectedClassName;

    public ClasspathBrowser(BrowserMDIFrame browserMDIFrame, ClasspathComponent classpathComponent, String string, boolean bl) {
        super(browserMDIFrame);
        this.frame = browserMDIFrame;
        this.setClasspathComponent(classpathComponent);
        this.setupControls(string, bl);
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnCancel) {
            this.doCancel();
        } else if (object == this.btnOk) {
            this.doOk();
        } else if (object == this.btnSetup) {
            this.doSetup();
        } else if (object == this.btnSync) {
            this.doSync(true);
        }
    }

    public void classpathChanged(ClasspathChangeEvent classpathChangeEvent) {
        this.needsMerge = true;
        if (classpathChangeEvent.isRemoval()) {
            this.resetOnNextMerge = true;
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.selectedClassName = null;
        }
        super.setVisible(bl);
    }

    public String getSelectedClassName() {
        return this.selectedClassName;
    }

    public void setClasspathComponent(ClasspathComponent classpathComponent) {
        if (this.classpathComponent != null) {
            this.classpathComponent.removeClasspathChangeListener(this);
        }
        this.classpathComponent = classpathComponent;
        if (classpathComponent != null) {
            classpathComponent.addClasspathChangeListener(this);
        }
        this.resetOnNextMerge = true;
        this.needsMerge = true;
        this.clear();
    }

    public void clear() {
        if (this.tree != null) {
            this.tree.setModel(new DefaultTreeModel(new ClassTreeNode()));
        }
    }

    private void setupControls(String string, boolean bl) {
        this.lblTitle = new JLabel(string);
        this.tree = new JTree(new ClassTreeNode());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.scpTree = new JScrollPane(this.tree);
        this.btnSetup = new JButton("Setup classpath");
        this.btnSetup.setVisible(bl);
        this.btnSync = new JButton("Synchronize");
        this.btnOk = new JButton("Ok");
        this.btnOk.setEnabled(false);
        this.btnCancel = new JButton("Cancel");
        this.btnOk.setPreferredSize(this.btnCancel.getPreferredSize());
        this.progressDialog = new ProgressDialog(this, null, "Scanning classpath ...");
    }

    private void setupComponent() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        container.add((Component)this.lblTitle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 1;
        container.add((Component)this.scpTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.bottom = 5;
        container.add((Component)this.createButtonBox(), gridBagConstraints);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setSize(450, 450);
        this.setModal(true);
        this.setTitle("Choose a class");
        GUIHelper.centerOnParentWindow(this, this.getOwner());
        this.setDefaultCloseOperation(0);
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        box.add(this.btnSetup);
        box.add(this.btnSync);
        box.add(Box.createHorizontalGlue());
        box.add(this.btnOk);
        box.add(this.btnCancel);
        return box;
    }

    private void setupEventHandlers() {
        this.btnCancel.addActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnSetup.addActionListener(this);
        this.btnSync.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClasspathBrowser.this.doCancel();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        Object object = new Object();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(1).put(keyStroke, object);
        jComponent.getActionMap().put(object, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathBrowser.this.doCancel();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ClasspathBrowser.this.conditionalUpdate();
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ClasspathBrowser.this.checkTreeSelection();
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ClasspathBrowser.this.isValidDoubleClickPath(mouseEvent)) {
                    ClasspathBrowser.this.doOk();
                }
            }
        });
    }

    private void conditionalUpdate() {
        if (this.needsMerge) {
            this.doSync(this.resetOnNextMerge);
        }
    }

    private boolean isValidDoubleClickPath(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath2 = this.tree.getSelectionPath();
        if (treePath2 == null || treePath == null || !treePath2.equals(treePath)) {
            return false;
        }
        ClassTreeNode classTreeNode = (ClassTreeNode)treePath2.getLastPathComponent();
        return !classTreeNode.isPackageNode();
    }

    private void checkTreeSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        boolean bl = false;
        if (treePath != null) {
            ClassTreeNode classTreeNode = (ClassTreeNode)treePath.getLastPathComponent();
            bl = !classTreeNode.isPackageNode();
        }
        this.btnOk.setEnabled(bl);
    }

    private void doOk() {
        StringBuffer stringBuffer = new StringBuffer();
        TreePath treePath = this.tree.getSelectionPath();
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(treePath.getPathComponent(i).toString());
        }
        this.selectedClassName = stringBuffer.toString();
        this.setVisible(false);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    private void doSetup() {
        this.frame.getActionSetupClasspath().actionPerformed(new ActionEvent(this, 0, null));
        this.conditionalUpdate();
    }

    private void doSync(final boolean bl) {
        final DefaultTreeModel defaultTreeModel = bl ? new DefaultTreeModel(new ClassTreeNode()) : (DefaultTreeModel)this.tree.getModel();
        Runnable runnable = new Runnable(){

            public void run() {
                if (ClasspathBrowser.this.classpathComponent != null) {
                    ClasspathBrowser.this.classpathComponent.mergeClassesIntoTree(defaultTreeModel, bl);
                }
            }
        };
        this.progressDialog.setRunnable(runnable);
        this.progressDialog.setVisible(true);
        if (bl) {
            this.tree.setModel(defaultTreeModel);
        }
        this.tree.expandPath(new TreePath(defaultTreeModel.getRoot()));
        this.resetOnNextMerge = false;
        this.needsMerge = false;
    }
}

