/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ValueRangeFacet
extends Facet {
    public static final int MIN_INCLUSIVE = 0;
    public static final int MAX_INCLUSIVE = 1;
    public static final int MIN_EXCLUSIVE = 2;
    public static final int MAX_EXCLUSIVE = 3;
    int facet;
    StringValue requiredValue;

    public ValueRangeFacet(int facetType) {
        this.facet = facetType;
    }

    public String getName() {
        switch (this.facet) {
            case 0: {
                return "minInclusive";
            }
            case 1: {
                return "minInclusive";
            }
            case 2: {
                return "minExclusive";
            }
            case 3: {
                return "maxExclusive";
            }
        }
        return null;
    }

    public String getValue() {
        return this.requiredValue.getStringValue();
    }

    public void setValue(String value) throws SchemaException {
        this.requiredValue = new StringValue(value);
    }

    public void checkFacetRestriction(SimpleType base) throws SchemaException {
        boolean OK;
        if (!(base instanceof AtomicType)) {
            throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + base.getDescription());
        }
        int primitive = ((AtomicType)base).getPrimitiveType();
        boolean bl = OK = primitive == 532 || primitive == 517 || primitive == 516 || primitive == 515 || primitive == 518 || primitive == 521 || primitive == 519 || primitive == 520 || primitive == 523 || primitive == 522 || primitive == 526 || primitive == 524 || primitive == 525 || primitive == 645 || primitive == 644;
        if (!OK) {
            throw new SchemaException("The " + this.getName() + " facet is not allowed on the unordered type " + base.getDescription());
        }
        try {
            AtomicValue req = this.requiredValue.convert((AtomicType)base);
        }
        catch (XPathException err) {
            throw new SchemaException("The value \u00ab" + this.requiredValue + "\u00bb of the " + this.getName() + " facet is not valid for the type " + base.getDescription());
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        try {
            AtomicValue req = this.requiredValue.convert((AtomicType)value.getItemType());
            if (!(value instanceof Comparable)) {
                return false;
            }
            int c = ((Comparable)((Object)value)).compareTo(req);
            switch (this.facet) {
                case 0: {
                    return c >= 0;
                }
                case 1: {
                    return c <= 0;
                }
                case 2: {
                    return c > 0;
                }
                case 3: {
                    return c < 0;
                }
            }
            return false;
        }
        catch (XPathException e) {
            return false;
        }
    }
}

