/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimestampTest
extends TestCase {
    static long TIME_TEST1 = 38720231L;
    static long TIME_TEST2 = 80279000L;
    static long TIME_TEST3 = -38720691L;
    static long TIME_COMPARE = 123498845L;
    static long TIME_EARLY = -2347889122L;
    static long TIME_LATE = 2347889122L;
    static String STRING_TEST1 = "1970-01-01 10:45:20.231";
    static String STRING_TEST2 = "1970-01-01 22:17:59.0";
    static String STRING_TEST3 = "1969-12-31 13:14:39.309";
    static String STRING_INVALID1 = "ABCDEFGHI";
    static String STRING_INVALID2 = "233104";
    static String STRING_INVALID3 = "21-43-48";
    static String STRING_OUTRANGE = "2999-15-99 35:99:66.875";
    static long[] TIME_ARRAY = new long[]{TIME_TEST1, TIME_TEST2, TIME_TEST3};
    static int[] YEAR_ARRAY = new int[]{70, 70, 69};
    static int[] MONTH_ARRAY;
    static int[] DATE_ARRAY;
    static int[] HOURS_ARRAY;
    static int[] MINUTES_ARRAY;
    static int[] SECONDS_ARRAY;
    static int[] NANOS_ARRAY;
    static int[] NANOS_ARRAY2;
    static String[] STRING_NANOS_ARRAY;
    static String[] STRING_GMT_ARRAY;
    static String[] STRING_LA_ARRAY;
    static String[] STRING_JP_ARRAY;
    static String[] INVALID_STRINGS;
    static String TZ_LONDON;
    static String TZ_PACIFIC;
    static String TZ_JAPAN;
    static String[] TIMEZONES;
    static String[][] STRING_ARRAYS;
    static String theExceptionMessage;

    static {
        int[] nArray = new int[3];
        nArray[2] = 11;
        MONTH_ARRAY = nArray;
        DATE_ARRAY = new int[]{1, 1, 31};
        HOURS_ARRAY = new int[]{10, 22, 13};
        MINUTES_ARRAY = new int[]{45, 17, 14};
        SECONDS_ARRAY = new int[]{20, 59, 39};
        int[] nArray2 = new int[3];
        nArray2[0] = 231000000;
        nArray2[2] = 309000000;
        NANOS_ARRAY = nArray2;
        NANOS_ARRAY2 = new int[]{137891990, 635665198, 109985421};
        STRING_NANOS_ARRAY = new String[]{"1970-01-01 10:45:20.13789199", "1970-01-01 22:17:59.635665198", "1969-12-31 13:14:39.109985421"};
        STRING_GMT_ARRAY = new String[]{STRING_TEST1, STRING_TEST2, STRING_TEST3};
        STRING_LA_ARRAY = new String[]{"02:45:20", "14:17:59", "05:14:40"};
        STRING_JP_ARRAY = new String[]{"19:45:20", "07:17:59", "22:14:40"};
        INVALID_STRINGS = new String[]{STRING_INVALID1, STRING_INVALID2, STRING_INVALID3};
        TZ_LONDON = "GMT";
        TZ_PACIFIC = "America/Los_Angeles";
        TZ_JAPAN = "Asia/Tokyo";
        TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};
        STRING_ARRAYS = new String[][]{STRING_GMT_ARRAY, STRING_LA_ARRAY, STRING_JP_ARRAY};
        theExceptionMessage = "Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
    }

    public void testTimestamplong() {
        Timestamp theTimestamp = new Timestamp(TIME_TEST1);
        TimestampTest.assertNotNull((Object)theTimestamp);
    }

    public void testTimestampintintintintintintint() {
        int[][] invalid;
        int[][] valid;
        int[][] nArrayArray = new int[14][];
        nArrayArray[0] = new int[]{99, 2, 14, 17, 52, 3, 213577212};
        int[] nArray = new int[7];
        nArray[2] = 1;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{106, 11, 31, 23, 59, 59, 999999999};
        nArrayArray[3] = new int[]{106, 11, 31, 23, 59, 61, 999999999};
        nArrayArray[4] = new int[]{106, 11, 31, 23, 59, -1, 999999999};
        nArrayArray[5] = new int[]{106, 11, 31, 23, 61, 59, 999999999};
        nArrayArray[6] = new int[]{106, 11, 31, 23, -1, 59, 999999999};
        nArrayArray[7] = new int[]{106, 11, 31, 25, 59, 59, 999999999};
        nArrayArray[8] = new int[]{106, 11, 31, -1, 59, 59, 999999999};
        nArrayArray[9] = new int[]{106, 11, 35, 23, 59, 59, 999999999};
        nArrayArray[10] = new int[]{106, 11, -1, 23, 59, 59, 999999999};
        nArrayArray[11] = new int[]{106, 15, 31, 23, 59, 59, 999999999};
        nArrayArray[12] = new int[]{106, -1, 31, 23, 59, 59, 999999999};
        nArrayArray[13] = new int[]{-10, 11, 31, 23, 59, 59, 999999999};
        int[][] nArrayArray2 = valid = nArrayArray;
        int n = 0;
        int n2 = nArrayArray2.length;
        while (n < n2) {
            int[] element = nArrayArray2[n];
            Timestamp theTimestamp = new Timestamp(element[0], element[1], element[2], element[3], element[4], element[5], element[6]);
            TimestampTest.assertNotNull((String)"Timestamp not generated: ", (Object)theTimestamp);
            ++n;
        }
        int[][] nArrayArray3 = invalid = new int[][]{{106, 11, 31, 23, 59, 59, 1999999999}, {106, 11, 31, 23, 59, 59, -999999999}};
        n2 = 0;
        int n3 = nArrayArray3.length;
        while (n2 < n3) {
            int[] element = nArrayArray3[n2];
            try {
                new Timestamp(element[0], element[1], element[2], element[3], element[4], element[5], element[6]);
                TimestampTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void testSetTimelong() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Timestamp theTimestamp = new Timestamp(TIME_TEST1);
        int i = 0;
        while (i < TIME_ARRAY.length) {
            theTimestamp.setTime(TIME_ARRAY[i]);
            TimestampTest.assertEquals((long)TIME_ARRAY[i], (long)theTimestamp.getTime());
            TimestampTest.assertEquals((int)NANOS_ARRAY[i], (int)theTimestamp.getNanos());
            ++i;
        }
    }

    public void testGetTime() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Timestamp theTimestamp = new Timestamp(element);
            TimestampTest.assertEquals((long)element, (long)theTimestamp.getTime());
            ++n;
        }
    }

    public void testGetYear() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)YEAR_ARRAY[i], (int)theTimestamp.getYear());
            ++i;
        }
    }

    public void testGetMonth() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)MONTH_ARRAY[i], (int)theTimestamp.getMonth());
            ++i;
        }
    }

    public void testGetDate() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)DATE_ARRAY[i], (int)theTimestamp.getDate());
            ++i;
        }
    }

    public void testGetHours() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)HOURS_ARRAY[i], (int)theTimestamp.getHours());
            ++i;
        }
    }

    public void testGetMinutes() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)MINUTES_ARRAY[i], (int)theTimestamp.getMinutes());
            ++i;
        }
    }

    public void testGetSeconds() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)SECONDS_ARRAY[i], (int)theTimestamp.getSeconds());
            ++i;
        }
    }

    public void testValueOfString() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            Timestamp theTimestamp2 = Timestamp.valueOf(STRING_GMT_ARRAY[i]);
            TimestampTest.assertEquals((Object)theTimestamp, (Object)theTimestamp2);
            ++i;
        }
        Timestamp theTimestamp = Timestamp.valueOf(STRING_OUTRANGE);
        TimestampTest.assertNotNull((Object)theTimestamp);
        String[] stringArray = INVALID_STRINGS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            try {
                Timestamp.valueOf(element);
                TimestampTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testValueOfString1() {
        Timestamp theReturn;
        long[] theReturnTime = new long[]{38720231L, 38720231L, 80279000L, -38720691L, 38720000L};
        int[] nArray = new int[5];
        nArray[0] = 231000000;
        nArray[1] = 231987654;
        nArray[3] = 309000000;
        int[] theReturnNanos = nArray;
        String[] valid = new String[]{"1970-01-01 10:45:20.231", "1970-01-01 10:45:20.231987654", "1970-01-01 22:17:59.0", "1969-12-31 13:14:39.309", "1970-01-01 10:45:20"};
        String[] stringArray = new String[9];
        stringArray[1] = "ABCDEFGHI";
        stringArray[2] = "233104";
        stringArray[3] = "1970-01-01 22:17:59.";
        stringArray[4] = "1970-01-01 10:45:20.231987654690645322";
        stringArray[5] = "1970-01-01 10:45:20&231987654";
        stringArray[6] = "1970-01-01 10:45:20.-31987654";
        stringArray[7] = "1970-01-01 10:45:20.ABCD87654";
        stringArray[8] = "21-43-48";
        String[] invalid = stringArray;
        int i = 0;
        while (i < valid.length) {
            theReturn = Timestamp.valueOf(valid[i]);
            TimestampTest.assertEquals((long)theReturnTime[i], (long)theReturn.getTime());
            TimestampTest.assertEquals((int)theReturnNanos[i], (int)theReturn.getNanos());
            ++i;
        }
        String[] stringArray2 = invalid;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String element = stringArray2[n];
            try {
                theReturn = Timestamp.valueOf(element);
                TimestampTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testToString() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((String)STRING_GMT_ARRAY[i], (String)theTimestamp.toString());
            ++i;
        }
    }

    public void testGetNanos() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Timestamp theTimestamp = new Timestamp(TIME_ARRAY[i]);
            TimestampTest.assertEquals((int)NANOS_ARRAY[i], (int)theTimestamp.getNanos());
            ++i;
        }
    }

    public void testSetNanosint() {
        Timestamp theTimestamp;
        int[] NANOS_INVALID = new int[]{-137891990, 1635665198, -1};
        int i = 0;
        while (i < TIME_ARRAY.length) {
            theTimestamp = new Timestamp(TIME_ARRAY[i]);
            theTimestamp.setNanos(NANOS_ARRAY2[i]);
            TimestampTest.assertEquals((int)NANOS_ARRAY2[i], (int)theTimestamp.getNanos());
            TimestampTest.assertEquals((String)STRING_NANOS_ARRAY[i], (String)theTimestamp.toString());
            ++i;
        }
        i = 0;
        while (i < NANOS_INVALID.length) {
            theTimestamp = new Timestamp(TIME_ARRAY[i]);
            int originalNanos = theTimestamp.getNanos();
            try {
                theTimestamp.setNanos(NANOS_INVALID[i]);
                TimestampTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            TimestampTest.assertEquals((int)originalNanos, (int)theTimestamp.getNanos());
            ++i;
        }
    }

    public void testEqualsTimestamp() {
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Timestamp theTimestamp = new Timestamp(element);
            Timestamp theTimestamp2 = new Timestamp(element);
            TimestampTest.assertTrue((boolean)theTimestamp.equals(theTimestamp2));
            ++n;
        }
        Timestamp theTest = new Timestamp(TIME_COMPARE);
        long[] lArray2 = TIME_ARRAY;
        n2 = 0;
        int n3 = lArray2.length;
        while (n2 < n3) {
            long element = lArray2[n2];
            Timestamp theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.equals(theTest));
            ++n2;
        }
        TimestampTest.assertFalse((boolean)new Timestamp(0L).equals(null));
    }

    public void testEqualsObject() {
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Timestamp theTimestamp = new Timestamp(element);
            Timestamp theTimestamp2 = new Timestamp(element);
            TimestampTest.assertTrue((boolean)theTimestamp.equals((Object)theTimestamp2));
            ++n;
        }
        Timestamp theTest = new Timestamp(TIME_COMPARE);
        long[] lArray2 = TIME_ARRAY;
        n2 = 0;
        int n3 = lArray2.length;
        while (n2 < n3) {
            long element = lArray2[n2];
            Timestamp theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.equals((Object)theTest));
            ++n2;
        }
        String nastyTest = new String("Test ");
        Timestamp theTimestamp = new Timestamp(TIME_ARRAY[1]);
        TimestampTest.assertFalse((boolean)theTimestamp.equals(nastyTest));
        TimestampTest.assertFalse((boolean)new Timestamp(0L).equals((Object)null));
    }

    public void testBeforeTimestamp() {
        Timestamp theTimestamp;
        long element;
        Timestamp theTest = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTimestamp = new Timestamp(element);
            TimestampTest.assertTrue((boolean)theTimestamp.before(theTest));
            ++n;
        }
        theTest = new Timestamp(TIME_EARLY);
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.before(theTest));
            ++n;
        }
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTest = new Timestamp(element);
            theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.before(theTest));
            theTest.setNanos(theTest.getNanos() + 1);
            TimestampTest.assertTrue((boolean)theTimestamp.before(theTest));
            ++n;
        }
    }

    public void testAfterTimestamp() {
        Timestamp theTimestamp;
        long element;
        Timestamp theTest = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.after(theTest));
            ++n;
        }
        theTest = new Timestamp(TIME_EARLY);
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTimestamp = new Timestamp(element);
            TimestampTest.assertTrue((boolean)theTimestamp.after(theTest));
            ++n;
        }
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            element = lArray[n];
            theTest = new Timestamp(element);
            theTimestamp = new Timestamp(element);
            TimestampTest.assertFalse((boolean)theTimestamp.after(theTest));
            theTimestamp.setNanos(theTimestamp.getNanos() + 1);
            TimestampTest.assertTrue((boolean)theTimestamp.after(theTest));
            ++n;
        }
    }

    public void testCompareToTimestamp() {
        Timestamp theTest = new Timestamp(TIME_EARLY);
        Timestamp theTest2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Timestamp theTimestamp = new Timestamp(element);
            Timestamp theTimestamp2 = new Timestamp(element);
            TimestampTest.assertTrue((theTimestamp.compareTo(theTest) > 0 ? 1 : 0) != 0);
            TimestampTest.assertTrue((theTimestamp.compareTo(theTest2) < 0 ? 1 : 0) != 0);
            TimestampTest.assertEquals((int)0, (int)theTimestamp.compareTo(theTimestamp2));
            ++n;
        }
        Timestamp t1 = new Timestamp(-1L);
        Timestamp t2 = new Timestamp(-1L);
        t1.setTime(Long.MIN_VALUE);
        t2.setDate(Integer.MIN_VALUE);
        TimestampTest.assertEquals((int)1, (int)t1.compareTo(t2));
        TimestampTest.assertEquals((int)-1, (int)t2.compareTo(t1));
        t1.setTime(Long.MAX_VALUE);
        t2.setTime(0x7FFFFFFFFFFFFFFEL);
        TimestampTest.assertEquals((int)1, (int)t1.compareTo(t2));
        TimestampTest.assertEquals((int)-1, (int)t2.compareTo(t1));
        t1.setTime(Integer.MAX_VALUE);
        t2.setTime(Integer.MAX_VALUE);
        TimestampTest.assertEquals((int)0, (int)t1.compareTo(t2));
        TimestampTest.assertEquals((int)0, (int)t2.compareTo(t1));
    }

    public void testCompareToDate() {
        Timestamp theTest = new Timestamp(TIME_EARLY);
        Timestamp theTest2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Timestamp theTimestamp = new Timestamp(element);
            Timestamp theTimestamp2 = new Timestamp(element);
            TimestampTest.assertTrue((theTimestamp.compareTo((Date)theTest) > 0 ? 1 : 0) != 0);
            TimestampTest.assertTrue((theTimestamp.compareTo((Date)theTest2) < 0 ? 1 : 0) != 0);
            TimestampTest.assertEquals((int)0, (int)theTimestamp.compareTo((Date)theTimestamp2));
            ++n;
        }
        Date nastyTest = new Date();
        Timestamp theTimestamp = new Timestamp(TIME_ARRAY[1]);
        try {
            theTimestamp.compareTo(nastyTest);
            TimestampTest.fail((String)"testCompareToObject: Did not get expected ClassCastException");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testSerializationSelf() throws Exception {
        Timestamp object = new Timestamp(100L);
        SerializationTest.verifySelf((Object)object);
    }

    public void testSerializationCompatibility() throws Exception {
        Timestamp object = new Timestamp(100L);
        SerializationTest.verifyGolden((TestCase)this, (Object)object);
    }

    public void test_toString() {
        Timestamp t1 = new Timestamp(Long.MIN_VALUE);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.192", (String)t1.toString());
        Timestamp t2 = new Timestamp(-9223372036854775807L);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.193", (String)t2.toString());
        Timestamp t3 = new Timestamp(-9223372036854775001L);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.999", (String)t3.toString());
        Timestamp t4 = new Timestamp(-9223372036854775000L);
        TimestampTest.assertEquals((String)"292269055-12-02 16:47:05.0", (String)t4.toString());
    }
}

