/* socket.c generated by valac 0.16.1, the Vala compiler
 * generated from socket.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <sys/socket.h>
#include <errno.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netinet/in.h>


#define FSO_FRAMEWORK_TYPE_TRANSPORT (fso_framework_transport_get_type ())
#define FSO_FRAMEWORK_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransport))
#define FSO_FRAMEWORK_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))
#define FSO_FRAMEWORK_IS_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_IS_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))

typedef struct _FsoFrameworkTransport FsoFrameworkTransport;
typedef struct _FsoFrameworkTransportClass FsoFrameworkTransportClass;
typedef struct _FsoFrameworkTransportPrivate FsoFrameworkTransportPrivate;

#define FSO_FRAMEWORK_TYPE_BASE_TRANSPORT (fso_framework_base_transport_get_type ())
#define FSO_FRAMEWORK_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransport))
#define FSO_FRAMEWORK_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))

typedef struct _FsoFrameworkBaseTransport FsoFrameworkBaseTransport;
typedef struct _FsoFrameworkBaseTransportClass FsoFrameworkBaseTransportClass;
typedef struct _FsoFrameworkBaseTransportPrivate FsoFrameworkBaseTransportPrivate;

#define FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT (fso_framework_socket_transport_get_type ())
#define FSO_FRAMEWORK_SOCKET_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT, FsoFrameworkSocketTransport))
#define FSO_FRAMEWORK_SOCKET_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT, FsoFrameworkSocketTransportClass))
#define FSO_FRAMEWORK_IS_SOCKET_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT))
#define FSO_FRAMEWORK_IS_SOCKET_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT))
#define FSO_FRAMEWORK_SOCKET_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT, FsoFrameworkSocketTransportClass))

typedef struct _FsoFrameworkSocketTransport FsoFrameworkSocketTransport;
typedef struct _FsoFrameworkSocketTransportClass FsoFrameworkSocketTransportClass;
typedef struct _FsoFrameworkSocketTransportPrivate FsoFrameworkSocketTransportPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef void (*FsoFrameworkTransportFunc) (FsoFrameworkTransport* transport, void* user_data);
struct _FsoFrameworkTransport {
	GObject parent_instance;
	FsoFrameworkTransportPrivate * priv;
	FsoFrameworkLogger* logger;
};

struct _FsoFrameworkTransportClass {
	GObjectClass parent_class;
	gboolean (*isOpen) (FsoFrameworkTransport* self);
	void (*openAsync) (FsoFrameworkTransport* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*openAsync_finish) (FsoFrameworkTransport* self, GAsyncResult* _res_);
	gboolean (*open) (FsoFrameworkTransport* self);
	void (*close) (FsoFrameworkTransport* self);
	gchar* (*getName) (FsoFrameworkTransport* self);
	void (*setDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
	void (*getDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify);
	void (*setPriorities) (FsoFrameworkTransport* self, gint rp, gint wp);
	void (*setBuffered) (FsoFrameworkTransport* self, gboolean on);
	gint (*writeAndRead) (FsoFrameworkTransport* self, void* wdata, gint wlength, void* rdata, gint rlength, gint maxWait);
	gint (*read) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*write) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*freeze) (FsoFrameworkTransport* self);
	void (*thaw) (FsoFrameworkTransport* self);
	void (*drain) (FsoFrameworkTransport* self);
	void (*flush) (FsoFrameworkTransport* self);
	gboolean (*suspend) (FsoFrameworkTransport* self);
	void (*resume) (FsoFrameworkTransport* self);
};

struct _FsoFrameworkBaseTransport {
	FsoFrameworkTransport parent_instance;
	FsoFrameworkBaseTransportPrivate * priv;
	gchar* name;
	guint speed;
	gboolean raw;
	gboolean hard;
	gint fd;
	FsoFrameworkTransportFunc hupfunc;
	gpointer hupfunc_target;
	GDestroyNotify hupfunc_target_destroy_notify;
	FsoFrameworkTransportFunc readfunc;
	gpointer readfunc_target;
	GDestroyNotify readfunc_target_destroy_notify;
	GByteArray* buffer;
};

struct _FsoFrameworkBaseTransportClass {
	FsoFrameworkTransportClass parent_class;
	gssize (*_real_write) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
	void (*configure) (FsoFrameworkBaseTransport* self);
	gchar* (*repr) (FsoFrameworkBaseTransport* self);
	gssize (*_real_read) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
};

struct _FsoFrameworkSocketTransport {
	FsoFrameworkBaseTransport parent_instance;
	FsoFrameworkSocketTransportPrivate * priv;
};

struct _FsoFrameworkSocketTransportClass {
	FsoFrameworkBaseTransportClass parent_class;
};

struct _FsoFrameworkSocketTransportPrivate {
	gint domain;
	gint stype;
	guint16 port;
};


static gpointer fso_framework_socket_transport_parent_class = NULL;

GType fso_framework_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_base_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_socket_transport_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_SOCKET_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT, FsoFrameworkSocketTransportPrivate))
enum  {
	FSO_FRAMEWORK_SOCKET_TRANSPORT_DUMMY_PROPERTY
};
FsoFrameworkSocketTransport* fso_framework_socket_transport_new (const gchar* type, const gchar* host, guint port);
FsoFrameworkSocketTransport* fso_framework_socket_transport_construct (GType object_type, const gchar* type, const gchar* host, guint port);
FsoFrameworkBaseTransport* fso_framework_base_transport_new (const gchar* name, guint speed, gboolean raw, gboolean hard);
FsoFrameworkBaseTransport* fso_framework_base_transport_construct (GType object_type, const gchar* name, guint speed, gboolean raw, gboolean hard);
static gchar* fso_framework_socket_transport_real_getName (FsoFrameworkTransport* base);
gchar* fso_framework_transport_getName (FsoFrameworkTransport* self);
static gchar* fso_framework_socket_transport_real_repr (FsoFrameworkBaseTransport* base);
static void fso_framework_socket_transport_real_configure (FsoFrameworkBaseTransport* base);
static gboolean fso_framework_socket_transport_real_open (FsoFrameworkTransport* base);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean fso_framework_transport_open (FsoFrameworkTransport* self);
static void fso_framework_socket_transport_finalize (GObject* obj);


FsoFrameworkSocketTransport* fso_framework_socket_transport_construct (GType object_type, const gchar* type, const gchar* host, guint port) {
	FsoFrameworkSocketTransport * self = NULL;
	const gchar* _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = host;
	self = (FsoFrameworkSocketTransport*) fso_framework_base_transport_construct (object_type, _tmp0_, (guint) 115200, TRUE, TRUE);
	_tmp1_ = port;
	self->priv->port = (guint16) _tmp1_;
	_tmp2_ = type;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("unix")))) {
		switch (0) {
			default:
			{
				self->priv->domain = AF_UNIX;
				self->priv->stype = SOCK_STREAM;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("udp")))) {
		switch (0) {
			default:
			{
				self->priv->domain = AF_INET;
				self->priv->stype = SOCK_DGRAM;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("tcp")))) {
		switch (0) {
			default:
			{
				self->priv->domain = AF_INET;
				self->priv->stype = SOCK_STREAM;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	return self;
}


FsoFrameworkSocketTransport* fso_framework_socket_transport_new (const gchar* type, const gchar* host, guint port) {
	return fso_framework_socket_transport_construct (FSO_FRAMEWORK_TYPE_SOCKET_TRANSPORT, type, host, port);
}


static gchar* fso_framework_socket_transport_real_getName (FsoFrameworkTransport* base) {
	FsoFrameworkSocketTransport * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	guint16 _tmp1_;
	self = (FsoFrameworkSocketTransport*) base;
	_tmp1_ = self->priv->port;
	if (((gint) _tmp1_) > 0) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		guint16 _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = FSO_FRAMEWORK_TRANSPORT_CLASS (fso_framework_socket_transport_parent_class)->getName ((FsoFrameworkTransport*) FSO_FRAMEWORK_BASE_TRANSPORT (self));
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->port;
		_tmp5_ = g_strdup_printf ("%s:%u", _tmp3_, (guint) _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_free0 (_tmp3_);
	} else {
		gchar* _tmp6_ = NULL;
		_tmp6_ = FSO_FRAMEWORK_TRANSPORT_CLASS (fso_framework_socket_transport_parent_class)->getName ((FsoFrameworkTransport*) FSO_FRAMEWORK_BASE_TRANSPORT (self));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}


static gchar* fso_framework_socket_transport_real_repr (FsoFrameworkBaseTransport* base) {
	FsoFrameworkSocketTransport * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (FsoFrameworkSocketTransport*) base;
	_tmp0_ = fso_framework_transport_getName ((FsoFrameworkTransport*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp3_ = g_strdup_printf ("<%s (fd %d)>", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


static void fso_framework_socket_transport_real_configure (FsoFrameworkBaseTransport* base) {
	FsoFrameworkSocketTransport * self;
	self = (FsoFrameworkSocketTransport*) base;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean fso_framework_socket_transport_real_open (FsoFrameworkTransport* base) {
	FsoFrameworkSocketTransport * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GResolver* _tmp10_ = NULL;
	GResolver* resolver;
	GList* addresses = NULL;
	GList* _tmp23_;
	gconstpointer _tmp24_ = NULL;
	GInetAddress* _tmp25_;
	GInetAddress* address;
	FsoFrameworkLogger* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GInetAddress* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	struct in_addr _tmp34_ = {0};
	struct in_addr inaddr;
	GInetAddress* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	struct in_addr _tmp38_ = {0};
	gint _tmp39_ = 0;
	gint _tmp40_;
	gint res;
	gint _tmp41_;
	struct sockaddr_in _tmp49_ = {0};
	struct sockaddr_in addr;
	guint16 _tmp50_;
	guint16 _tmp51_ = 0U;
	struct in_addr _tmp52_;
	guint32 _tmp53_;
	gint _tmp54_;
	gint _tmp55_ = 0;
	gint _tmp56_;
	gboolean _tmp64_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (FsoFrameworkSocketTransport*) base;
	_tmp0_ = self->priv->domain;
	_tmp1_ = self->priv->stype;
	_tmp2_ = socket (_tmp0_, _tmp1_, 0);
	((FsoFrameworkBaseTransport*) self)->fd = _tmp2_;
	_tmp3_ = ((FsoFrameworkBaseTransport*) self)->fd;
	if (_tmp3_ == (-1)) {
		FsoFrameworkLogger* _tmp4_;
		gint _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp5_ = errno;
		_tmp6_ = strerror (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Could not create socket: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		fso_framework_logger_error (_tmp4_, _tmp9_);
		_g_free0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp10_ = g_resolver_get_default ();
	resolver = _tmp10_;
	{
		GResolver* _tmp11_;
		const gchar* _tmp12_;
		GList* _tmp13_ = NULL;
		GList* _tmp14_;
		_tmp11_ = resolver;
		_tmp12_ = ((FsoFrameworkBaseTransport*) self)->name;
		_tmp13_ = g_resolver_lookup_by_name (_tmp11_, _tmp12_, NULL, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		__g_list_free__g_object_unref0_0 (addresses);
		addresses = _tmp14_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gint _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp16_ = ((FsoFrameworkBaseTransport*) self)->name;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = errno;
		_tmp19_ = strerror (_tmp18_);
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("Could not resolve ", _tmp17_, ": ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		fso_framework_logger_error (_tmp15_, _tmp22_);
		_g_free0 (_tmp22_);
		result = FALSE;
		_g_error_free0 (e);
		__g_list_free__g_object_unref0_0 (addresses);
		_g_object_unref0 (resolver);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (addresses);
		_g_object_unref0 (resolver);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp23_ = addresses;
	_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
	_tmp25_ = _g_object_ref0 ((GInetAddress*) _tmp24_);
	address = _tmp25_;
	_tmp26_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp27_ = ((FsoFrameworkBaseTransport*) self)->name;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = address;
	_tmp30_ = g_inet_address_to_string (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("Resolved ", _tmp28_, " to ", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	fso_framework_logger_info (_tmp26_, _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp34_.s_addr = (guint32) 0;
	inaddr = _tmp34_;
	_tmp35_ = address;
	_tmp36_ = g_inet_address_to_string (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp39_ = inet_aton (_tmp37_, &_tmp38_);
	 (inaddr);
	inaddr = _tmp38_;
	_tmp40_ = _tmp39_;
	_g_free0 (_tmp37_);
	res = _tmp40_;
	_tmp41_ = res;
	if (_tmp41_ == (-1)) {
		FsoFrameworkLogger* _tmp42_;
		gint _tmp43_;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_;
		gint _tmp48_;
		_tmp42_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp43_ = errno;
		_tmp44_ = strerror (_tmp43_);
		_tmp45_ = string_to_string (_tmp44_);
		_tmp46_ = g_strconcat ("Could not convert address: ", _tmp45_, NULL);
		_tmp47_ = _tmp46_;
		fso_framework_logger_error (_tmp42_, _tmp47_);
		_g_free0 (_tmp47_);
		_tmp48_ = ((FsoFrameworkBaseTransport*) self)->fd;
		close (_tmp48_);
		((FsoFrameworkBaseTransport*) self)->fd = -1;
		result = FALSE;
		 (inaddr);
		_g_object_unref0 (address);
		__g_list_free__g_object_unref0_0 (addresses);
		_g_object_unref0 (resolver);
		return result;
	}
	_tmp49_.sin_family = 0;
	addr = _tmp49_;
	addr.sin_family = AF_INET;
	_tmp50_ = self->priv->port;
	_tmp51_ = htons (_tmp50_);
	addr.sin_port = _tmp51_;
	_tmp52_ = inaddr;
	_tmp53_ = _tmp52_.s_addr;
	addr.sin_addr.s_addr = _tmp53_;
	_tmp54_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp55_ = connect (_tmp54_, &addr, sizeof (struct sockaddr_in));
	res = _tmp55_;
	_tmp56_ = res;
	if (_tmp56_ == (-1)) {
		FsoFrameworkLogger* _tmp57_;
		gint _tmp58_;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_;
		gint _tmp63_;
		_tmp57_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp58_ = errno;
		_tmp59_ = strerror (_tmp58_);
		_tmp60_ = string_to_string (_tmp59_);
		_tmp61_ = g_strconcat ("Could not bind to socket: ", _tmp60_, NULL);
		_tmp62_ = _tmp61_;
		fso_framework_logger_error (_tmp57_, _tmp62_);
		_g_free0 (_tmp62_);
		_tmp63_ = ((FsoFrameworkBaseTransport*) self)->fd;
		close (_tmp63_);
		((FsoFrameworkBaseTransport*) self)->fd = -1;
		result = FALSE;
		 (&addr);
		 (inaddr);
		_g_object_unref0 (address);
		__g_list_free__g_object_unref0_0 (addresses);
		_g_object_unref0 (resolver);
		return result;
	}
	_tmp64_ = FSO_FRAMEWORK_TRANSPORT_CLASS (fso_framework_socket_transport_parent_class)->open ((FsoFrameworkTransport*) FSO_FRAMEWORK_BASE_TRANSPORT (self));
	result = _tmp64_;
	 (&addr);
	 (inaddr);
	_g_object_unref0 (address);
	__g_list_free__g_object_unref0_0 (addresses);
	_g_object_unref0 (resolver);
	return result;
}


static void fso_framework_socket_transport_class_init (FsoFrameworkSocketTransportClass * klass) {
	fso_framework_socket_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkSocketTransportPrivate));
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->getName = fso_framework_socket_transport_real_getName;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->repr = fso_framework_socket_transport_real_repr;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->configure = fso_framework_socket_transport_real_configure;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->open = fso_framework_socket_transport_real_open;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_socket_transport_finalize;
}


static void fso_framework_socket_transport_instance_init (FsoFrameworkSocketTransport * self) {
	self->priv = FSO_FRAMEWORK_SOCKET_TRANSPORT_GET_PRIVATE (self);
}


static void fso_framework_socket_transport_finalize (GObject* obj) {
	FsoFrameworkSocketTransport * self;
	self = FSO_FRAMEWORK_SOCKET_TRANSPORT (obj);
	G_OBJECT_CLASS (fso_framework_socket_transport_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.SocketTransport
 *
 * FSO transport abstraction using a TCP or UDP socket
 **/
GType fso_framework_socket_transport_get_type (void) {
	static volatile gsize fso_framework_socket_transport_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_socket_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkSocketTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_socket_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkSocketTransport), 0, (GInstanceInitFunc) fso_framework_socket_transport_instance_init, NULL };
		GType fso_framework_socket_transport_type_id;
		fso_framework_socket_transport_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, "FsoFrameworkSocketTransport", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_socket_transport_type_id__volatile, fso_framework_socket_transport_type_id);
	}
	return fso_framework_socket_transport_type_id__volatile;
}



