------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2010-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Refcount;         use GNATCOLL.Refcount;
with GNATCOLL.Refcount.Weakref; use GNATCOLL.Refcount.Weakref;

package Test_Refcount_Support is

   type My_Type is new Weak_Refcounted with record
      Value : Integer;
   end record;

   function Create (Value : Integer) return access My_Type;

   overriding procedure Free (Self : in out My_Type);

   package Refs is new Smart_Pointers (My_Type);
   package Weak_Refs is new Weakref.Weakref_Pointers (My_Type);

end Test_Refcount_Support;
