WITH ada.strings.unbounded;
WITH ada.tags;
WITH ada.unchecked_deallocation;

PACKAGE BODY ibusiness_unit.fm_manager IS


   TYPE private_members IS
      RECORD

         a   : boolean := false;
         b : boolean := false;

         is_initialized : boolean         := false;

         shortcut        : ada.strings.unbounded.unbounded_string;
         description     : ada.strings.unbounded.unbounded_string;
      END RECORD;

      PROCEDURE free IS NEW ada.unchecked_deallocation
      (object => object'class, name => reference);
   PROCEDURE free IS NEW ada.unchecked_deallocation
      (private_members, access_private_members);


  FUNCTION create (tracer_class_name        : IN string := "";
                    tracer_class_description : IN string := "")
                    RETURN ibusiness_unit.reference IS
      myself : reference;

   BEGIN

      myself        := NEW object;
      myself.member := NEW private_members;

      myself.member.shortcut          :=
         ada.strings.unbounded.to_unbounded_string (tracer_class_name);
      myself.member.description       :=
         ada.strings.unbounded.to_unbounded_string (tracer_class_description);

      myself.is_running := true;

      RETURN ibusiness_unit.reference (myself);

   EXCEPTION
      WHEN error: OTHERS =>
         RETURN NULL;
   END create;

  PROCEDURE initialize (ref                  : IN OUT reference;
                         s_device        : IN string;
                         c_manager        : IN string;
                         d_manager          : IN string;
                         f_manager          : IN string;
                         fz_manager    : IN string;
                         gcc_manager          : IN string;
                         gcu_manager          : IN string;
                         mode_manager         : IN string;
                         rec_manager          : IN string;
                         l_proxy            : IN string;
                         eng_data      : IN string;
                         enable : IN boolean) IS
   BEGIN

      IF NOT ref.member.is_initialized THEN
         ref.member.is_initialized := true;
      END IF;

   EXCEPTION
      WHEN error: OTHERS =>
        null;
   END initialize;

  PROCEDURE finalize (ref : IN OUT reference) IS
   BEGIN

      IF ref /= NULL THEN

         free (ref.member);
         free (ref);

      END IF;

   EXCEPTION
      WHEN error: OTHERS =>
         NULL;
   END finalize;


  PROCEDURE proceed (ref : IN OUT reference) IS
  begin
     null;
  END proceed;


   FUNCTION fire (ref : IN reference) RETURN boolean IS
   begin
      return true;
      end fire;

  FUNCTION get_info (ref : IN reference) RETURN info IS
   begin
      return info'(a => true,
                   b => false,
                   c => true);
      end get_info;


END ibusiness_unit.fm_manager;
