------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2017, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Ravenscar.Report;

package body Test_All.Sporadic_Server_With_Callback is

   -----------------
   -- Sporadic_OP --
   -----------------

   procedure Sporadic_OP (Req : In_Request_T; Res : out Out_Request_T) is
   begin
      GNAT.Ravenscar.Report.Print ("Sporadic_OP " & Natural'Image (Req.I));
      Res.I := Req.I + 1;
   end Sporadic_OP;

   --------------
   -- Callback --
   --------------

   procedure Callback (Res : in Out_Request_T) is
   begin
      GNAT.Ravenscar.Report.Print ("Callback " & Natural'Image (Res.I));
      Update_Counter;
   end Callback;

end Test_All.Sporadic_Server_With_Callback;
