------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Traces;        use GNATCOLL.Traces;
with GNATCOLL.Traces.Syslog; use GNATCOLL.Traces.Syslog;

procedure Traces3 is
   Colors : constant Trace_Handle := Create ("DEBUG.COLORS");
   Time   : constant Trace_Handle := Create ("DEBUG.ABSOLUTE_TIME");
   Me1 : GNATCOLL.Traces.Trace_Handle;
   Me2 : GNATCOLL.Traces.Trace_Handle;
   Me3 : GNATCOLL.Traces.Trace_Handle;
begin
   Set_Active (Colors, True);
   Set_Active (Time, True);
   Register_Syslog_Stream;
   Me1 := Create ("MODULE1", On, "&syslog");
   Me2 := Create ("MODULE2", On, "&syslog:local0:info");
   Me3 := Create ("MODULE2", On, "&syslog:local0:error");

   Trace (Me1, "Message 1");
   Trace (Me2, "Message 2");
   Trace (Me3, "Message 3");
end Traces3;
