#!/bin/sh

# utility function
check_duplications() {
   prefix="$1"
   entity_ref_request="select *,count(*) from entity_refs group by entity, file, line, column, kind, caller, from_instantiation having count(*) > 1;"
   f2f_request="select *,count(*) from f2f group by fromFile, toFile, kind  having count(*) >1 ;"
   e2e_request="select *,count(*) from e2e group by fromEntity, toEntity, kind, order_by  having count(*) >1 ;"

   echo "$prefix"
   echo "$entity_ref_request" | $SQLITE3_SHELL obj/gnatinspect.db
   echo "$e2e_request" | $SQLITE3_SHELL obj/gnatinspect.db
   echo "$f2f_request" | $SQLITE3_SHELL obj/gnatinspect.db
}


# cleanup
gprclean -q -Psimulation
rm -f obj/gnatinspect.db

# build and run gnatinspect the first time
gprbuild -f -q -p -Psimulation
gnatinspect --exit -Psimulation
check_duplications "First run"

# make sure timestamps get updated
sleep 2

# rebuild and relaunch gnatinspect
gprbuild -f -q -Psimulation
gnatinspect --exit -Psimulation

check_duplications "Second run"
