package Pkg is
   --
   -- @description
   -- This is some sample documentation to test if GNATdoc can handle
   -- enumeration types consisting of simple characters.
   type Foo_Type is
     (' ',
      '0',
      '1',
      '2',
      '?');

   type Temp_Type is range -2 ** 31 .. 2 ** 31 - 1;

   subtype Value_Type   is Temp_Type;

   subtype Mode_1_Index_Type is Positive range 1 .. 4;

   subtype Mode_1_Code_Image_Type is String(Mode_1_Index_Type);

   type Mode_1_Code_Type is private;

   function Encode(Code : in Mode_1_Code_Type) return Value_Type;

   procedure Test (V : in out Foo_Type);

 private

     type Mode_1_Code_Type is record
        Code : Mode_1_Code_Image_Type := (others => '0');
     end record;

end;
