
IF (DEFINED ZYPP_PREFIX)
  MESSAGE(STATUS "ZYpp library prefix set to ${ZYPP_PREFIX}")
ELSE (DEFINED ZYPP_PREFIX)
  MESSAGE(STATUS "ZYpp path not set. Looking for it.")
ENDIF (DEFINED ZYPP_PREFIX)

if(ZYPP_INCLUDE_DIR AND ZYPP_LIBRARY)
	# Already in cache, be silent
	SET(ZYPP_FIND_QUIETLY TRUE)	
endif(ZYPP_INCLUDE_DIR AND ZYPP_LIBRARY)

set(ZYPP_LIBRARY)
set(ZYPP_INCLUDE_DIR)

IF (DEFINED ZYPP_PREFIX)
  MESSAGE( STATUS "Looking in ${ZYPP_PREFIX}")
  FIND_PATH(ZYPP_INCLUDE_DIR zypp/ZYpp.h
    ${ZYPP_PREFIX}/include
    NO_DEFAULT_PATH
    NO_SYSTEM_ENVIRONMENT_PATH
    NO_CMAKE_SYSTEM_PATH
  )
  FIND_LIBRARY(ZYPP_LIBRARY NAMES zypp
    PATHS
    ${ZYPP_PREFIX}/lib
    ${ZYPP_PREFIX}/lib64
    NO_DEFAULT_PATH
    NO_SYSTEM_ENVIRONMENT_PATH
    NO_CMAKE_SYSTEM_PATH
  )
ELSE (DEFINED ZYPP_PREFIX)
  FIND_PATH(ZYPP_INCLUDE_DIR zypp/ZYpp.h
    /usr/include
    /usr/local/include
  )
  FIND_LIBRARY(ZYPP_LIBRARY NAMES zypp
    PATHS
    /usr/lib
    /usr/local/lib
  )
ENDIF (DEFINED ZYPP_PREFIX)

if(ZYPP_INCLUDE_DIR AND ZYPP_LIBRARY)
   MESSAGE( STATUS "ZYpp found: includes in ${ZYPP_INCLUDE_DIR}, library in ${ZYPP_LIBRARY}")
   set(ZYPP_FOUND TRUE)
else(ZYPP_INCLUDE_DIR AND ZYPP_LIBRARY)
   MESSAGE( FATAL "ZYpp not found")
endif(ZYPP_INCLUDE_DIR AND ZYPP_LIBRARY)

MARK_AS_ADVANCED(ZYPP_INCLUDE_DIR ZYPP_LIBRARY)
