
doc ///
	Key
		"First Lie algebra tutorial"
	
	Description
		Text
	       	        In this elementary tutorial, we give a brief introduction 
			on how to use the package 
			GradedLieAlgebras.	
					    	    	
		Text
		    	The most common way to construct a Lie algebra 
			is by means of the constructor @TO lieAlgebra@, which
			produces a free Lie algebra on the generators given
			in input.

		
			
		Example
		        L = lieAlgebra{a,b}
			dims(1,5,L)
			
		Text
		        The above list is the dimensions in degrees 1 to 5 of the 
			free Lie algebra on two generators (of degree 1).
			To get an explicit basis in a certain degree,
			use 
			 @TO "basis(ZZ,LieAlgebra)"@. 
			
		Example
			basis(2,L)
			basis(3,L)
			
		Text
		        The basis elements in degree 3 given above should be interpreted as 
			[$a$, [$b$, $a$ ]] and [$b$, [$b$, $a$]]. 
			To multiply two Lie elements, use 
			@TO (symbol SPACE,LieElement,LieElement)@. 
			The operator SPACE is right 
			associative, so writing ($a$ $a$ $a$ $b$) as input 
			gives the Lie monomial [$a$, [$a$, [$a$, $b$]]],
			which in output is written in the same way as input. 
			A linear combination of Lie monomials
			is written in the natural way.  
			
		Example
			p = (a b) (a a b + 3 b b a) 
							
		Text
			The output is a linear 
			combination of the basis elements
			of degree 5.
			
		Example 
		    	basis(5,L)
			
		Text				
		        The element $p$ in $L$ may be used to define 
			a quotient Lie algebra by the ideal generated by $p$.
			
				
		Example
		        Q = L/{p}	
		        dims(1,5,Q)
			
		Text
		        As expected, the dimension in degree 5 of $Q$ is 1 less than 
			that of $L$.
		 
		Text
		        When $L$ is a big free Lie algebra it may be better to 
			define the relations in a "formal" manner. For an example,
			see @TO "Minimal models, Ext-algebras and Koszul duals"@.
			
		Text
		        A generator for a Lie algebra may be any variable
			name including indexed variables. Also, the same
			names can be used in different Lie algebras or even 
			rings. Use @TO "use(LieAlgebra)"@ 
			to switch between
			Lie algebras.
		
			
	        Example
		        L = lieAlgebra{a,b}
			M = lieAlgebra{a,b}/{a b}
			R = QQ[a,b]
			use L
			a b
			use M
			a b
			use R
			a*b
		      
						
	SeeAlso		    		        
		 "Second Lie algebra tutorial"
		 "Differential Lie algebra tutorial"	      
		 "Homomorphisms and derivations"
		 "Quotient Lie algebras and subspaces"
				       	 
///
end