/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FlextraExaminer_H
#define FlextraExaminer_H

#include <QMainWindow>
#include <QModelIndex>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"

class QPlainTextEdit;
class QSplitter;
class QTreeWidget;
class QTreeWidgetItem;

class MvFlextra;
class MvQFileInfoLabel;
class MvQLogBrowser;
class MvQPlainTextEditSearchLine;

using namespace std;

class FlextraExaminer : public MvQMainWindow
{
    Q_OBJECT

public:
    	FlextraExaminer(QWidget *parent = 0);
	~FlextraExaminer();
    	bool initData(const string&,const string&);
	void updateFileInfoLabel();

public slots:
	void slotShowAboutBox();
	void slotUpdateLogOutput();
	void slotClearLog(bool);
	void slotStatusMessage(QString);		
	void slotBlockSelected(QTreeWidgetItem*,QTreeWidgetItem*);
	void slotContextMenu(const QPoint &);

signals:
	void statusMessage(QString);

private:
	void setupEditActions();
	void setupViewActions();
	void setupHelpActions();
	void setupBlockPanel();
	void setupDumpPanel();
	void setupFindPanel();
	void setupLogArea();

	void readSettings();
	void writeSettings();

	MvFlextra *data_;
	string tmpFilePath_;
	string iconPath_;
	
	MvQMainWindow::MenuItemMap menuItems_;
	MvQFileInfoLabel*  fileInfoLabel_;

	QAction* actionFileInfo_;
	QSplitter* mainSplitter_;
	QSplitter* centralSplitter_;
	MvQLogBrowser* logBrowser_;
	QWidget* logPanel_;
	QAction* actionLog_;
	QLabel* statusMessageLabel_;
	MvQPlainTextEditSearchLine* findPanel_;
	
	QWidget* blockPanel_;
	QWidget* dumpPanel_;
	QPlainTextEdit* dumpText_;
	QTreeWidget* blockTree_;	
};

#endif
