/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef BaseTextEditor_H
#include "BaseTextEditor.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif

BaseTextEditor::BaseTextEditor(const IconClass& name,const string& kind):
	XEditor<UITextEditor_c>(name,kind)
{
}

BaseTextEditor::~BaseTextEditor()
{
}

void BaseTextEditor::apply()
{
	XMText text(text_);
	text.save(current_->path());
}

void BaseTextEditor::reset()
{
	InternalEditor::reset();

	XMText text(text_);
	text.load(current_->path());
	modified_ = false;
}

void BaseTextEditor::close()
{
	XMText text(text_);
	text.clear();
}

void BaseTextEditor::merge(IconObject* o)
{
	XMText text(text_);
	text.insert(o->dropText());
}
void BaseTextEditor::replace(IconObject* o)
{
	XMText text(text_);
	text.load(o->dropText());
}

string BaseTextEditor::alternateEditor()
{
	return "ExternalTextEditor";
}

bool BaseTextEditor::modified()
{
	return modified_;
}

void BaseTextEditor::modifiedCB(Widget,XtPointer)
{
	modified_ = true;
}

