/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExternalServiceEditor_H
#include "ExternalServiceEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif
#include "Action.h"

ExternalServiceEditor::ExternalServiceEditor(const IconClass& name,const string& kind):
	ExternalEditor(name,kind)
{
}

void ExternalServiceEditor::edit()
{
	Action action("edit");
	task_ = current_->action(action);  //add the action to the Queue
	task_->add(this);		   //notify observers
}

void ExternalServiceEditor::raise()
{
	if (temporary_)
		this->edit();
	else
		 temporary_ = true;
}

static EditorMaker<ExternalServiceEditor> editorMaker("ExternalServiceEditor");
