/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ListHelp_H
#include "ListHelp.h"
#endif

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif


ListHelp::ListHelp(Widget parent, RequestPanel& owner, const Parameter& def):
	XHelp<UIListHelp_c>(parent, owner, def),
	xlist_(list_,def)
{     
}

ListHelp::~ListHelp()
{
}

void ListHelp::refresh(const vector<string>& values)
{
	xlist_.set(values);
}

long ListHelp::flags()
{
	return EXPAND_FIRST_NAME;
}

void ListHelp::set(Request& r) 
{
	r.set(param_.name(),xlist_.get());
}

void ListHelp::browseCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);
}

void ListHelp::singleCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);
}

void ListHelp::multipleCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);
}

void ListHelp::extendedCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);
}

static HelpMaker<ListHelp> maker("help_multiple_selection");
//static HelpMaker<ListHelp> maker1("colour");
//static HelpMaker<ListHelp> maker2("help_colour");
