/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TABP_H
#define TABP_H

#include <Xm/XmP.h>
#include <Xm/DrawingAP.h>

typedef struct _TabClassPart {
    int         ignore;
} TabClassPart;

typedef struct _TabClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmDrawingAreaClassPart  drawing_area_class;
    TabClassPart     tab_class;
} TabClassRec;

extern TabClassRec tabClassRec;

typedef struct {
	XtCallbackList cb;
	XtCallbackList open_cb;
	XtCallbackList close_cb;
	XmFontList     font;
	Widget         current;
	GC             gc;
	Pixel          back;
	Pixel          blue;

	Dimension      hmargin;
	Dimension      vmargin;

	Dimension      title;
	Dimension      top;
	Dimension      bottom;

	int            delta;
	int            first;
	int            last;

	Boolean        drawer;
	Time            last_click;

	Boolean         drag;
	Boolean         wait;
	int             last_x;
	int             last_y;

} TabPart;

typedef struct _TabConstraintsPart {
	XmString name;
} TabConstraintsPart;


typedef struct _TabRec {
    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XmManagerPart    manager;
    XmDrawingAreaPart   drawing_area;
    TabPart      tab;
}  TabRec;

typedef struct _TabConstraintsRec {
    /* XmManagerConstraintPart     manager;
    XmDrawingAreaConstraintPart drawing_area; */
    TabConstraintsPart          tab;
} TabConstraintsRec, *TabConstraints;


#define TAB_CONSTRAINT(w) \
                   ((TabConstraints)((w)->core.constraints))


#define XtTabNumChildren(w) (((TabWidget)w) -> composite.num_children)
#define XtTabChild(w,i)     (((TabWidget)w) -> composite.children[i])

#endif /* TABP_H */



