/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  Plot Mod
//
// .AUTHOR:
//  Gilberto Camara, Baudoin Raoult and Fernando Ii
//
// .SUMMARY:
//  Defines an concrete class for higher level of control of Plot Mod.
//
//
// .CLIENTS:
//   This class is used the "main" module and by any METVIEW
//   object which needs to know, whether METVIEW is in interative
//   or in batch mode
// 
// .RESPONSIBILITIES:
//   - Inform the other classes about the operation of METVIEW
//     (interactive or bacth mode)
//
//
// .COLLABORATORS:
//   PlotModApp ( which will be either PlotModXApp or PlotModBatchApp).
//
// .DESCENDENT:
//   (none)
//
// .RELATED:
//   (none)
//
// .ASCENDENT:
//   (none)
//
#ifndef PlotMod_H
#define PlotMod_H

#include "MvRequest.h"
#include "MagicsObserver.h"

class MvStopWatch;

class PlotMod : public magics::MagicsObserver 
{

public:
	// Access to singleton object
	static PlotMod *plotModInstance_;
	static PlotMod& Instance();
	static void Instance(PlotMod*);

	// Default Constructor/Destructor
	PlotMod();
	~PlotMod() {}

	// Returns running mode: true: interactive, false: batch
	bool IsInteractive () { return isInteractive_; }

	// Window mode functions
//	bool CheckSetWindowOutputFormat( MvRequest& );	//Check and set
	bool IsWindow( const char* );			//Check a given driver
	bool IsWindow() { return isWindow_; }		//Inquire current status

	// Check/initialize request came from a Macro
	void CalledFromMacro ( bool flag ) { calledFromMacro_ = flag; }
	bool CalledFromMacro () { return calledFromMacro_; }
	bool CalledFromMacro ( MvRequest& );

	// Output Format methods
	MvRequest OutputFormatInfo();		// Get output info
 	MvRequest OutputFormat(); 		// Get request
	MvRequest MakeDefaultOutputFormat();  	// Get default
	void OutputFormat( MvRequest& ); 	// Initialize
	const char* Destination()		// "SCREEN","PRINTER","PREVIEW"
		{ return plotDestination_.c_str(); }
	const char* PrinterName()		// name of the printer
		{ return printerName_.c_str(); }

	// Internal Error should not happen in user version
//	static void InternalError ( const string & message, const string & title = string() );

	// System Error is used when probems are in one of the modules that PlotMod uses
	// including OpenGL
	virtual void SystemError   ( const string & message, const string & title = string() ) = 0;

	// Metview Error is due to user defining wrong parameters
	void MetviewError ( const string & message, const string & errorlevel = string() );
	
	// Show message dialog
	virtual void UserMessage  ( const string& ) = 0;

	// print a message to the log window or the output so it will be visible without '-slog'
	virtual void printMessage (const string&, bool) = 0;

	// the module will exit with an error code
	void exitWithError ();

 	// change/query the error message behaviour
	void setExitOnErrorMessage(bool toggle) {exitOnErrorMessage_ = toggle;};
	bool exitOnErrorMessage()               {return exitOnErrorMessage_;};
	void setpopupErrorMessage(bool toggle)  {popupErrorMessage_ = toggle;};
	bool popupErrorMessage()                {return popupErrorMessage_;};


	void warningMessage     (const string&);
	void errorMessage       (const string&);
	void infoMessage        (const string&);
	virtual void progressMessage    (const string&) {};

	// Timing methods
	void watchStart(const char*);   // Starts and names the session
	void watchLaptime(const char*); // Prints the laptime since the previous call to
                                    // watchLaptime() or from watchStart()
	void watchStop();               // Stops and prints a report

protected:
	bool isInteractive_;
	bool isWindow_;             // output on screen?
	bool calledFromMacro_;      // request came from Macro?
	bool exitOnErrorMessage_;   // do we exit when we get an error message?
	bool popupErrorMessage_;    // pop-up error messages?
	MvRequest outFormat_;       // output format info
	string plotDestination_;    // "SCREEN","PRINTER","PREVIEW"."FILE"
	string printerName_;        // name of the printer
	MvStopWatch* watch_;        // timing debug
};
#endif
