---
id: fast-foundation.calendar
title: Calendar class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Calendar](./fast-foundation.calendar.md)

## Calendar class

Calendar component


- The default slot for calendar content


dateselected - Fires a custom 'dateselected' event when Enter is invoked via keyboard on a date

<b>Signature:</b>

```typescript
export declare class Calendar extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [dateFormatter](./fast-foundation.calendar.dateformatter.md) |  | [DateFormatter](./fast-foundation.dateformatter.md) | date formatter utitlity for getting localized strings |
|  [dayFormat](./fast-foundation.calendar.dayformat.md) |  | [DayFormat](./fast-foundation.dayformat.md) | Format style for the day |
|  [disabledDates](./fast-foundation.calendar.disableddates.md) |  | string | A list of dates that should be shown as disabled |
|  [locale](./fast-foundation.calendar.locale.md) |  | string | String repesentation of the full locale including market, calendar type and numbering system |
|  [minWeeks](./fast-foundation.calendar.minweeks.md) |  | number | Minimum number of weeks to show for the month This can be used to normalize the calendar view when changing or across multiple calendars |
|  [month](./fast-foundation.calendar.month.md) |  | number | Month to display |
|  [monthFormat](./fast-foundation.calendar.monthformat.md) |  | [MonthFormat](./fast-foundation.monthformat.md) | Format style for the month label |
|  [readonly](./fast-foundation.calendar.readonly.md) |  | boolean | Readonly attribute for turning off data-grid |
|  [selectedDates](./fast-foundation.calendar.selecteddates.md) |  | string | A list of dates that should be shown as highlighted |
|  [weekdayFormat](./fast-foundation.calendar.weekdayformat.md) |  | [WeekdayFormat](./fast-foundation.weekdayformat.md) | Format style for the week day labels |
|  [year](./fast-foundation.calendar.year.md) |  | number | Year of the month to display |
|  [yearFormat](./fast-foundation.calendar.yearformat.md) |  | [YearFormat](./fast-foundation.yearformat.md) | Format style for the year used in the title |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [dateInString(date, datesString)](./fast-foundation.calendar.dateinstring.md) |  | A helper function that checks if a date exists in a list of dates |
|  [getDayClassNames(date, todayString)](./fast-foundation.calendar.getdayclassnames.md) |  | Creates a class string for the day container |
|  [getDays(info, minWeeks)](./fast-foundation.calendar.getdays.md) |  | A list of calendar days |
|  [getMonthInfo(month, year)](./fast-foundation.calendar.getmonthinfo.md) |  | Gets data needed to render about a calendar month as well as the previous and next months |
|  [getWeekdayText()](./fast-foundation.calendar.getweekdaytext.md) |  | Returns a list of weekday labels |
|  [handleDateSelect(event, day)](./fast-foundation.calendar.handledateselect.md) |  | Emits the "date-select" event with the day, month and year. |
|  [handleKeydown(event, date)](./fast-foundation.calendar.handlekeydown.md) |  | Handles keyboard events on a cell |
