import { Plugin } from 'rollup';
import { Loader } from 'esbuild';
import { FilterPattern } from '@rollup/pluginutils';

declare type Options = {
    include?: FilterPattern;
    exclude?: FilterPattern;
    sourceMap?: boolean;
    minify?: boolean;
    target?: string | string[];
    jsxFactory?: string;
    jsxFragment?: string;
    define?: {
        [k: string]: string;
    };
    /**
     * Use this tsconfig file instead
     * Disable it by setting to `false`
     */
    tsconfig?: string | false;
    /**
     * Map extension to esbuild loader
     * Note that each entry (the extension) needs to start with a dot
     */
    loaders?: {
        [ext: string]: Loader | false;
    };
};
declare const _default: (options?: Options) => Plugin;

export default _default;
export { Options };
