
module odbql_constants
  implicit none

character(len=*), parameter :: ODBQL_VERSION = "3.13.0" ! 
integer, parameter :: ODBQL_VERSION_NUMBER = 3013000 ! 
character(len=*), parameter :: ODBQL_SOURCE_ID = "2016-05-18 10:57:30 fc49f556e48970561d7ab6a2f24fdd7d9eb81ff2" ! 
integer, parameter :: ODBQL_OK = 0 !  Successful result 
integer, parameter :: ODBQL_ERROR = 1 !  SQL error or missing database 
integer, parameter :: ODBQL_INTERNAL = 2 !  Internal logic error in SQLite 
integer, parameter :: ODBQL_PERM = 3 !  Access permission denied 
integer, parameter :: ODBQL_ABORT = 4 !  Callback routine requested an abort 
integer, parameter :: ODBQL_BUSY = 5 !  The database file is locked 
integer, parameter :: ODBQL_LOCKED = 6 !  A table in the database is locked 
integer, parameter :: ODBQL_NOMEM = 7 !  A malloc() failed 
integer, parameter :: ODBQL_READONLY = 8 !  Attempt to write a readonly database 
integer, parameter :: ODBQL_INTERRUPT = 9 !  Operation terminated by odbql_interrupt()
integer, parameter :: ODBQL_IOERR = 10 !  Some kind of disk I/O error occurred 
integer, parameter :: ODBQL_CORRUPT = 11 !  The database disk image is malformed 
integer, parameter :: ODBQL_NOTFOUND = 12 !  Unknown opcode in odbql_file_control() 
integer, parameter :: ODBQL_FULL = 13 !  Insertion failed because database is full 
integer, parameter :: ODBQL_CANTOPEN = 14 !  Unable to open the database file 
integer, parameter :: ODBQL_PROTOCOL = 15 !  Database lock protocol error 
integer, parameter :: ODBQL_EMPTY = 16 !  Database is empty 
integer, parameter :: ODBQL_SCHEMA = 17 !  The database schema changed 
integer, parameter :: ODBQL_TOOBIG = 18 !  String or BLOB exceeds size limit 
integer, parameter :: ODBQL_CONSTRAINT = 19 !  Abort due to constraint violation 
integer, parameter :: ODBQL_MISMATCH = 20 !  Data type mismatch 
integer, parameter :: ODBQL_MISUSE = 21 !  Library used incorrectly 
integer, parameter :: ODBQL_NOLFS = 22 !  Uses OS features not supported on host 
integer, parameter :: ODBQL_AUTH = 23 !  Authorization denied 
integer, parameter :: ODBQL_FORMAT = 24 !  Auxiliary database format error 
integer, parameter :: ODBQL_RANGE = 25 !  2nd parameter to odbql_bind out of range 
integer, parameter :: ODBQL_NOTADB = 26 !  File opened that is not a database file 
integer, parameter :: ODBQL_NOTICE = 27 !  Notifications from odbql_log() 
integer, parameter :: ODBQL_WARNING = 28 !  Warnings from odbql_log() 
integer, parameter :: ODBQL_ROW = 100 !  odbql_step() has another row ready 
integer, parameter :: ODBQL_DONE = 101 !  odbql_step() has finished executing 
integer, parameter :: ODBQL_METADATA_CHANGED = 102 !  odbql_step(): metadata has changed 
integer, parameter :: ODBQL_IOERR_READ = IOR(ODBQL_IOERR, LSHIFT(1,8)) ! (ODBQL_IOERR | (1<<8))  [266]
integer, parameter :: ODBQL_IOERR_SHORT_READ = IOR(ODBQL_IOERR, LSHIFT(2,8)) ! (ODBQL_IOERR | (2<<8))  [522]
integer, parameter :: ODBQL_IOERR_WRITE = IOR(ODBQL_IOERR, LSHIFT(3,8)) ! (ODBQL_IOERR | (3<<8))  [778]
integer, parameter :: ODBQL_IOERR_FSYNC = IOR(ODBQL_IOERR, LSHIFT(4,8)) ! (ODBQL_IOERR | (4<<8))  [1034]
integer, parameter :: ODBQL_IOERR_DIR_FSYNC = IOR(ODBQL_IOERR, LSHIFT(5,8)) ! (ODBQL_IOERR | (5<<8))  [1290]
integer, parameter :: ODBQL_IOERR_TRUNCATE = IOR(ODBQL_IOERR, LSHIFT(6,8)) ! (ODBQL_IOERR | (6<<8))  [1546]
integer, parameter :: ODBQL_IOERR_FSTAT = IOR(ODBQL_IOERR, LSHIFT(7,8)) ! (ODBQL_IOERR | (7<<8))  [1802]
integer, parameter :: ODBQL_IOERR_UNLOCK = IOR(ODBQL_IOERR, LSHIFT(8,8)) ! (ODBQL_IOERR | (8<<8))  [2058]
integer, parameter :: ODBQL_IOERR_RDLOCK = IOR(ODBQL_IOERR, LSHIFT(9,8)) ! (ODBQL_IOERR | (9<<8))  [2314]
integer, parameter :: ODBQL_IOERR_DELETE = IOR(ODBQL_IOERR, LSHIFT(10,8)) ! (ODBQL_IOERR | (10<<8))  [2570]
integer, parameter :: ODBQL_IOERR_BLOCKED = IOR(ODBQL_IOERR, LSHIFT(11,8)) ! (ODBQL_IOERR | (11<<8))  [2826]
integer, parameter :: ODBQL_IOERR_NOMEM = IOR(ODBQL_IOERR, LSHIFT(12,8)) ! (ODBQL_IOERR | (12<<8))  [3082]
integer, parameter :: ODBQL_IOERR_ACCESS = IOR(ODBQL_IOERR, LSHIFT(13,8)) ! (ODBQL_IOERR | (13<<8))  [3338]
integer, parameter :: ODBQL_IOERR_CHECKRESERVEDLOCK = IOR(ODBQL_IOERR, LSHIFT(14,8)) ! (ODBQL_IOERR | (14<<8))  [3594]
integer, parameter :: ODBQL_IOERR_LOCK = IOR(ODBQL_IOERR, LSHIFT(15,8)) ! (ODBQL_IOERR | (15<<8))  [3850]
integer, parameter :: ODBQL_IOERR_CLOSE = IOR(ODBQL_IOERR, LSHIFT(16,8)) ! (ODBQL_IOERR | (16<<8))  [4106]
integer, parameter :: ODBQL_IOERR_DIR_CLOSE = IOR(ODBQL_IOERR, LSHIFT(17,8)) ! (ODBQL_IOERR | (17<<8))  [4362]
integer, parameter :: ODBQL_IOERR_SHMOPEN = IOR(ODBQL_IOERR, LSHIFT(18,8)) ! (ODBQL_IOERR | (18<<8))  [4618]
integer, parameter :: ODBQL_IOERR_SHMSIZE = IOR(ODBQL_IOERR, LSHIFT(19,8)) ! (ODBQL_IOERR | (19<<8))  [4874]
integer, parameter :: ODBQL_IOERR_SHMLOCK = IOR(ODBQL_IOERR, LSHIFT(20,8)) ! (ODBQL_IOERR | (20<<8))  [5130]
integer, parameter :: ODBQL_IOERR_SHMMAP = IOR(ODBQL_IOERR, LSHIFT(21,8)) ! (ODBQL_IOERR | (21<<8))  [5386]
integer, parameter :: ODBQL_IOERR_SEEK = IOR(ODBQL_IOERR, LSHIFT(22,8)) ! (ODBQL_IOERR | (22<<8))  [5642]
integer, parameter :: ODBQL_IOERR_DELETE_NOENT = IOR(ODBQL_IOERR, LSHIFT(23,8)) ! (ODBQL_IOERR | (23<<8))  [5898]
integer, parameter :: ODBQL_IOERR_MMAP = IOR(ODBQL_IOERR, LSHIFT(24,8)) ! (ODBQL_IOERR | (24<<8))  [6154]
integer, parameter :: ODBQL_IOERR_GETTEMPPATH = IOR(ODBQL_IOERR, LSHIFT(25,8)) ! (ODBQL_IOERR | (25<<8))  [6410]
integer, parameter :: ODBQL_IOERR_CONVPATH = IOR(ODBQL_IOERR, LSHIFT(26,8)) ! (ODBQL_IOERR | (26<<8))  [6666]
integer, parameter :: ODBQL_IOERR_VNODE = IOR(ODBQL_IOERR, LSHIFT(27,8)) ! (ODBQL_IOERR | (27<<8))  [6922]
integer, parameter :: ODBQL_IOERR_AUTH = IOR(ODBQL_IOERR, LSHIFT(28,8)) ! (ODBQL_IOERR | (28<<8))  [7178]
integer, parameter :: ODBQL_LOCKED_SHAREDCACHE = IOR(ODBQL_LOCKED, LSHIFT(1,8)) ! (ODBQL_LOCKED |  (1<<8))  [262]
integer, parameter :: ODBQL_BUSY_RECOVERY = IOR(ODBQL_BUSY, LSHIFT(1,8)) ! (ODBQL_BUSY   |  (1<<8))  [261]
integer, parameter :: ODBQL_BUSY_SNAPSHOT = IOR(ODBQL_BUSY, LSHIFT(2,8)) ! (ODBQL_BUSY   |  (2<<8))  [517]
integer, parameter :: ODBQL_CANTOPEN_NOTEMPDIR = IOR(ODBQL_CANTOPEN, LSHIFT(1,8)) ! (ODBQL_CANTOPEN | (1<<8))  [270]
integer, parameter :: ODBQL_CANTOPEN_ISDIR = IOR(ODBQL_CANTOPEN, LSHIFT(2,8)) ! (ODBQL_CANTOPEN | (2<<8))  [526]
integer, parameter :: ODBQL_CANTOPEN_FULLPATH = IOR(ODBQL_CANTOPEN, LSHIFT(3,8)) ! (ODBQL_CANTOPEN | (3<<8))  [782]
integer, parameter :: ODBQL_CANTOPEN_CONVPATH = IOR(ODBQL_CANTOPEN, LSHIFT(4,8)) ! (ODBQL_CANTOPEN | (4<<8))  [1038]
integer, parameter :: ODBQL_CORRUPT_VTAB = IOR(ODBQL_CORRUPT, LSHIFT(1,8)) ! (ODBQL_CORRUPT | (1<<8))  [267]
integer, parameter :: ODBQL_READONLY_RECOVERY = IOR(ODBQL_READONLY, LSHIFT(1,8)) ! (ODBQL_READONLY | (1<<8))  [264]
integer, parameter :: ODBQL_READONLY_CANTLOCK = IOR(ODBQL_READONLY, LSHIFT(2,8)) ! (ODBQL_READONLY | (2<<8))  [520]
integer, parameter :: ODBQL_READONLY_ROLLBACK = IOR(ODBQL_READONLY, LSHIFT(3,8)) ! (ODBQL_READONLY | (3<<8))  [776]
integer, parameter :: ODBQL_READONLY_DBMOVED = IOR(ODBQL_READONLY, LSHIFT(4,8)) ! (ODBQL_READONLY | (4<<8))  [1032]
integer, parameter :: ODBQL_ABORT_ROLLBACK = IOR(ODBQL_ABORT, LSHIFT(2,8)) ! (ODBQL_ABORT | (2<<8))  [516]
integer, parameter :: ODBQL_CONSTRAINT_CHECK = IOR(ODBQL_CONSTRAINT, LSHIFT(1,8)) ! (ODBQL_CONSTRAINT | (1<<8))  [275]
integer, parameter :: ODBQL_CONSTRAINT_COMMITHOOK = IOR(ODBQL_CONSTRAINT, LSHIFT(2,8)) ! (ODBQL_CONSTRAINT | (2<<8))  [531]
integer, parameter :: ODBQL_CONSTRAINT_FOREIGNKEY = IOR(ODBQL_CONSTRAINT, LSHIFT(3,8)) ! (ODBQL_CONSTRAINT | (3<<8))  [787]
integer, parameter :: ODBQL_CONSTRAINT_FUNCTION = IOR(ODBQL_CONSTRAINT, LSHIFT(4,8)) ! (ODBQL_CONSTRAINT | (4<<8))  [1043]
integer, parameter :: ODBQL_CONSTRAINT_NOTNULL = IOR(ODBQL_CONSTRAINT, LSHIFT(5,8)) ! (ODBQL_CONSTRAINT | (5<<8))  [1299]
integer, parameter :: ODBQL_CONSTRAINT_PRIMARYKEY = IOR(ODBQL_CONSTRAINT, LSHIFT(6,8)) ! (ODBQL_CONSTRAINT | (6<<8))  [1555]
integer, parameter :: ODBQL_CONSTRAINT_TRIGGER = IOR(ODBQL_CONSTRAINT, LSHIFT(7,8)) ! (ODBQL_CONSTRAINT | (7<<8))  [1811]
integer, parameter :: ODBQL_CONSTRAINT_UNIQUE = IOR(ODBQL_CONSTRAINT, LSHIFT(8,8)) ! (ODBQL_CONSTRAINT | (8<<8))  [2067]
integer, parameter :: ODBQL_CONSTRAINT_VTAB = IOR(ODBQL_CONSTRAINT, LSHIFT(9,8)) ! (ODBQL_CONSTRAINT | (9<<8))  [2323]
integer, parameter :: ODBQL_CONSTRAINT_ROWID = IOR(ODBQL_CONSTRAINT, LSHIFT(10,8)) ! (ODBQL_CONSTRAINT |(10<<8))  [2579]
integer, parameter :: ODBQL_NOTICE_RECOVER_WAL = IOR(ODBQL_NOTICE, LSHIFT(1,8)) ! (ODBQL_NOTICE | (1<<8))  [283]
integer, parameter :: ODBQL_NOTICE_RECOVER_ROLLBACK = IOR(ODBQL_NOTICE, LSHIFT(2,8)) ! (ODBQL_NOTICE | (2<<8))  [539]
integer, parameter :: ODBQL_WARNING_AUTOINDEX = IOR(ODBQL_WARNING, LSHIFT(1,8)) ! (ODBQL_WARNING | (1<<8))  [284]
integer, parameter :: ODBQL_AUTH_USER = IOR(ODBQL_AUTH, LSHIFT(1,8)) ! (ODBQL_AUTH | (1<<8))  [279]
integer, parameter :: ODBQL_OPEN_READONLY = 1 ! 0x00000001  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_READWRITE = 2 ! 0x00000002  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_CREATE = 4 ! 0x00000004  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_DELETEONCLOSE = 8 ! 0x00000008  VFS only 
integer, parameter :: ODBQL_OPEN_EXCLUSIVE = 16 ! 0x00000010  VFS only 
integer, parameter :: ODBQL_OPEN_AUTOPROXY = 32 ! 0x00000020  VFS only 
integer, parameter :: ODBQL_OPEN_URI = 64 ! 0x00000040  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_MEMORY = 128 ! 0x00000080  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_MAIN_DB = 256 ! 0x00000100  VFS only 
integer, parameter :: ODBQL_OPEN_TEMP_DB = 512 ! 0x00000200  VFS only 
integer, parameter :: ODBQL_OPEN_TRANSIENT_DB = 1024 ! 0x00000400  VFS only 
integer, parameter :: ODBQL_OPEN_MAIN_JOURNAL = 2048 ! 0x00000800  VFS only 
integer, parameter :: ODBQL_OPEN_TEMP_JOURNAL = 4096 ! 0x00001000  VFS only 
integer, parameter :: ODBQL_OPEN_SUBJOURNAL = 8192 ! 0x00002000  VFS only 
integer, parameter :: ODBQL_OPEN_MASTER_JOURNAL = 16384 ! 0x00004000  VFS only 
integer, parameter :: ODBQL_OPEN_NOMUTEX = 32768 ! 0x00008000  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_FULLMUTEX = 65536 ! 0x00010000  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_SHAREDCACHE = 131072 ! 0x00020000  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_PRIVATECACHE = 262144 ! 0x00040000  Ok for odbql_open_v2() 
integer, parameter :: ODBQL_OPEN_WAL = 524288 ! 0x00080000  VFS only 
integer, parameter :: ODBQL_IOCAP_ATOMIC = 1 ! 0x00000001 
integer, parameter :: ODBQL_IOCAP_ATOMIC512 = 2 ! 0x00000002 
integer, parameter :: ODBQL_IOCAP_ATOMIC1K = 4 ! 0x00000004 
integer, parameter :: ODBQL_IOCAP_ATOMIC2K = 8 ! 0x00000008 
integer, parameter :: ODBQL_IOCAP_ATOMIC4K = 16 ! 0x00000010 
integer, parameter :: ODBQL_IOCAP_ATOMIC8K = 32 ! 0x00000020 
integer, parameter :: ODBQL_IOCAP_ATOMIC16K = 64 ! 0x00000040 
integer, parameter :: ODBQL_IOCAP_ATOMIC32K = 128 ! 0x00000080 
integer, parameter :: ODBQL_IOCAP_ATOMIC64K = 256 ! 0x00000100 
integer, parameter :: ODBQL_IOCAP_SAFE_APPEND = 512 ! 0x00000200 
integer, parameter :: ODBQL_IOCAP_SEQUENTIAL = 1024 ! 0x00000400 
integer, parameter :: ODBQL_IOCAP_UNDELETABLE_WHEN_OPEN = 2048 ! 0x00000800 
integer, parameter :: ODBQL_IOCAP_POWERSAFE_OVERWRITE = 4096 ! 0x00001000 
integer, parameter :: ODBQL_IOCAP_IMMUTABLE = 8192 ! 0x00002000 
integer, parameter :: ODBQL_LOCK_NONE = 0 ! 
integer, parameter :: ODBQL_LOCK_SHARED = 1 ! 
integer, parameter :: ODBQL_LOCK_RESERVED = 2 ! 
integer, parameter :: ODBQL_LOCK_PENDING = 3 ! 
integer, parameter :: ODBQL_LOCK_EXCLUSIVE = 4 ! 
integer, parameter :: ODBQL_SYNC_NORMAL = 2 ! 0x00002 
integer, parameter :: ODBQL_SYNC_FULL = 3 ! 0x00003 
integer, parameter :: ODBQL_SYNC_DATAONLY = 16 ! 0x00010 
integer, parameter :: ODBQL_FCNTL_LOCKSTATE = 1 ! 
integer, parameter :: ODBQL_FCNTL_GET_LOCKPROXYFILE = 2 ! 
integer, parameter :: ODBQL_FCNTL_SET_LOCKPROXYFILE = 3 ! 
integer, parameter :: ODBQL_FCNTL_LAST_ERRNO = 4 ! 
integer, parameter :: ODBQL_FCNTL_SIZE_HINT = 5 ! 
integer, parameter :: ODBQL_FCNTL_CHUNK_SIZE = 6 ! 
integer, parameter :: ODBQL_FCNTL_FILE_POINTER = 7 ! 
integer, parameter :: ODBQL_FCNTL_SYNC_OMITTED = 8 ! 
integer, parameter :: ODBQL_FCNTL_WIN32_AV_RETRY = 9 ! 
integer, parameter :: ODBQL_FCNTL_PERSIST_WAL = 10 ! 
integer, parameter :: ODBQL_FCNTL_OVERWRITE = 11 ! 
integer, parameter :: ODBQL_FCNTL_VFSNAME = 12 ! 
integer, parameter :: ODBQL_FCNTL_POWERSAFE_OVERWRITE = 13 ! 
integer, parameter :: ODBQL_FCNTL_PRAGMA = 14 ! 
integer, parameter :: ODBQL_FCNTL_BUSYHANDLER = 15 ! 
integer, parameter :: ODBQL_FCNTL_TEMPFILENAME = 16 ! 
integer, parameter :: ODBQL_FCNTL_MMAP_SIZE = 18 ! 
integer, parameter :: ODBQL_FCNTL_TRACE = 19 ! 
integer, parameter :: ODBQL_FCNTL_HAS_MOVED = 20 ! 
integer, parameter :: ODBQL_FCNTL_SYNC = 21 ! 
integer, parameter :: ODBQL_FCNTL_COMMIT_PHASETWO = 22 ! 
integer, parameter :: ODBQL_FCNTL_WIN32_SET_HANDLE = 23 ! 
integer, parameter :: ODBQL_FCNTL_WAL_BLOCK = 24 ! 
integer, parameter :: ODBQL_FCNTL_ZIPVFS = 25 ! 
integer, parameter :: ODBQL_FCNTL_RBU = 26 ! 
integer, parameter :: ODBQL_FCNTL_VFS_POINTER = 27 ! 
integer, parameter :: ODBQL_FCNTL_JOURNAL_POINTER = 28 ! 
integer, parameter :: ODBQL_GET_LOCKPROXYFILE = ODBQL_FCNTL_GET_LOCKPROXYFILE ! 
integer, parameter :: ODBQL_SET_LOCKPROXYFILE = ODBQL_FCNTL_SET_LOCKPROXYFILE ! 
integer, parameter :: ODBQL_LAST_ERRNO = ODBQL_FCNTL_LAST_ERRNO ! 
integer, parameter :: ODBQL_ACCESS_EXISTS = 0 ! 
integer, parameter :: ODBQL_ACCESS_READWRITE = 1 !  Used by PRAGMA temp_store_directory 
integer, parameter :: ODBQL_ACCESS_READ = 2 !  Unused 
integer, parameter :: ODBQL_SHM_UNLOCK = 1 ! 
integer, parameter :: ODBQL_SHM_LOCK = 2 ! 
integer, parameter :: ODBQL_SHM_SHARED = 4 ! 
integer, parameter :: ODBQL_SHM_EXCLUSIVE = 8 ! 
integer, parameter :: ODBQL_SHM_NLOCK = 8 ! 
integer, parameter :: ODBQL_CONFIG_SINGLETHREAD = 1 !  nil 
integer, parameter :: ODBQL_CONFIG_MULTITHREAD = 2 !  nil 
integer, parameter :: ODBQL_CONFIG_SERIALIZED = 3 !  nil 
integer, parameter :: ODBQL_CONFIG_MALLOC = 4 !  odbql_mem_methods* 
integer, parameter :: ODBQL_CONFIG_GETMALLOC = 5 !  odbql_mem_methods* 
integer, parameter :: ODBQL_CONFIG_SCRATCH = 6 !  void*, int sz, int N 
integer, parameter :: ODBQL_CONFIG_PAGECACHE = 7 !  void*, int sz, int N 
integer, parameter :: ODBQL_CONFIG_HEAP = 8 !  void*, int nByte, int min 
integer, parameter :: ODBQL_CONFIG_MEMSTATUS = 9 !  boolean 
integer, parameter :: ODBQL_CONFIG_MUTEX = 10 !  odbql_mutex_methods* 
integer, parameter :: ODBQL_CONFIG_GETMUTEX = 11 !  odbql_mutex_methods* 
integer, parameter :: ODBQL_CONFIG_LOOKASIDE = 13 !  int int 
integer, parameter :: ODBQL_CONFIG_PCACHE = 14 !  no-op 
integer, parameter :: ODBQL_CONFIG_GETPCACHE = 15 !  no-op 
integer, parameter :: ODBQL_CONFIG_LOG = 16 !  xFunc, void* 
integer, parameter :: ODBQL_CONFIG_URI = 17 !  int 
integer, parameter :: ODBQL_CONFIG_PCACHE2 = 18 !  odbql_pcache_methods2* 
integer, parameter :: ODBQL_CONFIG_GETPCACHE2 = 19 !  odbql_pcache_methods2* 
integer, parameter :: ODBQL_CONFIG_COVERING_INDEX_SCAN = 20 !  int 
integer, parameter :: ODBQL_CONFIG_SQLLOG = 21 !  xSqllog, void* 
integer, parameter :: ODBQL_CONFIG_MMAP_SIZE = 22 !  odbql_int64, odbql_int64 
integer, parameter :: ODBQL_CONFIG_WIN32_HEAPSIZE = 23 !  int nByte 
integer, parameter :: ODBQL_CONFIG_PCACHE_HDRSZ = 24 !  int *psz 
integer, parameter :: ODBQL_CONFIG_PMASZ = 25 !  unsigned int szPma 
integer, parameter :: ODBQL_CONFIG_STMTJRNL_SPILL = 26 !  int nByte 
integer, parameter :: ODBQL_DBCONFIG_LOOKASIDE = 1001 !  void* int int 
integer, parameter :: ODBQL_DBCONFIG_ENABLE_FKEY = 1002 !  int int* 
integer, parameter :: ODBQL_DBCONFIG_ENABLE_TRIGGER = 1003 !  int int* 
integer, parameter :: ODBQL_DBCONFIG_ENABLE_FTS3_TOKENIZER = 1004 !  int int* 
integer, parameter :: ODBQL_DBCONFIG_ENABLE_LOAD_EXTENSION = 1005 !  int int* 
integer, parameter :: ODBQL_DENY = 1 !  Abort the SQL statement with an error 
integer, parameter :: ODBQL_IGNORE = 2 !  Don't allow access, but don't generate an error 
integer, parameter :: ODBQL_CREATE_INDEX = 1 !  Index Name      Table Name      
integer, parameter :: ODBQL_CREATE_TABLE = 2 !  Table Name      NULL            
integer, parameter :: ODBQL_CREATE_TEMP_INDEX = 3 !  Index Name      Table Name      
integer, parameter :: ODBQL_CREATE_TEMP_TABLE = 4 !  Table Name      NULL            
integer, parameter :: ODBQL_CREATE_TEMP_TRIGGER = 5 !  Trigger Name    Table Name      
integer, parameter :: ODBQL_CREATE_TEMP_VIEW = 6 !  View Name       NULL            
integer, parameter :: ODBQL_CREATE_TRIGGER = 7 !  Trigger Name    Table Name      
integer, parameter :: ODBQL_CREATE_VIEW = 8 !  View Name       NULL            
integer, parameter :: ODBQL_DELETE = 9 !  Table Name      NULL            
integer, parameter :: ODBQL_DROP_INDEX = 10 !  Index Name      Table Name      
integer, parameter :: ODBQL_DROP_TABLE = 11 !  Table Name      NULL            
integer, parameter :: ODBQL_DROP_TEMP_INDEX = 12 !  Index Name      Table Name      
integer, parameter :: ODBQL_DROP_TEMP_TABLE = 13 !  Table Name      NULL            
integer, parameter :: ODBQL_DROP_TEMP_TRIGGER = 14 !  Trigger Name    Table Name      
integer, parameter :: ODBQL_DROP_TEMP_VIEW = 15 !  View Name       NULL            
integer, parameter :: ODBQL_DROP_TRIGGER = 16 !  Trigger Name    Table Name      
integer, parameter :: ODBQL_DROP_VIEW = 17 !  View Name       NULL            
integer, parameter :: ODBQL_INSERT = 18 !  Table Name      NULL            
integer, parameter :: ODBQL_PRAGMA = 19 !  Pragma Name     1st arg or NULL 
integer, parameter :: ODBQL_READ = 20 !  Table Name      Column Name     
integer, parameter :: ODBQL_SELECT = 21 !  NULL            NULL            
integer, parameter :: ODBQL_TRANSACTION = 22 !  Operation       NULL            
integer, parameter :: ODBQL_UPDATE = 23 !  Table Name      Column Name     
integer, parameter :: ODBQL_ATTACH = 24 !  Filename        NULL            
integer, parameter :: ODBQL_DETACH = 25 !  Database Name   NULL            
integer, parameter :: ODBQL_ALTER_TABLE = 26 !  Database Name   Table Name      
integer, parameter :: ODBQL_REINDEX = 27 !  Index Name      NULL            
integer, parameter :: ODBQL_ANALYZE = 28 !  Table Name      NULL            
integer, parameter :: ODBQL_CREATE_VTABLE = 29 !  Table Name      Module Name     
integer, parameter :: ODBQL_DROP_VTABLE = 30 !  Table Name      Module Name     
integer, parameter :: ODBQL_FUNCTION = 31 !  NULL            Function Name   
integer, parameter :: ODBQL_SAVEPOINT = 32 !  Operation       Savepoint Name  
integer, parameter :: ODBQL_COPY = 0 !  No longer used 
integer, parameter :: ODBQL_RECURSIVE = 33 !  NULL            NULL            
integer, parameter :: ODBQL_LIMIT_LENGTH = 0 ! 
integer, parameter :: ODBQL_LIMIT_SQL_LENGTH = 1 ! 
integer, parameter :: ODBQL_LIMIT_COLUMN = 2 ! 
integer, parameter :: ODBQL_LIMIT_EXPR_DEPTH = 3 ! 
integer, parameter :: ODBQL_LIMIT_COMPOUND_SELECT = 4 ! 
integer, parameter :: ODBQL_LIMIT_VDBE_OP = 5 ! 
integer, parameter :: ODBQL_LIMIT_FUNCTION_ARG = 6 ! 
integer, parameter :: ODBQL_LIMIT_ATTACHED = 7 ! 
integer, parameter :: ODBQL_LIMIT_LIKE_PATTERN_LENGTH = 8 ! 
integer, parameter :: ODBQL_LIMIT_VARIABLE_NUMBER = 9 ! 
integer, parameter :: ODBQL_LIMIT_TRIGGER_DEPTH = 10 ! 
integer, parameter :: ODBQL_LIMIT_WORKER_THREADS = 11 ! 
integer, parameter :: ODBQL_INTEGER = 1 ! 
integer, parameter :: ODBQL_FLOAT = 2 ! 
integer, parameter :: ODBQL_BLOB = 4 ! 
integer, parameter :: ODBQL_NULL = 5 ! 
integer, parameter :: ODBQL_BITFIELD = 6 ! 
integer, parameter :: ODBQL_TEXT = 3 ! 
integer, parameter :: ODBQL_UTF8 = 1 !  IMP: R-37514-35566 
integer, parameter :: ODBQL_UTF16LE = 2 !  IMP: R-03371-37637 
integer, parameter :: ODBQL_UTF16BE = 3 !  IMP: R-51971-34154 
integer, parameter :: ODBQL_UTF16 = 4 !  Use native byte order 
integer, parameter :: ODBQL_ANY = 5 !  Deprecated 
integer, parameter :: ODBQL_UTF16_ALIGNED = 8 !  odbql_create_collation only 
integer, parameter :: ODBQL_DETERMINISTIC = 2048 ! 0x800 
integer, parameter :: ODBQL_STATIC = 0  ! ((odbql_destructor_type)0)
integer, parameter :: ODBQL_TRANSIENT = -1  ! ((odbql_destructor_type)-1)
integer, parameter :: ODBQL_INDEX_SCAN_UNIQUE = 1 !  Scan visits at most 1 row 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_EQ = 2 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_GT = 4 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_LE = 8 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_LT = 16 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_GE = 32 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_MATCH = 64 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_LIKE = 65 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_GLOB = 66 ! 
integer, parameter :: ODBQL_INDEX_CONSTRAINT_REGEXP = 67 ! 
integer, parameter :: ODBQL_MUTEX_FAST = 0 ! 
integer, parameter :: ODBQL_MUTEX_RECURSIVE = 1 ! 
integer, parameter :: ODBQL_MUTEX_STATIC_MASTER = 2 ! 
integer, parameter :: ODBQL_MUTEX_STATIC_MEM = 3 !  odbql_malloc() 
integer, parameter :: ODBQL_MUTEX_STATIC_MEM2 = 4 !  NOT USED 
integer, parameter :: ODBQL_MUTEX_STATIC_OPEN = 4 !  odbqlBtreeOpen() 
integer, parameter :: ODBQL_MUTEX_STATIC_PRNG = 5 !  odbql_random() 
integer, parameter :: ODBQL_MUTEX_STATIC_LRU = 6 !  lru page list 
integer, parameter :: ODBQL_MUTEX_STATIC_LRU2 = 7 !  NOT USED 
integer, parameter :: ODBQL_MUTEX_STATIC_PMEM = 7 !  odbqlPageMalloc() 
integer, parameter :: ODBQL_MUTEX_STATIC_APP1 = 8 !  For use by application 
integer, parameter :: ODBQL_MUTEX_STATIC_APP2 = 9 !  For use by application 
integer, parameter :: ODBQL_MUTEX_STATIC_APP3 = 10 !  For use by application 
integer, parameter :: ODBQL_MUTEX_STATIC_VFS1 = 11 !  For use by built-in VFS 
integer, parameter :: ODBQL_MUTEX_STATIC_VFS2 = 12 !  For use by extension VFS 
integer, parameter :: ODBQL_MUTEX_STATIC_VFS3 = 13 !  For use by application VFS 
integer, parameter :: ODBQL_TESTCTRL_FIRST = 5 ! 
integer, parameter :: ODBQL_TESTCTRL_PRNG_SAVE = 5 ! 
integer, parameter :: ODBQL_TESTCTRL_PRNG_RESTORE = 6 ! 
integer, parameter :: ODBQL_TESTCTRL_PRNG_RESET = 7 ! 
integer, parameter :: ODBQL_TESTCTRL_BITVEC_TEST = 8 ! 
integer, parameter :: ODBQL_TESTCTRL_FAULT_INSTALL = 9 ! 
integer, parameter :: ODBQL_TESTCTRL_BENIGN_MALLOC_HOOKS = 10 ! 
integer, parameter :: ODBQL_TESTCTRL_PENDING_BYTE = 11 ! 
integer, parameter :: ODBQL_TESTCTRL_ASSERT = 12 ! 
integer, parameter :: ODBQL_TESTCTRL_ALWAYS = 13 ! 
integer, parameter :: ODBQL_TESTCTRL_RESERVE = 14 ! 
integer, parameter :: ODBQL_TESTCTRL_OPTIMIZATIONS = 15 ! 
integer, parameter :: ODBQL_TESTCTRL_ISKEYWORD = 16 ! 
integer, parameter :: ODBQL_TESTCTRL_SCRATCHMALLOC = 17 ! 
integer, parameter :: ODBQL_TESTCTRL_LOCALTIME_FAULT = 18 ! 
integer, parameter :: ODBQL_TESTCTRL_EXPLAIN_STMT = 19 !  NOT USED 
integer, parameter :: ODBQL_TESTCTRL_NEVER_CORRUPT = 20 ! 
integer, parameter :: ODBQL_TESTCTRL_VDBE_COVERAGE = 21 ! 
integer, parameter :: ODBQL_TESTCTRL_BYTEORDER = 22 ! 
integer, parameter :: ODBQL_TESTCTRL_ISINIT = 23 ! 
integer, parameter :: ODBQL_TESTCTRL_SORTER_MMAP = 24 ! 
integer, parameter :: ODBQL_TESTCTRL_IMPOSTER = 25 ! 
integer, parameter :: ODBQL_TESTCTRL_LAST = 25 ! 
integer, parameter :: ODBQL_STATUS_MEMORY_USED = 0 ! 
integer, parameter :: ODBQL_STATUS_PAGECACHE_USED = 1 ! 
integer, parameter :: ODBQL_STATUS_PAGECACHE_OVERFLOW = 2 ! 
integer, parameter :: ODBQL_STATUS_SCRATCH_USED = 3 ! 
integer, parameter :: ODBQL_STATUS_SCRATCH_OVERFLOW = 4 ! 
integer, parameter :: ODBQL_STATUS_MALLOC_SIZE = 5 ! 
integer, parameter :: ODBQL_STATUS_PARSER_STACK = 6 ! 
integer, parameter :: ODBQL_STATUS_PAGECACHE_SIZE = 7 ! 
integer, parameter :: ODBQL_STATUS_SCRATCH_SIZE = 8 ! 
integer, parameter :: ODBQL_STATUS_MALLOC_COUNT = 9 ! 
integer, parameter :: ODBQL_DBSTATUS_LOOKASIDE_USED = 0 ! 
integer, parameter :: ODBQL_DBSTATUS_CACHE_USED = 1 ! 
integer, parameter :: ODBQL_DBSTATUS_SCHEMA_USED = 2 ! 
integer, parameter :: ODBQL_DBSTATUS_STMT_USED = 3 ! 
integer, parameter :: ODBQL_DBSTATUS_LOOKASIDE_HIT = 4 ! 
integer, parameter :: ODBQL_DBSTATUS_LOOKASIDE_MISS_SIZE = 5 ! 
integer, parameter :: ODBQL_DBSTATUS_LOOKASIDE_MISS_FULL = 6 ! 
integer, parameter :: ODBQL_DBSTATUS_CACHE_HIT = 7 ! 
integer, parameter :: ODBQL_DBSTATUS_CACHE_MISS = 8 ! 
integer, parameter :: ODBQL_DBSTATUS_CACHE_WRITE = 9 ! 
integer, parameter :: ODBQL_DBSTATUS_DEFERRED_FKS = 10 ! 
integer, parameter :: ODBQL_DBSTATUS_MAX = 10 !  Largest defined DBSTATUS 
integer, parameter :: ODBQL_STMTSTATUS_FULLSCAN_STEP = 1 ! 
integer, parameter :: ODBQL_STMTSTATUS_SORT = 2 ! 
integer, parameter :: ODBQL_STMTSTATUS_AUTOINDEX = 3 ! 
integer, parameter :: ODBQL_STMTSTATUS_VM_STEP = 4 ! 
integer, parameter :: ODBQL_CHECKPOINT_PASSIVE = 0 !  Do as much as possible w/o blocking 
integer, parameter :: ODBQL_CHECKPOINT_FULL = 1 !  Wait for writers, then checkpoint 
integer, parameter :: ODBQL_CHECKPOINT_RESTART = 2 !  Like FULL but wait for for readers 
integer, parameter :: ODBQL_CHECKPOINT_TRUNCATE = 3 !  Like RESTART but also truncate WAL 
integer, parameter :: ODBQL_VTAB_CONSTRAINT_SUPPORT = 1 ! 
integer, parameter :: ODBQL_ROLLBACK = 1 ! 
integer, parameter :: ODBQL_FAIL = 3 ! 
integer, parameter :: ODBQL_REPLACE = 5 ! 
integer, parameter :: ODBQL_SCANSTAT_NLOOP = 0 ! 
integer, parameter :: ODBQL_SCANSTAT_NVISIT = 1 ! 
integer, parameter :: ODBQL_SCANSTAT_EST = 2 ! 
integer, parameter :: ODBQL_SCANSTAT_NAME = 3 ! 
integer, parameter :: ODBQL_SCANSTAT_EXPLAIN = 4 ! 
integer, parameter :: ODBQL_SCANSTAT_SELECTID = 5 ! 
integer, parameter :: ODBQL_CHANGESET_DATA = 1 ! 
integer, parameter :: ODBQL_CHANGESET_NOTFOUND = 2 ! 
integer, parameter :: ODBQL_CHANGESET_CONFLICT = 3 ! 
integer, parameter :: ODBQL_CHANGESET_CONSTRAINT = 4 ! 
integer, parameter :: ODBQL_CHANGESET_FOREIGN_KEY = 5 ! 
integer, parameter :: ODBQL_CHANGESET_OMIT = 0 ! 
integer, parameter :: ODBQL_CHANGESET_REPLACE = 1 ! 
integer, parameter :: ODBQL_CHANGESET_ABORT = 2 ! 

end module odbql_constants
