Minutes from 84th OpenVDB TSC meeting, March 23rd, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: JT Nelson (Blender), Bruce Chernaik (Intel),
Laura Lediaev (ImageWorks), Sergio Rojas

Regrets: none

Agenda:

1) Confirm Quorum
2) Secretary
3) Forum
4) VDB 9.0
5) Node Visitor Tool (PR990)
6) TSC Meeting Notes (PR984)
7) VDB Extrapolate (PR760)
8) Multi-threaded Active Voxel Count (PR1010)
9) 8.1 Release
10) CMake / CI Sanitizers / Surfacing
11) Next meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Forum

No new issues.

4) VDB 9.0

VFX Reference Platform has announced a new policy of only accepting releases of
software that are available at the time of ratifying the reference platform
year. This means that we will likely need to change our releasing strategy and
make sure we have an ABI=9 complete OpenVDB 9.0.0 by August/September 2021. Jeff
proposes introducing a framework for opt-in to future ABI changes prior to
OpenVDB 9 being ready for release. Dan to add a new macro for future ABI=9 and a
CI test.

The TSC discussed the current deprecation strategy. It was noted that there's a
strict policy regarding ABI deprecation and support, but no policy for API
deprecation and support. This can cause friction when attempting to support
multiple versions of ABI in client code. One solution to improve this is to
change the C++14 deprecation macro back to an OPENVDB_DEPRECATED macro and
extend this macro to support the deprecation reason. This would make it simpler
for users to disable deprecation warnings for only OpenVDB.

5) Node Visitor Tool (PR990)

Jeff to try and adapt existing SideFX visitor code to the new Node Visitor API
based on Dan's suggestions and report any issues. It was decided there should be
more information provided in the documentation in the header of this tool to
assist with migration as it's not a drop-in replacement for the visitor pattern.
Jeff to look at writing this having gone through this process.

6) TSC Meeting Notes (PR984)

Jeff highlights that Andre's meeting notes haven't been merged yet. Nick
clarifies the process with regards to approvals.

7) VDB Extrapolate (PR760)

A minor change is needed to the GU_PrimVDB implementation in this PR. Jeff
briefly summarizes the rationale of including these primitives in the VDB
project.

Andre mentioned an issue with attempting to extrapolate integer grids resulting
in values that aren't in the original extension field. After some discussion, it
was suggested that the problem is likely due to attempting to extrapolate
inactive voxel values in the extension field but not totally clear what the
correct solution to this is. Andre to follow up with Ken offline to dig into the
problem a bit more.

8) Multi-threaded Active Voxel Count (PR1010)

Dan summarized the work in this PR. General feeling that it would be frustrating
to remove the virtual Tree::activeVoxelCount() method on the tree class in favor
of a tool method as the tree method is convenient.

Prior discussion about wanting to strip out virtual methods to use the existing
Tree class for the GPU are no longer relevant with NanoVDB. Main motivation in
stripping implementation from the Tree data structures is to reduce the code in
these core data structures for readability and improved compile-times and to
minimize confusion from having two independent implementations. An example of
this confusion in the codebase already is Tree::prune() vs tools::prune() where
the later is encouraged for improved performance. Though not applicable in this
case, an additional motivation in stripping implementation from the Tree data
structures is to eliminate some of the boilerplate in introducing a custom leaf
node.

One approach raised is to simply call the tool directly from the Tree class
itself which avoids having two implementations and achieves the goal of being
able to strip out the implementation in the lower levels of the tree. However,
this introduces a tool header into a tree class which does not currently have a
dependency in this direction. Despite this downside, all agreed that this seems
like the best approach in these types of cases. Dan to modify the PR to make
these changes.

Ken suggests that when locking down the tree, single-threaded performance may
exceed multi-threaded performance for some operations. Dan believes that multi-
threaded performance tends to always be faster at scale. General interest in
testing this theory.

9) 8.1 Release

When will VDB 8.1 will be ready for release? Given the need to patch the last
few releases, Nick proposed a release candidate period to attempt to improve
stability. Main features to include before release are the VDB Extrapolate SOP
and the VDB Merge SOP.

Ken has made some major changes to NanoVDB and a big update is coming. Jeff asks
about binary compatibility, Ken to check. Missing component right now is the C
API which needs updating.

10) CMake / CI Sanitizers / Surfacing

Nick briefly summarizes his recent PRs. Many improvements to CMake for Windows.
New PR adds sanitizer support in a weekly CI build (PR1013) - for now only
address sanitizer and undefined behavior sanitizers enabled. Surfacing work is
ongoing, Nick may refactor to make some of the framework internal to avoid
needing to achieve consensus on the API at this stage.

11) Next meeting

Next meeting is March 30th, 2021. 12pm-1pm EST (GMT-5).
