///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/scene/animation/AnimManager.h>

#include <boost/iostreams/device/file.hpp>
#include <boost/iostreams/stream.hpp>

#include "LAMMPSDumpParser.h"
#include "LAMMPSDumpParserSettingsDialog.h"
#include "../AtomsImportObject.h"
#include <atomviz/atoms/AtomsObject.h>

namespace AtomViz {

IMPLEMENT_ABSTRACT_PLUGIN_CLASS(LAMMPSDumpParser, MultiFileParser)

/******************************************************************************
* Default constructor.
******************************************************************************/
LAMMPSDumpParser::LAMMPSDumpParser(bool isLoading) : MultiFileParser(isLoading)
{
}

/******************************************************************************
* Opens the settings dialog for this parser.
******************************************************************************/
bool LAMMPSDumpParser::showSettingsDialog(QWidget* parent)
{
	LAMMPSDumpParserSettingsDialog dialog(this, parent);
	if(dialog.exec() != QDialog::Accepted)
		return false;
	return true;
}

};	// End of namespace AtomViz
