#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "SPLReader.h"
#include "BaseCommunication.h"

#include "memory_placements.h"

#define base CSHUReader

CSPLReader::CSPLReader(CReader *Owner, CBaseCommunication *Communicator)
	:base(Owner, Communicator)
{
}

CSPLReader::~CSPLReader(void)
{
}

void CSPLReader::SetHWString(char *String)
{
	if (m_ReaderInfo.HardwareVersion == 2 || m_ReaderInfo.HardwareVersion == 3)
		strcpy(String, "SP2_");  //STM32
	else
		strcpy(String, "SPL_");
}

void CSPLReader::GetProductString(uint8_t *Product)
{
	if (m_ReaderInfo.HardwareVersion == 2 || m_ReaderInfo.HardwareVersion == 3)
		memcpy(Product, "CJSP2", 5);  //STM32
	else
	    memcpy(Product, "CJSPL", 5);
}

