#ifndef ECA_DEBUG_H
#define ECA_DEBUG_H


#define DEBUG_MASK_COMMUNICATION_OUT   ((RSCT_UINT32)0x00000001)
#define DEBUG_MASK_COMMUNICATION_IN    ((RSCT_UINT32)0x00000002)
#define DEBUG_MASK_COMMUNICATION_ERROR ((RSCT_UINT32)0x00000004)
#define DEBUG_MASK_COMMUNICATION_INT   ((RSCT_UINT32)0x00000008)
#define DEBUG_MASK_COMMUNICATION_INFO  ((RSCT_UINT32)0x00000010)
#define DEBUG_MASK_TRANSLATION         ((RSCT_UINT32)0x00000100)
#define DEBUG_MASK_RESULTS             ((RSCT_UINT32)0x00000200)
#define LOG_LEVEL_DEBUG                ((RSCT_UINT32)0x00000400)
#define DEBUG_MASK_INPUT               ((RSCT_UINT32)0x00010000)
#define DEBUG_MASK_OUTPUT              ((RSCT_UINT32)0x00020000)

#define DEBUG_MASK_CTAPI               ((RSCT_UINT32)0x00040000)
#define DEBUG_MASK_IFD                 ((RSCT_UINT32)0x00080000)
#define DEBUG_MASK_CJECOM              ((RSCT_UINT32)0x00100000)
#define DEBUG_MASK_PPA                 ((RSCT_UINT32)0x00200000)

#define DEBUG_MASK_GENERIC             ((RSCT_UINT32)0x80000000)

#ifdef __cplusplus

  
class CJECA32_PRIVATE_CLASS CDebug
{
public:
    CDebug(unsigned int nLevelMask);
    void Out(const char *cDeviceName,
	     unsigned int nLevelMask,
             const char *cCaption,
             void *pData, uint32_t ulDataLen);

    /**
     * This method can be used to log arbitrary information. It is used just
     * like printf. It internally calls @ref CDebug::Out.
     */
    void varLog(const char *devName,
                unsigned int nLevelMask,
                const char *format, ...);

public:
	~CDebug(void);

#if defined(WIN_UMDF)
	void SetLoggerCallback(void *p_pcUmdfCallBack);
#endif

#if defined(OS_LINUX) || defined(OS_DARWIN)
	void setLevelMask(unsigned int nLevelMask);
	void setLogFileName(const char *fname);
#endif
	
private:
   unsigned int m_nLevelMask;
   void* m_pcUmdfCallBack_1;

#if defined(OS_LINUX) || defined(OS_DARWIN)
       char *m_logFileName;
#endif
};

extern CDebug CJECA32_PRIVATE_CLASS Debug;

#endif /* ifdef __cplusplus */


#ifdef __cplusplus
extern "C" {
#endif

  void rsct_debug_out(const char *cDeviceName, unsigned int nLevelMask,
		      const char *cCaption,
		      void *pData, uint32_t ulDataLen);

#ifdef __cplusplus
}
#endif


#endif

