dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: test_iget.m4 2293 2016-01-06 03:43:04Z wkliao $ */


undefine(`index')dnl
dnl dnl dnl
dnl
dnl Macros
dnl
dnl dnl dnl
dnl
dnl Upcase(str)
dnl
define(`Upcase',dnl
`dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)')dnl
dnl dnl dnl
dnl
dnl NCT_ITYPE(type)
dnl
define(`NCT_ITYPE', ``NCT_'Upcase($1)')dnl
dnl

define(`CheckText', `ifelse(`$1',`text', , `== (NCT_ITYPE($1) == NCT_TEXT)')')dnl
define(`CheckRange',`ifelse(`$1',`text', `1', `($2 >= $1_min && $2 <= $1_max)')')dnl
define(`IfCheckTextChar', `ifelse(`$1',`text', `if ($2 != NC_CHAR)')')dnl
define(`CheckNumRange',
       `ifelse(`$1',`text', `1',
               `inRange3($2,$3,NCT_ITYPE($1)) && ($2 >= $1_min && $2 <= $1_max)')')dnl

#include "tests.h"

int
test_ncmpi_iget_var1(void)
{
    int i, j, err, ncid, nok = 0; /* count of valid comparisons */
    MPI_Offset index[MAX_RANK];
    double expect, value, buf[1];
    int reqid, status;
    MPI_Datatype datatype;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;
        datatype = nc_mpi_type(var_type[i]);

        /* check if pnetcdf can detect a bad file ID */
        err = ncmpi_iget_var1(BAD_ID, i, index, buf, 1, datatype, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_var1(ncid, BAD_VARID, index, buf, 1, datatype, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        /* check if pnetcdf can detect out of boundary requests */
        for (j = 0; j < var_rank[i]; j++) {
            index[j] = var_shape[i][j]; /* make an out-of-boundary starts[] */
            err = ncmpi_iget_var1(ncid, i, index, buf, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK
            index[j] = 0;
        }
        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR)
                error("error in toMixedBase 1");

            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash(var_type[i], var_rank[i], index);
            if (var_rank[i] == 0 && i%2 )
                err = ncmpi_iget_var1(ncid, i, NULL, buf, 1, datatype, &reqid);
            else
                err = ncmpi_iget_var1(ncid, i, index, buf, 1, datatype, &reqid);
            IF (err != NC_NOERR)
                error("ncmpi_iget_var: %s", ncmpi_strerror(err));
            ELSE_NOK

            err = ncmpi_wait_all(ncid, 1, &reqid, &status);
            IF (err != NC_NOERR)
                error("ncmpi_wait_all: %s", ncmpi_strerror(err));
            ELSE_NOK

            err = nc2dbl( var_type[i], buf, &value );
            IF (err)
                error("error in nc2dbl");
            if (inRange(expect,var_type[i])) {
                IF (!equal2(value,expect,var_type[i])) {
                    error("expected: %G, got: %G", expect, value);
                } else {
                    nok++;
                }   
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}

dnl TEST_NC_IGET_VAR1(TYPE)
dnl
define(`TEST_NC_IGET_VAR1',dnl
`dnl
int
test_ncmpi_iget_var1_$1(void)
{
    int ncid;
    int i;
    int j;
    int err;
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset index[MAX_RANK];
    int canConvert;     /* Both text or both numeric */
    double expect;
    $1 value;
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        for (j = 0; j < var_rank[i]; j++)
            index[j] = 0;

        /* check if pnetcdf can detect a bad file ID */
        err = ncmpi_iget_var1_$1(BAD_ID, i, index, &value, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_var1_$1(ncid, BAD_VARID, index, &value, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        /* check if pnetcdf can detect out of boundary requests */
        for (j = 0; j < var_rank[i]; j++) {
            index[j] = var_shape[i][j]; /* make an out-of-boundary starts[] */
            err = ncmpi_iget_var1_$1(ncid, i, index, &value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("conversion: err = %d", err);
            } else IF (err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK
            index[j] = 0;
        }
        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR)
                error("error in toMixedBase 1");

            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4( var_type[i], var_rank[i], index, NCT_ITYPE($1) );

            if (var_rank[i] == 0 && i%2 )
                err = ncmpi_iget_var1_$1(ncid, i, NULL, &value, &reqid);
            else
                err = ncmpi_iget_var1_$1(ncid, i, index, &value, &reqid);
            if (err == NC_NOERR)
                ncmpi_wait_all(ncid, 1, &reqid, &status);

            if (canConvert) {
                if (inRange3(expect,var_type[i], NCT_ITYPE($1))) {
                    if (CheckRange($1, expect)) {
                        IF (status != NC_NOERR) {
                            error("%s", ncmpi_strerror(status));
                        } else {
                            IF (!equal(value,expect,var_type[i],NCT_ITYPE($1)))
                                error("expected: %G, got: %G", expect,
                                    (double) value);
                            ELSE_NOK
                        }
                    } else {
                        IF (status != NC_ERANGE)
                            error("Range error: status = %d", status);
                        ELSE_NOK
                    }
                } else {
                    IF (status != NC_NOERR && status != NC_ERANGE)
                        error("OK or Range error: status = %d", status);
                    ELSE_NOK
                }
            } else {
                IF (err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

TEST_NC_IGET_VAR1(text)
TEST_NC_IGET_VAR1(uchar)
TEST_NC_IGET_VAR1(schar)
TEST_NC_IGET_VAR1(short)
TEST_NC_IGET_VAR1(int)
TEST_NC_IGET_VAR1(long)
TEST_NC_IGET_VAR1(float)
TEST_NC_IGET_VAR1(double)
TEST_NC_IGET_VAR1(ushort)
TEST_NC_IGET_VAR1(uint)
TEST_NC_IGET_VAR1(longlong)
TEST_NC_IGET_VAR1(ulonglong)

int
test_ncmpi_iget_var(void)
{
    int ncid;
    int i;
    int j;
    int err, num_err;
    int nels;
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset index[MAX_RANK];
    double expect[MAX_NELS];
    double buf[MAX_NELS];
    int reqid, status;
    MPI_Datatype datatype;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        datatype = nc_mpi_type(var_type[i]);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if pnetcdf can detect a bad file ID */
        err = ncmpi_iget_var(BAD_ID, i, buf, 1, datatype, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        /* check if pnetcdf can detect a bad variable ID */
        err = ncmpi_iget_var(ncid, BAD_VARID, buf, 1, datatype, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK

        /* check if the contents are supposed to be */
        nels = 1;
        for (j = 0; j < var_rank[i]; j++) {
            nels *= var_shape[i][j];
        }
        for (j = 0; j < nels; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR)
                error("error in toMixedBase 1");
            expect[j] = hash(var_type[i], var_rank[i], index);
        }
        err = ncmpi_iget_var(ncid, i, buf, nels, datatype, &reqid);
        IF (err != NC_NOERR)
            error("ncmpi_iget_var: %s", ncmpi_strerror(err));
        ELSE_NOK

        err = ncmpi_wait_all(ncid, 1, &reqid, &status);
        IF (err != NC_NOERR)
            error("ncmpi_wait_all: %s", ncmpi_strerror(err));
        ELSE_NOK

        num_err = 0;
        for (j = 0; j < nels; j++) {
            double got;
            char *p = (char *) buf;
            p += j * nctypelen(var_type[i]);
            if (inRange(expect[j],var_type[i])) {
                err = nc2dbl(var_type[i], p, &got);
                IF (err != NC_NOERR)
                    error("error in nc2dbl");
                IF (!equal2(got,expect[j],var_type[i])) {
                    error("value read not that expected");
                    if (verbose) {
                        error("\n");
                        error("varid: %d, ", i);
                        error("var_name: %s, ", var_name[i]);
                        error("element number: %d ", j);
                        error("expect: %g", expect[j]);
                        error("got: %g", got);
                    }
                    num_err++;
                }
            }
            if (num_err == 0) nok++;
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}

dnl TEST_NC_IGET_VAR(TYPE)
dnl
define(`TEST_NC_IGET_VAR',dnl
`dnl
int
test_ncmpi_iget_var_$1(void)
{
    int ncid;
    int i;
    int j;
    int err, num_err;
    int allInExtRange;        /* all values within external range? */
    int allInIntRange;        /* all values within internal range? */
    int nels;
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset index[MAX_RANK];
    int canConvert;     /* Both text or both numeric */
    double expect[MAX_NELS];
    $1 value[MAX_NELS];
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if pnetcdf can detect a bad file ID */
        err = ncmpi_iget_var_$1(BAD_ID, i, value, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        /* check if pnetcdf can detect a bad variable ID */
        err = ncmpi_iget_var_$1(ncid, BAD_VARID, value, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK

        /* check if the contents are supposed to be */
        nels = 1;
        for (j = 0; j < var_rank[i]; j++) {
            nels *= var_shape[i][j];
        }
        allInExtRange = allInIntRange = 1;
        for (j = 0; j < nels; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR)
                error("error in toMixedBase 1");
            expect[j] = hash4(var_type[i], var_rank[i], index, NCT_ITYPE($1));
            if (inRange3(expect[j],var_type[i], NCT_ITYPE($1))) {
                IfCheckTextChar($1, var_type[i])
                    allInIntRange &= CheckRange($1, expect[j]);
            } else {
                allInExtRange = 0;
            }
        }
        err = ncmpi_iget_var_$1(ncid, i, value, &reqid);
        if (err == NC_NOERR)
            ncmpi_wait_all(ncid, 1, &reqid, &status);
        ELSE_NOK
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (status != NC_NOERR)
                        error("%s", ncmpi_strerror(status));
                    ELSE_NOK
                } else {
                    IF (status != NC_ERANGE)
                        error("Range error: status = %d", status);
                    ELSE_NOK
                }
            } else {
                IF (status != NC_NOERR && status != NC_ERANGE)
                    error("OK or Range error: status = %d", status);
                ELSE_NOK
            }
            num_err = 0;
            for (j = 0; j < nels; j++) {
                if (CheckNumRange($1, expect[j], var_type[i])) {
                    IF (!equal(value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("element number: %d ", j);
                            error("expect: %g", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                        num_err++;
                    }
                }
            }
            if (num_err == 0) nok++;
        } else {
            IF (nels > 0 && err != NC_ECHAR)
                error("wrong type: err = %d", err);
            ELSE_NOK
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

TEST_NC_IGET_VAR(text)
TEST_NC_IGET_VAR(uchar)
TEST_NC_IGET_VAR(schar)
TEST_NC_IGET_VAR(short)
TEST_NC_IGET_VAR(int)
TEST_NC_IGET_VAR(long)
TEST_NC_IGET_VAR(float)
TEST_NC_IGET_VAR(double)
TEST_NC_IGET_VAR(ushort)
TEST_NC_IGET_VAR(uint)
TEST_NC_IGET_VAR(longlong)
TEST_NC_IGET_VAR(ulonglong)


int
test_ncmpi_iget_vara(void)
{
    int ncid, d, i, j, k, err, num_err, nels, nslabs;
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Datatype datatype;
    double buf[MAX_NELS];
    double expect[MAX_NELS];
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        datatype = nc_mpi_type(var_type[i]);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }
        err = ncmpi_iget_vara(BAD_ID, i, start, edge, buf, 1, datatype, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_vara(ncid, BAD_VARID, start, edge, buf, 1, datatype, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];  /* out of boundary check */
            err = ncmpi_iget_vara(ncid, i, start, edge, buf, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = ncmpi_iget_vara(ncid, i, start, edge, buf, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                error("bad index/edge: err = %d", err);
            ELSE_NOK
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when */
        /* there is nothing to get (edge[j]==0) */
        if (var_rank[i] > 0) {
            for (j = 0; j < var_rank[i]; j++)
                edge[j] = 0;
            err = ncmpi_iget_vara(BAD_ID, i, start, edge, buf, 1, datatype, &reqid);
            IF (err != NC_EBADID) 
                error("bad ncid: err = %d", err);
            ELSE_NOK
            err = ncmpi_iget_vara(ncid, BAD_VARID, start, edge, buf, 1, datatype, &reqid);
            IF (err != NC_ENOTVAR) 
                error("bad var id: err = %d", err);
            ELSE_NOK
            for (j = 0; j < var_rank[i]; j++) {
                if (var_dimid[i][j] > 0) {                /* skip record dim */
                    start[j] = var_shape[i][j];     /* out of boundary check */
                    err = ncmpi_iget_vara(ncid, i, start, edge, buf, 1, datatype, &reqid);
                    IF (err != NC_EINVALCOORDS)
                        error("bad start: err = %d", err);
                    ELSE_NOK
                    start[j] = 0;
                }
            }
            for (j = 0; j < var_rank[i]; j++)
                edge[j] = 1;
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            for (j = 0; j < nels; j++) {
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase 1");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash(var_type[i], var_rank[i], index);
            }
            if (var_rank[i] == 0 && i%2)
                err = ncmpi_iget_vara(ncid, i, NULL, NULL, buf, 1, datatype, &reqid);
            else
                err = ncmpi_iget_vara(ncid, i, start, edge, buf, nels, datatype, &reqid);
            IF (err != NC_NOERR)
                error("ncmpi_iget_vara %s", ncmpi_strerror(err));
            ELSE_NOK

            err = ncmpi_wait_all(ncid, 1, &reqid, &status);
            IF (err != NC_NOERR)
                error("ncmpi_wait_all %s", ncmpi_strerror(err));
            ELSE_NOK

            num_err = 0;
            for (j = 0; j < nels; j++) {
                double got;
                char *p = (char *) buf;
                p += j * nctypelen(var_type[i]);
                if (inRange(expect[j],var_type[i])) {
                    err = nc2dbl(var_type[i], p, &got);
                    IF (err != NC_NOERR)
                        error("error in nc2dbl");
                    IF (!equal2(got,expect[j],var_type[i])) {
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("element number: %d ", j);
                            error("expect: %g", expect[j]);
                            error("got: %g", got);
                        }
                        num_err++;
                    }
                }
                if (num_err == 0) nok++;
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}

dnl TEST_NC_IGET_VARA(TYPE)
dnl
define(`TEST_NC_IGET_VARA',dnl
`dnl
int
test_ncmpi_iget_vara_$1(void)
{
    int ncid;
    int d;
    int i;
    int j;
    int k;
    int err, num_err;
    int allInExtRange;        /* all values within external range? */
    int allInIntRange;        /* all values within internal range? */
    int nels;
    int nslabs;
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    int canConvert;     /* Both text or both numeric */
    double expect[MAX_NELS];
    $1 value[MAX_NELS];
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }
        err = ncmpi_iget_vara_$1(BAD_ID, i, start, edge, value, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_vara_$1(ncid, BAD_VARID, start, edge, value, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];  /* out of boundary check */
            err = ncmpi_iget_vara_$1(ncid, i, start, edge, value, &reqid);
            IF (canConvert && err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK
            if (err == NC_NOERR) ncmpi_wait_all(ncid, 1, &reqid, &status);
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = ncmpi_iget_vara_$1(ncid, i, start, edge, value, &reqid);
            IF (canConvert && err != NC_EEDGE)
                error("bad index/edge: err = %d", err);
            ELSE_NOK
            if (err == NC_NOERR) ncmpi_wait_all(ncid, 1, &reqid, &status);
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when */
        /* there is nothing to get (edge[j]==0) */
        if (var_rank[i] > 0) {
            for (j = 0; j < var_rank[i]; j++) {
                edge[j] = 0;
            }
            err = ncmpi_iget_vara_$1(BAD_ID, i, start, edge, value, &reqid);
            IF (err != NC_EBADID) 
                error("bad ncid: err = %d", err);
            ELSE_NOK
            err = ncmpi_iget_vara_$1(ncid, BAD_VARID, start, edge, value, &reqid);
            IF (err != NC_ENOTVAR) 
                error("bad var id: err = %d", err);
            ELSE_NOK
            for (j = 0; j < var_rank[i]; j++) {
                if (var_dimid[i][j] > 0) {                /* skip record dim */
                    start[j] = var_shape[i][j];     /* out of boundary check */
                    err = ncmpi_iget_vara_$1(ncid, i, start, edge, value, &reqid);
                    IF (canConvert && err != NC_EINVALCOORDS)
                        error("bad start: err = %d", err);
                    ELSE_NOK
                    if (err == NC_NOERR) ncmpi_wait_all(ncid, 1, &reqid, &status);
                    start[j] = 0;
                }
            }
            err = ncmpi_iget_vara_$1(ncid, i, start, edge, value, &reqid);
            if (canConvert) {
                IF (err != NC_NOERR)
                    error("Error: ncmpi_iget_vara_$1 %s",ncmpi_strerror(err));
            } else {
                IF (err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
            if (err == NC_NOERR) ncmpi_wait_all(ncid, 1, &reqid, &status);
            for (j = 0; j < var_rank[i]; j++) {
                edge[j] = 1;
            }
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase 1");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_ITYPE($1));
                if (inRange3(expect[j],var_type[i], NCT_ITYPE($1))) {
                    IfCheckTextChar($1, var_type[i])
                        allInIntRange &= CheckRange($1, expect[j]);
                } else {
                    allInExtRange = 0;
                }
            }
            if (var_rank[i] == 0 && i%2)
                err = ncmpi_iget_vara_$1(ncid, i, NULL, NULL, value, &reqid);
            else
                err = ncmpi_iget_vara_$1(ncid, i, start, edge, value, &reqid);
            if (err == NC_NOERR)
                ncmpi_wait_all(ncid, 1, &reqid, &status);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (status != NC_NOERR)
                            error("%s", ncmpi_strerror(status));
                        ELSE_NOK
                    } else {
                        IF (status != NC_ERANGE)
                            error("Range error: status = %d", status);
                        ELSE_NOK
                    }
                } else {
                    IF (status != NC_NOERR && status != NC_ERANGE)
                        error("OK or Range error: status = %d", status);
                    ELSE_NOK
                }
                num_err = 0;
                for (j = 0; j < nels; j++) {
                    if (CheckNumRange($1, expect[j], var_type[i])) {
                        IF (!equal(value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                            num_err++;
                        }
                    }
                }
                if (num_err == 0) nok++;
            } else {
                IF (nels > 0 && err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARA(text)
TEST_NC_IGET_VARA(uchar)
TEST_NC_IGET_VARA(schar)
TEST_NC_IGET_VARA(short)
TEST_NC_IGET_VARA(int)
TEST_NC_IGET_VARA(long)
TEST_NC_IGET_VARA(float)
TEST_NC_IGET_VARA(double)
TEST_NC_IGET_VARA(ushort)
TEST_NC_IGET_VARA(uint)
TEST_NC_IGET_VARA(longlong)
TEST_NC_IGET_VARA(ulonglong)

int
test_ncmpi_iget_vars(void)
{
    int ncid;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err, num_err;
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    double buf[MAX_NELS];
    double expect[MAX_NELS];
    int reqid, status;
    MPI_Datatype datatype;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        datatype = nc_mpi_type(var_type[i]);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }
        err = ncmpi_iget_vars(BAD_ID, i, start, edge, stride, buf, 1, datatype, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_vars(ncid, BAD_VARID, start, edge, stride, buf, 1, datatype, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];    /* out of boundary check */
            err = ncmpi_iget_vars(ncid, i, start, edge, stride, buf, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK

            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = ncmpi_iget_vars(ncid, i, start, edge, stride, buf, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                error("bad edge: err = %d", err);
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = ncmpi_iget_vars(ncid, i, start, edge, stride, buf, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                error("bad stride: err = %d", err);
            ELSE_NOK
            stride[j] = 1;
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                ELSE_NOK
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase 1");
                    ELSE_NOK
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash(var_type[i], var_rank[i], index2);
                }
                if (var_rank[i] == 0 && i%2 )
                    err = ncmpi_iget_vars(ncid, i, NULL, NULL, NULL, buf, 1, datatype, &reqid);
                else
                    err = ncmpi_iget_vars(ncid, i, index, count, stride, buf, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK

                err = ncmpi_wait_all(ncid, 1, &reqid, &status);
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK

                num_err = 0;
                for (j = 0; j < nels; j++) {
                    double got;
                    char *p = (char *) buf;
                    p += j * nctypelen(var_type[i]);
                    if (inRange(expect[j],var_type[i])) {
                        err = nc2dbl(var_type[i], p, &got);
                        IF (err != NC_NOERR)
                            error("error in nc2dbl");
                        IF (!equal2(got,expect[j],var_type[i])) {
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", got);
                            }
                            num_err++;
                        }
                    }
                }
                if (num_err == 0) nok++;
            }
        }

    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}

dnl TEST_NC_IGET_VARS(TYPE)
dnl
define(`TEST_NC_IGET_VARS',dnl
`dnl
int
test_ncmpi_iget_vars_$1(void)
{
    int ncid;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err, num_err;
    int allInExtRange;        /* all values within external range? */
    int allInIntRange;        /* all values within internal range? */
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    int canConvert;     /* Both text or both numeric */
    double expect[MAX_NELS];
    $1 value[MAX_NELS];
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }
        err = ncmpi_iget_vars_$1(BAD_ID, i, start, edge, stride, value, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_vars_$1(ncid, BAD_VARID, start, edge, stride, value, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];    /* out of boundary check */
            err = ncmpi_iget_vars_$1(ncid, i, start, edge, stride, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("conversion: err = %d", err);
            } else {
                IF (err != NC_EINVALCOORDS)
                    error("bad index: err = %d", err);
                ELSE_NOK

                start[j] = 0;
                edge[j] = var_shape[i][j] + 1;  /* edge error check */
                err = ncmpi_iget_vars_$1(ncid, i, start, edge, stride, value, &reqid);
                IF (err != NC_EEDGE)
                    error("bad edge: err = %d", err);
                ELSE_NOK
                edge[j] = 1;
                stride[j] = 0;
                err = ncmpi_iget_vars_$1(ncid, i, start, edge, stride, value, &reqid);
                IF (err != NC_ESTRIDE)
                    error("bad stride: err = %d", err);
                ELSE_NOK
                stride[j] = 1;
            }
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                ELSE_NOK
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase 1");
                    ELSE_NOK
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash4(var_type[i], var_rank[i], index2, 
                        NCT_ITYPE($1));
                    if (inRange3(expect[j],var_type[i],NCT_ITYPE($1))) {
                        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1, expect[j]);
                    } else {
                        allInExtRange = 0;
                    }
                }
                if (var_rank[i] == 0 && i%2 )
                    err = ncmpi_iget_vars_$1(ncid, i, NULL, NULL, NULL, value, &reqid);
                else
                    err = ncmpi_iget_vars_$1(ncid, i, index, count, stride, value, &reqid);
                if (err == NC_NOERR)
                    ncmpi_wait_all(ncid, 1, &reqid, &status);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (status != NC_NOERR)
                                error("%s", ncmpi_strerror(status));
                            ELSE_NOK
                        } else {
                            IF (status != NC_ERANGE)
                                error("Range error: status = %d", status);
                            ELSE_NOK
                        }
                    } else {
                        IF (status != NC_NOERR && status != NC_ERANGE)
                            error("OK or Range error: status = %d", status);
                        ELSE_NOK
                    }
                    num_err = 0;
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            IF (!equal(value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("element number: %d ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                                num_err++;
                            }
                        }
                    }
                    if (num_err == 0) nok++;
                } else {
                    IF (nels > 0 && err != NC_ECHAR)
                        error("wrong type: err = %d", err);
                    ELSE_NOK
                }
            }
        }

    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARS(text)
TEST_NC_IGET_VARS(uchar)
TEST_NC_IGET_VARS(schar)
TEST_NC_IGET_VARS(short)
TEST_NC_IGET_VARS(int)
TEST_NC_IGET_VARS(long)
TEST_NC_IGET_VARS(float)
TEST_NC_IGET_VARS(double)
TEST_NC_IGET_VARS(ushort)
TEST_NC_IGET_VARS(uint)
TEST_NC_IGET_VARS(longlong)
TEST_NC_IGET_VARS(ulonglong)

int
test_ncmpi_iget_varm(void)
{
    int ncid;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err, num_err;
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    MPI_Offset imap[MAX_RANK];
    double buf[MAX_NELS], expect[MAX_NELS];
    int reqid, status;
    MPI_Datatype datatype;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        datatype = nc_mpi_type(var_type[i]);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }
        err = ncmpi_iget_varm(BAD_ID, i, start, edge, stride, imap, buf, 1, datatype, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_varm(ncid, BAD_VARID, start, edge, stride, imap, buf, 1, datatype, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];    /* out of boundary check */
            err = ncmpi_iget_varm(ncid, i, start, edge, stride, imap, buf, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                error("bad index: err = %d", err);
            ELSE_NOK

            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = ncmpi_iget_varm(ncid, i, start, edge, stride, imap, buf, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                error("bad edge: err = %d", err);
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = ncmpi_iget_varm(ncid, i, start, edge, stride, imap, buf, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                error("bad stride: err = %d", err);
            ELSE_NOK
            stride[j] = 1;
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                ELSE_NOK
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    index[j] += start[j];
                    nels *= count[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase 1");
                    ELSE_NOK
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash(var_type[i], var_rank[i], index2);
                }
                if (var_rank[i] == 0 && i%2 )
                    err = ncmpi_iget_varm(ncid,i,NULL,NULL,NULL,NULL,buf, 1, datatype, &reqid);
                else
                    err = ncmpi_iget_varm(ncid,i,index,count,stride,imap,buf, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK

                err = ncmpi_wait_all(ncid, 1, &reqid, &status);
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK

                num_err = 0;
                for (j = 0; j < nels; j++) {
                    double got;
                    char *p = (char *) buf;
                    p += j * nctypelen(var_type[i]);
                    if (inRange(expect[j],var_type[i])) {
                        err = nc2dbl(var_type[i], p, &got);
                        IF (err != NC_NOERR)
                            error("error in nc2dbl");
                        IF (!equal2(got,expect[j],var_type[i])) {
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", got);
                            }
                            num_err++;
                        }
                    }
                    if (num_err == 0) nok++;
                }
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}

dnl TEST_NC_IGET_VARM(TYPE)
dnl
define(`TEST_NC_IGET_VARM',dnl
`dnl
int
test_ncmpi_iget_varm_$1(void)
{
    int ncid;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err, num_err;
    int allInExtRange;        /* all values within external range? */
    int allInIntRange;        /* all values within internal range? */
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    int nok = 0;      /* count of valid comparisons */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    MPI_Offset imap[MAX_RANK];
    int canConvert;     /* Both text or both numeric */
    double expect[MAX_NELS];
    $1 value[MAX_NELS];
    int reqid, status;

    err = ncmpi_open(comm, testfile, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));
    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }
        err = ncmpi_iget_varm_$1(BAD_ID, i, start, edge, stride, imap, value, &reqid);
        IF (err != NC_EBADID)
            error("bad ncid: err = %d", err);
        ELSE_NOK
        err = ncmpi_iget_varm_$1(ncid, BAD_VARID, start, edge, stride, imap, value, &reqid);
        IF (err != NC_ENOTVAR)
            error("bad var id: err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];    /* out of boundary check */
            err = ncmpi_iget_varm_$1(ncid, i, start, edge, stride, imap, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("conversion: err = %d", err);
            } else {
                IF (err != NC_EINVALCOORDS)
                    error("bad index: err = %d", err);
                ELSE_NOK

                start[j] = 0;
                edge[j] = var_shape[i][j] + 1;  /* edge error check */
                err = ncmpi_iget_varm_$1(ncid, i, start, edge, stride, imap, value, &reqid);
                IF (err != NC_EEDGE)
                    error("bad edge: err = %d", err);
                ELSE_NOK
                edge[j] = 1;
                stride[j] = 0;
                err = ncmpi_iget_varm_$1(ncid, i, start, edge, stride, imap, value, &reqid);
                IF (err != NC_ESTRIDE)
                    error("bad stride: err = %d", err);
                ELSE_NOK
                stride[j] = 1;
            }
        }
        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                ELSE_NOK
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase 1");
                    ELSE_NOK
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
                        NCT_ITYPE($1));
                    if (inRange3(expect[j],var_type[i],NCT_ITYPE($1))) {
                        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1, expect[j]);
                    } else {
                        allInExtRange = 0;
                    }
                }
                if (var_rank[i] == 0 && i%2 )
                    err = ncmpi_iget_varm_$1(ncid,i,NULL,NULL,NULL,NULL,value, &reqid);
                else
                    err = ncmpi_iget_varm_$1(ncid,i,index,count,stride,imap,value, &reqid);
                if (err == NC_NOERR)
                    ncmpi_wait_all(ncid, 1, &reqid, &status);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (status != NC_NOERR)
                                error("%s", ncmpi_strerror(status));
                            ELSE_NOK
                        } else {
                            IF (status != NC_ERANGE)
                                error("Range error: status = %d", status);
                            ELSE_NOK
                        }
                    } else {
                        IF (status != NC_NOERR && status != NC_ERANGE)
                            error("OK or Range error: status = %d", status);
                        ELSE_NOK
                    }
                    num_err = 0;
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            IF (!equal(value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("element number: %d ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                                num_err++;
                            }
                        }
                    }
                    if (num_err == 0) nok++;
                } else {
                    IF (nels > 0 && err != NC_ECHAR)
                        error("wrong type: err = %d", err);
                    ELSE_NOK
                }
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARM(text)
TEST_NC_IGET_VARM(uchar)
TEST_NC_IGET_VARM(schar)
TEST_NC_IGET_VARM(short)
TEST_NC_IGET_VARM(int)
TEST_NC_IGET_VARM(long)
TEST_NC_IGET_VARM(float)
TEST_NC_IGET_VARM(double)
TEST_NC_IGET_VARM(ushort)
TEST_NC_IGET_VARM(uint)
TEST_NC_IGET_VARM(longlong)
TEST_NC_IGET_VARM(ulonglong)


