# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CollectionItemUpdateConfiguration(Model):
    """object returned when requesting a collection of software update
    configuration.

    :param azure_virtual_machines: List of azure resource Ids for azure
     virtual machines targeted by the software update configuration.
    :type azure_virtual_machines: list[str]
    :param duration: Maximum time allowed for the software update
     configuration run. Duration needs to be specified using the format
     PT[n]H[n]M[n]S as per ISO8601
    :type duration: timedelta
    """

    _attribute_map = {
        'azure_virtual_machines': {'key': 'azureVirtualMachines', 'type': '[str]'},
        'duration': {'key': 'duration', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(CollectionItemUpdateConfiguration, self).__init__(**kwargs)
        self.azure_virtual_machines = kwargs.get('azure_virtual_machines', None)
        self.duration = kwargs.get('duration', None)
