# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class MetricTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                   .metrics.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://insights.twilio.com/v1/Voice/CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Metrics',
        ))

    def test_read_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Metrics?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "next_page_url": null,
                    "key": "metrics",
                    "url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Metrics?PageSize=50&Page=0"
                },
                "metrics": [
                    {
                        "timestamp": "2019-10-07T22:32:06Z",
                        "call_sid": "CA7569efe0253644fa4a88aa97beca3310",
                        "account_sid": "AC998c10b68cbfda9f67277f7d8f4439c9",
                        "edge": "sdk_edge",
                        "direction": "both",
                        "sdk_edge": {
                            "interval": {
                                "packets_received": 50,
                                "packets_lost": 0,
                                "audio_in": {
                                    "value": 81.0
                                },
                                "audio_out": {
                                    "value": 5237.0
                                },
                                "jitter": {
                                    "value": 9
                                },
                                "mos": {
                                    "value": 4.39
                                },
                                "rtt": {
                                    "value": 81
                                }
                            },
                            "cumulative": {
                                "bytes_received": 547788,
                                "bytes_sent": 329425,
                                "packets_received": 3900,
                                "packets_lost": 0,
                                "packets_sent": 3934
                            }
                        },
                        "client_edge": null,
                        "carrier_edge": null,
                        "sip_edge": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .metrics.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 10,
                    "page_size": 5,
                    "first_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Metrics?Direction=both&Edge=sdk_edge&PageSize=5&Page=0",
                    "previous_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Metrics?Direction=both&Edge=sdk_edge&PageSize=5&Page=9&PageToken=DP10",
                    "next_page_url": null,
                    "key": "metrics",
                    "url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Metrics?Direction=both&Edge=sdk_edge&PageSize=5&Page=10"
                },
                "metrics": [
                    {
                        "timestamp": "2019-10-07T22:32:06Z",
                        "call_sid": "CA7569efe0253644fa4a88aa97beca3310",
                        "account_sid": "AC998c10b68cbfda9f67277f7d8f4439c9",
                        "edge": "sdk_edge",
                        "direction": "both",
                        "sdk_edge": {
                            "interval": {
                                "packets_received": 50,
                                "packets_lost": 0,
                                "audio_in": {
                                    "value": 81.0
                                },
                                "audio_out": {
                                    "value": 5237.0
                                },
                                "jitter": {
                                    "value": 9
                                },
                                "mos": {
                                    "value": 4.39
                                },
                                "rtt": {
                                    "value": 81
                                }
                            },
                            "cumulative": {
                                "bytes_received": 547788,
                                "bytes_sent": 329425,
                                "packets_received": 3900,
                                "packets_lost": 0,
                                "packets_sent": 3934
                            }
                        },
                        "client_edge": null,
                        "carrier_edge": null,
                        "sip_edge": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .metrics.list()

        self.assertIsNotNone(actual)
