% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mbs_contexts.R
\name{count_mbs_contexts}
\alias{count_mbs_contexts}
\title{Count MBS variants grouped by length.}
\usage{
count_mbs_contexts(vcf_list)
}
\arguments{
\item{vcf_list}{GRanges or GRangesList object containing mbs variants.}
}
\value{
A tibble containing the number of MBS per MBS length per gr.
}
\description{
Count MBS variants grouped by length.
}
\details{
Counts the number of mbs grouped by length from a GRanges or GRangesList object containing mbs variants.
This is used, since a COSMIC context has to our knowledge not yet been defined.
This function applies the count_mbs_contexts_gr function to each gr in its input.
It then combines the results in a single tibble and returns this.
}
\examples{
## Get a GRangesList or GRanges object with mbs variants.
mbs_grl <- readRDS(system.file("states/blood_grl_mbs.rds",
  package = "MutationalPatterns"
))

# Count the MBSs
count_mbs_contexts(mbs_grl)
}
\seealso{
Other MBS: 
\code{\link{plot_compare_mbs}()},
\code{\link{plot_mbs_contexts}()}
}
\concept{MBS}
