package RestfulDB::CGI;
use warnings;
use strict;

use CGI qw(:standard -utf8);
use File::Basename qw(basename dirname);

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    save_cgi_parameters
);

sub save_cgi_parameters {
    my $db_dir = shift;
    my $request_basename = basename( $ENV{REQUEST_URI} );
    my $script_basename = basename( $0 );
    $request_basename =~ /^([-\w\d_\.]+)/;
    $request_basename = $1;
    $script_basename =~ /([-\w\d_\.]+)/;
    $script_basename = $1;
    my $save_file_name = $db_dir . "/" .
        $request_basename . "-" . $script_basename . ".sav";
    
    my $fh;
    open( $fh, ">>", $save_file_name );
    save_parameters( $fh );
    close( $fh );
}

1;
