/* automatically generated by rust-bindgen 0.69.4 */

pub const DAV1D_MAX_CDEF_STRENGTHS: u32 = 8;
pub const DAV1D_MAX_OPERATING_POINTS: u32 = 32;
pub const DAV1D_MAX_TILE_COLS: u32 = 64;
pub const DAV1D_MAX_TILE_ROWS: u32 = 64;
pub const DAV1D_MAX_SEGMENTS: u32 = 8;
pub const DAV1D_NUM_REF_FRAMES: u32 = 8;
pub const DAV1D_PRIMARY_REF_NONE: u32 = 7;
pub const DAV1D_REFS_PER_FRAME: u32 = 7;
pub const DAV1D_TOTAL_REFS_PER_FRAME: u32 = 8;
pub const DAV1D_PICTURE_ALIGNMENT: u32 = 64;
pub const DAV1D_API_VERSION_MAJOR: u32 = 7;
pub const DAV1D_API_VERSION_MINOR: u32 = 0;
pub const DAV1D_API_VERSION_PATCH: u32 = 0;
pub const DAV1D_MAX_THREADS: u32 = 256;
pub const DAV1D_MAX_FRAME_DELAY: u32 = 256;
pub type va_list = __builtin_va_list;
#[doc = " A reference-counted object wrapper for a user-configurable pointer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dUserData {
    #[doc = "< data pointer"]
    pub data: *const u8,
    #[doc = "< allocation origin"]
    pub ref_: *mut Dav1dRef,
}
#[doc = " Input packet metadata which are copied from the input data used to\n decode each image into the matching structure of the output image\n returned back to the user. Since these are metadata fields, they\n can be used for other purposes than the documented ones, they will\n still be passed from input data to output picture without being\n used internally."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dDataProps {
    #[doc = "< container timestamp of input data, INT64_MIN if unknown (default)"]
    pub timestamp: i64,
    #[doc = "< container duration of input data, 0 if unknown (default)"]
    pub duration: i64,
    #[doc = "< stream offset of input data, -1 if unknown (default)"]
    pub offset: i64,
    #[doc = "< packet size, default Dav1dData.sz"]
    pub size: usize,
    #[doc = "< user-configurable data, default NULL members"]
    pub user_data: Dav1dUserData,
}
extern "C" {
    #[doc = " Release reference to a Dav1dDataProps."]
    pub fn dav1d_data_props_unref(props: *mut Dav1dDataProps);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dObuType {
    DAV1D_OBU_SEQ_HDR = 1,
    DAV1D_OBU_TD = 2,
    DAV1D_OBU_FRAME_HDR = 3,
    DAV1D_OBU_TILE_GRP = 4,
    DAV1D_OBU_METADATA = 5,
    DAV1D_OBU_FRAME = 6,
    DAV1D_OBU_REDUNDANT_FRAME_HDR = 7,
    DAV1D_OBU_PADDING = 15,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dTxfmMode {
    DAV1D_TX_4X4_ONLY = 0,
    DAV1D_TX_LARGEST = 1,
    DAV1D_TX_SWITCHABLE = 2,
    DAV1D_N_TX_MODES = 3,
}
impl Dav1dFilterMode {
    pub const DAV1D_FILTER_BILINEAR: Dav1dFilterMode = Dav1dFilterMode::DAV1D_N_SWITCHABLE_FILTERS;
}
impl Dav1dFilterMode {
    pub const DAV1D_FILTER_SWITCHABLE: Dav1dFilterMode = Dav1dFilterMode::DAV1D_N_FILTERS;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dFilterMode {
    DAV1D_FILTER_8TAP_REGULAR = 0,
    DAV1D_FILTER_8TAP_SMOOTH = 1,
    DAV1D_FILTER_8TAP_SHARP = 2,
    DAV1D_N_SWITCHABLE_FILTERS = 3,
    DAV1D_N_FILTERS = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dAdaptiveBoolean {
    DAV1D_OFF = 0,
    DAV1D_ON = 1,
    DAV1D_ADAPTIVE = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dRestorationType {
    DAV1D_RESTORATION_NONE = 0,
    DAV1D_RESTORATION_SWITCHABLE = 1,
    DAV1D_RESTORATION_WIENER = 2,
    DAV1D_RESTORATION_SGRPROJ = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dWarpedMotionType {
    DAV1D_WM_TYPE_IDENTITY = 0,
    DAV1D_WM_TYPE_TRANSLATION = 1,
    DAV1D_WM_TYPE_ROT_ZOOM = 2,
    DAV1D_WM_TYPE_AFFINE = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Dav1dWarpedMotionParams {
    pub type_: Dav1dWarpedMotionType,
    pub matrix: [i32; 6usize],
    pub u: Dav1dWarpedMotionParams__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Dav1dWarpedMotionParams__bindgen_ty_1 {
    pub p: Dav1dWarpedMotionParams__bindgen_ty_1__bindgen_ty_1,
    pub abcd: [i16; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dWarpedMotionParams__bindgen_ty_1__bindgen_ty_1 {
    pub alpha: i16,
    pub beta: i16,
    pub gamma: i16,
    pub delta: i16,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dPixelLayout {
    #[doc = "< monochrome"]
    DAV1D_PIXEL_LAYOUT_I400 = 0,
    #[doc = "< 4:2:0 planar"]
    DAV1D_PIXEL_LAYOUT_I420 = 1,
    #[doc = "< 4:2:2 planar"]
    DAV1D_PIXEL_LAYOUT_I422 = 2,
    #[doc = "< 4:4:4 planar"]
    DAV1D_PIXEL_LAYOUT_I444 = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dFrameType {
    #[doc = "< Key Intra frame"]
    DAV1D_FRAME_TYPE_KEY = 0,
    #[doc = "< Inter frame"]
    DAV1D_FRAME_TYPE_INTER = 1,
    #[doc = "< Non key Intra frame"]
    DAV1D_FRAME_TYPE_INTRA = 2,
    #[doc = "< Switch Inter frame"]
    DAV1D_FRAME_TYPE_SWITCH = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dColorPrimaries {
    DAV1D_COLOR_PRI_BT709 = 1,
    DAV1D_COLOR_PRI_UNKNOWN = 2,
    DAV1D_COLOR_PRI_BT470M = 4,
    DAV1D_COLOR_PRI_BT470BG = 5,
    DAV1D_COLOR_PRI_BT601 = 6,
    DAV1D_COLOR_PRI_SMPTE240 = 7,
    DAV1D_COLOR_PRI_FILM = 8,
    DAV1D_COLOR_PRI_BT2020 = 9,
    DAV1D_COLOR_PRI_XYZ = 10,
    DAV1D_COLOR_PRI_SMPTE431 = 11,
    DAV1D_COLOR_PRI_SMPTE432 = 12,
    DAV1D_COLOR_PRI_EBU3213 = 22,
    DAV1D_COLOR_PRI_RESERVED = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dTransferCharacteristics {
    DAV1D_TRC_BT709 = 1,
    DAV1D_TRC_UNKNOWN = 2,
    DAV1D_TRC_BT470M = 4,
    DAV1D_TRC_BT470BG = 5,
    DAV1D_TRC_BT601 = 6,
    DAV1D_TRC_SMPTE240 = 7,
    DAV1D_TRC_LINEAR = 8,
    #[doc = "< logarithmic (100:1 range)"]
    DAV1D_TRC_LOG100 = 9,
    #[doc = "< lograithmic (100*sqrt(10):1 range)"]
    DAV1D_TRC_LOG100_SQRT10 = 10,
    DAV1D_TRC_IEC61966 = 11,
    DAV1D_TRC_BT1361 = 12,
    DAV1D_TRC_SRGB = 13,
    DAV1D_TRC_BT2020_10BIT = 14,
    DAV1D_TRC_BT2020_12BIT = 15,
    #[doc = "< PQ"]
    DAV1D_TRC_SMPTE2084 = 16,
    DAV1D_TRC_SMPTE428 = 17,
    #[doc = "< hybrid log/gamma (BT.2100 / ARIB STD-B67)"]
    DAV1D_TRC_HLG = 18,
    DAV1D_TRC_RESERVED = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dMatrixCoefficients {
    DAV1D_MC_IDENTITY = 0,
    DAV1D_MC_BT709 = 1,
    DAV1D_MC_UNKNOWN = 2,
    DAV1D_MC_FCC = 4,
    DAV1D_MC_BT470BG = 5,
    DAV1D_MC_BT601 = 6,
    DAV1D_MC_SMPTE240 = 7,
    DAV1D_MC_SMPTE_YCGCO = 8,
    DAV1D_MC_BT2020_NCL = 9,
    DAV1D_MC_BT2020_CL = 10,
    DAV1D_MC_SMPTE2085 = 11,
    #[doc = "< Chromaticity-derived"]
    DAV1D_MC_CHROMAT_NCL = 12,
    DAV1D_MC_CHROMAT_CL = 13,
    DAV1D_MC_ICTCP = 14,
    DAV1D_MC_RESERVED = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dChromaSamplePosition {
    DAV1D_CHR_UNKNOWN = 0,
    #[doc = "< Horizontally co-located with luma(0, 0)\n< sample, between two vertical samples"]
    DAV1D_CHR_VERTICAL = 1,
    #[doc = "< Co-located with luma(0, 0) sample"]
    DAV1D_CHR_COLOCATED = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dContentLightLevel {
    pub max_content_light_level: u16,
    pub max_frame_average_light_level: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dMasteringDisplay {
    pub primaries: [[u16; 2usize]; 3usize],
    pub white_point: [u16; 2usize],
    pub max_luminance: u32,
    pub min_luminance: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dITUTT35 {
    pub country_code: u8,
    pub country_code_extension_byte: u8,
    pub payload_size: usize,
    pub payload: *mut u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSequenceHeader {
    #[doc = " Stream profile, 0 for 8-10 bits/component 4:2:0 or monochrome;\n 1 for 8-10 bits/component 4:4:4; 2 for 4:2:2 at any bits/component,\n or 12 bits/component at any chroma subsampling."]
    pub profile: u8,
    #[doc = " Maximum dimensions for this stream. In non-scalable streams, these\n are often the actual dimensions of the stream, although that is not\n a normative requirement."]
    pub max_width: ::std::os::raw::c_int,
    #[doc = " Maximum dimensions for this stream. In non-scalable streams, these\n are often the actual dimensions of the stream, although that is not\n a normative requirement."]
    pub max_height: ::std::os::raw::c_int,
    #[doc = "< format of the picture"]
    pub layout: Dav1dPixelLayout,
    #[doc = "< color primaries (av1)"]
    pub pri: Dav1dColorPrimaries,
    #[doc = "< transfer characteristics (av1)"]
    pub trc: Dav1dTransferCharacteristics,
    #[doc = "< matrix coefficients (av1)"]
    pub mtrx: Dav1dMatrixCoefficients,
    #[doc = "< chroma sample position (av1)"]
    pub chr: Dav1dChromaSamplePosition,
    #[doc = " 0, 1 and 2 mean 8, 10 or 12 bits/component, respectively. This is not\n exactly the same as 'hbd' from the spec; the spec's hbd distinguishes\n between 8 (0) and 10-12 (1) bits/component, and another element\n (twelve_bit) to distinguish between 10 and 12 bits/component. To get\n the spec's hbd, use !!our_hbd, and to get twelve_bit, use hbd == 2."]
    pub hbd: u8,
    #[doc = " Pixel data uses JPEG pixel range ([0,255] for 8bits) instead of\n MPEG pixel range ([16,235] for 8bits luma, [16,240] for 8bits chroma)."]
    pub color_range: u8,
    pub num_operating_points: u8,
    pub operating_points: [Dav1dSequenceHeader_Dav1dSequenceHeaderOperatingPoint; 32usize],
    pub still_picture: u8,
    pub reduced_still_picture_header: u8,
    pub timing_info_present: u8,
    pub num_units_in_tick: u32,
    pub time_scale: u32,
    pub equal_picture_interval: u8,
    pub num_ticks_per_picture: u32,
    pub decoder_model_info_present: u8,
    pub encoder_decoder_buffer_delay_length: u8,
    pub num_units_in_decoding_tick: u32,
    pub buffer_removal_delay_length: u8,
    pub frame_presentation_delay_length: u8,
    pub display_model_info_present: u8,
    pub width_n_bits: u8,
    pub height_n_bits: u8,
    pub frame_id_numbers_present: u8,
    pub delta_frame_id_n_bits: u8,
    pub frame_id_n_bits: u8,
    pub sb128: u8,
    pub filter_intra: u8,
    pub intra_edge_filter: u8,
    pub inter_intra: u8,
    pub masked_compound: u8,
    pub warped_motion: u8,
    pub dual_filter: u8,
    pub order_hint: u8,
    pub jnt_comp: u8,
    pub ref_frame_mvs: u8,
    pub screen_content_tools: Dav1dAdaptiveBoolean,
    pub force_integer_mv: Dav1dAdaptiveBoolean,
    pub order_hint_n_bits: u8,
    pub super_res: u8,
    pub cdef: u8,
    pub restoration: u8,
    pub ss_hor: u8,
    pub ss_ver: u8,
    pub monochrome: u8,
    pub color_description_present: u8,
    pub separate_uv_delta_q: u8,
    pub film_grain_present: u8,
    pub operating_parameter_info:
        [Dav1dSequenceHeader_Dav1dSequenceHeaderOperatingParameterInfo; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSequenceHeader_Dav1dSequenceHeaderOperatingPoint {
    pub major_level: u8,
    pub minor_level: u8,
    pub initial_display_delay: u8,
    pub idc: u16,
    pub tier: u8,
    pub decoder_model_param_present: u8,
    pub display_model_param_present: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSequenceHeader_Dav1dSequenceHeaderOperatingParameterInfo {
    pub decoder_buffer_delay: u32,
    pub encoder_buffer_delay: u32,
    pub low_delay_mode: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSegmentationData {
    pub delta_q: i16,
    pub delta_lf_y_v: i8,
    pub delta_lf_y_h: i8,
    pub delta_lf_u: i8,
    pub delta_lf_v: i8,
    pub ref_: i8,
    pub skip: u8,
    pub globalmv: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSegmentationDataSet {
    pub d: [Dav1dSegmentationData; 8usize],
    pub preskip: u8,
    pub last_active_segid: i8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dLoopfilterModeRefDeltas {
    pub mode_delta: [i8; 2usize],
    pub ref_delta: [i8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFilmGrainData {
    pub seed: ::std::os::raw::c_uint,
    pub num_y_points: ::std::os::raw::c_int,
    pub y_points: [[u8; 2usize]; 14usize],
    pub chroma_scaling_from_luma: ::std::os::raw::c_int,
    pub num_uv_points: [::std::os::raw::c_int; 2usize],
    pub uv_points: [[[u8; 2usize]; 10usize]; 2usize],
    pub scaling_shift: ::std::os::raw::c_int,
    pub ar_coeff_lag: ::std::os::raw::c_int,
    pub ar_coeffs_y: [i8; 24usize],
    pub ar_coeffs_uv: [[i8; 28usize]; 2usize],
    pub ar_coeff_shift: u64,
    pub grain_scale_shift: ::std::os::raw::c_int,
    pub uv_mult: [::std::os::raw::c_int; 2usize],
    pub uv_luma_mult: [::std::os::raw::c_int; 2usize],
    pub uv_offset: [::std::os::raw::c_int; 2usize],
    pub overlap_flag: ::std::os::raw::c_int,
    pub clip_to_restricted_range: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Dav1dFrameHeader {
    #[doc = "< film grain parameters"]
    pub film_grain: Dav1dFrameHeader__bindgen_ty_1,
    #[doc = "< type of the picture"]
    pub frame_type: Dav1dFrameType,
    pub width: [::std::os::raw::c_int; 2usize],
    pub height: ::std::os::raw::c_int,
    #[doc = "< frame number"]
    pub frame_offset: u8,
    #[doc = "< temporal id of the frame for SVC"]
    pub temporal_id: u8,
    #[doc = "< spatial id of the frame for SVC"]
    pub spatial_id: u8,
    pub show_existing_frame: u8,
    pub existing_frame_idx: u8,
    pub frame_id: u32,
    pub frame_presentation_delay: u32,
    pub show_frame: u8,
    pub showable_frame: u8,
    pub error_resilient_mode: u8,
    pub disable_cdf_update: u8,
    pub allow_screen_content_tools: u8,
    pub force_integer_mv: u8,
    pub frame_size_override: u8,
    pub primary_ref_frame: u8,
    pub buffer_removal_time_present: u8,
    pub operating_points: [Dav1dFrameHeader_Dav1dFrameHeaderOperatingPoint; 32usize],
    pub refresh_frame_flags: u8,
    pub render_width: ::std::os::raw::c_int,
    pub render_height: ::std::os::raw::c_int,
    pub super_res: Dav1dFrameHeader__bindgen_ty_2,
    pub have_render_size: u8,
    pub allow_intrabc: u8,
    pub frame_ref_short_signaling: u8,
    pub refidx: [i8; 7usize],
    pub hp: u8,
    pub subpel_filter_mode: Dav1dFilterMode,
    pub switchable_motion_mode: u8,
    pub use_ref_frame_mvs: u8,
    pub refresh_context: u8,
    pub tiling: Dav1dFrameHeader__bindgen_ty_3,
    pub quant: Dav1dFrameHeader__bindgen_ty_4,
    pub segmentation: Dav1dFrameHeader__bindgen_ty_5,
    pub delta: Dav1dFrameHeader__bindgen_ty_6,
    pub all_lossless: u8,
    pub loopfilter: Dav1dFrameHeader__bindgen_ty_7,
    pub cdef: Dav1dFrameHeader__bindgen_ty_8,
    pub restoration: Dav1dFrameHeader__bindgen_ty_9,
    pub txfm_mode: Dav1dTxfmMode,
    pub switchable_comp_refs: u8,
    pub skip_mode_allowed: u8,
    pub skip_mode_enabled: u8,
    pub skip_mode_refs: [i8; 2usize],
    pub warp_motion: u8,
    pub reduced_txtp_set: u8,
    pub gmv: [Dav1dWarpedMotionParams; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_1 {
    pub data: Dav1dFilmGrainData,
    pub present: u8,
    pub update: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader_Dav1dFrameHeaderOperatingPoint {
    pub buffer_removal_time: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_2 {
    pub width_scale_denominator: u8,
    pub enabled: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_3 {
    pub uniform: u8,
    pub n_bytes: u8,
    pub min_log2_cols: u8,
    pub max_log2_cols: u8,
    pub log2_cols: u8,
    pub cols: u8,
    pub min_log2_rows: u8,
    pub max_log2_rows: u8,
    pub log2_rows: u8,
    pub rows: u8,
    pub col_start_sb: [u16; 65usize],
    pub row_start_sb: [u16; 65usize],
    pub update: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_4 {
    pub yac: u8,
    pub ydc_delta: i8,
    pub udc_delta: i8,
    pub uac_delta: i8,
    pub vdc_delta: i8,
    pub vac_delta: i8,
    pub qm: u8,
    pub qm_y: u8,
    pub qm_u: u8,
    pub qm_v: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_5 {
    pub enabled: u8,
    pub update_map: u8,
    pub temporal: u8,
    pub update_data: u8,
    pub seg_data: Dav1dSegmentationDataSet,
    pub lossless: [u8; 8usize],
    pub qidx: [u8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_6 {
    pub q: Dav1dFrameHeader__bindgen_ty_6__bindgen_ty_1,
    pub lf: Dav1dFrameHeader__bindgen_ty_6__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_6__bindgen_ty_1 {
    pub present: u8,
    pub res_log2: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_6__bindgen_ty_2 {
    pub present: u8,
    pub res_log2: u8,
    pub multi: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_7 {
    pub level_y: [u8; 2usize],
    pub level_u: u8,
    pub level_v: u8,
    pub mode_ref_delta_enabled: u8,
    pub mode_ref_delta_update: u8,
    pub mode_ref_deltas: Dav1dLoopfilterModeRefDeltas,
    pub sharpness: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_8 {
    pub damping: u8,
    pub n_bits: u8,
    pub y_strength: [u8; 8usize],
    pub uv_strength: [u8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dFrameHeader__bindgen_ty_9 {
    pub type_: [Dav1dRestorationType; 3usize],
    pub unit_size: [u8; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dPictureParameters {
    #[doc = "< width (in pixels)"]
    pub w: ::std::os::raw::c_int,
    #[doc = "< height (in pixels)"]
    pub h: ::std::os::raw::c_int,
    #[doc = "< format of the picture"]
    pub layout: Dav1dPixelLayout,
    #[doc = "< bits per pixel component (8 or 10)"]
    pub bpc: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dPicture {
    pub seq_hdr: *mut Dav1dSequenceHeader,
    pub frame_hdr: *mut Dav1dFrameHeader,
    #[doc = " Pointers to planar image data (Y is [0], U is [1], V is [2]). The data\n should be bytes (for 8 bpc) or words (for 10 bpc). In case of words\n containing 10 bpc image data, the pixels should be located in the LSB\n bits, so that values range between [0, 1023]; the upper bits should be\n zero'ed out."]
    pub data: [*mut ::std::os::raw::c_void; 3usize],
    #[doc = " Number of bytes between 2 lines in data[] for luma [0] or chroma [1]."]
    pub stride: [isize; 2usize],
    pub p: Dav1dPictureParameters,
    pub m: Dav1dDataProps,
    #[doc = " High Dynamic Range Content Light Level metadata applying to this picture,\n as defined in section 5.8.3 and 6.7.3"]
    pub content_light: *mut Dav1dContentLightLevel,
    #[doc = " High Dynamic Range Mastering Display Color Volume metadata applying to\n this picture, as defined in section 5.8.4 and 6.7.4"]
    pub mastering_display: *mut Dav1dMasteringDisplay,
    #[doc = " Array of ITU-T T.35 metadata as defined in section 5.8.2 and 6.7.2"]
    pub itut_t35: *mut Dav1dITUTT35,
    #[doc = " Number of ITU-T T35 metadata entries in the array"]
    pub n_itut_t35: usize,
    #[doc = "< reserved for future use"]
    pub reserved: [usize; 4usize],
    #[doc = "< Dav1dFrameHeader allocation origin"]
    pub frame_hdr_ref: *mut Dav1dRef,
    #[doc = "< Dav1dSequenceHeader allocation origin"]
    pub seq_hdr_ref: *mut Dav1dRef,
    #[doc = "< Dav1dContentLightLevel allocation origin"]
    pub content_light_ref: *mut Dav1dRef,
    #[doc = "< Dav1dMasteringDisplay allocation origin"]
    pub mastering_display_ref: *mut Dav1dRef,
    #[doc = "< Dav1dITUTT35 allocation origin"]
    pub itut_t35_ref: *mut Dav1dRef,
    #[doc = "< reserved for future use"]
    pub reserved_ref: [usize; 4usize],
    #[doc = "< Frame data allocation origin"]
    pub ref_: *mut Dav1dRef,
    #[doc = "< pointer managed by the allocator"]
    pub allocator_data: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dPicAllocator {
    #[doc = "< custom data to pass to the allocator callbacks."]
    pub cookie: *mut ::std::os::raw::c_void,
    #[doc = " Allocate the picture buffer based on the Dav1dPictureParameters.\n\n The data[0], data[1] and data[2] must be DAV1D_PICTURE_ALIGNMENT byte\n aligned and with a pixel width/height multiple of 128 pixels. Any\n allocated memory area should also be padded by DAV1D_PICTURE_ALIGNMENT\n bytes.\n data[1] and data[2] must share the same stride[1].\n\n This function will be called on the main thread (the thread which calls\n dav1d_get_picture()).\n\n @param  pic The picture to allocate the buffer for. The callback needs to\n             fill the picture data[0], data[1], data[2], stride[0] and\n             stride[1].\n             The allocator can fill the pic allocator_data pointer with\n             a custom pointer that will be passed to\n             release_picture_callback().\n @param cookie Custom pointer passed to all calls.\n\n @note No fields other than data, stride and allocator_data must be filled\n       by this callback.\n @return 0 on success. A negative DAV1D_ERR value on error."]
    pub alloc_picture_callback: ::std::option::Option<
        unsafe extern "C" fn(
            pic: *mut Dav1dPicture,
            cookie: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Release the picture buffer.\n\n If frame threading is used, this function may be called by the main\n thread (the thread which calls dav1d_get_picture()) or any of the frame\n threads and thus must be thread-safe. If frame threading is not used,\n this function will only be called on the main thread.\n\n @param pic    The picture that was filled by alloc_picture_callback().\n @param cookie Custom pointer passed to all calls."]
    pub release_picture_callback: ::std::option::Option<
        unsafe extern "C" fn(pic: *mut Dav1dPicture, cookie: *mut ::std::os::raw::c_void),
    >,
}
extern "C" {
    #[doc = " Release reference to a picture."]
    pub fn dav1d_picture_unref(p: *mut Dav1dPicture);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dData {
    #[doc = "< data pointer"]
    pub data: *const u8,
    #[doc = "< data size"]
    pub sz: usize,
    #[doc = "< allocation origin"]
    pub ref_: *mut Dav1dRef,
    #[doc = "< user provided metadata passed to the output picture"]
    pub m: Dav1dDataProps,
}
extern "C" {
    #[doc = " Allocate data.\n\n @param data Input context.\n @param   sz Size of the data that should be allocated.\n\n @return Pointer to the allocated buffer on success. NULL on error."]
    pub fn dav1d_data_create(data: *mut Dav1dData, sz: usize) -> *mut u8;
}
extern "C" {
    #[doc = " Wrap an existing data array.\n\n @param          data Input context.\n @param           buf The data to be wrapped.\n @param            sz Size of the data.\n @param free_callback Function to be called when we release our last\n                      reference to this data. In this callback, $buf will be\n                      the $buf argument to this function, and $cookie will\n                      be the $cookie input argument to this function.\n @param        cookie Opaque parameter passed to free_callback().\n\n @return 0 on success. A negative DAV1D_ERR value on error."]
    pub fn dav1d_data_wrap(
        data: *mut Dav1dData,
        buf: *const u8,
        sz: usize,
        free_callback: ::std::option::Option<
            unsafe extern "C" fn(buf: *const u8, cookie: *mut ::std::os::raw::c_void),
        >,
        cookie: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Wrap a user-provided data pointer into a reference counted object.\n\n data->m.user_data field will initialized to wrap the provided $user_data\n pointer.\n\n $free_callback will be called on the same thread that released the last\n reference. If frame threading is used, make sure $free_callback is\n thread-safe.\n\n @param          data Input context.\n @param     user_data The user data to be wrapped.\n @param free_callback Function to be called when we release our last\n                      reference to this data. In this callback, $user_data\n                      will be the $user_data argument to this function, and\n                      $cookie will be the $cookie input argument to this\n                      function.\n @param        cookie Opaque parameter passed to $free_callback.\n\n @return 0 on success. A negative DAV1D_ERR value on error."]
    pub fn dav1d_data_wrap_user_data(
        data: *mut Dav1dData,
        user_data: *const u8,
        free_callback: ::std::option::Option<
            unsafe extern "C" fn(user_data: *const u8, cookie: *mut ::std::os::raw::c_void),
        >,
        cookie: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free the data reference.\n\n The reference count for data->m.user_data will be decremented (if it has been\n initialized with dav1d_data_wrap_user_data). The $data object will be memset\n to 0.\n\n @param data Input context."]
    pub fn dav1d_data_unref(data: *mut Dav1dData);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dLogger {
    #[doc = "< Custom data to pass to the callback."]
    pub cookie: *mut ::std::os::raw::c_void,
    #[doc = " Logger callback. May be NULL to disable logging.\n\n @param cookie Custom pointer passed to all calls.\n @param format The vprintf compatible format string.\n @param     ap List of arguments referenced by the format string."]
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(
            cookie: *mut ::std::os::raw::c_void,
            format: *const ::std::os::raw::c_char,
            ap: *mut __va_list_tag,
        ),
    >,
}
pub mod Dav1dInloopFilterType {
    pub type Type = ::std::os::raw::c_uint;
    pub const DAV1D_INLOOPFILTER_NONE: Type = 0;
    pub const DAV1D_INLOOPFILTER_DEBLOCK: Type = 1;
    pub const DAV1D_INLOOPFILTER_CDEF: Type = 2;
    pub const DAV1D_INLOOPFILTER_RESTORATION: Type = 4;
    pub const DAV1D_INLOOPFILTER_ALL: Type = 7;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dDecodeFrameType {
    #[doc = "< decode and return all frames"]
    DAV1D_DECODEFRAMETYPE_ALL = 0,
    #[doc = "< decode and return frames referenced by other frames only"]
    DAV1D_DECODEFRAMETYPE_REFERENCE = 1,
    #[doc = "< decode and return intra frames only (includes keyframes)"]
    DAV1D_DECODEFRAMETYPE_INTRA = 2,
    #[doc = "< decode and return keyframes only"]
    DAV1D_DECODEFRAMETYPE_KEY = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dSettings {
    #[doc = "< number of threads (0 = number of logical cores in host system, default 0)"]
    pub n_threads: ::std::os::raw::c_int,
    #[doc = "< Set to 1 for low-latency decoding (0 = ceil(sqrt(n_threads)), default 0)"]
    pub max_frame_delay: ::std::os::raw::c_int,
    #[doc = "< whether to apply film grain on output frames (default 1)"]
    pub apply_grain: ::std::os::raw::c_int,
    #[doc = "< select an operating point for scalable AV1 bitstreams (0 - 31, default 0)"]
    pub operating_point: ::std::os::raw::c_int,
    #[doc = "< output all spatial layers of a scalable AV1 biststream (default 1)"]
    pub all_layers: ::std::os::raw::c_int,
    #[doc = "< maximum frame size, in pixels (0 = unlimited, default 0)"]
    pub frame_size_limit: ::std::os::raw::c_uint,
    #[doc = "< Picture allocator callback."]
    pub allocator: Dav1dPicAllocator,
    #[doc = "< Logger callback."]
    pub logger: Dav1dLogger,
    #[doc = "< whether to abort decoding on standard compliance violations\n< that don't affect actual bitstream decoding (e.g. inconsistent\n< or invalid metadata, default 0)"]
    pub strict_std_compliance: ::std::os::raw::c_int,
    #[doc = "< output invisibly coded frames (in coding order) in addition\n< to all visible frames. Because of show-existing-frame, this\n< means some frames may appear twice (once when coded,\n< once when shown, default 0)"]
    pub output_invisible_frames: ::std::os::raw::c_int,
    #[doc = "< postfilters to enable during decoding (default\n< DAV1D_INLOOPFILTER_ALL)"]
    pub inloop_filters: Dav1dInloopFilterType::Type,
    #[doc = "< frame types to decode (default\n< DAV1D_DECODEFRAMETYPE_ALL)"]
    pub decode_frame_type: Dav1dDecodeFrameType,
    #[doc = "< reserved for future use"]
    pub reserved: [u8; 16usize],
}
extern "C" {
    #[doc = " Get library version."]
    pub fn dav1d_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get library API version.\n\n @return A value in the format 0x00XXYYZZ, where XX is the major version,\n         YY the minor version, and ZZ the patch version.\n @see DAV1D_API_MAJOR, DAV1D_API_MINOR, DAV1D_API_PATCH"]
    pub fn dav1d_version_api() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Initialize settings to default values.\n\n @param s Input settings context."]
    pub fn dav1d_default_settings(s: *mut Dav1dSettings);
}
extern "C" {
    #[doc = " Allocate and open a decoder instance.\n\n @param c_out The decoder instance to open. *c_out will be set to the\n              allocated context.\n @param     s Input settings context.\n\n @note The context must be freed using dav1d_close() when decoding is\n       finished.\n\n @return 0 on success, or < 0 (a negative DAV1D_ERR code) on error."]
    pub fn dav1d_open(
        c_out: *mut *mut Dav1dContext,
        s: *const Dav1dSettings,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Parse a Sequence Header OBU from bitstream data.\n\n @param out Output Sequence Header.\n @param buf The data to be parser.\n @param sz  Size of the data.\n\n @return\n                  0: Success, and out is filled with the parsed Sequence Header\n                     OBU parameters.\n  DAV1D_ERR(ENOENT): No Sequence Header OBUs were found in the buffer.\n  Other negative DAV1D_ERR codes: Invalid data in the buffer, invalid passed-in\n                                  arguments, and other errors during parsing.\n\n @note It is safe to feed this function data containing other OBUs than a\n       Sequence Header, as they will simply be ignored. If there is more than\n       one Sequence Header OBU present, only the last will be returned."]
    pub fn dav1d_parse_sequence_header(
        out: *mut Dav1dSequenceHeader,
        buf: *const u8,
        sz: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Feed bitstream data to the decoder, in the form of one or multiple AV1\n Open Bitstream Units (OBUs).\n\n @param   c Input decoder instance.\n @param  in Input bitstream data. On success, ownership of the reference is\n            passed to the library.\n\n @return\n         0: Success, and the data was consumed.\n  DAV1D_ERR(EAGAIN): The data can't be consumed. dav1d_get_picture() should\n                     be called to get one or more frames before the function\n                     can consume new data.\n  Other negative DAV1D_ERR codes: Error during decoding or because of invalid\n                                  passed-in arguments. The reference remains\n                                  owned by the caller."]
    pub fn dav1d_send_data(c: *mut Dav1dContext, in_: *mut Dav1dData) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return a decoded picture.\n\n @param   c Input decoder instance.\n @param out Output frame. The caller assumes ownership of the returned\n            reference.\n\n @return\n         0: Success, and a frame is returned.\n  DAV1D_ERR(EAGAIN): Not enough data to output a frame. dav1d_send_data()\n                     should be called with new input.\n  Other negative DAV1D_ERR codes: Error during decoding or because of invalid\n                                  passed-in arguments.\n\n @note To drain buffered frames from the decoder (i.e. on end of stream),\n       call this function until it returns DAV1D_ERR(EAGAIN).\n\n @code{.c}\n  Dav1dData data = { 0 };\n  Dav1dPicture p = { 0 };\n  int res;\n\n  read_data(&data);\n  do {\n      res = dav1d_send_data(c, &data);\n      // Keep going even if the function can't consume the current data\n         packet. It eventually will after one or more frames have been\n         returned in this loop.\n      if (res < 0 && res != DAV1D_ERR(EAGAIN))\n          free_and_abort();\n      res = dav1d_get_picture(c, &p);\n      if (res < 0) {\n          if (res != DAV1D_ERR(EAGAIN))\n              free_and_abort();\n      } else\n          output_and_unref_picture(&p);\n  // Stay in the loop as long as there's data to consume.\n  } while (data.sz || read_data(&data) == SUCCESS);\n\n  // Handle EOS by draining all buffered frames.\n  do {\n      res = dav1d_get_picture(c, &p);\n      if (res < 0) {\n          if (res != DAV1D_ERR(EAGAIN))\n              free_and_abort();\n      } else\n          output_and_unref_picture(&p);\n  } while (res == 0);\n @endcode"]
    pub fn dav1d_get_picture(c: *mut Dav1dContext, out: *mut Dav1dPicture)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Apply film grain to a previously decoded picture. If the picture contains no\n film grain metadata, then this function merely returns a new reference.\n\n @param   c Input decoder instance.\n @param out Output frame. The caller assumes ownership of the returned\n            reference.\n @param  in Input frame. No ownership is transferred.\n\n @return\n         0: Success, and a frame is returned.\n  Other negative DAV1D_ERR codes: Error due to lack of memory or because of\n                                  invalid passed-in arguments.\n\n @note If `Dav1dSettings.apply_grain` is true, film grain was already applied\n       by `dav1d_get_picture`, and so calling this function leads to double\n       application of film grain. Users should only call this when needed."]
    pub fn dav1d_apply_grain(
        c: *mut Dav1dContext,
        out: *mut Dav1dPicture,
        in_: *const Dav1dPicture,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close a decoder instance and free all associated memory.\n\n @param c_out The decoder instance to close. *c_out will be set to NULL."]
    pub fn dav1d_close(c_out: *mut *mut Dav1dContext);
}
extern "C" {
    #[doc = " Flush all delayed frames in decoder and clear internal decoder state,\n to be used when seeking.\n\n @param c Input decoder instance.\n\n @note Decoding will start only after a valid sequence header OBU is\n       delivered to dav1d_send_data().\n"]
    pub fn dav1d_flush(c: *mut Dav1dContext);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Dav1dEventFlags {
    #[doc = " The last returned picture contains a reference to a new Sequence Header,\n either because it's the start of a new coded sequence, or the decoder was\n flushed before it was generated."]
    DAV1D_EVENT_FLAG_NEW_SEQUENCE = 1,
    #[doc = " The last returned picture contains a reference to a Sequence Header with\n new operating parameters information for the current coded sequence."]
    DAV1D_EVENT_FLAG_NEW_OP_PARAMS_INFO = 2,
}
extern "C" {
    #[doc = " Fetch a combination of DAV1D_EVENT_FLAG_* event flags generated by the decoding\n process.\n\n @param c Input decoder instance.\n @param flags Where to write the flags.\n\n @return 0 on success, or < 0 (a negative DAV1D_ERR code) on error.\n\n @note Calling this function will clear all the event flags currently stored in\n       the decoder.\n"]
    pub fn dav1d_get_event_flags(
        c: *mut Dav1dContext,
        flags: *mut Dav1dEventFlags,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Retrieve the user-provided metadata associated with the input data packet\n for the last decoding error reported to the user, i.e. a negative return\n value (not EAGAIN) from dav1d_send_data() or dav1d_get_picture().\n\n @param   c Input decoder instance.\n @param out Output Dav1dDataProps. On success, the caller assumes ownership of\n            the returned reference.\n\n @return 0 on success, or < 0 (a negative DAV1D_ERR code) on error."]
    pub fn dav1d_get_decode_error_data_props(
        c: *mut Dav1dContext,
        out: *mut Dav1dDataProps,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the decoder delay, which is the number of internally buffered frames, not\n including reference frames.\n This value is guaranteed to be >= 1 and <= max_frame_delay.\n\n @param s Input settings context.\n\n @return Decoder frame delay on success, or < 0 (a negative DAV1D_ERR code) on\n         error.\n\n @note The returned delay is valid only for a Dav1dContext initialized with the\n       provided Dav1dSettings."]
    pub fn dav1d_get_frame_delay(s: *const Dav1dSettings) -> ::std::os::raw::c_int;
}
#[doc = "< allocation origin"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Dav1dRef {
    pub _address: u8,
}
